/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.autodetect.FormatterBasedLineIndentInfoBuilder;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjusterImpl;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetector;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatisticsImpl;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IndentOptionsDetectorImpl
implements IndentOptionsDetector {
    private final PsiFile myFile;
    private final Project myProject;
    private final Document myDocument;
    private final ProgressIndicator myProgressIndicator;

    public IndentOptionsDetectorImpl(@NotNull PsiFile file2, @NotNull ProgressIndicator indicator) {
        if (file2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(1);
        }
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        this.myProgressIndicator = indicator;
    }

    @TestOnly
    public IndentOptionsDetectorImpl(@NotNull PsiFile file2) {
        if (file2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(2);
        }
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        this.myProgressIndicator = null;
    }

    @Nullable
    public IndentOptionsAdjuster getIndentOptionsAdjuster() {
        try {
            List<LineIndentInfo> linesInfo = this.calcLineIndentInfo(this.myProgressIndicator);
            if (linesInfo != null) {
                return new IndentOptionsAdjusterImpl(new IndentUsageStatisticsImpl(linesInfo));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)CodeStyle.getSettings((PsiFile)this.myFile).getIndentOptions(this.myFile.getFileType()).clone();
        IndentOptionsAdjuster adjuster = this.getIndentOptionsAdjuster();
        if (adjuster != null) {
            adjuster.adjust(indentOptions);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(3);
        }
        return indentOptions2;
    }

    @Nullable
    private List<LineIndentInfo> calcLineIndentInfo(@Nullable ProgressIndicator indicator) {
        if (this.myDocument == null || this.myDocument.getLineCount() < 3 || this.isFileBigToDetect()) {
            return null;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)this.myFile);
        FormattingModelBuilder modelBuilder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)this.myFile);
        if (modelBuilder2 == null) {
            return null;
        }
        FormattingModel model2 = modelBuilder2.createModel(FormattingContext.create((PsiElement)this.myFile, (CodeStyleSettings)settings));
        Block rootBlock = model2.getRootBlock();
        return new FormatterBasedLineIndentInfoBuilder(this.myDocument, rootBlock, indicator).build();
    }

    private boolean isFileBigToDetect() {
        VirtualFile file2 = this.myFile.getVirtualFile();
        return file2 != null && file2.getLength() > 0x100000L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

