/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LangBundle;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectAndAdjustIndentOptionsTask;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Automatic indent detection", NotificationDisplayType.STICKY_BALLOON, true);
    private boolean myIsEnabledInTest;
    private final Map<VirtualFile, CommonCodeStyleSettings.IndentOptions> myDiscardedOptions = ContainerUtil.createWeakMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        TimeStampedIndentOptions options2;
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if (!this.isEnabled(settings, file2)) {
            return null;
        }
        Project project = file2.getProject();
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project);
        Document document = psiManager.getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        synchronized (document2) {
            options2 = this.getValidCachedIndentOptions(file2, document);
            if (options2 != null) {
                return options2;
            }
            options2 = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document);
            options2.associateWithDocument(document);
        }
        this.scheduleDetectionInBackground(project, document, options2);
        return options2;
    }

    protected void scheduleDetectionInBackground(@NotNull Project project, @NotNull Document document, @NotNull TimeStampedIndentOptions options2) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        if (document == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        if (options2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        new DetectAndAdjustIndentOptionsTask(project, document, options2).scheduleInBackgroundForCommittedDocument();
    }

    public boolean useOnFullReformat() {
        return false;
    }

    @TestOnly
    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(6);
        }
        if (!file2.isValid() || !file2.isWritable() || file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledFile || ScratchUtil.isScratch((VirtualFile)file2.getVirtualFile())) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile || this.myDiscardedOptions.containsKey(vFile)) {
            return false;
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null && settings.AUTODETECT_INDENTS;
    }

    @TestOnly
    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    private void disableForFile(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(7);
        }
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(8);
        }
        this.myDiscardedOptions.put(file2, indentOptions);
    }

    public TimeStampedIndentOptions getValidCachedIndentOptions(PsiFile file2, Document document) {
        TimeStampedIndentOptions defaultIndentOptions;
        TimeStampedIndentOptions cachedInDocument;
        CommonCodeStyleSettings.IndentOptions options2 = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument((PsiFile)file2);
        if (options2 instanceof TimeStampedIndentOptions && !(cachedInDocument = (TimeStampedIndentOptions)options2).isOutdated(document, defaultIndentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document))) {
            return cachedInDocument;
        }
        return null;
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        if (project == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(9);
        }
        DetectionDisabledNotification notification = new DetectionDisabledNotification(project);
        notification.notify(project);
    }

    private static boolean areDetected(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(10);
        }
        return indentOptions instanceof TimeStampedIndentOptions && ((TimeStampedIndentOptions)indentOptions).isDetected();
    }

    @Nullable
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(11);
        }
        return new MyUIContributor(indentOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleDetectionInBackground";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showDisabledDetectionNotification";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "areDetected";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentStatusBarUiContributor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyUIContributor
    extends IndentStatusBarUIContributor {
        private MyUIContributor(CommonCodeStyleSettings.IndentOptions options2) {
            super(options2);
        }

        public AnAction @Nullable [] getActions(@NotNull PsiFile file2) {
            if (file2 == null) {
                MyUIContributor.$$$reportNull$$$0(0);
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
            ArrayList<Object> actions = new ArrayList<Object>();
            VirtualFile virtualFile = file2.getVirtualFile();
            Project project = file2.getProject();
            CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)project).getIndentOptions(file2.getFileType());
            String projectOptionsTip = StringUtil.capitalizeWords((String)IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)projectOptions), (boolean)true);
            if (indentOptions instanceof TimeStampedIndentOptions) {
                if (((TimeStampedIndentOptions)indentOptions).isDetected()) {
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reject", (Object[])new Object[]{projectOptionsTip}), e -> {
                        DetectableIndentOptionsProvider.this.disableForFile(virtualFile, indentOptions);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                    }));
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reindent", (Object[])new Object[]{projectOptionsTip}), e -> {
                        DetectableIndentOptionsProvider.this.disableForFile(virtualFile, indentOptions);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                        CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, file2.getTextRange())));
                        DetectableIndentOptionsProvider.this.myDiscardedOptions.remove(virtualFile);
                    }));
                    actions.add(Separator.getInstance());
                }
            } else if (DetectableIndentOptionsProvider.this.myDiscardedOptions.containsKey(virtualFile)) {
                CommonCodeStyleSettings.IndentOptions discardedOptions = DetectableIndentOptionsProvider.this.myDiscardedOptions.get(virtualFile);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                if (document != null) {
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.apply", (Object[])new Object[]{IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)discardedOptions), ColorUtil.toHex((Color)JBColor.GRAY)}), e -> {
                        DetectableIndentOptionsProvider.this.myDiscardedOptions.remove(virtualFile);
                        discardedOptions.associateWithDocument(document);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                    }));
                    actions.add(Separator.getInstance());
                }
            }
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public AnAction createDisableAction(@NotNull Project project) {
            if (project == null) {
                MyUIContributor.$$$reportNull$$$0(1);
            }
            DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.disable", (Object[])new Object[0]), e -> {
                CodeStyle.getSettings((Project)project).AUTODETECT_INDENTS = false;
                DetectableIndentOptionsProvider.this.myDiscardedOptions.clear();
                FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, null);
                DetectableIndentOptionsProvider.showDisabledDetectionNotification(project);
            });
            if (dumbAwareAction == null) {
                MyUIContributor.$$$reportNull$$$0(2);
            }
            return dumbAwareAction;
        }

        public String getHint() {
            if (DetectableIndentOptionsProvider.areDetected(this.getIndentOptions())) {
                return LangBundle.message((String)"indent.option.detected", (Object[])new Object[0]);
            }
            return null;
        }

        public boolean areActionsAvailable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyUIContributor.$$$reportNull$$$0(3);
            }
            return DetectableIndentOptionsProvider.areDetected(this.getIndentOptions()) || DetectableIndentOptionsProvider.this.myDiscardedOptions.containsKey(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$MyUIContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$MyUIContributor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDisableAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createDisableAction";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "areActionsAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ReEnableDetection
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableDetection(@NotNull Project project, Notification notification) {
            if (project == null) {
                ReEnableDetection.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReEnableDetection.$$$reportNull$$$0(1);
            }
            CodeStyle.getSettings((Project)this.myProject).AUTODETECT_INDENTS = true;
            FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)this.myProject, null);
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$ReEnableDetection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ShowIndentDetectionOptionAction
    extends DumbAwareAction {
        private ShowIndentDetectionOptionAction(@Nullable @NlsActions.ActionText String text2) {
            super(text2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowIndentDetectionOptionAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtilImpl.showSettingsDialog(e.getProject(), "preferences.sourceCode", "detect indent");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$ShowIndentDetectionOptionAction", "actionPerformed"));
        }
    }

    private static final class DetectionDisabledNotification
    extends Notification {
        private DetectionDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message((String)"code.style.indent.detector.notification.content", (Object[])new Object[0]), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableDetection(project, this));
            this.addAction((AnAction)new ShowIndentDetectionOptionAction(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }
}

