/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ThreeStateCheckBoxRenderer
extends ThreeStateCheckBox
implements TableCellRenderer,
TableCellEditor {
    private final List<CellEditorListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public ThreeStateCheckBoxRenderer() {
        this.setThirdStateEnabled(false);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ThreeStateCheckBoxRenderer.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        JCheckBox checkBox2 = this.tune(value2, isSelected, row, table, false);
        checkBox2.setOpaque(true);
        return checkBox2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.tune(value2, isSelected, row, table, hasFocus);
    }

    private JCheckBox tune(Object value2, boolean isSelected, int row, JTable table, boolean hasFocus) {
        this.setForeground(RenderingUtil.getForeground((JTable)table, (boolean)isSelected));
        this.setBackground(RenderingUtil.getBackground((JTable)table, (boolean)isSelected));
        if (value2 == null) {
            this.setState(ThreeStateCheckBox.State.DONT_CARE);
        } else {
            this.setSelected((Boolean)value2);
        }
        return this;
    }

    @Override
    @Nullable
    public Object getCellEditorValue() {
        return this.getState() != ThreeStateCheckBox.State.DONT_CARE ? Boolean.valueOf(this.isSelected()) : null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        for (CellEditorListener listener2 : this.myListeners) {
            listener2.editingStopped(e);
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        for (CellEditorListener listener2 : this.myListeners) {
            listener2.editingCanceled(e);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myListeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myListeners.remove(l);
    }
}

