/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessorKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.Consumer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0005H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/PlatformProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "Lcom/intellij/platform/CommandLineProjectOpenProcessor;", "()V", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "getName", "", "isProjectFile", "lookForProjectsInDirectory", "openProjectAndFile", "Ljava/nio/file/Path;", "line", "", "column", "tempProject", "Companion", "Option", "intellij.platform.ide.impl"})
public final class PlatformProjectOpenProcessor
extends ProjectOpenProcessor
implements CommandLineProjectOpenProcessor {
    @JvmField
    @NotNull
    public static final Key<Boolean> PROJECT_OPENED_BY_PLATFORM_PROCESSOR;
    @JvmField
    @NotNull
    public static final Key<Boolean> PROJECT_CONFIGURED_BY_PLATFORM_PROCESSOR;
    @NotNull
    public static final Companion Companion;

    public boolean canOpenProject(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2.isDirectory();
    }

    public boolean isProjectFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return false;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Path path = virtualFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"virtualFile.toNioPath()");
        Path baseDir = path;
        return Companion.doOpenProject(baseDir, OpenProjectTask.copy$default(Companion.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(baseDir, projectToClose), forceOpenInNewFrame, null, false, false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048574, null));
    }

    @Override
    @Nullable
    public Project openProjectAndFile(@NotNull Path file2, int line, int column, boolean tempProject) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (tempProject) {
            return Companion.createTempProjectAndOpenFile(file2, new OpenProjectTask(true, null, false, false, null, null, false, null, null, line, column, false, false, false, null, false, false, null, null, null, 1047038, null));
        }
        return Companion.doOpenProject(file2, new OpenProjectTask(false, null, false, false, null, null, false, null, null, line, column, false, false, false, null, false, false, null, null, null, 1047039, null));
    }

    @NotNull
    public String getName() {
        return "text editor";
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"PROJECT_OPENED_BY_PLATFORM_PROCESSOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"PRO\u2026D_BY_PLATFORM_PROCESSOR\")");
        PROJECT_OPENED_BY_PLATFORM_PROCESSOR = key;
        Key key2 = Key.create((String)"PROJECT_CONFIGURED_BY_PLATFORM_PROCESSOR");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<Boolean>(\"PRO\u2026D_BY_PLATFORM_PROCESSOR\")");
        PROJECT_CONFIGURED_BY_PLATFORM_PROCESSOR = key2;
    }

    @JvmStatic
    @NotNull
    public static final PlatformProjectOpenProcessor getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final PlatformProjectOpenProcessor getInstanceIfItExists() {
        return Companion.getInstanceIfItExists();
    }

    @JvmStatic
    @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static final Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, int line, @Nullable ProjectOpenedCallback callback2, boolean isReopen) {
        return Companion.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame, line, callback2, isReopen);
    }

    @JvmStatic
    @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static final Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, int line, @Nullable ProjectOpenedCallback callback2, @NotNull EnumSet<Option> options2) {
        return Companion.doOpenProject(virtualFile, projectToClose, line, callback2, options2);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Project createTempProjectAndOpenFile(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        return Companion.createTempProjectAndOpenFile(file2, options2);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Project doOpenProject(@NotNull Path file2, @NotNull OpenProjectTask originalOptions) {
        return Companion.doOpenProject(file2, originalOptions);
    }

    @JvmStatic
    @Deprecated(message="If project base dir differs from project store base dir, specify it as contentRoot in the options", level=DeprecationLevel.ERROR)
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    public static final Project openExistingProject(@NotNull Path file2, @NotNull Path projectStoreBaseDir, @NotNull OpenProjectTask options2) {
        return Companion.openExistingProject(file2, projectStoreBaseDir, options2);
    }

    @JvmStatic
    @NotNull
    public static final Module runDirectoryProjectConfigurators(@NotNull Path baseDir, @NotNull Project project, boolean newProject) {
        return Companion.runDirectoryProjectConfigurators(baseDir, project, newProject);
    }

    @JvmStatic
    public static final boolean attachToProject(@NotNull Project project, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
        return Companion.attachToProject(project, projectDir, callback2);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final OpenProjectTask createOptionsToOpenDotIdeaOrCreateNewIfNotExists(@NotNull Path projectDir, @Nullable Project projectToClose) {
        return Companion.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(projectDir, projectToClose);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/platform/PlatformProjectOpenProcessor$Option;", "", "(Ljava/lang/String;I)V", "FORCE_NEW_FRAME", "TEMP_PROJECT", "intellij.platform.ide.impl"})
    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option FORCE_NEW_FRAME;
        public static final /* enum */ Option TEMP_PROJECT;
        private static final /* synthetic */ Option[] $VALUES;

        static {
            Option[] optionArray = new Option[2];
            Option[] optionArray2 = optionArray;
            optionArray[0] = FORCE_NEW_FRAME = new Option();
            optionArray[1] = TEMP_PROJECT = new Option();
            $VALUES = optionArray;
        }

        public static Option[] values() {
            return (Option[])$VALUES.clone();
        }

        public static Option valueOf(String string) {
            return Enum.valueOf(Option.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011H\u0007J>\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0007J<\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0007J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0011H\u0007J\b\u0010 \u001a\u00020!H\u0007J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0007J\"\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011H\u0007J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0005H\u0007J\n\u0010)\u001a\u00020\u0005*\u00020\u000bJ\n\u0010*\u001a\u00020\u0005*\u00020\u000bR#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/platform/PlatformProjectOpenProcessor$Companion;", "", "()V", "PROJECT_CONFIGURED_BY_PLATFORM_PROCESSOR", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PROJECT_OPENED_BY_PLATFORM_PROCESSOR", "attachToProject", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "createOptionsToOpenDotIdeaOrCreateNewIfNotExists", "Lcom/intellij/ide/impl/OpenProjectTask;", "projectToClose", "createTempProjectAndOpenFile", "file", "options", "doOpenProject", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "forceOpenInNewFrame", "line", "", "isReopen", "Ljava/util/EnumSet;", "Lcom/intellij/platform/PlatformProjectOpenProcessor$Option;", "originalOptions", "getInstance", "Lcom/intellij/platform/PlatformProjectOpenProcessor;", "getInstanceIfItExists", "openExistingProject", "projectStoreBaseDir", "runDirectoryProjectConfigurators", "Lcom/intellij/openapi/module/Module;", "baseDir", "newProject", "isConfiguredByPlatformProcessor", "isOpenedByPlatformProcessor", "intellij.platform.ide.impl"})
    public static final class Companion {
        public final boolean isOpenedByPlatformProcessor(@NotNull Project $this$isOpenedByPlatformProcessor) {
            Intrinsics.checkNotNullParameter((Object)$this$isOpenedByPlatformProcessor, (String)"$this$isOpenedByPlatformProcessor");
            return Intrinsics.areEqual((Object)((Boolean)$this$isOpenedByPlatformProcessor.getUserData(PROJECT_OPENED_BY_PLATFORM_PROCESSOR)), (Object)true);
        }

        public final boolean isConfiguredByPlatformProcessor(@NotNull Project $this$isConfiguredByPlatformProcessor) {
            Intrinsics.checkNotNullParameter((Object)$this$isConfiguredByPlatformProcessor, (String)"$this$isConfiguredByPlatformProcessor");
            return Intrinsics.areEqual((Object)((Boolean)$this$isConfiguredByPlatformProcessor.getUserData(PROJECT_CONFIGURED_BY_PLATFORM_PROCESSOR)), (Object)true);
        }

        @JvmStatic
        @NotNull
        public final PlatformProjectOpenProcessor getInstance() {
            PlatformProjectOpenProcessor platformProjectOpenProcessor = this.getInstanceIfItExists();
            Intrinsics.checkNotNull((Object)platformProjectOpenProcessor);
            return platformProjectOpenProcessor;
        }

        @JvmStatic
        @Nullable
        public final PlatformProjectOpenProcessor getInstanceIfItExists() {
            ExtensionPointName extensionPointName = ProjectOpenProcessor.EXTENSION_POINT_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"EXTENSION_POINT_NAME");
            for (ProjectOpenProcessor processor2 : extensionPointName.getExtensionList()) {
                if (!(processor2 instanceof PlatformProjectOpenProcessor)) continue;
                return (PlatformProjectOpenProcessor)processor2;
            }
            return null;
        }

        @JvmStatic
        @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        @Nullable
        public final Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, int line, @Nullable ProjectOpenedCallback callback2, boolean isReopen) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            OpenProjectTask options2 = new OpenProjectTask(forceOpenInNewFrame, projectToClose, false, false, null, null, false, null, null, line, 0, false, false, false, null, false, false, null, null, null, 1048060, null);
            Path path = Paths.get(virtualFile.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(virtualFile.path)");
            return this.doOpenProject(path, options2);
        }

        @JvmStatic
        @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        @Nullable
        public final Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, int line, @Nullable ProjectOpenedCallback callback2, @NotNull EnumSet<Option> options2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(options2, (String)"options");
            Function1 function1 = null;
            Function1 function12 = null;
            Function1 function13 = null;
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            boolean bl3 = false;
            int n = line;
            boolean bl4 = false;
            int n2 = 0;
            boolean bl5 = callback2 != null;
            OpenProjectTask openProjectOptions = new OpenProjectTask(options2.contains((Object)Option.FORCE_NEW_FRAME), projectToClose, false, false, null, null, false, callback2, null, n, n2, bl4, bl5, bl3, string, bl2, bl, function13, function12, function1, 1043836, null);
            Path path = Paths.get(virtualFile.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(virtualFile.path)");
            return this.doOpenProject(path, openProjectOptions);
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Project createTempProjectAndOpenFile(@NotNull Path file2, @NotNull OpenProjectTask options2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            String dummyProjectName = ((Object)file2.getFileName()).toString();
            Path baseDir = FileUtilRt.createTempDirectory((String)dummyProjectName, null, (boolean)true).toPath();
            OpenProjectTask copy2 = OpenProjectTask.copy$default(options2, false, null, true, false, null, dummyProjectName, false, null, null, 0, 0, false, true, false, null, false, false, null, null, (Function1)new Function1<Module, Unit>(file2){
                final /* synthetic */ Path $file;

                public final void invoke(@NotNull Module module) {
                    Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                    ModuleRootModificationUtil.updateModel((Module)module, (Consumer)((Consumer)new Consumer<ModifiableRootModel>(this){
                        final /* synthetic */ createTempProjectAndOpenFile.copy.1 this$0;

                        public final void consume(ModifiableRootModel model2) {
                            ModifiableRootModel modifiableRootModel = model2;
                            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"model");
                            ContentEntry[] entries2 = modifiableRootModel.getContentEntries();
                            if (entries2.length == 1) {
                                model2.removeContentEntry(entries2[0]);
                            }
                            model2.addContentEntry(VfsUtilCore.pathToUrl((String)((Object)this.this$0.$file).toString()));
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.$file = path;
                    super(1);
                }
            }, 520155, null);
            Project project = ProjectManagerEx.getInstanceEx().openProject(baseDir, copy2);
            if (project == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ProjectManagerEx.getInst\u2026Dir, copy) ?: return null");
            Project project2 = project;
            PlatformProjectOpenProcessorKt.access$openFileFromCommandLine(project2, file2, copy2.getLine(), copy2.getColumn());
            return project2;
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Project doOpenProject(@NotNull Path file2, @NotNull OpenProjectTask originalOptions) {
            Path baseDirCandidate;
            Project lightEditProject;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)originalOptions, (String)"originalOptions");
            PlatformProjectOpenProcessorKt.access$getLOG$p().info("Opening " + file2);
            if (Files.isDirectory(file2, new LinkOption[0])) {
                return ProjectManagerEx.getInstanceEx().openProject(file2, this.createOptionsToOpenDotIdeaOrCreateNewIfNotExists(file2, null));
            }
            OpenProjectTask options2 = originalOptions;
            if (LightEditUtil.isForceOpenInLightEditMode() && (lightEditProject = LightEditUtil.openFile(file2)) != null) {
                return lightEditProject;
            }
            for (baseDirCandidate = file2.getParent(); baseDirCandidate != null && !Files.exists(baseDirCandidate.resolve(".idea"), new LinkOption[0]); baseDirCandidate = baseDirCandidate.getParent()) {
            }
            Path baseDir = null;
            if (baseDirCandidate == null) {
                PlatformProjectOpenProcessorKt.access$getLOG$p().info("No project directory found");
                if (Registry.is((String)"ide.open.file.in.temp.project.dir")) {
                    return this.createTempProjectAndOpenFile(file2, options2);
                }
                Path path = file2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.parent");
                baseDir = path;
                options2 = OpenProjectTask.copy$default(options2, false, null, !Files.isDirectory(baseDir.resolve(".idea"), new LinkOption[0]), false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048571, null);
            } else {
                baseDir = baseDirCandidate;
                PlatformProjectOpenProcessorKt.access$getLOG$p().info("Project directory found: " + baseDir);
            }
            Project project = ProjectManagerEx.getInstanceEx().openProject(baseDir, Intrinsics.areEqual((Object)baseDir, (Object)file2) ? options2 : OpenProjectTask.copy$default(options2, false, null, false, false, null, ((Object)file2.getFileName()).toString(), false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048543, null));
            if (project != null && Intrinsics.areEqual((Object)file2, (Object)baseDir) ^ true) {
                PlatformProjectOpenProcessorKt.access$openFileFromCommandLine(project, file2, options2.getLine(), options2.getColumn());
            }
            return project;
        }

        @JvmStatic
        @Deprecated(message="If project base dir differs from project store base dir, specify it as contentRoot in the options", level=DeprecationLevel.ERROR)
        @ApiStatus.Internal
        @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
        @Nullable
        public final Project openExistingProject(@NotNull Path file2, @NotNull Path projectStoreBaseDir, @NotNull OpenProjectTask options2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            if (Intrinsics.areEqual((Object)file2, (Object)projectStoreBaseDir)) {
                return ProjectManagerEx.getInstanceEx().openProject(projectStoreBaseDir, options2);
            }
            return ProjectManagerEx.getInstanceEx().openProject(projectStoreBaseDir, OpenProjectTask.copy$default(options2, false, null, false, false, null, ((Object)file2.getFileName()).toString(), false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048543, null));
        }

        @JvmStatic
        @NotNull
        public final Module runDirectoryProjectConfigurators(@NotNull Path baseDir, @NotNull Project project, boolean newProject) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.putUserData(PROJECT_CONFIGURED_BY_PLATFORM_PROCESSOR, (Object)true);
            Ref moduleRef = new Ref();
            VirtualFile virtualFile = ProjectUtil.getFileAndRefresh(baseDir);
            Intrinsics.checkNotNull((Object)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"ProjectUtil.getFileAndRefresh(baseDir)!!");
            VirtualFile virtualFile2 = virtualFile;
            PlatformProjectOpenProcessorKt.access$getEP_NAME$p().forEachExtensionSafe((java.util.function.Consumer)new java.util.function.Consumer<DirectoryProjectConfigurator>(project, virtualFile2, moduleRef, newProject){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Ref $moduleRef;
                final /* synthetic */ boolean $newProject;

                public final void accept(DirectoryProjectConfigurator configurator) {
                    Function0<Unit> $fun$task$1 = new Function0<Unit>(this, configurator){
                        final /* synthetic */ runDirectoryProjectConfigurators.1 this$0;
                        final /* synthetic */ DirectoryProjectConfigurator $configurator;

                        public final void invoke() {
                            this.$configurator.configureProject(this.this$0.$project, this.this$0.$virtualFile, (Ref<Module>)this.this$0.$moduleRef, this.this$0.$newProject);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$configurator = directoryProjectConfigurator;
                            super(0);
                        }
                    };
                    DirectoryProjectConfigurator directoryProjectConfigurator = configurator;
                    Intrinsics.checkNotNullExpressionValue((Object)directoryProjectConfigurator, (String)"configurator");
                    if (directoryProjectConfigurator.isEdtRequired()) {
                        ApplicationManager.getApplication().invokeAndWait(new Runnable($fun$task$1){
                            final /* synthetic */ Companion.runDirectoryProjectConfigurators.1 $task$1;

                            public final void run() {
                                this.$task$1.invoke();
                            }
                            {
                                this.$task$1 = var1_1;
                            }
                        });
                    } else {
                        $fun$task$1.invoke();
                    }
                }
                {
                    this.$project = project;
                    this.$virtualFile = virtualFile;
                    this.$moduleRef = ref;
                    this.$newProject = bl;
                }
            });
            Module module = (Module)moduleRef.get();
            if (module == null) {
                PlatformProjectOpenProcessorKt.access$getLOG$p().error("No extension configured a module for " + baseDir + "; extensions = " + PlatformProjectOpenProcessorKt.access$getEP_NAME$p().getExtensionList());
            }
            Module module2 = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            return module2;
        }

        @JvmStatic
        public final boolean attachToProject(@NotNull Project project, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            return ProjectAttachProcessor.EP_NAME.findFirstSafe((Predicate)new Predicate<ProjectAttachProcessor>(project, projectDir, callback2){
                final /* synthetic */ Project $project;
                final /* synthetic */ Path $projectDir;
                final /* synthetic */ ProjectOpenedCallback $callback;

                public final boolean test(ProjectAttachProcessor processor2) {
                    return processor2.attachToProject(this.$project, this.$projectDir, this.$callback);
                }
                {
                    this.$project = project;
                    this.$projectDir = path;
                    this.$callback = projectOpenedCallback;
                }
            }) != null;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final OpenProjectTask createOptionsToOpenDotIdeaOrCreateNewIfNotExists(@NotNull Path projectDir, @Nullable Project projectToClose) {
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            boolean bl = !ProjectUtil.isValidProjectPath(projectDir);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            Function1 function1 = null;
            Function1 function12 = null;
            Function1 function13 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            String string = null;
            boolean bl4 = false;
            boolean bl5 = true;
            boolean bl6 = !application.isUnitTestMode();
            int n = 0;
            int n2 = 0;
            Object var14_14 = null;
            ProjectOpenedCallback projectOpenedCallback = null;
            boolean bl7 = false;
            String string2 = null;
            Project project = null;
            Project project2 = projectToClose;
            boolean bl8 = bl;
            boolean bl9 = true;
            return new OpenProjectTask(false, project2, bl8, bl5, project, string2, bl7, projectOpenedCallback, var14_14, n2, n, bl6, bl9, bl4, string, bl3, bl2, function13, function12, function1, 1042417, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

