/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.LibraryNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPatternProvider
extends PatternDialectProvider {
    @NonNls
    public static final String FILE = "file";
    private static final Logger LOG = Logger.getInstance(ProjectPatternProvider.class);

    @Override
    public TreeModel createTreeModel(Project project, Marker marker) {
        return FileTreeModelBuilder.createTreeModel(project, false, marker);
    }

    @Override
    public TreeModel createTreeModel(Project project, Set<? extends PsiFile> deps, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return FileTreeModelBuilder.createTreeModel(project, false, deps, marker, settings);
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getShortName() {
        return FILE;
    }

    @Override
    public AnAction[] createActions(Project project, Runnable update2) {
        if (ProjectViewDirectoryHelper.getInstance(project).supportsHideEmptyMiddlePackages()) {
            return new AnAction[]{new CompactEmptyMiddlePackagesAction(update2)};
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PackageSet createPackageSet(PackageDependenciesNode node, boolean recursively) {
        if (node instanceof ModuleGroupNode) {
            if (!recursively) {
                return null;
            }
            return new FilePatternPackageSet(ProjectPatternProvider.getGroupModulePattern((ModuleGroupNode)node), "*//*");
        }
        if (node instanceof ModuleNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = ((ModuleNode)node).getModuleName();
            return new FilePatternPackageSet(modulePattern, "*/");
        }
        if (node instanceof DirectoryNode) {
            Object pattern = ((DirectoryNode)node).getFQName();
            if (pattern != null) {
                pattern = ((String)pattern).length() > 0 ? (String)pattern + (recursively ? "//*" : "/*") : (String)pattern + (recursively ? "*/" : "*");
            }
            VirtualFile vDir = ((DirectoryNode)node).getDirectory();
            PsiElement psiElement = node.getPsiElement();
            boolean projectFiles = true;
            String modulePattern = null;
            if (psiElement != null) {
                Project project = psiElement.getProject();
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vDir, (Project)project);
                if (module == null) {
                    projectFiles = false;
                    modulePattern = ProjectFileIndex.getInstance((Project)project).getOrderEntriesForFile(vDir).stream().filter(entry -> entry instanceof LibraryOrSdkOrderEntry).findFirst().map(entry -> entry instanceof JdkOrderEntry ? ((JdkOrderEntry)entry).getJdkName() : entry.getPresentableName()).orElse(null);
                } else {
                    modulePattern = module.getName();
                }
            }
            return new FilePatternPackageSet(modulePattern, (String)pattern, projectFiles);
        }
        if (node instanceof LibraryNode) {
            return new FilePatternPackageSet(node.toString(), recursively ? "*/" : "*", false);
        }
        if (node instanceof FileNode) {
            if (recursively) {
                return null;
            }
            FileNode fNode = (FileNode)node;
            PsiFile file2 = (PsiFile)fNode.getPsiElement();
            if (file2 == null) {
                return null;
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            VirtualFile contentRoot = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getContentRootForFile(virtualFile);
            if (contentRoot == null) {
                return null;
            }
            String fqName = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
            if (fqName != null) {
                return new FilePatternPackageSet(ProjectPatternProvider.getModulePattern(node), fqName);
            }
        } else if (node instanceof GeneralGroupNode) {
            return new FilePatternPackageSet("", recursively ? "*/" : "*", false);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    private static final class CompactEmptyMiddlePackagesAction
    extends ToggleAction {
        private final Runnable myUpdate;

        CompactEmptyMiddlePackagesAction(Runnable update2) {
            super(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myUpdate = update2;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                CompactEmptyMiddlePackagesAction.$$$reportNull$$$0(0);
            }
            return DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                CompactEmptyMiddlePackagesAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES = flag;
            this.myUpdate.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/packageDependencies/ui/ProjectPatternProvider$CompactEmptyMiddlePackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

