/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.scopeView.nodes.BasePsiNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.LibraryNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeModelBuilder {
    private static final Logger LOG = Logger.getInstance(FileTreeModelBuilder.class);
    public static final Key<Integer> FILE_COUNT = Key.create((String)"FILE_COUNT");
    private final ProjectFileIndex myFileIndex;
    private final Project myProject;
    private final boolean myShowModuleGroups;
    private final boolean myShowModules;
    private final boolean myFlattenPackages;
    private final boolean myCompactEmptyMiddlePackages;
    private boolean myShowFiles;
    private final Marker myMarker;
    private final boolean myAddUnmarkedFiles;
    private final PackageDependenciesNode myRoot;
    private final Map<VirtualFile, DirectoryNode> myModuleDirNodes;
    private final Map<Module, ModuleNode> myModuleNodes;
    private final Map<String, ModuleGroupNode> myModuleGroupNodes;
    private final ModuleGrouper myGrouper;
    private GeneralGroupNode myExternalNode;
    private int myScannedFileCount;
    private int myTotalFileCount;
    private int myMarkedFileCount;
    private JTree myTree;
    protected final VirtualFile myBaseDir;
    protected VirtualFile[] myContentRoots;

    public FileTreeModelBuilder(@NotNull Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        if (project == null) {
            FileTreeModelBuilder.$$$reportNull$$$0(0);
        }
        this.myModuleDirNodes = new HashMap<VirtualFile, DirectoryNode>();
        this.myModuleNodes = new HashMap<Module, ModuleNode>();
        this.myModuleGroupNodes = new HashMap<String, ModuleGroupNode>();
        this.myScannedFileCount = 0;
        this.myTotalFileCount = 0;
        this.myMarkedFileCount = 0;
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir();
        this.myContentRoots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        boolean multiModuleProject = ModuleManager.getInstance((Project)this.myProject).getModules().length > 1;
        this.myShowModules = settings.UI_SHOW_MODULES && multiModuleProject;
        this.myGrouper = ModuleGrouper.instanceFor((Project)project);
        ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(this.myProject);
        this.myFlattenPackages = directoryHelper.supportsFlattenPackages() && settings.UI_FLATTEN_PACKAGES;
        this.myCompactEmptyMiddlePackages = directoryHelper.supportsHideEmptyMiddlePackages() && settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        this.myShowFiles = settings.UI_SHOW_FILES;
        this.myShowModuleGroups = settings.UI_SHOW_MODULE_GROUPS && multiModuleProject;
        this.myMarker = marker;
        this.myAddUnmarkedFiles = !settings.UI_FILTER_LEGALS;
        this.myRoot = new RootNode(this.myProject);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public void setTree(DnDAwareTree tree) {
        this.myTree = tree;
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Set<? extends PsiFile> files2, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new FileTreeModelBuilder(project, marker, settings).build(files2, showProgress);
    }

    public static synchronized TreeModel createTreeModel(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new FileTreeModelBuilder(project, marker, settings).build(project, false);
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Marker marker) {
        return new FileTreeModelBuilder(project, marker, new DependenciesPanel.DependencyPanelSettings()).build(project, showProgress);
    }

    private void countFiles(Project project) {
        Integer fileCount = (Integer)project.getUserData(FILE_COUNT);
        if (fileCount == null) {
            Object[] roots;
            this.myFileIndex.iterateContent(fileOrDir -> {
                if (!fileOrDir.isDirectory()) {
                    this.counting();
                }
                return true;
            });
            for (VirtualFile virtualFile : roots = LibraryUtil.getLibraryRoots((Project)project)) {
                if (ContainerUtil.exists((Object[])roots, r -> VfsUtilCore.isAncestor((VirtualFile)r, (VirtualFile)root, (boolean)true))) continue;
                this.countFilesRecursively(virtualFile);
            }
            project.putUserData(FILE_COUNT, (Object)this.myTotalFileCount);
        } else {
            this.myTotalFileCount = fileCount;
        }
    }

    private void countFilesRecursively(VirtualFile file2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory()) {
                    FileTreeModelBuilder.this.counting();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/FileTreeModelBuilder$1", "visitFile"));
            }
        });
    }

    public static void clearCaches(Project project) {
        project.putUserData(FILE_COUNT, null);
    }

    public TreeModel build(Project project, boolean showProgress) {
        return this.build(project, showProgress, null);
    }

    public TreeModel build(final Project project, boolean showProgress, final @Nullable Runnable successRunnable) {
        final Runnable buildingRunnable = () -> {
            Object[] roots;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(FileTreeModelBuilder.getScanningPackagesMessage());
                indicator.setIndeterminate(true);
            }
            this.countFiles(project);
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            this.myFileIndex.iterateContent((ContentIterator)new MyContentIterator());
            for (VirtualFile virtualFile : roots = LibraryUtil.getLibraryRoots((Project)project)) {
                if (ContainerUtil.exists((Object[])roots, r -> VfsUtilCore.isAncestor((VirtualFile)r, (VirtualFile)root, (boolean)true))) continue;
                this.processFilesRecursively(virtualFile);
            }
        };
        final TreeModel treeModel = new TreeModel(this.myRoot);
        if (showProgress) {
            Task.Backgroundable backgroundable = new Task.Backgroundable(project, CodeInsightBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    buildingRunnable.run();
                }

                public void onSuccess() {
                    if (project.isDisposed()) {
                        return;
                    }
                    FileTreeModelBuilder.this.myRoot.setSorted(false);
                    FileTreeModelBuilder.this.myRoot.sortChildren();
                    treeModel.reload(FileTreeModelBuilder.this.myRoot);
                    if (successRunnable != null) {
                        successRunnable.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packageDependencies/ui/FileTreeModelBuilder$2", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)backgroundable);
        } else {
            buildingRunnable.run();
        }
        treeModel.setTotalFileCount(this.myTotalFileCount);
        treeModel.setMarkedFileCount(this.myMarkedFileCount);
        return treeModel;
    }

    private void processFilesRecursively(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTreeModelBuilder.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private PackageDependenciesNode parent;

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.parent = file2.isDirectory() ? null : FileTreeModelBuilder.this.buildFileNode(file2, this.parent);
                return true;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (file2.isDirectory()) {
                    this.parent = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/packageDependencies/ui/FileTreeModelBuilder$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterChildrenVisited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void counting() {
        ++this.myTotalFileCount;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            FileTreeModelBuilder.update(indicator, true, -1.0);
        }
    }

    private static void update(ProgressIndicator indicator, boolean indeterminate, double fraction) {
        if (indicator instanceof PanelProgressIndicator) {
            ((PanelProgressIndicator)indicator).update(FileTreeModelBuilder.getScanningPackagesMessage(), indeterminate, fraction);
        } else if (fraction != -1.0) {
            indicator.setFraction(fraction);
        }
    }

    private TreeModel build(Set<? extends PsiFile> files2, boolean showProgress) {
        if (files2.size() == 1) {
            this.myShowFiles = true;
        }
        Runnable buildingRunnable = () -> {
            for (PsiFile file2 : files2) {
                if (file2 == null) continue;
                ReadAction.run(() -> this.buildFileNode(file2.getVirtualFile(), null));
            }
        };
        if (showProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, CodeInsightBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]), false, this.myProject);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator());
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private PackageDependenciesNode buildFileNode(VirtualFile file2, PackageDependenciesNode lastParent) {
        boolean isMarked;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        if (indicator != null) {
            FileTreeModelBuilder.update(indicator, false, (double)this.myScannedFileCount++ / (double)this.myTotalFileCount);
        }
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file2);
        if (isMarked) {
            ++this.myMarkedFileCount;
        }
        if (isMarked || this.myAddUnmarkedFiles) {
            PackageDependenciesNode dirNode;
            PackageDependenciesNode packageDependenciesNode = dirNode = !this.myCompactEmptyMiddlePackages && lastParent != null ? lastParent : this.getFileParentNode(file2);
            if (this.myShowFiles) {
                FileNode fileNode = new FileNode(file2, this.myProject, isMarked);
                dirNode.add(fileNode);
            } else {
                dirNode.addFile(file2, isMarked);
            }
            return dirNode;
        }
        return null;
    }

    @NotNull
    public PackageDependenciesNode getFileParentNode(VirtualFile file2) {
        LOG.assertTrue(file2 != null);
        VirtualFile containingDirectory = file2.getParent();
        PackageDependenciesNode packageDependenciesNode = this.getModuleDirNode(containingDirectory, this.myFileIndex.getModuleForFile(file2), null);
        if (packageDependenciesNode == null) {
            FileTreeModelBuilder.$$$reportNull$$$0(2);
        }
        return packageDependenciesNode;
    }

    public boolean hasFileNode(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTreeModelBuilder.$$$reportNull$$$0(3);
        }
        return this.myModuleDirNodes.containsKey(file2);
    }

    @Nullable
    public DefaultMutableTreeNode removeNode(PsiElement element2, PsiDirectory parent) {
        TreeNode treeNode;
        LOG.assertTrue(parent != null, (Object)(element2 instanceof PsiFile && ((PsiFile)element2).getVirtualFile() != null ? ((PsiFile)element2).getVirtualFile().getPath() : element2));
        VirtualFile parentVirtualFile = parent.getVirtualFile();
        Module module = this.myFileIndex.getModuleForFile(parentVirtualFile);
        if (element2 instanceof PsiDirectory && this.myFlattenPackages) {
            PackageDependenciesNode moduleNode = this.getModuleNode(module);
            PsiDirectory psiDirectory = (PsiDirectory)element2;
            VirtualFile virtualFile = psiDirectory.getVirtualFile();
            PackageDependenciesNode dirNode = this.getModuleDirNode(virtualFile, this.myFileIndex.getModuleForFile(virtualFile), null);
            dirNode.removeFromParent();
            return moduleNode;
        }
        DirectoryNode dirNode = this.myModuleDirNodes.get(parentVirtualFile);
        if (dirNode == null) {
            return null;
        }
        DirectoryNode wrapper2 = dirNode.getWrapper();
        while (wrapper2 != null) {
            dirNode = wrapper2;
            this.myModuleDirNodes.put(wrapper2.getDirectory(), null);
            wrapper2 = dirNode.getWrapper();
        }
        PackageDependenciesNode[] classOrDirNodes = FileTreeModelBuilder.findNodeForPsiElement(dirNode, element2);
        if (classOrDirNodes != null) {
            for (PackageDependenciesNode classNode : classOrDirNodes) {
                classNode.removeFromParent();
            }
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)dirNode.getParent();
        DefaultMutableTreeNode node = dirNode;
        if (element2 == parent) {
            this.myModuleDirNodes.put(parentVirtualFile, null);
            dirNode.removeFromParent();
            node = parentNode;
        }
        while (parent != null && node != null && node.getChildCount() == 0) {
            PsiDirectory directory = parent.getParentDirectory();
            parentNode = (DefaultMutableTreeNode)node.getParent();
            node.removeFromParent();
            if (node instanceof DirectoryNode) {
                while (node != null) {
                    this.myModuleDirNodes.put(((DirectoryNode)node).getDirectory(), null);
                    node = ((DirectoryNode)node).getCompactedDirNode();
                }
            } else if (node instanceof ModuleNode) {
                this.myModuleNodes.put(((ModuleNode)node).getModule(), null);
            } else if (node instanceof ModuleGroupNode) {
                this.myModuleGroupNodes.put(((ModuleGroupNode)node).getModuleGroupName(), null);
            }
            node = parentNode;
            parent = directory;
        }
        if (this.myCompactEmptyMiddlePackages && node instanceof DirectoryNode && node.getChildCount() == 1 && (treeNode = node.getChildAt(0)) instanceof DirectoryNode) {
            node.removeAllChildren();
            for (int i2 = treeNode.getChildCount() - 1; i2 >= 0; --i2) {
                node.add((MutableTreeNode)treeNode.getChildAt(i2));
            }
            ((DirectoryNode)node).setCompactedDirNode((DirectoryNode)treeNode);
        }
        return parentNode != null ? parentNode : this.myRoot;
    }

    @Nullable
    public PackageDependenciesNode addFileNode(PsiFile file2) {
        boolean isMarked;
        VirtualFile vFile = file2.getVirtualFile();
        LOG.assertTrue(vFile != null);
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(vFile);
        if (!isMarked) {
            return null;
        }
        VirtualFile dirToReload = vFile.getParent();
        PackageDependenciesNode rootToReload = this.myModuleDirNodes.get(dirToReload);
        if (rootToReload == null && this.myFlattenPackages) {
            Module module = this.myFileIndex.getModuleForFile(vFile);
            boolean moduleNodeExist = this.myModuleNodes.get(module) != null;
            rootToReload = this.getModuleNode(module);
            if (!moduleNodeExist) {
                rootToReload = null;
            }
        } else {
            while ((rootToReload == null || ((DirectoryNode)rootToReload).getCompactedDirNode() != null) && dirToReload != null) {
                dirToReload = dirToReload.getParent();
                rootToReload = this.myModuleDirNodes.get(dirToReload);
            }
        }
        PackageDependenciesNode dirNode = this.getFileParentNode(vFile);
        if (FileTreeModelBuilder.findNodeForPsiElement(dirNode, (PsiElement)file2) == null) {
            dirNode.add(new FileNode(vFile, this.myProject, true));
        }
        return rootToReload;
    }

    @Nullable
    public PackageDependenciesNode addDirNode(PsiDirectory dir) {
        VirtualFile vFile = dir.getVirtualFile();
        if (this.myMarker == null) {
            return null;
        }
        final boolean[] isMarked = new boolean[]{this.myMarker.isMarked(vFile)};
        VirtualFile dirToReload = vFile.getParent();
        PackageDependenciesNode rootToReload = this.myModuleDirNodes.get(dirToReload);
        if (rootToReload == null && this.myFlattenPackages) {
            Module module = this.myFileIndex.getModuleForFile(vFile);
            boolean moduleNodeExist = this.myModuleNodes.get(module) != null;
            rootToReload = this.getModuleNode(module);
            if (!moduleNodeExist) {
                rootToReload = null;
            }
        } else {
            while (rootToReload == null && dirToReload != null) {
                dirToReload = dirToReload.getParent();
                rootToReload = this.myModuleDirNodes.get(dirToReload);
            }
        }
        this.myFileIndex.iterateContentUnderDirectory(vFile, (ContentIterator)new MyContentIterator(){

            @Override
            public boolean processFile(@NotNull VirtualFile fileOrDir) {
                if (fileOrDir == null) {
                    4.$$$reportNull$$$0(0);
                }
                isMarked[0] = isMarked[0] | FileTreeModelBuilder.this.myMarker.isMarked(fileOrDir);
                return super.processFile(fileOrDir);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/packageDependencies/ui/FileTreeModelBuilder$4", "processFile"));
            }
        });
        if (!isMarked[0]) {
            return null;
        }
        this.getModuleDirNode(vFile, this.myFileIndex.getModuleForFile(vFile), null);
        return rootToReload != null ? rootToReload : this.myRoot;
    }

    @Nullable
    public PackageDependenciesNode findNode(PsiFileSystemItem file2, PsiElement psiElement) {
        if (file2 instanceof PsiDirectory) {
            return this.getModuleDirNode(file2.getVirtualFile(), this.myFileIndex.getModuleForFile(file2.getVirtualFile()), null);
        }
        PackageDependenciesNode parent = this.getFileParentNode(file2.getVirtualFile());
        PackageDependenciesNode[] nodes = FileTreeModelBuilder.findNodeForPsiElement(parent, (PsiElement)file2);
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        for (PackageDependenciesNode node : nodes) {
            if (node.getPsiElement() != psiElement) continue;
            return node;
        }
        return nodes[0];
    }

    public static PackageDependenciesNode @Nullable [] findNodeForPsiElement(PackageDependenciesNode parent, PsiElement element2) {
        HashSet<PackageDependenciesNode> result2 = new HashSet<PackageDependenciesNode>();
        for (int i2 = 0; i2 < parent.getChildCount(); ++i2) {
            TreeNode treeNode = parent.getChildAt(i2);
            if (!(treeNode instanceof PackageDependenciesNode)) continue;
            PackageDependenciesNode node = (PackageDependenciesNode)treeNode;
            if (element2 instanceof PsiDirectory && node.getPsiElement() == element2) {
                return new PackageDependenciesNode[]{node};
            }
            if (!(element2 instanceof PsiFile)) continue;
            PsiFile psiFile = null;
            if (node instanceof BasePsiNode) {
                psiFile = ((BasePsiNode)node).getContainingFile();
            } else if (node instanceof FileNode) {
                psiFile = (PsiFile)node.getPsiElement();
            }
            if (psiFile == null || !Comparing.equal((Object)psiFile.getVirtualFile(), (Object)((PsiFile)element2).getVirtualFile())) continue;
            result2.add(node);
        }
        return result2.isEmpty() ? null : result2.toArray(new PackageDependenciesNode[0]);
    }

    private PackageDependenciesNode getModuleDirNode(VirtualFile virtualFile, Module module, DirectoryNode childNode) {
        if (virtualFile == null) {
            return this.getModuleNode(module);
        }
        PackageDependenciesNode directoryNode = this.myModuleDirNodes.get(virtualFile);
        if (directoryNode != null) {
            if (this.myCompactEmptyMiddlePackages) {
                DirectoryNode parentWrapper;
                DirectoryNode nestedNode = ((DirectoryNode)directoryNode).getCompactedDirNode();
                if (nestedNode != null) {
                    boolean expand = false;
                    if (this.myTree != null) {
                        expand = !this.myTree.isCollapsed(new TreePath(directoryNode.getPath()));
                    }
                    DirectoryNode parentWrapper2 = nestedNode.getWrapper();
                    while (parentWrapper2.getWrapper() != null) {
                        parentWrapper2 = parentWrapper2.getWrapper();
                    }
                    for (int i2 = parentWrapper2.getChildCount() - 1; i2 >= 0; --i2) {
                        nestedNode.add((MutableTreeNode)parentWrapper2.getChildAt(i2));
                    }
                    ((DirectoryNode)directoryNode).setCompactedDirNode(null);
                    parentWrapper2.add(nestedNode);
                    nestedNode.removeUpReference();
                    if (this.myTree != null && expand) {
                        Runnable expandRunnable = () -> this.myTree.expandPath(new TreePath(nestedNode.getPath()));
                        SwingUtilities.invokeLater(expandRunnable);
                    }
                    return parentWrapper2;
                }
                if (directoryNode.getParent() == null && (parentWrapper = ((DirectoryNode)directoryNode).getWrapper()) != null) {
                    while (parentWrapper.getWrapper() != null) {
                        parentWrapper = parentWrapper.getWrapper();
                    }
                    return parentWrapper;
                }
            }
            return directoryNode;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
        VirtualFile classRoot = fileIndex.getClassRootForFile(virtualFile);
        directoryNode = new DirectoryNode(virtualFile, this.myProject, this.myCompactEmptyMiddlePackages, this.myFlattenPackages, this.myBaseDir, this.myContentRoots);
        this.myModuleDirNodes.put(virtualFile, (DirectoryNode)directoryNode);
        VirtualFile directory = virtualFile.getParent();
        if (!this.myFlattenPackages && directory != null && !Comparing.equal((Object)virtualFile, (Object)classRoot)) {
            if (this.myCompactEmptyMiddlePackages && !Comparing.equal((Object)sourceRoot, (Object)virtualFile) && !Comparing.equal((Object)contentRoot, (Object)virtualFile)) {
                ((DirectoryNode)directoryNode).setCompactedDirNode(childNode);
            }
            if (fileIndex.getModuleForFile(directory) == module) {
                DirectoryNode parentDirectoryNode = this.myModuleDirNodes.get(directory);
                if (parentDirectoryNode != null || !this.myCompactEmptyMiddlePackages || sourceRoot != null && VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)sourceRoot, (boolean)false) && fileIndex.getSourceRootForFile(directory) != null || Comparing.equal((Object)directory, (Object)contentRoot) || Comparing.equal((Object)directory, (Object)classRoot)) {
                    this.getModuleDirNode(directory, module, (DirectoryNode)directoryNode).add(directoryNode);
                } else {
                    directoryNode = this.getModuleDirNode(directory, module, (DirectoryNode)directoryNode);
                }
            } else {
                this.getModuleNode(module).add(directoryNode);
            }
        } else {
            if ((directory == null || Comparing.equal((Object)virtualFile, (Object)classRoot)) && fileIndex.isInLibrary(virtualFile)) {
                List orderEntriesForFile = fileIndex.getOrderEntriesForFile(virtualFile);
                if (orderEntriesForFile.isEmpty()) {
                    this.myRoot.add(directoryNode);
                } else {
                    LibraryNode node = new LibraryNode((OrderEntry)orderEntriesForFile.get(0), this.myProject);
                    LibraryNode existingLibraryNode = this.getExistingLibraryNode(node);
                    if (existingLibraryNode != null) {
                        node = existingLibraryNode;
                    } else {
                        this.addExternalDepNode(node);
                    }
                    node.add(directoryNode);
                }
                return directoryNode;
            }
            if (Comparing.equal((Object)contentRoot, (Object)virtualFile)) {
                this.getModuleNode(module).add(directoryNode);
            } else {
                Object root = !Comparing.equal((Object)sourceRoot, (Object)virtualFile) && sourceRoot != null ? sourceRoot : (contentRoot != null ? contentRoot : null);
                if (root != null) {
                    this.getModuleDirNode((VirtualFile)root, module, null).add(directoryNode);
                } else {
                    this.addExternalDepNode(directoryNode);
                }
            }
        }
        return directoryNode;
    }

    private LibraryNode getExistingLibraryNode(LibraryNode node) {
        if (this.myExternalNode != null) {
            for (int i2 = 0; i2 < this.myExternalNode.getChildCount(); ++i2) {
                TreeNode child2 = this.myExternalNode.getChildAt(i2);
                if (!(child2 instanceof LibraryNode) || !child2.equals(node)) continue;
                return (LibraryNode)child2;
            }
        }
        return null;
    }

    private void addExternalDepNode(PackageDependenciesNode node) {
        if (this.myExternalNode == null) {
            this.myExternalNode = new GeneralGroupNode("External Dependencies", AllIcons.Nodes.PpLibFolder, this.myProject);
            this.myRoot.add(this.myExternalNode);
        }
        this.myExternalNode.add(node);
    }

    @Nullable
    private PackageDependenciesNode getModuleNode(Module module) {
        if (module == null || !this.myShowModules) {
            return this.myRoot;
        }
        ModuleNode node = this.myModuleNodes.get(module);
        if (node != null) {
            return node;
        }
        node = new ModuleNode(module, this.myShowModuleGroups ? this.myGrouper : null);
        List groupPath = this.myGrouper.getGroupPath(module);
        if (groupPath.isEmpty()) {
            this.myModuleNodes.put(module, node);
            this.myRoot.add(node);
            return node;
        }
        this.myModuleNodes.put(module, node);
        if (this.myShowModuleGroups) {
            this.getParentModuleGroup(groupPath).add(node);
        } else {
            this.myRoot.add(node);
        }
        return node;
    }

    private PackageDependenciesNode getParentModuleGroup(List<String> groupPath) {
        String key = StringUtil.join(groupPath, (String)"");
        ModuleGroupNode groupNode = this.myModuleGroupNodes.get(key);
        if (groupNode == null) {
            groupNode = new ModuleGroupNode(new ModuleGroup(groupPath), this.myProject);
            this.myModuleGroupNodes.put(key, groupNode);
            this.myRoot.add(groupNode);
        }
        if (groupPath.size() > 1) {
            PackageDependenciesNode node = this.getParentModuleGroup(groupPath.subList(0, groupPath.size() - 1));
            node.add(groupNode);
        }
        return groupNode;
    }

    @NlsContexts.ProgressText
    public static String getScanningPackagesMessage() {
        return CodeInsightBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/ui/FileTreeModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/ui/FileTreeModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileParentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasFileNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyContentIterator
    implements ContentIterator {
        PackageDependenciesNode lastParent = null;
        VirtualFile dir;

        private MyContentIterator() {
        }

        public boolean processFile(@NotNull VirtualFile fileOrDir) {
            if (fileOrDir == null) {
                MyContentIterator.$$$reportNull$$$0(0);
            }
            ReadAction.run(() -> {
                if (!fileOrDir.isDirectory()) {
                    if (this.lastParent != null && !Comparing.equal((Object)this.dir, (Object)fileOrDir.getParent())) {
                        this.lastParent = null;
                    }
                    this.lastParent = FileTreeModelBuilder.this.buildFileNode(fileOrDir, this.lastParent);
                    this.dir = fileOrDir.getParent();
                } else {
                    this.lastParent = null;
                }
            });
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/packageDependencies/ui/FileTreeModelBuilder$MyContentIterator", "processFile"));
        }
    }
}

