/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.application.Topics;
import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.AboutPopup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeScreenComponentFactory {
    @NotNull
    static JComponent createSmallLogo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        String welcomeScreenLogoUrl = appInfo.getApplicationSvgIconUrl();
        if (welcomeScreenLogoUrl != null) {
            Icon icon2 = IconLoader.getIcon((String)welcomeScreenLogoUrl);
            float scale = 28.0f / (float)icon2.getIconWidth();
            Icon smallLogoIcon = IconUtil.scale(icon2, null, scale);
            JLabel logo = new JLabel(smallLogoIcon);
            logo.setBorder((Border)JBUI.Borders.empty((int)29, (int)0, (int)27, (int)0));
            logo.setHorizontalAlignment(0);
            panel2.add((Component)logo, (Object)"West");
        }
        String applicationName = Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
        JLabel appName = new JLabel(applicationName);
        appName.setForeground(JBColor.foreground());
        appName.setFont(appName.getFont().deriveFont(0));
        final ActionLink copyAbout = new ActionLink("", EmptyIcon.ICON_16, WelcomeScreenComponentFactory.createCopyAboutAction());
        copyAbout.setHoveringIcon(AllIcons.Actions.Copy);
        copyAbout.setToolTipText(IdeBundle.message((String)"welcome.screen.copy.about.action.text", (Object[])new Object[0]));
        Object appVersion = appInfo.getFullVersion();
        if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
            appVersion = (String)appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
        }
        JLabel version2 = new JLabel((String)appVersion);
        version2.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        version2.setForeground((Color)Gray._128);
        NonOpaquePanel textPanel = new NonOpaquePanel();
        textPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        textPanel.setBorder((Border)JBUI.Borders.empty((int)28, (int)10, (int)25, (int)10));
        BorderLayoutPanel namePanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((Component)appName).andTransparent()).addToRight((Component)copyAbout);
        textPanel.add((Component)namePanel);
        textPanel.add((Component)version2);
        panel2.add((Component)textPanel, (Object)"Center");
        panel2.setToolTipText(applicationName + " " + (String)appVersion);
        panel2.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                copyAbout.setIcon(AllIcons.Actions.Copy);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                copyAbout.setIcon(EmptyIcon.ICON_16);
            }
        });
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(0);
        }
        return nonOpaquePanel;
    }

    @NotNull
    static JComponent createLogo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        String welcomeScreenLogoUrl = appInfo.getWelcomeScreenLogoUrl();
        if (welcomeScreenLogoUrl != null) {
            JLabel logo = new JLabel(IconLoader.getIcon((String)welcomeScreenLogoUrl));
            logo.setBorder((Border)JBUI.Borders.empty((int)30, (int)0, (int)10, (int)0));
            logo.setHorizontalAlignment(0);
            panel2.add((Component)logo, (Object)"North");
        }
        String applicationName = Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
        JLabel appName = new JLabel(applicationName);
        appName.setForeground(JBColor.foreground());
        appName.setFont(WelcomeScreenUIManager.getProductFont(36).deriveFont(0));
        appName.setHorizontalAlignment(0);
        Object appVersion = IdeBundle.message((String)"welcome.screen.logo.version.label", (Object[])new Object[]{appInfo.getFullVersion()});
        if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
            appVersion = (String)appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
        }
        JLabel version2 = new JLabel((String)appVersion);
        version2.setFont(WelcomeScreenUIManager.getProductFont(16));
        version2.setHorizontalAlignment(0);
        version2.setForeground((Color)Gray._128);
        panel2.add((Component)appName);
        panel2.add((Component)version2, (Object)"South");
        panel2.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(1);
        }
        return nonOpaquePanel;
    }

    private static AnAction createCopyAboutAction() {
        return DumbAwareAction.create(e -> CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(AboutPopup.getAboutText())));
    }

    static JComponent createRecentProjects(Disposable parentDisposable) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new NewRecentProjectPanel(parentDisposable), "Center");
        panel2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        panel2.setBorder((Border)new CustomLineBorder((Color)WelcomeScreenUIManager.getSeparatorColor(), (Insets)JBUI.insetsRight((int)1)));
        return panel2;
    }

    static JLabel createArrow(final ActionLink link2) {
        JLabel arrow = new JLabel(AllIcons.General.LinkDropTriangle);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MouseEvent newEvent = MouseEventAdapter.convert((MouseEvent)e, (Component)link2, (int)e.getX(), (int)e.getY());
                link2.doClick((InputEvent)newEvent);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$2", "onClick"));
            }
        }.installOn((Component)arrow);
        return arrow;
    }

    @NotNull
    public static AnAction createShowPopupAction(final @NonNls @NotNull String groupId2) {
        if (groupId2 == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(2);
        }
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId2);
                PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, configureGroup, e.getDataContext(), false, false, false, false, null, -1, null, "WelcomeScreen", new MenuItemPresentationFactory(true), false);
                popup2.showUnderneathOf(Objects.requireNonNull(e.getInputEvent().getComponent()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$3", "actionPerformed"));
            }
        };
    }

    static JComponent createActionLink(@NotNull Container parentContainer, @Nls String text2, String groupId2, Icon icon2, @Nullable Component focusOnLeft) {
        if (parentContainer == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(3);
        }
        AnAction action2 = WelcomeScreenComponentFactory.createShowPopupAction(groupId2);
        JComponent panel2 = WelcomeScreenComponentFactory.wrapActionLink(new ActionLink(text2, icon2, action2));
        WelcomeScreenFocusManager.installFocusable(parentContainer, panel2, action2, 40, 38, focusOnLeft);
        return panel2;
    }

    public static JComponent wrapActionLink(@NotNull ActionLink link2) {
        if (link2 == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(4);
        }
        JPanel panel2 = (JPanel)WelcomeScreenComponentFactory.wrapActionLinkWithoutArrow(link2);
        if (!StringUtil.isEmptyOrSpaces((String)link2.getText())) {
            panel2.add((Component)WelcomeScreenComponentFactory.createArrow(link2), "East");
        }
        return panel2;
    }

    public static JComponent wrapActionLinkWithoutArrow(@NotNull ActionLink link2) {
        if (link2 == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(5);
        }
        link2.setFocusable(false);
        link2.setPaintUnderline(false);
        link2.setNormalColor(WelcomeScreenUIManager.getLinkNormalColor());
        JActionLinkPanel panel2 = new JActionLinkPanel(link2);
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        return panel2;
    }

    public static JComponent createErrorsLink(Disposable parent) {
        IdeMessagePanel panel2 = new IdeMessagePanel(null, MessagePool.getInstance());
        panel2.setBorder((Border)JBUI.Borders.emptyRight((int)13));
        panel2.setOpaque(false);
        Disposer.register((Disposable)parent, (Disposable)panel2);
        return panel2;
    }

    @NotNull
    public static Component createEventLink(@NotNull @Nls String linkText, @NotNull Disposable parentDisposable) {
        if (linkText == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(7);
        }
        ActionLink actionLink2 = new ActionLink(linkText, AllIcons.Ide.Notification.NoEvents, new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                BalloonLayout balloonLayout;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((balloonLayout = WelcomeFrame.getInstance().getBalloonLayout()) instanceof WelcomeBalloonLayoutImpl) {
                    WelcomeBalloonLayoutImpl welcomeBalloonLayout = (WelcomeBalloonLayoutImpl)balloonLayout;
                    if (welcomeBalloonLayout.getLocationComponent() == null && e.getInputEvent() != null) {
                        welcomeBalloonLayout.setLocationComponent(e.getInputEvent().getComponent());
                    }
                    welcomeBalloonLayout.showPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$4", "actionPerformed"));
            }
        });
        JComponent panel2 = WelcomeScreenComponentFactory.wrapActionLink(actionLink2);
        panel2.setVisible(false);
        Topics.subscribe(WelcomeBalloonLayoutImpl.BALLOON_NOTIFICATION_TOPIC, (Disposable)parentDisposable, types -> {
            if (!types.isEmpty()) {
                NotificationType type = (NotificationType)Collections.max(types);
                actionLink2.setIcon(type == NotificationType.IDE_UPDATE ? AllIcons.Ide.Notification.IdeUpdate : IdeNotificationArea.createIconWithNotificationCount(panel2, type, types.size(), false));
            }
            panel2.setVisible(!types.isEmpty());
        });
        JComponent jComponent = panel2;
        if (jComponent == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @Nls
    public static String getApplicationTitle() {
        String suffix;
        Object title = IdeBundle.message((String)"label.welcome.to.0", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (Boolean.getBoolean("ide.ui.version.in.title")) {
            title = (String)title + " " + ApplicationInfo.getInstance().getFullVersion();
        }
        if ((suffix = ProjectFrameHelper.getSuperUserSuffix()) != null) {
            title = (String)title + " (" + suffix + ")";
        }
        return title;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContainer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmallLogo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventLink";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createShowPopupAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createActionLink";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionLink";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionLinkWithoutArrow";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEventLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class JActionLinkPanel
    extends JPanel {
        @NotNull
        private final ActionLink myActionLink;

        public JActionLinkPanel(@NotNull ActionLink actionLink2) {
            if (actionLink2 == null) {
                JActionLinkPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myActionLink = actionLink2;
            this.add((Component)this.myActionLink);
            this.setOpaque(false);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJActionLinkPanel(this.myActionLink.getAccessibleContext());
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionLink", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$JActionLinkPanel", "<init>"));
        }

        protected final class AccessibleJActionLinkPanel
        extends AccessibleContextDelegate {
            private final JComponent.AccessibleJComponent myAccessibleHelper;

            AccessibleJActionLinkPanel(AccessibleContext context) {
                super(context);
                this.myAccessibleHelper = new JComponent.AccessibleJComponent(){};
            }

            public Container getDelegateParent() {
                return JActionLinkPanel.this.getParent();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PUSH_BUTTON;
            }

            public int getAccessibleChildrenCount() {
                return this.myAccessibleHelper.getAccessibleChildrenCount();
            }

            public Accessible getAccessibleChild(int i2) {
                return this.myAccessibleHelper.getAccessibleChild(i2);
            }
        }
    }
}

