/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarWidgetUsagesCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("status.bar.widgets", 1);
    private static final EventId3<PluginInfo, String, Boolean> WIDGET = GROUP.registerEvent("widget", (EventField)EventFields.PluginInfo, (EventField)EventFields.StringValidatedByCustomRule((String)"id", (String)"status_bar_widget_factory"), (EventField)EventFields.Boolean((String)"enabled"));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        StatusBarWidgetSettings settings = (StatusBarWidgetSettings)((Object)ApplicationManager.getApplication().getService(StatusBarWidgetSettings.class));
        StatusBarWidgetFactory.EP_NAME.processWithPluginDescriptor((factory2, plugin2) -> {
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin2);
            boolean enabled = settings.isEnabled((StatusBarWidgetFactory)factory2);
            if (enabled != factory2.isEnabledByDefault()) {
                result2.add(WIDGET.metric((Object)pluginInfo, (Object)factory2.getId(), (Object)enabled));
            }
        });
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            StatusBarWidgetUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetUsagesCollector", "getMetrics"));
    }

    public static class StatusBarWidgetFactoryValidationRule
    extends CustomValidationRule {
        public static final String RULE_ID = "status_bar_widget_factory";

        public boolean acceptRuleId(@Nullable String ruleId) {
            return RULE_ID.equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                StatusBarWidgetFactoryValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                StatusBarWidgetFactoryValidationRule.$$$reportNull$$$0(1);
            }
            for (StatusBarWidgetFactory type : (StatusBarWidgetFactory[])StatusBarWidgetFactory.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)type.getId(), (CharSequence)data2)) continue;
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
                ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    StatusBarWidgetFactoryValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                StatusBarWidgetFactoryValidationRule.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetUsagesCollector$StatusBarWidgetFactoryValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetUsagesCollector$StatusBarWidgetFactoryValidationRule";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

