/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.PresentationModeProgressPanel;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProcessBalloon {
    private final List<InfoAndProgressPanel.MyInlineProgressIndicator> myIndicators = new ArrayList<InfoAndProgressPanel.MyInlineProgressIndicator>();
    private final int myMaxVisible;
    private int myVisible;

    ProcessBalloon(int visibleCount) {
        this.myMaxVisible = visibleCount;
    }

    public void addIndicator(@Nullable JRootPane pane2, @NotNull InfoAndProgressPanel.MyInlineProgressIndicator indicator) {
        if (indicator == null) {
            ProcessBalloon.$$$reportNull$$$0(0);
        }
        if (pane2 != null) {
            this.myIndicators.add(indicator);
            this.show(pane2);
        }
    }

    public void removeIndicator(@Nullable JRootPane pane2, @NotNull InfoAndProgressPanel.MyInlineProgressIndicator indicator) {
        if (indicator == null) {
            ProcessBalloon.$$$reportNull$$$0(1);
        }
        this.myIndicators.remove(indicator);
        if (indicator.myPresentationModeProgressPanel != null) {
            --this.myVisible;
            if (pane2 != null && !this.myIndicators.isEmpty()) {
                this.show(pane2);
            }
        }
    }

    private void show(final @NotNull JRootPane pane2) {
        if (pane2 == null) {
            ProcessBalloon.$$$reportNull$$$0(2);
        }
        ArrayList<InfoAndProgressPanel.MyInlineProgressIndicator> indicators = new ArrayList<InfoAndProgressPanel.MyInlineProgressIndicator>();
        for (final InfoAndProgressPanel.MyInlineProgressIndicator indicator : this.myIndicators) {
            if (indicator.myPresentationModeProgressPanel == null) {
                if (this.myVisible == this.myMaxVisible) continue;
                ++this.myVisible;
                indicator.myPresentationModeProgressPanel = new PresentationModeProgressPanel(indicator);
                indicator.updateProgressNow();
                indicator.myPresentationModeBalloon = ProcessBalloon.create(pane2, indicator, indicator.myPresentationModeProgressPanel.getProgressPanel());
                indicator.myPresentationModeShowBalloon = true;
                indicators.add(indicator);
                continue;
            }
            if (indicator.myPresentationModeBalloon.isDisposed()) continue;
            indicators.add(indicator);
        }
        for (final InfoAndProgressPanel.MyInlineProgressIndicator indicator : indicators) {
            if (indicator.myPresentationModeShowBalloon) {
                indicator.myPresentationModeShowBalloon = false;
                indicator.myPresentationModeBalloon.show((PositionTracker)new PositionTracker<Balloon>(ProcessBalloon.getAnchor(pane2)){

                    public RelativePoint recalculateLocation(@NotNull Balloon balloon2) {
                        Component component2;
                        if (balloon2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Component c = ProcessBalloon.getAnchor(pane2);
                        int y = c.getHeight() - JBUIScale.scale((int)45);
                        BalloonLayoutImpl balloonLayout = ProcessBalloon.getBalloonLayout(pane2);
                        if (balloonLayout != null && !ProcessBalloon.isBottomSideToolWindowsVisible(pane2) && (component2 = balloonLayout.getTopBalloonComponent()) != null) {
                            y = SwingUtilities.convertPoint((Component)component2, (int)0, (int)(-JBUIScale.scale((int)45)), (Component)c).y;
                        }
                        if (ProcessBalloon.this.myVisible > 1) {
                            int index2 = ProcessBalloon.this.myIndicators.indexOf(indicator);
                            int rowHeight = balloon2.getPreferredSize().height + JBUI.scale((int)5);
                            y -= rowHeight * (ProcessBalloon.this.myVisible - index2 - 1);
                        }
                        return new RelativePoint(c, new Point(c.getWidth() - JBUIScale.scale((int)150), y));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/openapi/wm/impl/status/ProcessBalloon$1", "recalculateLocation"));
                    }
                }, Balloon.Position.above);
                continue;
            }
            indicator.myPresentationModeBalloon.revalidate();
        }
    }

    @NotNull
    private static Balloon create(@NotNull JRootPane pane2, @NotNull Disposable parentDisposable, @NotNull JComponent content2) {
        if (pane2 == null) {
            ProcessBalloon.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            ProcessBalloon.$$$reportNull$$$0(4);
        }
        if (content2 == null) {
            ProcessBalloon.$$$reportNull$$$0(5);
        }
        final Balloon balloon2 = JBPopupFactory.getInstance().createBalloonBuilder(content2).setFadeoutTime(0L).setFillColor(Gray.TRANSPARENT).setShowCallout(false).setBorderColor(Gray.TRANSPARENT).setBorderInsets((Insets)JBUI.emptyInsets()).setAnimationCycle(0).setCloseButtonEnabled(false).setHideOnClickOutside(false).setDisposable(parentDisposable).setHideOnFrameResize(false).setHideOnKeyOutside(false).setBlockClicksThroughBalloon(true).setHideOnAction(false).setShadow(false).createBalloon();
        final BalloonLayoutImpl balloonLayout = ProcessBalloon.getBalloonLayout(pane2);
        if (balloonLayout != null) {
            class MyListener
            implements JBPopupListener,
            Runnable {
                MyListener() {
                }

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        MyListener.$$$reportNull$$$0(0);
                    }
                    balloonLayout.addListener(this);
                }

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        MyListener.$$$reportNull$$$0(1);
                    }
                    balloonLayout.removeListener(this);
                }

                @Override
                public void run() {
                    if (!balloon2.isDisposed()) {
                        balloon2.revalidate();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/openapi/wm/impl/status/ProcessBalloon$1MyListener";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeShown";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onClosed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            balloon2.addListener((JBPopupListener)new MyListener());
        }
        Balloon balloon3 = balloon2;
        if (balloon3 == null) {
            ProcessBalloon.$$$reportNull$$$0(6);
        }
        return balloon3;
    }

    @Nullable
    private static BalloonLayoutImpl getBalloonLayout(@NotNull JRootPane pane2) {
        Component parent;
        if (pane2 == null) {
            ProcessBalloon.$$$reportNull$$$0(7);
        }
        if ((parent = UIUtil.findUltimateParent((Component)pane2)) instanceof IdeFrame) {
            return (BalloonLayoutImpl)((IdeFrame)parent).getBalloonLayout();
        }
        return null;
    }

    @NotNull
    private static Component getAnchor(@NotNull JRootPane pane2) {
        JComponent tabWrapper;
        if (pane2 == null) {
            ProcessBalloon.$$$reportNull$$$0(8);
        }
        if ((tabWrapper = UIUtil.findComponentOfType((JComponent)pane2, TabbedPaneWrapper.TabWrapper.class)) != null && tabWrapper.isShowing()) {
            JComponent jComponent = tabWrapper;
            if (jComponent == null) {
                ProcessBalloon.$$$reportNull$$$0(9);
            }
            return jComponent;
        }
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.findComponentOfType((JComponent)pane2, EditorsSplitters.class));
        if (splitters != null) {
            Object object = splitters.isShowing() ? splitters : pane2;
            if (object == null) {
                ProcessBalloon.$$$reportNull$$$0(10);
            }
            return object;
        }
        FileEditorManagerEx ex = FileEditorManagerEx.getInstanceEx(ProjectUtil.guessCurrentProject((JComponent)pane2));
        if (ex == null) {
            JRootPane jRootPane = pane2;
            if (jRootPane == null) {
                ProcessBalloon.$$$reportNull$$$0(11);
            }
            return jRootPane;
        }
        splitters = ex.getSplitters();
        Object object = splitters.isShowing() ? splitters : pane2;
        if (object == null) {
            ProcessBalloon.$$$reportNull$$$0(12);
        }
        return object;
    }

    private static boolean isBottomSideToolWindowsVisible(@NotNull JRootPane parent) {
        ToolWindowsPane pane2;
        if (parent == null) {
            ProcessBalloon.$$$reportNull$$$0(13);
        }
        return (pane2 = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)parent, ToolWindowsPane.class))) != null && pane2.isBottomSideToolWindowsVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/ProcessBalloon";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/ProcessBalloon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeIndicator";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBalloonLayout";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBottomSideToolWindowsVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

