/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineProgressIndicator
extends ProgressIndicatorBase
implements Disposable {
    protected final TextPanel myText;
    private final TextPanel myText2;
    @NotNull
    private final JBIterable<ProgressButton> myEastButtons;
    @NotNull
    protected final JProgressBar myProgress;
    protected final JPanel myComponent;
    private final boolean myCompact;
    private TaskInfo myInfo;
    private final TextPanel myProcessName;
    private boolean myDisposed;

    public InlineProgressIndicator(boolean compact, @NotNull TaskInfo processInfo) {
        if (processInfo == null) {
            InlineProgressIndicator.$$$reportNull$$$0(0);
        }
        this.myCompact = compact;
        this.myInfo = processInfo;
        this.myProgress = new JProgressBar(0);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myProgress);
        this.myText = new TextPanel();
        this.myText2 = new TextPanel();
        this.myProcessName = new TextPanel();
        this.myEastButtons = this.createEastButtons();
        this.myComponent = this.createComponent();
    }

    @NotNull
    protected JPanel createComponent() {
        MyComponent component2 = new MyComponent(this.myCompact, (JComponent)((Object)this.myProcessName));
        if (this.myCompact) {
            component2.setLayout(new BorderLayout(2, 0));
            this.createCompactTextAndProgress(component2);
            component2.add((Component)InlineProgressIndicator.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(b -> b.button)), "East");
            component2.setToolTipText(this.myInfo.getTitle() + ". " + IdeBundle.message((String)"progress.text.clickToViewProgressWindow", (Object[])new Object[0]));
        } else {
            component2.setLayout(new BorderLayout());
            this.myProcessName.setText(this.myInfo.getTitle());
            component2.add((Component)((Object)this.myProcessName), "North");
            this.myProcessName.setForeground(UIUtil.getPanelBackground().brighter().brighter());
            this.myProcessName.setBorder(JBUI.Borders.empty((int)2));
            NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            content2.setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)(this.myInfo.isCancellable() ? 2 : 4)));
            component2.add((Component)content2, "Center");
            content2.add((Component)InlineProgressIndicator.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(b -> InlineProgressIndicator.withBorder(b.button))), (Object)"East");
            content2.add((Component)((Object)this.myText), (Object)"North");
            content2.add((Component)this.myProgress, (Object)"Center");
            content2.add((Component)((Object)this.myText2), (Object)"South");
            component2.setBorder(JBUI.Borders.empty((int)2));
        }
        UIUtil.uiTraverser((Component)component2).forEach(o -> ((JComponent)o).setOpaque(false));
        if (!this.myCompact) {
            this.myProcessName.recomputeSize();
            this.myText.recomputeSize();
            this.myText2.recomputeSize();
        }
        MyComponent myComponent = component2;
        if (myComponent == null) {
            InlineProgressIndicator.$$$reportNull$$$0(1);
        }
        return myComponent;
    }

    protected void createCompactTextAndProgress(@NotNull JPanel component2) {
        if (component2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(2);
        }
        NonOpaquePanel textAndProgress = new NonOpaquePanel((LayoutManager)new BorderLayout());
        textAndProgress.add((Component)((Object)this.myText), "Center");
        NonOpaquePanel progressWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        progressWrapper.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        progressWrapper.add((Component)this.myProgress, (Object)"Center");
        textAndProgress.add((Component)progressWrapper, "East");
        component2.add((Component)textAndProgress, "Center");
    }

    static JPanel createButtonPanel(Iterable<? extends JComponent> components) {
        NonOpaquePanel iconsPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag gb = new GridBag().setDefaultFill(1);
        for (JComponent jComponent : components) {
            iconsPanel.add((Component)jComponent, gb.next());
        }
        return iconsPanel;
    }

    @NotNull
    private static Wrapper withBorder(@NotNull InplaceButton button2) {
        if (button2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(3);
        }
        Wrapper wrapper2 = new Wrapper((JComponent)button2);
        wrapper2.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)2));
        Wrapper wrapper3 = wrapper2;
        if (wrapper3 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(4);
        }
        return wrapper3;
    }

    @NotNull
    protected JBIterable<ProgressButton> createEastButtons() {
        JBIterable jBIterable = JBIterable.of((Object)this.createCancelButton());
        if (jBIterable == null) {
            InlineProgressIndicator.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    protected final ProgressButton createCancelButton() {
        InplaceButton cancelButton = new InplaceButton(new IconButton(this.myInfo.getCancelTooltipText(), this.myCompact ? AllIcons.Process.StopSmall : AllIcons.Process.Stop, this.myCompact ? AllIcons.Process.StopSmallHovered : AllIcons.Process.StopHovered), __ -> this.cancelRequest()).setFillBg(false);
        cancelButton.setVisible(this.myInfo.isCancellable());
        return new ProgressButton(cancelButton, () -> cancelButton.setPainting(!this.isStopping()));
    }

    protected void cancelRequest() {
        this.cancel();
    }

    protected void updateProgress() {
        this.queueProgressUpdate();
    }

    protected void updateAndRepaint() {
        if (this.isDisposed()) {
            return;
        }
        this.updateProgressNow();
        this.myComponent.repaint();
    }

    public void updateProgressNow() {
        if (this.isPaintingIndeterminate()) {
            this.myProgress.setIndeterminate(true);
        } else {
            this.myProgress.setIndeterminate(false);
            this.myProgress.setMinimum(0);
            this.myProgress.setMaximum(100);
        }
        if (this.getFraction() > 0.0) {
            this.myProgress.setValue((int)(this.getFraction() * 99.0 + 1.0));
        }
        this.setTextValue(this.getText() != null ? this.getText() : "");
        this.setText2Value(this.getText2() != null ? this.getText2() : "");
        if (this.myCompact && StringUtil.isEmpty((String)this.getTextValue())) {
            this.setTextValue(this.myInfo.getTitle());
        }
        if (this.isStopping()) {
            if (this.myCompact) {
                this.setTextValue(IdeBundle.message((String)"progress.text.stopping", (Object[])new Object[]{this.getTextValue()}));
            } else {
                this.setProcessNameValue(IdeBundle.message((String)"progress.text.stopping", (Object[])new Object[]{this.myInfo.getTitle()}));
                this.setTextEnabled(false);
                this.setText2Enabled(false);
            }
            this.myProgress.setEnabled(false);
        } else {
            this.setTextEnabled(true);
            this.setText2Enabled(true);
            this.myProgress.setEnabled(true);
        }
        this.myEastButtons.forEach(b -> b.updateAction.run());
    }

    @Nullable
    protected String getTextValue() {
        return this.myText.getText();
    }

    protected void setTextValue(@NlsContexts.ProgressText @NotNull String text2) {
        if (text2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(6);
        }
        this.myText.setText(text2);
    }

    protected void setTextEnabled(boolean value2) {
        this.myText.setEnabled(value2);
    }

    protected void setText2Value(@NlsContexts.ProgressDetails @NotNull String text2) {
        if (text2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(7);
        }
        this.myText2.setText(text2);
    }

    protected void setText2Enabled(boolean value2) {
        this.myText2.setEnabled(value2);
    }

    protected void setProcessNameValue(@NlsContexts.ProgressTitle @NotNull String text2) {
        if (text2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(8);
        }
        this.myProcessName.setText(text2);
    }

    protected boolean isPaintingIndeterminate() {
        return this.isIndeterminate() || this.getFraction() == 0.0;
    }

    protected boolean isStopping() {
        return this.wasStarted() && (this.isCanceled() || !this.isRunning()) && !this.isFinished();
    }

    protected boolean isFinished() {
        return false;
    }

    protected void queueProgressUpdate() {
        this.updateAndRepaint();
    }

    protected void queueRunningUpdate(@NotNull Runnable update2) {
        if (update2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(9);
        }
        update2.run();
    }

    @Override
    protected void onProgressChange() {
        this.updateProgress();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel2 = this.myComponent;
        if (jPanel2 == null) {
            InlineProgressIndicator.$$$reportNull$$$0(10);
        }
        return jPanel2;
    }

    boolean isCompact() {
        return this.myCompact;
    }

    TaskInfo getInfo() {
        return this.myInfo;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myComponent.removeAll();
        UIUtil.disposeProgress((JProgressBar)this.myProgress);
        GuiUtils.removePotentiallyLeakingReferences((Container)this.myComponent);
        GuiUtils.removePotentiallyLeakingReferences((Container)this.myProgress);
        this.myInfo = null;
    }

    private boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/InlineProgressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/InlineProgressIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withBorder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEastButtons";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCompactTextAndProgress";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withBorder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTextValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setText2Value";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProcessNameValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "queueRunningUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyComponent
    extends JPanel {
        private final boolean myCompact;
        private final JComponent myProcessName;

        private MyComponent(@NotNull boolean compact, JComponent processName) {
            if (processName == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            this.myCompact = compact;
            this.myProcessName = processName;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (UIUtil.isCloseClick((MouseEvent)e) && MyComponent.this.getBounds().contains(e.getX(), e.getY())) {
                        InlineProgressIndicator.this.cancelRequest();
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myCompact) {
                super.paintComponent(g);
                return;
            }
            GraphicsConfig c = GraphicsUtil.setupAAPainting((Graphics)g);
            UISettings.setupAntialiasing((Graphics)g);
            int arc = 8;
            Color bg = this.getBackground();
            Rectangle bounds2 = this.myProcessName.getBounds();
            Rectangle label2 = SwingUtilities.convertRectangle(this.myProcessName.getParent(), bounds2, this);
            g.setColor(UIUtil.getPanelBackground());
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            if (!StartupUiUtil.isUnderDarcula()) {
                bg = ColorUtil.toAlpha((Color)bg.darker().darker(), (int)230);
                g.setColor(bg);
                g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
                g.setColor(UIUtil.getPanelBackground());
                g.fillRoundRect(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2, arc, arc);
                g.fillRect(0, (int)label2.getMaxY() + 1, this.getWidth() - 1, this.getHeight() / 2);
            } else {
                bg = bg.brighter();
                g.setColor(bg);
                g.drawLine(0, (int)label2.getMaxY() + 1, this.getWidth() - 1, (int)label2.getMaxY() + 1);
            }
            g.setColor(bg);
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            c.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/openapi/wm/impl/status/InlineProgressIndicator$MyComponent", "<init>"));
        }
    }
}

