/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.MacDockDelegate;
import com.intellij.ui.win.WinDockDelegate;
import org.jetbrains.annotations.Nullable;

public final class SystemDock {
    private static final Logger log = Logger.getInstance(SystemDock.class);
    @Nullable
    private static final Delegate ourDelegate;

    public static synchronized void updateMenu() {
        try {
            if (ourDelegate != null) {
                ourDelegate.updateRecentProjectsMenu();
            }
        }
        catch (Throwable err) {
            log.error(err);
        }
    }

    static {
        Delegate delegate2 = null;
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isUnitTestMode()) {
            if (SystemInfo.isMac) {
                delegate2 = MacDockDelegate.getInstance();
            } else if (SystemInfo.isWindows) {
                delegate2 = WinDockDelegate.getInstance();
            }
        }
        ourDelegate = delegate2;
    }

    public static interface Delegate {
        public void updateRecentProjectsMenu();
    }
}

