/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeBackgroundUtil {
    public static final String EDITOR_PROP = "idea.background.editor";
    public static final String FRAME_PROP = "idea.background.frame";
    public static final String TARGET_PROP = "idea.background.target";
    public static final Key<Boolean> NO_BACKGROUND = Key.create((String)"SUPPRESS_BACKGROUND");
    static final RenderingHints.Key ADJUST_ALPHA;

    @NotNull
    public static Graphics2D withEditorBackground(@NotNull Graphics g, @NotNull JComponent component2) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(1);
        }
        if (IdeBackgroundUtil.suppressBackground(component2)) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(2);
            }
            return graphics2D;
        }
        return IdeBackgroundUtil.withNamedPainters(g, EDITOR_PROP, component2);
    }

    @NotNull
    public static Graphics2D withFrameBackground(@NotNull Graphics g, @NotNull JComponent component2) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(3);
        }
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(4);
        }
        if (IdeBackgroundUtil.suppressBackground(component2)) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(5);
            }
            return graphics2D;
        }
        return IdeBackgroundUtil.withNamedPainters(g, FRAME_PROP, component2);
    }

    private static boolean suppressBackground(@NotNull JComponent component2) {
        String type;
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(6);
        }
        if ((type = IdeBackgroundUtil.getComponentType(component2)) == null) {
            return false;
        }
        String spec = System.getProperty(TARGET_PROP, "*");
        boolean allInclusive = spec.startsWith("*");
        return allInclusive ? spec.contains("-" + type) : !spec.contains(type);
    }

    private static boolean isKnownName(@Nullable String name) {
        return name != null && (name.equals("navbar") || name.equals("terminal"));
    }

    @NonNls
    @Nullable
    private static String getComponentType(JComponent component2) {
        return component2 instanceof JTree ? "tree" : (component2 instanceof JList ? "list" : (component2 instanceof JTable ? "table" : (component2 instanceof JViewport ? "viewport" : (component2 instanceof JTabbedPane ? "tabs" : (component2 instanceof JButton ? "button" : (component2 instanceof ActionToolbar ? "toolbar" : (component2 instanceof StatusBar ? "statusbar" : (component2 instanceof JMenuBar || component2 instanceof JMenu ? "menubar" : (component2 instanceof Stripe ? "stripe" : (component2 instanceof EditorsSplitters ? "frame" : (component2 instanceof EditorComponentImpl ? "editor" : (component2 instanceof EditorGutterComponentEx ? "editor" : (component2 instanceof JBLoadingPanel ? "loading" : (component2 instanceof JBTabs ? "tabs" : (component2 instanceof ToolWindowHeader ? "title" : (component2 instanceof JBPanelWithEmptyText ? "panel" : (component2 instanceof JPanel && IdeBackgroundUtil.isKnownName(component2.getName()) ? component2.getName() : null)))))))))))))))));
    }

    @NotNull
    public static Graphics2D getOriginalGraphics(@NotNull Graphics g) {
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(7);
        }
        Graphics2D graphics2D = g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(8);
        }
        return graphics2D;
    }

    @NotNull
    private static Graphics2D withNamedPainters(@NotNull Graphics g, @NotNull String paintersName, @NotNull JComponent component2) {
        PaintersHelper helper;
        JRootPane rootPane;
        if (g == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(9);
        }
        if (paintersName == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(10);
        }
        if (component2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(11);
        }
        Component glassPane = (rootPane = component2.getRootPane()) == null ? null : rootPane.getGlassPane();
        PaintersHelper paintersHelper = helper = glassPane instanceof IdeGlassPaneImpl ? ((IdeGlassPaneImpl)glassPane).getNamedPainters(paintersName) : null;
        if (helper == null || !helper.needsRepaint()) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                IdeBackgroundUtil.$$$reportNull$$$0(12);
            }
            return graphics2D;
        }
        Graphics2D graphics2D = MyGraphics.wrap(g, helper, component2);
        if (graphics2D == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(13);
        }
        return graphics2D;
    }

    static void initEditorPainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(14);
        }
        PaintersHelper.initWallpaperPainter(EDITOR_PROP, glassPane.getNamedPainters(EDITOR_PROP));
    }

    static void initFramePainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(15);
        }
        PaintersHelper painters = glassPane.getNamedPainters(FRAME_PROP);
        PaintersHelper.initWallpaperPainter(FRAME_PROP, painters);
        painters.addPainter((Painter)new AbstractPainter(){
            final EditorEmptyTextPainter p = (EditorEmptyTextPainter)ApplicationManager.getApplication().getService(EditorEmptyTextPainter.class);

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(Component component2, Graphics2D g) {
                this.p.paintEmptyText((JComponent)component2, g);
            }
        }, null);
    }

    @NotNull
    public static Color getIdeBackgroundColor() {
        return new JBColor(() -> {
            Color light = ColorUtil.darker((Color)UIUtil.getPanelBackground(), (int)3);
            return StartupUiUtil.isUnderDarcula() ? Gray._40 : light;
        });
    }

    public static void createTemporaryBackgroundTransform(@NotNull JPanel root, String tmp, @NotNull Disposable disposable2) {
        if (root == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(16);
        }
        if (disposable2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(17);
        }
        PaintersHelper paintersHelper = new PaintersHelper(root);
        PaintersHelper.initWallpaperPainter(tmp, paintersHelper);
        Disposer.register((Disposable)disposable2, (Disposable)JBSwingUtilities.addGlobalCGTransform((t, v) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)t)) {
                return v;
            }
            return MyGraphics.wrap(v, paintersHelper, t);
        }));
    }

    public static void createTemporaryBackgroundTransform(JPanel root, Image image, Fill fill, Anchor anchor2, float alpha, Insets insets, Disposable disposable2) {
        PaintersHelper paintersHelper = new PaintersHelper(root);
        paintersHelper.addPainter((Painter)PaintersHelper.newImagePainter(image, fill, anchor2, alpha, insets), root);
        Disposer.register((Disposable)disposable2, (Disposable)JBSwingUtilities.addGlobalCGTransform((t, v) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)t)) {
                return v;
            }
            return MyGraphics.wrap(v, paintersHelper, t);
        }));
    }

    @NotNull
    public static String getBackgroundSpec(@Nullable Project project, @NotNull String propertyName) {
        String spec;
        if (propertyName == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(18);
        }
        String string = spec = project == null || project.isDisposed() ? null : PropertiesComponent.getInstance((Project)project).getValue(propertyName);
        if (spec == null) {
            spec = PropertiesComponent.getInstance().getValue(propertyName);
        }
        String string2 = spec == null ? System.getProperty(propertyName, "") : spec;
        if (string2 == null) {
            IdeBackgroundUtil.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public static boolean isEditorBackgroundImageSet(@Nullable Project project) {
        return StringUtil.isNotEmpty((String)IdeBackgroundUtil.getBackgroundSpec(project, EDITOR_PROP));
    }

    public static void repaintAllWindows() {
        UISettings.getInstance().fireUISettingsChanged();
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
    }

    static {
        JBSwingUtilities.addGlobalCGTransform((BiFunction)new MyTransform());
        ADJUST_ALPHA = new RenderingHints.Key(1){

            @Override
            public boolean isCompatibleValue(Object val) {
                return val instanceof Boolean;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintersName";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glassPane";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withEditorBackground";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withFrameBackground";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalGraphics";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withNamedPainters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withEditorBackground";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withFrameBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suppressBackground";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalGraphics";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withNamedPainters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initEditorPainters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initFramePainters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryBackgroundTransform";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundSpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyTransform
    implements BiFunction<JComponent, Graphics2D, Graphics2D> {
        private MyTransform() {
        }

        @Override
        public Graphics2D apply(JComponent c, Graphics2D g) {
            Graphics2D gg;
            Editor editor;
            if (Boolean.TRUE.equals(ComponentUtil.getClientProperty((JComponent)c, NO_BACKGROUND))) {
                return g;
            }
            String type = IdeBackgroundUtil.getComponentType(c);
            if (type == null) {
                return g;
            }
            if ("frame".equals(type)) {
                return IdeBackgroundUtil.withFrameBackground(g, c);
            }
            Editor editor2 = editor = "editor".equals(type) ? MyTransform.obtainEditor(c) : null;
            if (editor != null) {
                if (!(g instanceof MyGraphics) && Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)editor))) {
                    return g;
                }
                if (c instanceof EditorComponentImpl && ((EditorImpl)editor).isDumb()) {
                    return MyGraphics.unwrap(g);
                }
            }
            if ((gg = IdeBackgroundUtil.withEditorBackground(g, c)) instanceof MyGraphics) {
                ((MyGraphics)((Object)gg)).preserved = editor != null ? MyTransform.getEditorPreserveColorCondition((EditorEx)editor) : MyTransform.getGeneralPreserveColorCondition(c);
            }
            return gg;
        }

        private static Editor obtainEditor(JComponent c) {
            return c instanceof EditorComponentImpl ? ((EditorComponentImpl)c).getEditor() : (c instanceof EditorGutterComponentEx ? (Editor)CommonDataKeys.EDITOR.getData((DataProvider)((Object)c)) : null);
        }

        @NotNull
        private static Predicate<Color> getEditorPreserveColorCondition(EditorEx editor) {
            Color background1 = editor.getBackgroundColor();
            Color background2 = editor.getGutterComponentEx().getBackground();
            Predicate<Color> predicate2 = color -> color != background1 && color != background2;
            if (predicate2 == null) {
                MyTransform.$$$reportNull$$$0(0);
            }
            return predicate2;
        }

        @NotNull
        private static Predicate<Color> getGeneralPreserveColorCondition(JComponent c) {
            Color selection1;
            JComponent view;
            Component component2 = view = c instanceof JViewport ? ((JViewport)c).getView() : c;
            Color color2 = view instanceof JTree ? UIUtil.getTreeSelectionBackground((boolean)true) : (view instanceof JList ? UIUtil.getListSelectionBackground((boolean)true) : (view instanceof JTable ? UIUtil.getTableSelectionBackground((boolean)true) : (selection1 = view instanceof JMenuBar || view instanceof JMenu ? UIManager.getColor("Menu.selectionBackground") : null)));
            Color selection2 = view instanceof JTree ? UIUtil.getTreeSelectionBackground((boolean)false) : (view instanceof JList ? UIUtil.getListSelectionBackground((boolean)false) : (view instanceof JTable ? UIUtil.getTableSelectionBackground((boolean)false) : null));
            Predicate<Color> predicate2 = color -> color == selection1 || color == selection2;
            if (predicate2 == null) {
                MyTransform.$$$reportNull$$$0(1);
            }
            return predicate2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyTransform";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorPreserveColorCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGeneralPreserveColorCondition";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class MyGraphics
    extends Graphics2DDelegate {
        final PaintersHelper helper;
        final PaintersHelper.Offsets offsets;
        Predicate<? super Color> preserved;

        static Graphics2D wrap(Graphics g, PaintersHelper helper, JComponent component2) {
            MyGraphics gg = g instanceof MyGraphics ? (MyGraphics)((Object)g) : null;
            return new MyGraphics(gg != null ? gg.myDelegate : g, helper, helper.computeOffsets(g, component2), gg != null ? gg.preserved : null);
        }

        static Graphics2D unwrap(Graphics g) {
            return g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        }

        MyGraphics(Graphics g, PaintersHelper helper, PaintersHelper.Offsets offsets2, Predicate<? super Color> preserved) {
            super((Graphics2D)g);
            this.helper = helper;
            this.offsets = offsets2;
            this.preserved = preserved;
        }

        @NotNull
        public Graphics create() {
            return new MyGraphics(this.getDelegate().create(), this.helper, this.offsets, this.preserved);
        }

        public void clearRect(int x, int y, int width, int height) {
            super.clearRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, null, this.getColor());
        }

        public void fillRect(int x, int y, int width, int height) {
            super.fillRect(x, y, width, height);
            this.runAllPainters(x, y, width, height, null, this.getColor());
        }

        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            super.fillArc(x, y, width, height, startAngle, arcAngle);
            this.runAllPainters(x, y, width, height, new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2), this.getColor());
        }

        public void fillOval(int x, int y, int width, int height) {
            super.fillOval(x, y, width, height);
            this.runAllPainters(x, y, width, height, new Ellipse2D.Double(x, y, width, height), this.getColor());
        }

        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            super.fillPolygon(xPoints, yPoints, nPoints);
            Polygon s = new Polygon(xPoints, yPoints, nPoints);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void fillPolygon(Polygon s) {
            super.fillPolygon(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
            this.runAllPainters(x, y, width, height, new RoundRectangle2D.Double(x, y, width, height, arcHeight, arcHeight), this.getColor());
        }

        public void fill(Shape s) {
            super.fill(s);
            Rectangle r = s.getBounds();
            this.runAllPainters(r.x, r.y, r.width, r.height, s, this.getColor());
        }

        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            super.drawImage(img, op, x, y);
            this.runAllPainters(x, y, img.getWidth(), img.getHeight(), null, img);
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, width, height, observer);
            this.runAllPainters(x, y, width, height, null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, Color c, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, width, height, c, observer);
            this.runAllPainters(x, y, width, height, null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, observer);
            this.runAllPainters(x, y, img.getWidth(null), img.getHeight(null), null, img);
            return b;
        }

        public boolean drawImage(Image img, int x, int y, Color c, ImageObserver observer) {
            boolean b = super.drawImage(img, x, y, c, observer);
            this.runAllPainters(x, y, img.getWidth(null), img.getHeight(null), null, img);
            return b;
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            boolean b = super.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            this.runAllPainters(dx1, dy1, dx2 - dx1, dy2 - dy1, null, img);
            return b;
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color c, ImageObserver observer) {
            boolean b = super.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, c, observer);
            this.runAllPainters(dx1, dy1, dx2 - dx1, dy2 - dy1, null, img);
            return b;
        }

        @Nullable
        private static Shape calcTempClip(@Nullable Shape prevClip, @NotNull Shape forcedClip) {
            if (forcedClip == null) {
                MyGraphics.$$$reportNull$$$0(0);
            }
            if (prevClip == null) {
                return forcedClip;
            }
            if (prevClip instanceof Rectangle2D && forcedClip instanceof Rectangle2D) {
                Rectangle2D r = ((Rectangle2D)prevClip).createIntersection((Rectangle2D)forcedClip);
                return r.isEmpty() ? null : r;
            }
            Area area = new Area(prevClip);
            area.intersect(new Area(forcedClip));
            return area.getBounds().isEmpty() ? null : area;
        }

        void runAllPainters(int x, int y, int width, int height, @Nullable Shape sourceShape, @Nullable Object reason) {
            boolean preserve;
            boolean hasAlpha;
            if (width <= 1 || height <= 1) {
                return;
            }
            if (reason instanceof Color) {
                hasAlpha = ((Color)reason).getAlpha() < 255;
            } else if (reason instanceof BufferedImage) {
                hasAlpha = ((BufferedImage)reason).getColorModel().hasAlpha();
            } else {
                boolean bl = hasAlpha = !(reason instanceof VolatileImage) || ((VolatileImage)reason).getTransparency() != 1;
            }
            if (hasAlpha) {
                return;
            }
            Shape prevClip = this.getClip();
            Shape tmpClip = MyGraphics.calcTempClip(prevClip, sourceShape != null ? sourceShape : new Rectangle(x, y, width, height));
            if (tmpClip == null) {
                return;
            }
            boolean bl = preserve = this.preserved != null && reason instanceof Color && this.preserved.test((Color)reason);
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.TRUE);
            }
            this.setClip(tmpClip);
            this.helper.runAllPainters(this.myDelegate, this.offsets);
            this.setClip(prevClip);
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.FALSE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forcedClip", "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyGraphics", "calcTempClip"));
        }
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        CENTER,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }

    public static enum Fill {
        PLAIN,
        SCALE,
        TILE;

    }
}

