/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0014J\u0012\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/wm/impl/CloseProjectWindowHelper;", "", "()V", "isMacSystemMenu", "", "()Z", "isShowWelcomeScreen", "isShowWelcomeScreenFromSettings", "closeProjectAndShowWelcomeFrameIfNoProjectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "couldReturnToWelcomeScreen", "getNumberOfOpenedProjects", "", "quitApp", "windowClosing", "Companion", "intellij.platform.ide.impl"})
public class CloseProjectWindowHelper {
    @NotNull
    private static final Key<Boolean> SHOW_WELCOME_FRAME_FOR_PROJECT;
    @NotNull
    public static final Companion Companion;

    protected boolean isMacSystemMenu() {
        return SystemProperties.getBooleanProperty((String)"idea.test.isMacSystemMenu", (boolean)SystemInfo.isMacSystemMenu);
    }

    private final boolean isShowWelcomeScreen() {
        return this.isMacSystemMenu() && this.isShowWelcomeScreenFromSettings();
    }

    protected boolean isShowWelcomeScreenFromSettings() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)generalSettings, (String)"GeneralSettings.getInstance()");
        return generalSettings.isShowWelcomeScreen();
    }

    public void windowClosing(@Nullable Project project) {
        int numberOfOpenedProjects = this.getNumberOfOpenedProjects();
        if (numberOfOpenedProjects > 1 || numberOfOpenedProjects == 1 && this.couldReturnToWelcomeScreen(project)) {
            this.closeProjectAndShowWelcomeFrameIfNoProjectOpened(project);
        } else {
            this.quitApp();
        }
    }

    protected int getNumberOfOpenedProjects() {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        return projectManager.getOpenProjects().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProjectAndShowWelcomeFrameIfNoProjectOpened(@Nullable Project project) {
        boolean $i$f$runInAutoSaveDisabledMode = false;
        AutoCloseable autoCloseable = (AutoCloseable)SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Application app;
            AccessToken it$iv = (AccessToken)autoCloseable;
            boolean bl3 = false;
            boolean bl4 = false;
            if (project != null && project.isOpen()) {
                ProjectManagerEx.getInstanceEx().closeAndDispose(project);
            }
            Application application = app = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            ((AppLifecycleListener)application.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectFrameClosed();
            boolean bl5 = SaveAndSyncHandler.Companion.getInstance().saveSettingsUnderModalProgress((ComponentManager)app);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        WelcomeFrame.showIfNoProjectOpened();
    }

    protected void quitApp() {
        ApplicationManager.getApplication().exit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean couldReturnToWelcomeScreen(Project project) {
        Object object;
        block3: {
            block2: {
                object = project;
                if (object == null) break block2;
                Project project2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                object = (Boolean)SHOW_WELCOME_FRAME_FOR_PROJECT.get((UserDataHolder)project);
                if (object != null) break block3;
            }
            if (!this.isShowWelcomeScreen()) return false;
            if (PlatformUtils.isPyCharmDs()) return false;
            if (PlatformUtils.isDataGrip()) return false;
            return true;
        }
        boolean bl = (Boolean)object;
        return bl;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"Show.Welcome.Frame.For.Project");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"Show.Welcome.Frame.For.Project\")");
        SHOW_WELCOME_FRAME_FOR_PROJECT = key;
    }

    @NotNull
    public static final Key<Boolean> getSHOW_WELCOME_FRAME_FOR_PROJECT() {
        Companion companion = Companion;
        return SHOW_WELCOME_FRAME_FOR_PROJECT;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/CloseProjectWindowHelper$Companion;", "", "()V", "SHOW_WELCOME_FRAME_FOR_PROJECT", "Lcom/intellij/openapi/util/Key;", "", "getSHOW_WELCOME_FRAME_FOR_PROJECT$annotations", "getSHOW_WELCOME_FRAME_FOR_PROJECT", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getSHOW_WELCOME_FRAME_FOR_PROJECT$annotations() {
        }

        @NotNull
        public final Key<Boolean> getSHOW_WELCOME_FRAME_FOR_PROJECT() {
            return SHOW_WELCOME_FRAME_FOR_PROJECT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

