/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class VfsDependentEnum<T> {
    private final File myFile;
    private final DataExternalizer<T> myKeyDescriptor;
    private final int myVersion;
    private boolean myMarkedForInvalidation;
    private final List<T> myInstances;
    private final Map<T, Integer> myInstanceToId;
    private final Object myLock;
    private boolean myTriedToLoadFile;

    public VfsDependentEnum(@NotNull String fileName, @NotNull KeyDescriptor<T> descriptor2, int version2) {
        if (fileName == null) {
            VfsDependentEnum.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            VfsDependentEnum.$$$reportNull$$$0(1);
        }
        this(FSRecords.getPersistentFSPaths(), fileName, descriptor2, version2);
    }

    @ApiStatus.Internal
    VfsDependentEnum(@NotNull PersistentFSPaths paths, @NotNull String fileName, @NotNull KeyDescriptor<T> descriptor2, int version2) {
        if (paths == null) {
            VfsDependentEnum.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            VfsDependentEnum.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            VfsDependentEnum.$$$reportNull$$$0(4);
        }
        this.myInstances = ContainerUtil.createConcurrentList();
        this.myInstanceToId = new ConcurrentHashMap<T, Integer>();
        this.myLock = new Object();
        this.myFile = paths.getVfsEnumFile(fileName);
        this.myKeyDescriptor = descriptor2;
        this.myVersion = version2;
    }

    public int getId(@NotNull T s) throws IOException {
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(5);
        }
        return this.getIdRaw(s, true);
    }

    int getIdRaw(@NotNull T s, boolean vfsRebuildOnException) throws IOException {
        Integer integer;
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(6);
        }
        if ((integer = this.myInstanceToId.get(s)) != null) {
            return integer;
        }
        Object object = this.myLock;
        synchronized (object) {
            integer = this.myInstanceToId.get(s);
            if (integer != null) {
                return integer;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (integer = this.myInstanceToId.get(s)) != null) {
                    return integer;
                }
                int enumerated = this.myInstances.size() + 1;
                this.register(s, enumerated);
                this.saveToFile(s);
                return enumerated;
            }
            catch (IOException e) {
                this.invalidate(e, vfsRebuildOnException);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(@NotNull T instance) throws IOException {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(7);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.myFile, true);
        try (DataOutputStream output2 = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            if (this.myFile.length() == 0L) {
                DataInputOutputUtil.writeTIME((DataOutput)output2, (long)FSRecords.getCreationTimestamp());
                DataInputOutputUtil.writeINT((DataOutput)output2, (int)this.myVersion);
            }
            this.myKeyDescriptor.save((DataOutput)output2, instance);
        }
        finally {
            try {
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadFromFile() throws IOException {
        if (this.myTriedToLoadFile || !this.myInstances.isEmpty() || !this.myFile.exists()) return false;
        this.myTriedToLoadFile = true;
        boolean deleteFile2 = false;
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));
            long vfsVersion = DataInputOutputUtil.readTIME((DataInput)input);
            if (vfsVersion != FSRecords.getCreationTimestamp()) {
                deleteFile2 = true;
                boolean bl = false;
                return bl;
            }
            int savedVersion = DataInputOutputUtilRt.readINT((DataInput)input);
            if (savedVersion != this.myVersion) throw new IOException("Version mismatch: current " + this.myVersion + ", previous:" + savedVersion + ", file:" + this.myFile);
            ArrayList<Object> elements = new ArrayList<Object>();
            HashMap<Object, Integer> elementToIdMap = new HashMap<Object, Integer>();
            while (input.available() > 0) {
                Object instance = this.myKeyDescriptor.read((DataInput)input);
                assert (instance != null);
                elements.add(instance);
                elementToIdMap.put(instance, elements.size());
            }
            this.myInstances.addAll(elements);
            this.myInstanceToId.putAll(elementToIdMap);
            boolean bl = true;
            return bl;
            finally {
                input.close();
            }
        }
        finally {
            if (deleteFile2) {
                FileUtil.deleteWithRenaming((File)this.myFile);
            }
        }
    }

    private void invalidate(@NotNull Throwable e, boolean vfsRebuildOnException) {
        if (e == null) {
            VfsDependentEnum.$$$reportNull$$$0(8);
        }
        if (!this.myMarkedForInvalidation) {
            this.myMarkedForInvalidation = true;
            FileUtil.deleteWithRenaming((File)this.myFile);
            if (vfsRebuildOnException) {
                FSRecords.requestVfsRebuild(e);
            }
        }
    }

    private void register(@NotNull T instance, int id2) {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(9);
        }
        this.myInstanceToId.put(instance, id2);
        assert (id2 == this.myInstances.size() + 1);
        this.myInstances.add(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public T getById(int id2) throws IOException {
        boolean loaded;
        block10: {
            T instance;
            assert (id2 > 0);
            if (--id2 < this.myInstances.size() && (instance = this.myInstances.get(id2)) != null) {
                T t = instance;
                if (t != null) return t;
                VfsDependentEnum.$$$reportNull$$$0(10);
                return t;
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (id2 < this.myInstances.size() && (instance = this.myInstances.get(id2)) != null) {
                T t = instance;
                // MONITOREXIT : object
                if (t != null) return t;
                VfsDependentEnum.$$$reportNull$$$0(11);
                return t;
            }
            loaded = this.loadFromFile();
            if (!loaded || (instance = this.myInstances.get(id2)) == null) break block10;
            T t = instance;
            // MONITOREXIT : object
            if (t != null) return t;
            VfsDependentEnum.$$$reportNull$$$0(12);
            return t;
        }
        try {
            assert (false) : "Reading nonexistent value:" + id2 + "," + this.myFile + ", loaded:" + loaded;
        }
        catch (IOException | AssertionError e) {
            this.invalidate((Throwable)e, true);
            throw e;
        }
        VfsDependentEnum.$$$reportNull$$$0(13);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIdRaw";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

