/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.util.BitUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PersistentFSRecordAccessor {
    private static final Logger LOG = Logger.getInstance(PersistentFSRecordAccessor.class);
    static final int FREE_RECORD_FLAG = 1024;
    private static final int ALL_VALID_FLAGS = 2047;
    @NotNull
    private final PersistentFSContentAccessor myPersistentFSContentAccessor;
    @NotNull
    private final PersistentFSAttributeAccessor myPersistentFSAttributeAccessor;
    @NotNull
    private final IntList myNewFreeRecords;

    PersistentFSRecordAccessor(@NotNull PersistentFSContentAccessor accessor, @NotNull PersistentFSAttributeAccessor attributeAccessor) {
        if (accessor == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(0);
        }
        if (attributeAccessor == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(1);
        }
        this.myPersistentFSContentAccessor = accessor;
        this.myPersistentFSAttributeAccessor = attributeAccessor;
        this.myNewFreeRecords = new IntArrayList();
    }

    void addToFreeRecordsList(int id2, @NotNull PersistentFSConnection connection) {
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(2);
        }
        connection.markDirty();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myNewFreeRecords.add(id2);
        }
        connection.getRecords().setFlags(id2, 1024);
    }

    int createRecord(@NotNull PersistentFSConnection connection) throws IOException {
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(3);
        }
        connection.markDirty();
        int free = connection.getFreeRecord();
        if (free == 0) {
            int fileLength = PersistentFSRecordAccessor.length(connection);
            LOG.assertTrue(fileLength % 40 == 0);
            int newRecord = fileLength / 40;
            connection.getRecords().cleanRecord(newRecord);
            assert (fileLength + 40 == PersistentFSRecordAccessor.length(connection));
            return newRecord;
        }
        this.deleteContentAndAttributes(free, connection);
        connection.getRecords().cleanRecord(free);
        return free;
    }

    void checkSanity(@NotNull PersistentFSConnection connection) throws IOException {
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(4);
        }
        long t = System.currentTimeMillis();
        int fileLength = PersistentFSRecordAccessor.length(connection);
        assert (fileLength % 40 == 0);
        int recordCount = fileLength / 40;
        IntArrayList usedAttributeRecordIds = new IntArrayList();
        IntArrayList validAttributeIds = new IntArrayList();
        for (int id2 = 2; id2 < recordCount; ++id2) {
            int flags = connection.getRecords().doGetFlags(id2);
            LOG.assertTrue((flags & 0xFFFFF800) == 0, (Object)("Invalid flags: 0x" + Integer.toHexString(flags) + ", id: " + id2));
            boolean isFreeRecord = connection.getFreeRecords().contains(id2);
            if (BitUtil.isSet((int)flags, (int)1024)) {
                LOG.assertTrue(isFreeRecord, (Object)("Record, marked free, not in free list: " + id2));
                continue;
            }
            LOG.assertTrue(!isFreeRecord, (Object)("Record, not marked free, in free list: " + id2));
            this.checkRecordSanity(id2, recordCount, (IntList)usedAttributeRecordIds, (IntList)validAttributeIds, connection);
        }
        t = System.currentTimeMillis() - t;
        LOG.info("Sanity check took " + t + " ms");
    }

    private void checkRecordSanity(int id2, int recordCount, @NotNull IntList usedAttributeRecordIds, @NotNull IntList validAttributeIds, @NotNull PersistentFSConnection connection) throws IOException {
        if (usedAttributeRecordIds == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(5);
        }
        if (validAttributeIds == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(7);
        }
        int parentId = connection.getRecords().getParent(id2);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0 && connection.getRecords().getParent(parentId) > 0) {
            int parentFlags = connection.getRecords().doGetFlags(parentId);
            assert (!BitUtil.isSet((int)parentFlags, (int)1024)) : parentId + ": " + Integer.toHexString(parentFlags);
            assert (BitUtil.isSet((int)parentFlags, (int)2)) : parentId + ": " + Integer.toHexString(parentFlags);
        }
        String name = PersistentFSRecordAccessor.getName(id2, connection);
        LOG.assertTrue(parentId == 0 || name.length() != 0, (Object)("File with empty name found under " + PersistentFSRecordAccessor.getName(parentId, connection) + ", id=" + id2));
        this.myPersistentFSContentAccessor.checkContentsStorageSanity(id2, connection);
        this.myPersistentFSAttributeAccessor.checkAttributesStorageSanity(id2, usedAttributeRecordIds, validAttributeIds, connection);
        long length = connection.getRecords().getLength(id2);
        assert (length >= -1L) : "Invalid file length found for " + name + ": " + length;
    }

    @NotNull
    IntList getNewFreeRecords() {
        IntList intList = this.myNewFreeRecords;
        if (intList == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(8);
        }
        return intList;
    }

    @Nullable
    private static String getName(int fileId, @NotNull PersistentFSConnection connection) throws IOException {
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(9);
        }
        return connection.getNames().valueOf(connection.getRecords().getNameId(fileId));
    }

    private static int length(@NotNull PersistentFSConnection connection) {
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(10);
        }
        return (int)connection.getRecords().length();
    }

    private void deleteContentAndAttributes(int id2, @NotNull PersistentFSConnection connection) throws IOException {
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(11);
        }
        this.myPersistentFSContentAccessor.deleteContent(id2, connection);
        this.myPersistentFSAttributeAccessor.deleteAttributes(id2, connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedAttributeRecordIds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validAttributeIds";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordAccessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFreeRecords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addToFreeRecordsList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkSanity";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRecordSanity";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "length";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteContentAndAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

