/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class PersistentFSPaths {
    @NonNls
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    @NotNull
    private final String myCachesDir;

    PersistentFSPaths(@NotNull String dir) {
        if (dir == null) {
            PersistentFSPaths.$$$reportNull$$$0(0);
        }
        this.myCachesDir = dir;
    }

    @NotNull
    File getCorruptionMarkerFile() {
        return new File(new File(this.myCachesDir), "corruption.marker");
    }

    @NotNull
    File getVfsEnumBaseFile() {
        return new File(new File(this.myCachesDir), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    @NotNull
    File getVfsEnumFile(@NotNull String enumName) {
        if (enumName == null) {
            PersistentFSPaths.$$$reportNull$$$0(1);
        }
        return new File(new File(this.myCachesDir), DEPENDENT_PERSISTENT_LIST_START_PREFIX + enumName + VFS_FILES_EXTENSION);
    }

    Path getRootsFile() {
        if (FSRecords.ourStoreRootsSeparately) {
            return new File(this.myCachesDir).getAbsoluteFile().toPath().resolve("roots" + VFS_FILES_EXTENSION);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSPaths";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVfsEnumFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

