/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.CompactRecordsTable;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RefCountingContentStorage;
import com.intellij.util.io.storage.Storage;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

final class PersistentFSConnector {
    private static final Logger LOG = Logger.getInstance(PersistentFSConnector.class);
    private static final int MAX_INITIALIZATION_ATTEMPTS = 10;

    PersistentFSConnector() {
    }

    @NotNull
    static PersistentFSConnection connect(@NotNull String cachesDir, int version2, boolean useContentHashes) {
        if (cachesDir == null) {
            PersistentFSConnector.$$$reportNull$$$0(0);
        }
        PersistentFSConnection persistentFSConnection = (PersistentFSConnection)FSRecords.writeAndHandleErrors(() -> PersistentFSConnector.init(cachesDir, version2, useContentHashes));
        if (persistentFSConnection == null) {
            PersistentFSConnector.$$$reportNull$$$0(1);
        }
        return persistentFSConnection;
    }

    @NotNull
    private static PersistentFSConnection init(@NotNull String cachesDir, int expectedVersion, boolean useContentHashes) {
        if (cachesDir == null) {
            PersistentFSConnector.$$$reportNull$$$0(2);
        }
        Exception exception = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            Pair<PersistentFSConnection, Exception> pair = PersistentFSConnector.tryInit(cachesDir, expectedVersion, useContentHashes);
            exception = (Exception)pair.getSecond();
            if (exception != null) continue;
            PersistentFSConnection persistentFSConnection = (PersistentFSConnection)pair.getFirst();
            if (persistentFSConnection == null) {
                PersistentFSConnector.$$$reportNull$$$0(3);
            }
            return persistentFSConnection;
        }
        throw new RuntimeException("Can't initialize filesystem storage", exception);
    }

    @NotNull
    private static Pair<PersistentFSConnection, Exception> tryInit(@NotNull String cachesDir, int expectedVersion, boolean useContentHashes) {
        Pair pair;
        if (cachesDir == null) {
            PersistentFSConnector.$$$reportNull$$$0(4);
        }
        Storage attributes = null;
        RefCountingContentStorage contents = null;
        PersistentFSRecordsStorage records = null;
        ContentHashEnumerator contentHashesEnumerator = null;
        PersistentStringEnumerator names2 = null;
        boolean markDirty2 = false;
        PersistentFSPaths persistentFSPaths = new PersistentFSPaths(cachesDir);
        Path basePath = new File(cachesDir).getAbsoluteFile().toPath();
        try {
            Files.createDirectories(basePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            Pair pair2 = Pair.create(null, (Object)e);
            if (pair2 == null) {
                PersistentFSConnector.$$$reportNull$$$0(5);
            }
            return pair2;
        }
        Path namesFile = basePath.resolve("names" + PersistentFSPaths.VFS_FILES_EXTENSION);
        Path attributesFile = basePath.resolve("attrib" + PersistentFSPaths.VFS_FILES_EXTENSION);
        Path contentsFile = basePath.resolve("content" + PersistentFSPaths.VFS_FILES_EXTENSION);
        Path contentsHashesFile = basePath.resolve("contentHashes" + PersistentFSPaths.VFS_FILES_EXTENSION);
        Path recordsFile = basePath.resolve("records" + PersistentFSPaths.VFS_FILES_EXTENSION);
        File vfsDependentEnumBaseFile = persistentFSPaths.getVfsEnumBaseFile();
        if (!Files.exists(namesFile, new LinkOption[0])) {
            PersistentFSConnector.invalidateIndex("'" + namesFile + "' does not exist");
        }
        try {
            int version2;
            boolean initial;
            boolean aligned;
            if (persistentFSPaths.getCorruptionMarkerFile().exists()) {
                PersistentFSConnector.invalidateIndex("corruption marker found");
                throw new IOException("Corruption marker file found");
            }
            StorageLockContext storageLockContext = new StorageLockContext(false);
            names2 = new PersistentStringEnumerator(namesFile, storageLockContext);
            attributes = new Storage(attributesFile, PersistentFSConnection.REASONABLY_SMALL){

                protected AbstractRecordsTable createRecordsTable(PagePool pool, @NotNull Path recordsFile) throws IOException {
                    if (recordsFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return FSRecords.inlineAttributes && FSRecords.useSmallAttrTable ? new CompactRecordsTable(recordsFile, pool, false) : super.createRecordsTable(pool, recordsFile);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordsFile", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnector$1", "createRecordsTable"));
                }
            };
            contents = new RefCountingContentStorage(contentsFile, CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FSRecords Content Write Pool"), FSRecords.useCompressionUtil, useContentHashes);
            ContentHashEnumerator contentHashEnumerator = contentHashesEnumerator = useContentHashes ? new ContentHashEnumerator(contentsHashesFile, storageLockContext) : null;
            if (contentHashesEnumerator != null) {
                PersistentFSConnector.checkContentSanity(contents, contentHashesEnumerator);
            }
            boolean bl = aligned = PagedFileStorage.BUFFER_SIZE % 40 == 0;
            if (!aligned) {
                LOG.error("Buffer size " + PagedFileStorage.BUFFER_SIZE + " is not aligned for record size 40");
            }
            boolean bl2 = initial = (records = new PersistentFSRecordsStorage(new ResizeableMappedFile(recordsFile, 20480, storageLockContext, PagedFileStorage.BUFFER_SIZE, aligned, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER))).length() == 0L;
            if (initial) {
                records.cleanRecord(0);
                records.cleanRecord(1);
                PersistentFSConnector.setCurrentVersion(records, attributes, contents, expectedVersion);
            }
            if ((version2 = PersistentFSConnector.getVersion(records, attributes, contents)) != expectedVersion) {
                throw new IOException("FS repository version mismatch: actual=" + version2 + " expected=" + FSRecords.VERSION);
            }
            if (records.getConnectionStatus() != 523190095) {
                throw new IOException("FS repository wasn't safely shut down");
            }
            if (initial) {
                markDirty2 = true;
            }
            IntList freeRecords = PersistentFSConnector.scanFreeRecords(records);
            pair = Pair.create((Object)new PersistentFSConnection(persistentFSPaths, records, names2, attributes, contents, contentHashesEnumerator, freeRecords, markDirty2), null);
        }
        catch (Exception e) {
            LOG.info("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + e.getMessage());
            try {
                PersistentFSConnection.closeStorages(records, names2, attributes, contentHashesEnumerator, contents);
                boolean deleted = FileUtil.delete((File)persistentFSPaths.getCorruptionMarkerFile());
                deleted &= IOUtil.deleteAllFilesStartingWith((Path)namesFile);
                deleted &= AbstractStorage.deleteFiles((Path)attributesFile);
                deleted &= AbstractStorage.deleteFiles((Path)contentsFile);
                deleted &= IOUtil.deleteAllFilesStartingWith((Path)contentsHashesFile);
                deleted &= IOUtil.deleteAllFilesStartingWith((Path)recordsFile);
                deleted &= IOUtil.deleteAllFilesStartingWith((File)vfsDependentEnumBaseFile);
                Path rootsFile = persistentFSPaths.getRootsFile();
                if (!(deleted &= rootsFile == null || IOUtil.deleteAllFilesStartingWith((Path)rootsFile))) {
                    throw new IOException("Cannot delete filesystem storage files");
                }
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                LOG.warn("Cannot rebuild filesystem storage", (Throwable)e1);
                Pair pair3 = Pair.create(null, (Object)e1);
                if (pair3 == null) {
                    PersistentFSConnector.$$$reportNull$$$0(7);
                }
                return pair3;
            }
            Pair pair4 = Pair.create(null, (Object)e);
            if (pair4 == null) {
                PersistentFSConnector.$$$reportNull$$$0(8);
            }
            return pair4;
        }
        if (pair == null) {
            PersistentFSConnector.$$$reportNull$$$0(6);
        }
        return pair;
    }

    private static void checkContentSanity(@NotNull RefCountingContentStorage contents, @NotNull ContentHashEnumerator contentHashesEnumerator) throws IOException {
        int liveRecordsCount;
        int largestId;
        if (contents == null) {
            PersistentFSConnector.$$$reportNull$$$0(9);
        }
        if (contentHashesEnumerator == null) {
            PersistentFSConnector.$$$reportNull$$$0(10);
        }
        if ((largestId = contentHashesEnumerator.getLargestId()) != (liveRecordsCount = contents.getRecordsCount())) {
            throw new IOException("Content storage & enumerator corrupted");
        }
    }

    private static void invalidateIndex(@NotNull String reason) {
        String[] children2;
        if (reason == null) {
            PersistentFSConnector.$$$reportNull$$$0(11);
        }
        LOG.info("Marking VFS as corrupted: " + reason);
        Path indexRoot = PathManager.getIndexRoot();
        if (Files.exists(indexRoot, new LinkOption[0]) && (children2 = indexRoot.toFile().list()) != null && children2.length > 0) {
            FileUtil.createIfDoesntExist((File)PathManager.getIndexRoot().resolve("corruption.marker").toFile());
        }
    }

    private static IntList scanFreeRecords(PersistentFSRecordsStorage records) {
        IntArrayList freeRecords = new IntArrayList();
        int fileLength = (int)records.length();
        LOG.assertTrue(fileLength % 40 == 0, (Object)("invalid file size: " + fileLength));
        int count = fileLength / 40;
        for (int n = 2; n < count; ++n) {
            if (!BitUtil.isSet((int)records.doGetFlags(n), (int)1024)) continue;
            freeRecords.add(n);
        }
        return freeRecords;
    }

    private static int getVersion(PersistentFSRecordsStorage records, Storage attributes, RefCountingContentStorage contents) {
        int recordsVersion = records.getVersion();
        if (attributes.getVersion() != recordsVersion || contents.getVersion() != recordsVersion) {
            return -1;
        }
        return recordsVersion;
    }

    private static void setCurrentVersion(PersistentFSRecordsStorage records, Storage attributes, RefCountingContentStorage contents, int version2) {
        records.setVersion(version2);
        attributes.setVersion(version2);
        contents.setVersion(version2);
        records.setConnectionStatus(523190095);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachesDir";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentHashesEnumerator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tryInit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryInit";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkContentSanity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

