/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.Storage;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PersistentFSAttributeAccessor {
    private static final int MAX_SMALL_ATTR_SIZE = 64;
    private final boolean myBulkAttrReadSupport;
    private final boolean myInlineAttributes;

    PersistentFSAttributeAccessor(boolean bulkAttrReadSupport, boolean inlineAttributes) {
        this.myBulkAttrReadSupport = bulkAttrReadSupport;
        this.myInlineAttributes = inlineAttributes;
    }

    @Nullable
    DataInputStream readAttribute(int fileId, @NotNull FileAttribute attribute, @NotNull PersistentFSConnection connection) throws IOException {
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(1);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        int recordId = connection.getRecords().getAttributeRecordId(fileId);
        if (recordId == 0) {
            return null;
        }
        int encodedAttrId = connection.getAttributeId(attribute.getId());
        Storage storage2 = connection.getAttributes();
        int page = 0;
        try (DataInputStream attrRefs = storage2.readStream(recordId);){
            if (this.myBulkAttrReadSupport) {
                PersistentFSAttributeAccessor.skipRecordHeader(attrRefs, PersistentFSConnection.RESERVED_ATTR_ID, fileId);
            }
            while (attrRefs.available() > 0) {
                int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                if (attIdOnPage != encodedAttrId) {
                    if (!this.myInlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                    continue;
                }
                if (this.myInlineAttributes && attrAddressOrSize < 64) {
                    byte[] b = new byte[attrAddressOrSize];
                    attrRefs.readFully(b);
                    DataInputStream dataInputStream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(b));
                    return dataInputStream;
                }
                page = this.myInlineAttributes ? attrAddressOrSize - 64 : attrAddressOrSize;
                break;
            }
        }
        if (page == 0) {
            return null;
        }
        DataInputStream stream = connection.getAttributes().readStream(page);
        if (this.myBulkAttrReadSupport) {
            PersistentFSAttributeAccessor.skipRecordHeader(stream, encodedAttrId, fileId);
        }
        return stream;
    }

    boolean hasAttributePage(int fileId, @NotNull FileAttribute attr, @NotNull PersistentFSConnection connection) throws IOException {
        if (attr == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(3);
        }
        return this.findAttributePage(fileId, attr, false, connection) != 0;
    }

    private int findAttributePage(int fileId, @NotNull FileAttribute attr, boolean toWrite, @NotNull PersistentFSConnection connection) throws IOException {
        if (attr == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(4);
        }
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(5);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        int recordId = connection.getRecords().getAttributeRecordId(fileId);
        int encodedAttrId = connection.getAttributeId(attr.getId());
        boolean directoryRecord = false;
        Storage storage2 = connection.getAttributes();
        if (recordId == 0) {
            if (!toWrite) {
                return 0;
            }
            recordId = storage2.createNewRecord();
            connection.getRecords().setAttributeRecordId(fileId, recordId);
            directoryRecord = true;
        } else {
            try (DataInputStream attrRefs = storage2.readStream(recordId);){
                if (this.myBulkAttrReadSupport) {
                    PersistentFSAttributeAccessor.skipRecordHeader(attrRefs, PersistentFSConnection.RESERVED_ATTR_ID, fileId);
                }
                while (attrRefs.available() > 0) {
                    int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    if (attIdOnPage == encodedAttrId) {
                        if (this.myInlineAttributes) {
                            int n = attrAddressOrSize < 64 ? -recordId : attrAddressOrSize - 64;
                            return n;
                        }
                        int n = attrAddressOrSize;
                        return n;
                    }
                    if (!this.myInlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                }
            }
        }
        if (toWrite) {
            try {
                int n;
                block29: {
                    AbstractStorage.AppenderStream appender = storage2.appendStream(recordId);
                    try {
                        if (this.myBulkAttrReadSupport && directoryRecord) {
                            DataInputOutputUtil.writeINT((DataOutput)appender, (int)PersistentFSConnection.RESERVED_ATTR_ID);
                            DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
                        }
                        DataInputOutputUtil.writeINT((DataOutput)appender, (int)encodedAttrId);
                        int attrAddress = storage2.createNewRecord();
                        DataInputOutputUtil.writeINT((DataOutput)appender, (int)(this.myInlineAttributes ? attrAddress + 64 : attrAddress));
                        PersistentFSConnection.REASONABLY_SMALL.myAttrPageRequested = true;
                        n = attrAddress;
                        if (appender == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (appender != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    appender.close();
                }
                return n;
            }
            finally {
                PersistentFSConnection.REASONABLY_SMALL.myAttrPageRequested = false;
            }
        }
        return 0;
    }

    @NotNull
    DataOutputStream writeAttribute(int fileId, @NotNull FileAttribute attribute, @NotNull PersistentFSConnection connection) {
        if (attribute == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(7);
        }
        AttributeOutputStream stream = new AttributeOutputStream(fileId, attribute, connection);
        if (attribute.isVersioned()) {
            try {
                DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)attribute.getVersion());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        AttributeOutputStream attributeOutputStream = stream;
        if (attributeOutputStream == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(8);
        }
        return attributeOutputStream;
    }

    void deleteAttributes(int id2, @NotNull PersistentFSConnection connection) throws IOException {
        int attPage;
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(9);
        }
        if ((attPage = connection.getRecords().getAttributeRecordId(id2)) != 0) {
            try (DataInputStream attStream = connection.getAttributes().readStream(attPage);){
                if (this.myBulkAttrReadSupport) {
                    PersistentFSAttributeAccessor.skipRecordHeader(attStream, PersistentFSConnection.RESERVED_ATTR_ID, id2);
                }
                while (attStream.available() > 0) {
                    DataInputOutputUtil.readINT((DataInput)attStream);
                    int attAddressOrSize = DataInputOutputUtil.readINT((DataInput)attStream);
                    if (this.myInlineAttributes) {
                        if (attAddressOrSize < 64) {
                            attStream.skipBytes(attAddressOrSize);
                            continue;
                        }
                        attAddressOrSize -= 64;
                    }
                    connection.getAttributes().deleteRecord(attAddressOrSize);
                }
            }
            connection.getAttributes().deleteRecord(attPage);
        }
    }

    private static void writeRecordHeader(int recordTag, int fileId, @NotNull DataOutputStream appender) throws IOException {
        if (appender == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(10);
        }
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)recordTag);
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
    }

    private static void skipRecordHeader(DataInputStream refs, int expectedRecordTag, int expectedFileId) throws IOException {
        int attId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (attId == expectedRecordTag || expectedRecordTag == 0);
        int fileId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (expectedFileId == fileId || expectedFileId == 0);
    }

    void checkAttributesStorageSanity(int id2, @NotNull IntList usedAttributeRecordIds, @NotNull IntList validAttributeIds, @NotNull PersistentFSConnection connection) throws IOException {
        if (usedAttributeRecordIds == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(11);
        }
        if (validAttributeIds == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(12);
        }
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(13);
        }
        int attributeRecordId = connection.getRecords().getAttributeRecordId(id2);
        assert (attributeRecordId >= 0);
        if (attributeRecordId > 0) {
            this.checkAttributesSanity(attributeRecordId, usedAttributeRecordIds, validAttributeIds, connection);
        }
    }

    private void checkAttributesSanity(int attributeRecordId, @NotNull IntList usedAttributeRecordIds, @NotNull IntList validAttributeIds, @NotNull PersistentFSConnection connection) throws IOException {
        if (usedAttributeRecordIds == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(14);
        }
        if (validAttributeIds == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(15);
        }
        if (connection == null) {
            PersistentFSAttributeAccessor.$$$reportNull$$$0(16);
        }
        assert (!usedAttributeRecordIds.contains(attributeRecordId));
        usedAttributeRecordIds.add(attributeRecordId);
        try (DataInputStream dataInputStream = connection.getAttributes().readStream(attributeRecordId);){
            if (this.myBulkAttrReadSupport) {
                PersistentFSAttributeAccessor.skipRecordHeader(dataInputStream, 0, 0);
            }
            while (dataInputStream.available() > 0) {
                int attId = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (!validAttributeIds.contains(attId)) {
                    validAttributeIds.add(attId);
                }
                int attDataRecordIdOrSize = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (this.myInlineAttributes) {
                    if (attDataRecordIdOrSize < 64) {
                        dataInputStream.skipBytes(attDataRecordIdOrSize);
                        continue;
                    }
                    attDataRecordIdOrSize -= 64;
                }
                assert (!usedAttributeRecordIds.contains(attDataRecordIdOrSize));
                usedAttributeRecordIds.add(attDataRecordIdOrSize);
                connection.getAttributes().checkSanity(attDataRecordIdOrSize);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSAttributeAccessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedAttributeRecordIds";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validAttributeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSAttributeAccessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributePage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAttributePage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeRecordHeader";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkAttributesStorageSanity";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkAttributesSanity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AttributeOutputStream
    extends DataOutputStream {
        @NotNull
        private final FileAttribute myAttribute;
        @NotNull
        private final PersistentFSConnection myConnection;
        private final int myFileId;

        private AttributeOutputStream(@NotNull int fileId, @NotNull FileAttribute attribute, PersistentFSConnection connection) {
            if (attribute == null) {
                AttributeOutputStream.$$$reportNull$$$0(0);
            }
            if (connection == null) {
                AttributeOutputStream.$$$reportNull$$$0(1);
            }
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myAttribute = attribute;
            this.myConnection = connection;
        }

        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            if (PersistentFSAttributeAccessor.this.myInlineAttributes && _out.size() < 64) {
                this.rewriteDirectoryRecordWithAttrContent(_out);
                this.myConnection.incLocalModCount();
            } else {
                this.myConnection.incLocalModCount();
                int page = PersistentFSAttributeAccessor.this.findAttributePage(this.myFileId, this.myAttribute, true, this.myConnection);
                if (PersistentFSAttributeAccessor.this.myInlineAttributes && page < 0) {
                    this.rewriteDirectoryRecordWithAttrContent(new BufferExposingByteArrayOutputStream());
                    page = PersistentFSAttributeAccessor.this.findAttributePage(this.myFileId, this.myAttribute, true, this.myConnection);
                }
                if (PersistentFSAttributeAccessor.this.myBulkAttrReadSupport) {
                    BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                    this.out = stream;
                    PersistentFSAttributeAccessor.writeRecordHeader(this.myConnection.getAttributeId(this.myAttribute.getId()), this.myFileId, this);
                    this.write(_out.getInternalBuffer(), 0, _out.size());
                    this.myConnection.getAttributes().writeBytes(page, stream.toByteArraySequence(), this.myAttribute.isFixedSize());
                } else {
                    this.myConnection.getAttributes().writeBytes(page, _out.toByteArraySequence(), this.myAttribute.isFixedSize());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rewriteDirectoryRecordWithAttrContent(@NotNull BufferExposingByteArrayOutputStream _out) throws IOException {
            if (_out == null) {
                AttributeOutputStream.$$$reportNull$$$0(2);
            }
            int recordId = this.myConnection.getRecords().getAttributeRecordId(this.myFileId);
            assert (PersistentFSAttributeAccessor.this.myInlineAttributes);
            int encodedAttrId = this.myConnection.getAttributeId(this.myAttribute.getId());
            Storage storage2 = this.myConnection.getAttributes();
            BufferExposingByteArrayOutputStream unchangedPreviousDirectoryStream = null;
            boolean directoryRecord = false;
            if (recordId == 0) {
                recordId = storage2.createNewRecord();
                this.myConnection.getRecords().setAttributeRecordId(this.myFileId, recordId);
                directoryRecord = true;
            } else {
                try (DataInputStream attrRefs = storage2.readStream(recordId);
                     DataOutputStream dataStream = null;){
                    int remainingAtStart = attrRefs.available();
                    if (PersistentFSAttributeAccessor.this.myBulkAttrReadSupport) {
                        unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                        dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                        int attId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (attId == PersistentFSConnection.RESERVED_ATTR_ID);
                        int fileId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (this.myFileId == fileId);
                        PersistentFSAttributeAccessor.writeRecordHeader(attId, fileId, dataStream);
                    }
                    while (attrRefs.available() > 0) {
                        int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        if (attIdOnPage != encodedAttrId) {
                            if (dataStream == null) {
                                unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                                dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                            }
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attIdOnPage);
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attrAddressOrSize);
                            if (attrAddressOrSize >= 64) continue;
                            byte[] b = new byte[attrAddressOrSize];
                            attrRefs.readFully(b);
                            dataStream.write(b);
                            continue;
                        }
                        if (attrAddressOrSize >= 64) continue;
                        if (_out.size() == attrAddressOrSize) {
                            int remaining = attrRefs.available();
                            storage2.replaceBytes(recordId, remainingAtStart - remaining, _out.toByteArraySequence());
                            return;
                        }
                        attrRefs.skipBytes(attrAddressOrSize);
                    }
                }
            }
            try (AbstractStorage.StorageDataOutput directoryStream = storage2.writeStream(recordId);){
                if (directoryRecord && PersistentFSAttributeAccessor.this.myBulkAttrReadSupport) {
                    PersistentFSAttributeAccessor.writeRecordHeader(PersistentFSConnection.RESERVED_ATTR_ID, this.myFileId, (DataOutputStream)directoryStream);
                }
                if (unchangedPreviousDirectoryStream != null) {
                    directoryStream.write(unchangedPreviousDirectoryStream.getInternalBuffer(), 0, unchangedPreviousDirectoryStream.size());
                }
                if (_out.size() > 0) {
                    DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)encodedAttrId);
                    DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)_out.size());
                    directoryStream.write(_out.getInternalBuffer(), 0, _out.size());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_out";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSAttributeAccessor$AttributeOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rewriteDirectoryRecordWithAttrContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

