/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.core.CoreBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    public static final VirtualFileSystemEntry[] EMPTY_ARRAY = new VirtualFileSystemEntry[0];
    static final PersistentFS ourPersistence = PersistentFS.getInstance();
    static final int ALL_FLAGS_MASK = -16777216;
    @NotNull
    private volatile VfsData.Segment mySegment;
    private volatile VirtualDirectoryImpl myParent;
    final int myId;
    private volatile CachedFileType myFileType;
    static final VirtualFileSystemEntry NULL_VIRTUAL_FILE = new VirtualFileSystemEntry(){

        @Override
        public String toString() {
            return "NULL";
        }

        @NotNull
        public NewVirtualFileSystem getFileSystem() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile findChild(@NotNull String name) {
            if (name == null) {
                1.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile refreshAndFindChild(@NotNull String name) {
            if (name == null) {
                1.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile findChildIfCached(@NotNull String name) {
            if (name == null) {
                1.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<VirtualFile> getCachedChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Iterable<VirtualFile> iterInDbChildren() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public VirtualFile[] getChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public InputStream getInputStream() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshAndFindChild";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findChildIfCached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    VirtualFileSystemEntry(int id2, @NotNull VfsData.Segment segment, @Nullable VirtualDirectoryImpl parent) {
        if (segment == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(0);
        }
        this.mySegment = segment;
        this.myId = id2;
        this.myParent = parent;
        if (id2 <= 0) {
            throw new IllegalArgumentException("id must be positive but got: " + id2);
        }
    }

    private VirtualFileSystemEntry() {
        this.mySegment = null;
        this.myParent = null;
        this.myId = -42;
    }

    @NotNull
    VfsData getVfsData() {
        VfsData vfsData = this.getSegment().vfsData;
        if (vfsData == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(1);
        }
        return vfsData;
    }

    @NotNull VfsData.Segment getSegment() {
        VfsData.Segment segment = this.mySegment;
        if (segment.replacement != null) {
            segment = this.updateSegmentAndParent(segment);
        }
        VfsData.Segment segment2 = segment;
        if (segment2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(2);
        }
        return segment2;
    }

    @NotNull
    private VfsData.Segment updateSegmentAndParent(@NotNull VfsData.Segment segment) {
        if (segment == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(3);
        }
        while (segment.replacement != null) {
            segment = segment.replacement;
        }
        VirtualDirectoryImpl changedParent = segment.vfsData.getChangedParent(this.myId);
        if (changedParent != null) {
            this.myParent = changedParent;
        }
        this.mySegment = segment;
        VfsData.Segment segment2 = segment;
        if (segment2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(4);
        }
        return segment2;
    }

    void registerLink(@NotNull VirtualFileSystem fs) {
        if (fs == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(5);
        }
        if (fs instanceof LocalFileSystemImpl && this.isSymlink() && this.isValid()) {
            ((LocalFileSystemImpl)fs).symlinkUpdated(this.myId, (VirtualFile)this.myParent, this.getNameSequence(), this.getPath(), this.getCanonicalPath());
        }
    }

    void updateLinkStatus(@NotNull VirtualFileSystemEntry parent) {
        if (parent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(6);
        }
        this.setFlagInt(0x40000000, parent.thisOrParentHaveSymlink());
        this.registerLink((VirtualFileSystem)this.getFileSystem());
    }

    @NotNull
    public String getName() {
        String string = this.getNameSequence().toString();
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public CharSequence getNameSequence() {
        CharSequence charSequence = FileNameCache.getVFileName(this.getNameId());
        if (charSequence == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(8);
        }
        return charSequence;
    }

    public final int getNameId() {
        return this.getSegment().getNameId(this.myId);
    }

    public VirtualDirectoryImpl getParent() {
        VfsData.Segment segment = this.mySegment;
        if (segment.replacement != null) {
            this.updateSegmentAndParent(segment);
        }
        return this.myParent;
    }

    public boolean isDirty() {
        return this.getFlagInt(0x10000000);
    }

    public long getModificationStamp() {
        return this.isValid() ? this.getSegment().getModificationStamp(this.myId) : -1L;
    }

    public void setModificationStamp(long modificationStamp) {
        this.getSegment().setModificationStamp(this.myId, modificationStamp);
    }

    boolean getFlagInt(@Flags int mask) {
        return this.getSegment().getFlag(this.myId, mask);
    }

    void setFlagInt(@Flags int mask, boolean value2) {
        this.getSegment().setFlag(this.myId, mask, value2);
    }

    public boolean isFileIndexed() {
        return this.getFlagInt(0x4000000);
    }

    public void setFileIndexed(boolean indexed) {
        this.setFlagInt(0x4000000, indexed);
    }

    public void markClean() {
        this.setFlagInt(0x10000000, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.markDirtyInternal();
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                parent.markDirty();
            }
        }
    }

    void markDirtyInternal() {
        this.setFlagInt(0x10000000, true);
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file2 : this.getCachedChildren()) {
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
    }

    protected char @NotNull [] appendPathOnFileSystem(int accumulatedPathLength, int @NotNull [] positionRef) {
        if (positionRef == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(9);
        }
        CharSequence name = this.getNameSequence();
        char[] chars = this.getParent().appendPathOnFileSystem(accumulatedPathLength + 1 + name.length(), positionRef);
        int i2 = positionRef[0];
        chars[i2] = 47;
        positionRef[0] = VirtualFileSystemEntry.copyString(chars, i2 + 1, name);
        if (chars == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(10);
        }
        return chars;
    }

    private static int copyString(char @NotNull [] chars, int pos, @NotNull CharSequence s) {
        if (s == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(11);
        }
        if (chars == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(12);
        }
        int length = s.length();
        CharArrayUtil.getChars((CharSequence)s, (char[])chars, (int)0, (int)pos, (int)length);
        return pos + length;
    }

    @NotNull
    public String getUrl() {
        String protocol = this.getFileSystem().getProtocol();
        int prefixLen = protocol.length() + "://".length();
        char[] chars = this.appendPathOnFileSystem(prefixLen, new int[]{prefixLen});
        VirtualFileSystemEntry.copyString(chars, VirtualFileSystemEntry.copyString(chars, 0, protocol), "://");
        return new String(chars);
    }

    @NotNull
    public String getPath() {
        return new String(this.appendPathOnFileSystem(0, new int[]{0}));
    }

    public void delete(Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ourPersistence.deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName2) throws IOException {
        if (newName2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getName().equals(newName2)) {
            return;
        }
        this.validateName(newName2);
        ourPersistence.renameFile(requestor, (VirtualFile)this, newName2);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(14);
        }
        this.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildFile(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    public boolean isWritable() {
        return this.getFlagInt(0x1000000);
    }

    public void setWritable(boolean writable) throws IOException {
        ourPersistence.setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return ourPersistence.getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        ourPersistence.setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return ourPersistence.getLength((VirtualFile)this);
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(16);
        }
        if (copyName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(17);
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(CoreBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        VirtualFile virtualFile = EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> ourPersistence.copyFile(requestor, (VirtualFile)this, newParent, copyName));
        if (virtualFile == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> {
            ourPersistence.moveFile(requestor, (VirtualFile)this, newParent);
            return this;
        });
    }

    public int getId() {
        return this.myId;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof VirtualFileSystemEntry && this.myId == ((VirtualFileSystemEntry)((Object)o)).myId;
    }

    public int hashCode() {
        return this.myId;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(20);
        }
        this.validateName(name);
        VirtualFile virtualFile = ourPersistence.createChildDirectory(requestor, (VirtualFile)this, name);
        if (virtualFile == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    private void validateName(@NotNull String name) throws IOException {
        if (name == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(22);
        }
        if (!this.getFileSystem().isValidName(name)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{name}));
        }
    }

    public boolean exists() {
        return this.getVfsData().isFileValid(this.myId);
    }

    public boolean isValid() {
        return this.exists();
    }

    @NonNls
    public String toString() {
        if (this.isValid()) {
            return this.getUrl();
        }
        String reason = this.getInvalidationInfo();
        return this.getUrl() + " (invalid" + (String)(reason == null ? "" : ", reason: " + reason) + ")";
    }

    public void setNewName(@NotNull String newName2) {
        if (newName2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(23);
        }
        if (!this.getFileSystem().isValidName(newName2)) {
            throw new IllegalArgumentException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName2}));
        }
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        this.getSegment().setNameId(this.myId, FileNameCache.storeName(newName2));
        parent.addChild(this);
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public void setParent(@NotNull VirtualFile newParent) {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        VirtualDirectoryImpl directory = (VirtualDirectoryImpl)newParent;
        this.getSegment().changeParent(this.myId, directory);
        directory.addChild(this);
        this.updateLinkStatus(directory);
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    @ApiStatus.Internal
    public void invalidate(@NotNull Object source, @NotNull Object reason) {
        if (source == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(25);
        }
        if (reason == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(26);
        }
        this.getVfsData().invalidateFile(this.myId);
        this.appendInvalidationReason(source, reason);
    }

    @ApiStatus.Internal
    public void appendInvalidationReason(@NotNull Object source, @NotNull Object reason) {
        if (source == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(27);
        }
        if (reason == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(28);
        }
        if (DebugInvalidation.DEBUG && !ApplicationInfoImpl.isInStressTest()) {
            String oldReason = (String)this.getUserData(DebugInvalidation.INVALIDATION_REASON);
            String newReason = source + ": " + reason;
            if (oldReason == null) {
                this.putUserData(DebugInvalidation.INVALIDATION_TRACE, ThrowableInterner.intern((Throwable)new Throwable()));
            }
            this.putUserData(DebugInvalidation.INVALIDATION_REASON, oldReason == null ? newReason : oldReason + "; " + newReason);
        }
    }

    private String getInvalidationInfo() {
        String reason = (String)this.getUserData(DebugInvalidation.INVALIDATION_REASON);
        if (reason == null) {
            return null;
        }
        Throwable trace = (Throwable)this.getUserData(DebugInvalidation.INVALIDATION_TRACE);
        if (trace == null) {
            return reason;
        }
        return reason + "; stacktrace:\n" + ExceptionUtil.getThrowableText((Throwable)trace);
    }

    @NotNull
    public Charset getCharset() {
        return this.isCharsetSet() ? super.getCharset() : this.computeCharset();
    }

    @NotNull
    private Charset computeCharset() {
        Charset charset;
        if (this.isDirectory()) {
            Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
            charset = configured == null ? Charset.defaultCharset() : configured;
            this.setCharset(charset);
        } else {
            byte[] content2;
            FileType fileType;
            block10: {
                Charset charset2;
                fileType = this.getFileType();
                if (this.isCharsetSet()) {
                    Charset charset3 = super.getCharset();
                    if (charset3 == null) {
                        VirtualFileSystemEntry.$$$reportNull$$$0(29);
                    }
                    return charset3;
                }
                try {
                    content2 = VfsUtilCore.loadBytes((VirtualFile)this);
                    if (!this.isCharsetSet()) break block10;
                    charset2 = super.getCharset();
                }
                catch (IOException e) {
                    Charset charset4 = super.getCharset();
                    if (charset4 == null) {
                        VirtualFileSystemEntry.$$$reportNull$$$0(31);
                    }
                    return charset4;
                }
                if (charset2 == null) {
                    VirtualFileSystemEntry.$$$reportNull$$$0(30);
                }
                return charset2;
            }
            charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, content2, fileType);
        }
        Charset charset5 = charset;
        if (charset5 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(32);
        }
        return charset5;
    }

    @NotNull
    public String getPresentableName() {
        if (UISettings.getInstance().getHideKnownExtensionInTabs() && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            String string = nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
            if (string == null) {
                VirtualFileSystemEntry.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = this.getName();
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(34);
        }
        return string;
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(35);
        }
        if (property == VFileProperty.SPECIAL) {
            return !this.isDirectory() && this.isSpecial();
        }
        if (property == VFileProperty.HIDDEN) {
            return this.getFlagInt(0x2000000);
        }
        if (property == VFileProperty.SYMLINK) {
            return this.isSymlink();
        }
        throw new IllegalArgumentException("unknown property: " + property);
    }

    private boolean isSymlink() {
        return this.getFlagInt(0x20000000);
    }

    private boolean isSpecial() {
        return !this.isDirectory() && this.getFlagInt(Integer.MIN_VALUE);
    }

    @ApiStatus.Internal
    public boolean thisOrParentHaveSymlink() {
        return this.isSymlink() || this.getFlagInt(0x40000000);
    }

    @ApiStatus.Internal
    public void setWritableFlag(boolean value2) {
        this.setFlagInt(0x1000000, value2);
    }

    @ApiStatus.Internal
    public void setHiddenFlag(boolean value2) {
        this.setFlagInt(0x2000000, value2);
    }

    public String getCanonicalPath() {
        if (this.thisOrParentHaveSymlink()) {
            if (this.isSymlink()) {
                return ourPersistence.resolveSymLink((VirtualFile)this);
            }
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                return parent.getCanonicalPath() + "/" + this.getName();
            }
            return this.getName();
        }
        return this.getPath();
    }

    public NewVirtualFile getCanonicalFile() {
        if (this.thisOrParentHaveSymlink()) {
            String path = this.getCanonicalPath();
            return path != null ? (NewVirtualFile)this.getFileSystem().findFileByPath(path) : null;
        }
        return this;
    }

    public boolean isRecursiveOrCircularSymlink() {
        if (!this.isSymlink()) {
            return false;
        }
        NewVirtualFile resolved2 = this.getCanonicalFile();
        if (resolved2 == null) {
            return false;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)resolved2, (VirtualFile)this, (boolean)false)) {
            return true;
        }
        for (VirtualDirectoryImpl p = this.getParent(); p != null; p = p.getParent()) {
            NewVirtualFile parentResolved;
            if (!p.thisOrParentHaveSymlink()) {
                return false;
            }
            if (!p.isSymlink() || !resolved2.equals(parentResolved = p.getCanonicalFile())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public FileType getFileType() {
        FileType type;
        CachedFileType cache2 = this.myFileType;
        FileType fileType = type = cache2 == null ? null : cache2.getUpToDateOrNull();
        if (type == null) {
            type = super.getFileType();
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                this.myFileType = CachedFileType.forType(type);
            }
        }
        FileType fileType2 = type;
        if (fileType2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(36);
        }
        return fileType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 14: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSegmentAndParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPathOnFileSystem";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCharset";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateSegmentAndParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerLink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateLinkStatus";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendPathOnFileSystem";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendInvalidationReason";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DebugInvalidation {
        private static final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();
        private static final Key<String> INVALIDATION_REASON = Key.create((String)"INVALIDATION_REASON");
        private static final Key<Throwable> INVALIDATION_TRACE = Key.create((String)"INVALIDATION_TRACE");

        private DebugInvalidation() {
        }
    }

    static @interface Flags {
    }

    @ApiStatus.Internal
    static class VfsDataFlags {
        static final int IS_WRITABLE_FLAG = 0x1000000;
        static final int IS_HIDDEN_FLAG = 0x2000000;
        private static final int INDEXED_FLAG = 0x4000000;
        static final int SYSTEM_LINE_SEPARATOR_DETECTED = 0x8000000;
        static final int CHILDREN_CASE_SENSITIVITY_CACHED = 0x8000000;
        private static final int DIRTY_FLAG = 0x10000000;
        static final int IS_SYMLINK_FLAG = 0x20000000;
        static final int STRICT_PARENT_HAS_SYMLINK_FLAG = 0x40000000;
        static final int CHILDREN_CASE_SENSITIVE = Integer.MIN_VALUE;
        static final int IS_SPECIAL_FLAG = Integer.MIN_VALUE;

        VfsDataFlags() {
        }
    }
}

