/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileLoadingTracker;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance(VirtualDirectoryImpl.class);
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    final VfsData.DirectoryData myData;
    private final NewVirtualFileSystem myFs;

    VirtualDirectoryImpl(int id2, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data2, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs) {
        if (segment == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(0);
        }
        if (data2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(1);
        }
        if (fs == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(2);
        }
        super(id2, segment, parent);
        this.myData = data2;
        this.myFs = fs;
        if (parent != null) {
            this.registerLink((VirtualFileSystem)fs);
        }
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.myFs;
        if (newVirtualFileSystem == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(3);
        }
        return newVirtualFileSystem;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate2) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(4);
        }
        if (delegate2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(5);
        }
        this.updateCaseSensitivityIfUnknown(name);
        VirtualFileSystemEntry result2 = this.doFindChild(name, ensureCanonicalName, delegate2, this.isCaseSensitive());
        if (result2 == NULL_VIRTUAL_FILE) {
            result2 = doRefresh ? this.createAndFindChildWithEventFire(name, delegate2) : null;
        } else if (result2 != null && doRefresh && delegate2.isDirectory((VirtualFile)result2) != result2.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result2});
            result2 = this.findChild(name, false, ensureCanonicalName, delegate2);
        }
        return result2;
    }

    @Nullable
    private VirtualFileSystemEntry doFindChildInArray(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(6);
        }
        if (this.myData.isAdoptedName(name)) {
            return NULL_VIRTUAL_FILE;
        }
        int[] array2 = this.myData.myChildrenIds;
        int indexInReal = this.findIndex(array2, name);
        if (indexInReal >= 0) {
            return this.getVfsData().getFileById(array2[indexInReal], this, true);
        }
        return null;
    }

    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate2, boolean caseSensitive) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(7);
        }
        if (delegate2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(8);
        }
        if (name.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            return this.handleInvalidDirectory(null);
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name);
        if (found != null) {
            return found;
        }
        if (ensureCanonicalName) {
            String trimmedName = VirtualDirectoryImpl.deSlash(name);
            if (trimmedName == null) {
                return null;
            }
            if (!trimmedName.equals(name)) {
                found = this.doFindChildInArray(trimmedName);
                if (found != null) {
                    return found;
                }
                name = trimmedName;
            }
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        return this.findInPersistence(name, ensureCanonicalName, delegate2, caseSensitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry findInPersistence(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate2, boolean caseSensitive) {
        VirtualFileSystemEntry child2;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(9);
        }
        if (delegate2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(10);
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            CharSequence persistedName;
            child2 = this.doFindChildInArray(name);
            if (child2 != null) {
                return child2;
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            ChildInfo childInfo = ourPersistence.findChildInfo((VirtualFile)this, name, delegate2);
            if (childInfo == null) {
                this.myData.addAdoptedName(name, caseSensitive);
                return null;
            }
            if (ensureCanonicalName && !Comparing.equal((CharSequence)name, (CharSequence)(persistedName = childInfo.getName())) && (child2 = this.doFindChildInArray(name = persistedName.toString())) != null) {
                return child2;
            }
            int nameId = childInfo.getNameId();
            int id2 = childInfo.getId();
            int attributes = ourPersistence.getFileAttributes(id2);
            boolean isEmptyDirectory = PersistentFS.isDirectory(attributes) && !ourPersistence.mayHaveChildren(id2);
            child2 = this.createChild(id2, nameId, delegate2, attributes, isEmptyDirectory);
            this.addChild(child2);
        }
        if (!child2.isDirectory()) {
            VfsRootAccess.assertAccessInTests((VirtualFile)child2, this.getFileSystem());
        }
        return child2;
    }

    private <T> T handleInvalidDirectory(T empty) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return empty;
        }
        throw new InvalidVirtualFileAccessException((VirtualFile)this);
    }

    @ApiStatus.Internal
    public void setCaseSensitivityFlag(@NotNull FileAttributes.CaseSensitivity sensitivity) {
        if (sensitivity == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(11);
        }
        VfsData vfsData = this.getVfsData();
        VfsData.Segment segment = vfsData.getSegment(this.getId(), false);
        int newFlags = (sensitivity == FileAttributes.CaseSensitivity.UNKNOWN ? 0 : 0x8000000) | (sensitivity == FileAttributes.CaseSensitivity.SENSITIVE ? Integer.MIN_VALUE : 0);
        segment.setFlags(this.getId(), -2013265920, newFlags);
    }

    private static String deSlash(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(12);
        }
        int startTrimmed = -1;
        int endTrimmed = -1;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (startTrimmed == -1) {
                if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
                startTrimmed = i2;
                continue;
            }
            if (endTrimmed == -1) {
                if (!VirtualDirectoryImpl.isFileSeparator(c)) continue;
                endTrimmed = i2;
                continue;
            }
            if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
            return null;
        }
        if (startTrimmed == -1) {
            return null;
        }
        if (endTrimmed == -1) {
            return name.substring(startTrimmed);
        }
        if (startTrimmed == endTrimmed) {
            return null;
        }
        return name.substring(startTrimmed, endTrimmed);
    }

    private static boolean isFileSeparator(char c) {
        return c == '/' || c == File.separatorChar;
    }

    private VirtualFileSystemEntry @NotNull [] getArraySafely(boolean putToMemoryCache) {
        VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.myData.getFileChildren(this, putToMemoryCache);
        if (virtualFileSystemEntryArray == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(13);
        }
        return virtualFileSystemEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    @ApiStatus.Internal
    public VirtualFileSystemEntry createChild(@NotNull String name, int id2, @NotNull NewVirtualFileSystem delegate2, @PersistentFS.Attributes int attributes, boolean isEmptyDirectory) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(14);
        }
        if (delegate2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(15);
        }
        int nameId = FileNameCache.storeName(name);
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry virtualFileSystemEntry = this.createChild(id2, nameId, delegate2, attributes, isEmptyDirectory);
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntry != null) return virtualFileSystemEntry;
        VirtualDirectoryImpl.$$$reportNull$$$0(16);
        return virtualFileSystemEntry;
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int id2, int nameId, @NotNull NewVirtualFileSystem delegate2, @PersistentFS.Attributes int attributes, boolean isEmptyDirectory) {
        if (delegate2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(17);
        }
        FileLoadingTracker.fileLoaded(this, nameId);
        VfsData vfsData = this.getVfsData();
        VfsData.Segment segment = vfsData.getSegment(id2, true);
        boolean isDirectory = PersistentFS.isDirectory(attributes);
        VfsData.initFile(id2, segment, nameId, isDirectory ? new VfsData.DirectoryData() : KeyFMap.EMPTY_MAP);
        LOG.assertTrue(!(this.getFileSystem() instanceof Win32LocalFileSystem));
        VirtualFileSystemEntry child2 = vfsData.getFileById(id2, this, true);
        assert (child2 != null);
        FileAttributes.CaseSensitivity sensitivity = isDirectory ? PersistentFS.areChildrenCaseSensitive(attributes) : FileAttributes.CaseSensitivity.UNKNOWN;
        int newFlags = (PersistentFS.isSymLink(attributes) ? 0x20000000 : 0) | (PersistentFS.isSpecialFile(attributes) ? Integer.MIN_VALUE : 0) | (PersistentFS.isWritable(attributes) ? 0x1000000 : 0) | (PersistentFS.isHidden(attributes) ? 0x2000000 : 0) | (sensitivity != FileAttributes.CaseSensitivity.UNKNOWN ? 0x8000000 : 0) | (sensitivity == FileAttributes.CaseSensitivity.SENSITIVE ? Integer.MIN_VALUE : 0);
        int relevantFlagsMask = -352321536;
        segment.setFlags(id2, relevantFlagsMask, newFlags);
        child2.updateLinkStatus(this);
        if (delegate2.markNewFilesAsDirty()) {
            child2.markDirty();
        }
        if (isDirectory && child2 instanceof VirtualDirectoryImpl && isEmptyDirectory) {
            ((VirtualDirectoryImpl)child2).setAllChildrenLoaded();
        }
        VirtualFileSystemEntry virtualFileSystemEntry = child2;
        if (virtualFileSystemEntry == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(18);
        }
        return virtualFileSystemEntry;
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate2) {
        FakeVirtualFile fake;
        FileAttributes attributes;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(19);
        }
        if (delegate2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(20);
        }
        if ((attributes = delegate2.getAttributes((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, name)))) == null) {
            return null;
        }
        String realName = delegate2.getCanonicallyCasedName((VirtualFile)fake);
        boolean isDirectory = attributes.isDirectory();
        boolean isEmptyDirectory = isDirectory && !delegate2.hasChildren((VirtualFile)fake);
        String symlinkTarget = attributes.isSymLink() ? delegate2.resolveSymLink((VirtualFile)fake) : null;
        ChildInfo[] children2 = isEmptyDirectory ? ChildInfo.EMPTY_ARRAY : null;
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, isDirectory, attributes, symlinkTarget, true, children2);
        RefreshQueue.getInstance().processSingleEvent(false, (VFileEvent)event);
        return this.findChild(realName);
    }

    private void updateCaseSensitivityIfUnknown(@NotNull String childName) {
        VFilePropertyChangeEvent caseSensitivityEvent;
        if (childName == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(21);
        }
        if ((caseSensitivityEvent = VfsImplUtil.generateCaseSensitivityChangedEventForUnknownCase((VirtualFile)this, childName)) != null) {
            PersistentFSImpl.executeChangeCaseSensitivity((VirtualFile)this, (FileAttributes.CaseSensitivity)caseSensitivityEvent.getNewValue());
            RefreshQueue.getInstance().processSingleEvent(true, (VFileEvent)caseSensitivityEvent);
        }
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(22);
        }
        return this.findChild(name, true, true, this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        VirtualFileSystemEntry found;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(23);
        }
        return (found = this.doFindChildInArray(name)) == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(24);
            }
            return list2;
        }
        if (ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            List<VirtualFile> list3 = Arrays.asList(this.getChildren());
            if (list3 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(25);
            }
            return list3;
        }
        this.loadPersistedChildren();
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(26);
        }
        return collection;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(27);
            }
            return list2;
        }
        if (!ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            this.loadPersistedChildren();
        }
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    private void loadPersistedChildren() {
        String[] names2 = ourPersistence.listPersisted((VirtualFile)this);
        NewVirtualFileSystem delegate2 = PersistentFS.replaceWithNativeFS(this.getFileSystem());
        for (String name : names2) {
            this.findChild(name, false, false, delegate2);
        }
    }

    public VirtualFile @NotNull [] getChildren() {
        if (!this.isValid()) {
            VirtualFile[] virtualFileArray = (VirtualFile[])this.handleInvalidDirectory(EMPTY_ARRAY);
            if (virtualFileArray == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(29);
            }
            return virtualFileArray;
        }
        if (this.allChildrenLoaded()) {
            return this.getArraySafely(true);
        }
        return this.loadAllChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private VirtualFile @NotNull [] loadAllChildren() {
        VirtualFile[] files2;
        NewVirtualFileSystem delegate2 = this.getFileSystem();
        boolean caseSensitive = this.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
        List<? extends ChildInfo> children2 = ourPersistence.listAll((VirtualFile)this);
        int[] result2 = ArrayUtil.newIntArray((int)children2.size());
        if (children2.isEmpty()) {
            VirtualFile[] files22 = VirtualFile.EMPTY_ARRAY;
        } else {
            files2 = new VirtualFile[children2.size()];
            int[] errorsCount = new int[]{0};
            children2.sort((o1, o2) -> {
                CharSequence name2;
                CharSequence name1 = o1.getName();
                int cmp = VirtualDirectoryImpl.compareNames(name1, name2 = o2.getName(), caseSensitive);
                if (cmp == 0 && name1 != name2 && errorsCount[0] < 10) {
                    LOG.error(ourPersistence + " returned duplicate file names(" + name1 + "," + name2 + ") caseSensitive: " + caseSensitive + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " isCaseSensitive(): " + this.isCaseSensitive() + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + this + "; children: " + StringUtil.first((String)children2.toString(), (int)300, (boolean)true));
                    errorsCount[0] = errorsCount[0] + 1;
                    if (!caseSensitive) {
                        cmp = VirtualDirectoryImpl.compareNames(name1, name2, true);
                    }
                }
                return cmp;
            });
            IntOpenHashSet prevChildren = new IntOpenHashSet(this.myData.myChildrenIds);
            VfsData vfsData = this.getVfsData();
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                ChildInfo child2 = children2.get(i2);
                int id2 = child2.getId();
                assert (id2 > 0) : child2;
                result2[i2] = id2;
                prevChildren.remove(id2);
                VirtualFileSystemEntry file2 = vfsData.getFileById(id2, this, true);
                if (file2 == null) {
                    int attributes = ourPersistence.getFileAttributes(id2);
                    boolean isEmptyDirectory = PersistentFS.isDirectory(attributes) && !ourPersistence.mayHaveChildren(id2);
                    file2 = this.createChild(id2, child2.getNameId(), delegate2, attributes, isEmptyDirectory);
                }
                files2[i2] = file2;
            }
            if (!prevChildren.isEmpty()) {
                LOG.error("Loaded child disappeared: parent=" + VirtualDirectoryImpl.verboseToString(this) + "; child=" + VirtualDirectoryImpl.verboseToString(vfsData.getFileById(prevChildren.iterator().nextInt(), this, true)));
            }
        }
        this.myData.clearAdoptedNames();
        this.myData.myChildrenIds = result2;
        this.setAllChildrenLoaded();
        if (CHECK) {
            this.assertConsistency(caseSensitive, children2);
        }
        // MONITOREXIT : directoryData
        if (files2 != null) return files2;
        VirtualDirectoryImpl.$$$reportNull$$$0(30);
        return files2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConsistency(boolean caseSensitive, @NotNull Object details) {
        if (details == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(31);
        }
        if (!CHECK || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        int[] childrenIds = this.myData.myChildrenIds;
        if (childrenIds.length == 0) {
            return;
        }
        VfsData vfsData = this.getVfsData();
        CharSequence prevName = vfsData.getNameByFileId(childrenIds[0]);
        for (int i2 = 1; i2 < childrenIds.length; ++i2) {
            int id2 = childrenIds[i2];
            int prev2 = childrenIds[i2 - 1];
            CharSequence name = vfsData.getNameByFileId(id2);
            int cmp = VirtualDirectoryImpl.compareNames(name, prevName, caseSensitive);
            prevName = name;
            if (cmp <= 0) {
                VirtualDirectoryImpl.error(VirtualDirectoryImpl.verboseToString(vfsData.getFileById(prev2, this, true)) + " is wrongly placed before " + VirtualDirectoryImpl.verboseToString(vfsData.getFileById(id2, this, true)), this.getArraySafely(true), details);
            }
            VfsData.DirectoryData directoryData = this.myData;
            synchronized (directoryData) {
                if (this.myData.isAdoptedName(name)) {
                    try {
                        VirtualDirectoryImpl.error("In " + VirtualDirectoryImpl.verboseToString(this) + " file '" + name + "' is both child and adopted", this.getArraySafely(true), "Adopted: " + this.myData.getAdoptedNames() + ";\n " + details);
                    }
                    finally {
                        this.myData.removeAdoptedName(name);
                    }
                }
                continue;
            }
        }
    }

    @NotNull
    @NonNls
    private static String verboseToString(VirtualFileSystemEntry file2) {
        if (file2 == null) {
            return "null";
        }
        String string = file2 + " (name: '" + file2.getName() + "', " + ((Object)((Object)file2)).getClass() + ", parent: " + file2.getParent() + "; id: " + file2.getId() + "; FS: " + file2.getFileSystem() + "; delegate.attrs: " + file2.getFileSystem().getAttributes((VirtualFile)file2) + "; caseSensitive: " + file2.isCaseSensitive() + "; canonical: " + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + ") ";
        if (string == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static void error(@NonNls String message2, VirtualFileSystemEntry @NotNull [] array2, Object ... details) {
        if (details == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(33);
        }
        if (array2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(34);
        }
        String children2 = StringUtil.join((Object[])array2, VirtualDirectoryImpl::verboseToString, (String)"\n");
        String detailsStr = StringUtil.join((Iterable)ContainerUtil.map((Object[])details, o -> o instanceof Object[] ? Arrays.toString((Object[])o) : o), (String)"\n");
        throw new AssertionError((Object)(message2 + "; children: " + children2 + "\nDetails: " + detailsStr));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(35);
        }
        return this.findChild(name, false, true, this.getFileSystem());
    }

    public VirtualFileSystemEntry doFindChildById(int id2) {
        int i2 = ArrayUtil.indexOf((int[])this.myData.myChildrenIds, (int)id2);
        if (i2 >= 0) {
            return this.getVfsData().getFileById(id2, this, true);
        }
        String name = ourPersistence.getName(id2);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndAddChildren(@NotNull List<? extends ChildInfo> added2, boolean markAllChildrenLoaded, @NotNull PairConsumer<? super VirtualFile, ? super ChildInfo> fileCreated) {
        if (added2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(36);
        }
        if (fileCreated == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(37);
        }
        if (added2.size() <= 1) {
            for (int i2 = 0; i2 < added2.size(); ++i2) {
                ChildInfo info = added2.get(i2);
                assert (info.getId() > 0) : info;
                @PersistentFS.Attributes int attributes = info.getFileAttributeFlags();
                boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                VfsData.DirectoryData directoryData = this.myData;
                synchronized (directoryData) {
                    int[] oldIds = this.myData.myChildrenIds;
                    if (ArrayUtil.indexOf((int[])oldIds, (int)info.getId()) < 0) {
                        VirtualFileSystemEntry file2 = this.createChild(info.getId(), info.getNameId(), this.getFileSystem(), attributes, isEmptyDirectory);
                        this.addChild(file2);
                        fileCreated.consume((Object)file2, (Object)info);
                    }
                    continue;
                }
            }
            if (markAllChildrenLoaded) {
                this.setAllChildrenLoaded();
            }
            return;
        }
        boolean caseSensitive = this.isCaseSensitive();
        Comparator pairComparator = (p1, p2) -> VirtualDirectoryImpl.compareNames(p1.getName(), p2.getName(), caseSensitive);
        added2.sort(pairComparator);
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            final int[] oldIds = this.myData.myChildrenIds;
            IntArrayList mergedIds = new IntArrayList(oldIds.length + added2.size());
            for (int i3 = 0; i3 < added2.size(); ++i3) {
                ChildInfo info = added2.get(i3);
                assert (info.getId() > 0) : info;
                @PersistentFS.Attributes int attributes = info.getFileAttributeFlags();
                boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                this.myData.removeAdoptedName(info.getName());
                VirtualFileSystemEntry file3 = this.createChild(info.getId(), info.getNameId(), this.getFileSystem(), attributes, isEmptyDirectory);
                fileCreated.consume((Object)file3, (Object)info);
            }
            final VfsData vfsData = this.getVfsData();
            AbstractList<ChildInfo> existingChildren = new AbstractList<ChildInfo>(){

                @Override
                public ChildInfo get(int index2) {
                    int id2 = oldIds[index2];
                    assert (id2 > 0) : id2;
                    int nameId = vfsData.getNameId(id2);
                    return new ChildInfoImpl(id2, nameId, null, null, null);
                }

                @Override
                public int size() {
                    return oldIds.length;
                }
            };
            ContainerUtil.processSortedListsInOrder(added2, (List)existingChildren, (Comparator)pairComparator, (boolean)true, (arg_0, arg_1) -> VirtualDirectoryImpl.lambda$createAndAddChildren$3((IntList)mergedIds, arg_0, arg_1));
            this.myData.myChildrenIds = mergedIds.toIntArray();
            if (markAllChildrenLoaded) {
                this.setAllChildrenLoaded();
            }
            this.assertConsistency(caseSensitive, added2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child2) {
        if (child2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(38);
        }
        CharSequence childName = child2.getNameSequence();
        boolean caseSensitive = this.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            this.myData.removeAdoptedName(childName);
            int indexInReal = this.findIndex(this.myData.myChildrenIds, childName);
            if (indexInReal < 0) {
                int i2 = -indexInReal - 1;
                this.insertChildAt(child2, i2);
            }
            this.assertConsistency(caseSensitive, (Object)child2);
        }
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file2, int i2) {
        if (file2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(39);
        }
        int id2 = file2.getId();
        assert (id2 > 0) : file2 + ": " + id2;
        this.myData.myChildrenIds = ArrayUtil.insert((int[])this.myData.myChildrenIds, (int)i2, (int)id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(40);
        }
        boolean caseSensitive = this.isCaseSensitive();
        String name = file2.getName();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int indexInReal = this.findIndex(this.myData.myChildrenIds, name);
            if (indexInReal >= 0) {
                this.myData.myChildrenIds = ArrayUtil.remove((int[])this.myData.myChildrenIds, (int)indexInReal);
            }
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedName(name, caseSensitive);
            }
            this.assertConsistency(caseSensitive, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(@NotNull IntSet idsToRemove, @NotNull List<? extends CharSequence> namesToRemove) {
        if (idsToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(41);
        }
        if (namesToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(42);
        }
        boolean caseSensitive = this.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int[] newIds = new int[this.myData.myChildrenIds.length];
            int[] oldIds = this.myData.myChildrenIds;
            int o = 0;
            for (int oldId : oldIds) {
                if (idsToRemove.contains(oldId)) continue;
                assert (oldId > 0) : Arrays.toString(oldIds);
                newIds[o++] = oldId;
            }
            if (o != newIds.length) {
                newIds = o == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : Arrays.copyOf(newIds, o);
            }
            this.myData.myChildrenIds = newIds;
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedNames(namesToRemove, caseSensitive);
            }
            this.assertConsistency(caseSensitive, namesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void validateChildrenToCreate(@NotNull Collection<VFileCreateEvent> childrenToCreate) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(43);
        }
        if (childrenToCreate.size() <= 1) {
            childrenToCreate.removeIf(event -> !event.isValid());
            return;
        }
        boolean caseSensitive = this.isCaseSensitive();
        Set existingNames = CollectionFactory.createCharSequenceSet((boolean)caseSensitive, (int)this.myData.myChildrenIds.length);
        VfsData vfsData = this.getVfsData();
        for (int id2 : this.myData.myChildrenIds) {
            existingNames.add(vfsData.getNameByFileId(id2));
        }
        int id3 = this.getId();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            existingNames.addAll(FSRecords.listNames(id3));
            this.validateAgainst(childrenToCreate, existingNames);
            if (!childrenToCreate.isEmpty() && !this.allChildrenLoaded()) {
                int beforeSize = existingNames.size();
                String[] names2 = this.getFileSystem().list((VirtualFile)this);
                existingNames.addAll(Arrays.asList(names2));
                if (beforeSize != existingNames.size()) {
                    this.validateAgainst(childrenToCreate, existingNames);
                }
            }
        }
    }

    private void validateAgainst(@NotNull Collection<VFileCreateEvent> childrenToCreate, @NotNull Set<? extends CharSequence> existingNames) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(44);
        }
        if (existingNames == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(45);
        }
        childrenToCreate.removeIf(event -> {
            String childName = event.getChildName();
            return !this.myData.isAdoptedName(childName) && existingNames.contains(childName);
        });
    }

    public boolean allChildrenLoaded() {
        return this.myData.allChildrenLoaded();
    }

    private void setAllChildrenLoaded() {
        this.myData.setAllChildrenLoaded();
    }

    @NotNull
    public List<String> getSuspiciousNames() {
        List<String> list2 = this.myData.getAdoptedNames();
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(46);
        }
        return list2;
    }

    private int findIndex(int @NotNull [] ids, @NotNull CharSequence name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(47);
        }
        if (ids == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(48);
        }
        VfsData vfsData = this.getVfsData();
        boolean caseSensitive = this.isCaseSensitive();
        return ObjectUtils.binarySearch((int)0, (int)ids.length, mid -> VirtualDirectoryImpl.compareNames(vfsData.getNameByFileId(ids[mid]), name, caseSensitive));
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean caseSensitive) {
        int d;
        if (name1 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(49);
        }
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(50);
        }
        if ((d = name1.length() - name2.length()) != 0) {
            return d;
        }
        for (int i2 = 0; i2 < name1.length(); ++i2) {
            d = StringUtil.compare((char)name1.charAt(i2), (char)name2.charAt(i2), (!caseSensitive ? 1 : 0) != 0);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public List<VirtualFile> getCachedChildren() {
        List<VirtualFileSystemEntry> list2 = Arrays.asList(this.getArraySafely(false));
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(51);
        }
        return list2;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child2 : this.getArraySafely(true)) {
            child2.markDirtyInternal();
            if (!(child2 instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child2).markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(52);
        }
        this.myData.myUserMap = map2;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.myData.myUserMap;
        if (keyFMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(53);
        }
        return keyFMap;
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
        if (oldMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(54);
        }
        if (newMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(55);
        }
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.myData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    static void checkLeaks(@NotNull KeyFMap newMap) {
        if (newMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(56);
        }
        for (Key key : newMap.getKeys()) {
            if (newMap.get(key) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }

    public boolean isCaseSensitive() {
        return this.isChildrenCaseSensitivityKnown() ? this.getFlagInt(Integer.MIN_VALUE) : super.isCaseSensitive();
    }

    @ApiStatus.Internal
    private boolean isChildrenCaseSensitivityKnown() {
        return this.getFlagInt(0x8000000);
    }

    @ApiStatus.Internal
    @NotNull
    public FileAttributes.CaseSensitivity getChildrenCaseSensitivity() {
        FileAttributes.CaseSensitivity caseSensitivity = this.isChildrenCaseSensitivityKnown() ? (this.isCaseSensitive() ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE) : FileAttributes.CaseSensitivity.UNKNOWN;
        if (caseSensitivity == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(57);
        }
        return caseSensitivity;
    }

    private static /* synthetic */ void lambda$createAndAddChildren$3(IntList mergedIds, ChildInfo nextInfo, Boolean __) {
        mergedIds.add(nextInfo.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 46: 
            case 51: 
            case 53: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 46: 
            case 51: 
            case 53: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 46: 
            case 51: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 35: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sensitivity";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCreated";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsToRemove";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToRemove";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenToCreate";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getArraySafely";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildren";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildrenWithoutLoadingVfsFromOtherProjects";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAllChildren";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "verboseToString";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspiciousNames";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedChildren";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenCaseSensitivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 46: 
            case 51: 
            case 53: 
            case 57: {
                break;
            }
            case 4: 
            case 5: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFindChildInArray";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFindChild";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInPersistence";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCaseSensitivityFlag";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deSlash";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAndFindChildWithEventFire";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateCaseSensitivityIfUnknown";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findChildIfCached";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddChildren";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "insertChildAt";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeChildren";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "validateChildrenToCreate";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "validateAgainst";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "compareNames";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "changeUserMap";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkLeaks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 46: 
            case 51: 
            case 53: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

