/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VfsRootAccess {
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null && System.getProperty("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Set<String> ourAdditionalRoots = CollectionFactory.createFilePathSet();
    private static boolean insideGettingRoots;

    @TestOnly
    static void assertAccessInTests(@NotNull VirtualFile child2, @NotNull NewVirtualFileSystem delegate2) {
        if (child2 == null) {
            VfsRootAccess.$$$reportNull$$$0(0);
        }
        if (delegate2 == null) {
            VfsRootAccess.$$$reportNull$$$0(1);
        }
        Application application = ApplicationManager.getApplication();
        if (SHOULD_PERFORM_ACCESS_CHECK && application.isUnitTestMode() && application instanceof ApplicationImpl && ((ApplicationImpl)application).getComponentCreated() && !ApplicationInfoImpl.isInStressTest()) {
            boolean isUnder;
            if (delegate2 != LocalFileSystem.getInstance() && delegate2 != JarFileSystem.getInstance()) {
                return;
            }
            if (child2.getParent() == null || child2.getParent().getParent() == null) {
                return;
            }
            Set<String> allowed = VfsRootAccess.allowedRoots();
            boolean bl = isUnder = allowed == null || allowed.isEmpty();
            if (!isUnder) {
                VirtualFile local = child2;
                if (delegate2 == JarFileSystem.getInstance()) {
                    local = JarFileSystem.getInstance().getVirtualFileForJar(child2);
                    assert (local != null) : child2;
                }
                for (String root : allowed) {
                    String rootLocalPath;
                    if (VfsUtilCore.isAncestorOrSelf((String)root, (VirtualFile)local)) {
                        isUnder = true;
                        break;
                    }
                    if (!root.startsWith("jar://") || !(isUnder = VfsUtilCore.isAncestorOrSelf((String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root))), (VirtualFile)local))) continue;
                    break;
                }
            }
            assert (isUnder) : "File accessed outside allowed roots: " + child2 + ";\nAllowed roots: " + new ArrayList<String>(allowed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Set<String> allowedRoots() {
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        @NonNls Set allowed = CollectionFactory.createFilePathSet();
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        String homePath2 = PathManager.getHomePathFor(Application.class);
        if (homePath2 != null) {
            allowed.add(FileUtil.toSystemIndependentName((String)homePath2));
        }
        try {
            URL outUrl = Application.class.getResource("/");
            if (outUrl != null) {
                String output2 = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
                allowed.add(FileUtil.toSystemIndependentName((String)output2));
            }
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            // empty catch block
        }
        try {
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.getJavaHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)new File(FileUtil.getTempDirectory()).getParent()));
            allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
            allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.findInUserHome(".m2")));
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.findInUserHome(".gradle")));
            allowed.add("/etc");
            allowed.add("/private/etc");
            for (Project project : openProjects) {
                if (!project.isInitialized()) {
                    return null;
                }
                for (String url : ProjectRootManager.getInstance((Project)project).getContentRootUrls()) {
                    allowed.add(VfsUtilCore.urlToPath((String)url));
                }
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    String homePath;
                    Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (moduleSdk == null || (homePath = moduleSdk.getHomePath()) == null) continue;
                    allowed.add(homePath);
                }
                for (String url : VfsRootAccess.getAllRootUrls(project)) {
                    allowed.add(StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)url), (String)"!/"));
                }
                String location = project.getBasePath();
                assert (location != null) : project;
                allowed.add(FileUtil.toSystemIndependentName((String)location));
            }
        }
        catch (Error error) {
            // empty catch block
        }
        Project[] projectArray = ourAdditionalRoots;
        synchronized (ourAdditionalRoots) {
            allowed.addAll(ourAdditionalRoots);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return allowed;
        }
    }

    private static String getJavaHome() {
        String javaHomeParent;
        String javaHome = SystemProperties.getJavaHome();
        if (JdkUtil.checkForJre((String)javaHome) && !JdkUtil.checkForJdk((String)javaHome) && JdkUtil.checkForJre((String)(javaHomeParent = PathUtil.getParentPath((String)javaHome))) && JdkUtil.checkForJdk((String)javaHomeParent)) {
            javaHome = javaHomeParent;
        }
        return javaHome;
    }

    private static String findInUserHome(String path) {
        File file2 = new File(SystemProperties.getUserHome(), path);
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e) {
            return file2.getPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getAllRootUrls(Project project) {
        insideGettingRoots = true;
        try {
            Set roots = CollectionFactory.createSmallMemoryFootprintSet();
            OrderEnumerator enumerator = ProjectRootManager.getInstance((Project)project).orderEntries().using((RootModelProvider)new DefaultModulesProvider(project));
            ContainerUtil.addAll((Collection)roots, (Object[])enumerator.classes().getUrls());
            ContainerUtil.addAll((Collection)roots, (Object[])enumerator.sources().getUrls());
            Set set2 = roots;
            return set2;
        }
        finally {
            insideGettingRoots = false;
        }
    }

    @TestOnly
    public static void allowRootAccess(@NotNull Disposable disposable2, String ... roots) {
        if (disposable2 == null) {
            VfsRootAccess.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            VfsRootAccess.$$$reportNull$$$0(3);
        }
        if (roots.length == 0) {
            return;
        }
        VfsRootAccess.doAllow(roots);
        Disposer.register((Disposable)disposable2, () -> VfsRootAccess.disallowRootAccess(roots));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @TestOnly
    public static void allowRootAccess(String ... roots) {
        if (roots == null) {
            VfsRootAccess.$$$reportNull$$$0(4);
        }
        DeprecatedMethodException.report((String)"Use `allowRootAccess(Disposable, String...)` instead");
        VfsRootAccess.doAllow(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAllow(String ... roots) {
        if (roots == null) {
            VfsRootAccess.$$$reportNull$$$0(5);
        }
        Set<String> set2 = ourAdditionalRoots;
        synchronized (set2) {
            for (String root : roots) {
                String path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/');
                if (path.isEmpty()) {
                    throw new IllegalArgumentException("Must not pass empty pat but got: '" + Arrays.toString(roots) + "'");
                }
                ourAdditionalRoots.add(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private static void disallowRootAccess(String ... roots) {
        if (roots == null) {
            VfsRootAccess.$$$reportNull$$$0(6);
        }
        Set<String> set2 = ourAdditionalRoots;
        synchronized (set2) {
            for (String root : roots) {
                ourAdditionalRoots.remove(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/'));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsRootAccess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertAccessInTests";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "allowRootAccess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doAllow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "disallowRootAccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

