/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.util.containers.WeakInterner;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FilePathInterner
extends WeakInterner<CharSequence> {
    @NotNull
    public CharSequence intern(@NotNull CharSequence path) {
        List names2;
        int[] nameIds;
        if (path == null) {
            FilePathInterner.$$$reportNull$$$0(0);
        }
        CharSequence charSequence = (nameIds = (names2 = StringUtil.split((String)path.toString(), (String)"/")).stream().mapToInt(name -> FileNameCache.storeName(name)).toArray()).length == 0 ? "" : (CharSequence)super.intern((Object)new FileSeparatedCharSequence(nameIds));
        if (charSequence == null) {
            FilePathInterner.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FileSeparatedCharSequence
    implements CharSequenceWithStringHash {
        private final int[] nameIds;
        private transient int hash;

        private FileSeparatedCharSequence(int @NotNull [] nameIds) {
            if (nameIds == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(0);
            }
            this.nameIds = nameIds;
        }

        public int length() {
            int length = 0;
            for (int nameId : this.nameIds) {
                CharSequence name = FileNameCache.getVFileName(nameId);
                length += name.length();
            }
            return length + this.nameIds.length - 1;
        }

        public char charAt(int index2) {
            for (int n = 0; n < this.nameIds.length; ++n) {
                int nameId;
                CharSequence name;
                if (n > 0) {
                    if (index2 == 0) {
                        return '/';
                    }
                    --index2;
                }
                if (index2 < (name = FileNameCache.getVFileName(nameId = this.nameIds[n])).length()) {
                    return name.charAt(index2);
                }
                index2 -= name.length();
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int start2, int end) {
            return this.toString().substring(start2, end);
        }

        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder(this.length() + this.nameIds.length - 1);
            for (int n = 0; n < this.nameIds.length; ++n) {
                if (n > 0 || !SystemInfo.isWindows) {
                    b.append('/');
                }
                int nameId = this.nameIds[n];
                CharSequence name = FileNameCache.getVFileName(nameId);
                b.append(name);
            }
            String string = b.toString();
            if (string == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                for (int n = 0; n < this.nameIds.length; ++n) {
                    if (n > 0 || !SystemInfo.isWindows) {
                        h = h * 31 + 47;
                    }
                    int nameId = this.nameIds[n];
                    CharSequence name = FileNameCache.getVFileName(nameId);
                    for (int i2 = 0; i2 < name.length(); ++i2) {
                        char c = name.charAt(i2);
                        h = h * 31 + c;
                    }
                }
                this.hash = h;
                return h;
            }
            return h;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof FileSeparatedCharSequence)) {
                return false;
            }
            FileSeparatedCharSequence other = (FileSeparatedCharSequence)obj2;
            return Arrays.equals(this.nameIds, other.nameIds);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIds";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner$FileSeparatedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner$FileSeparatedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

