/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLRUMap;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class FileNameCache {
    private static final IntSLRUCache<CharSequence>[] ourNameCache = new IntSLRUCache[16];
    private static final String FS_SEPARATORS;
    private static final boolean ourTrackStats = false;
    private static final int ourLOneSize = 1024;
    private static final IntObjectLRUMap.MapEntry<CharSequence>[] ourArrayCache;
    private static final AtomicInteger ourQueries;
    private static final AtomicInteger ourMisses;

    public static int storeName(@NotNull String name) {
        if (name == null) {
            FileNameCache.$$$reportNull$$$0(0);
        }
        FileNameCache.assertShortFileName(name);
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    private static void assertShortFileName(@NotNull String name) {
        if (name == null) {
            FileNameCache.$$$reportNull$$$0(1);
        }
        if (name.length() <= 1) {
            return;
        }
        int start2 = 0;
        if (SystemInfo.isWindows && name.startsWith("//")) {
            int idx = name.indexOf(47, 2);
            int n = start2 = idx == -1 ? 2 : idx + 1;
        }
        if (StringUtil.containsAnyChar((String)name, (String)FS_SEPARATORS, (int)start2, (int)name.length())) {
            throw new IllegalArgumentException("Must not intern long path: '" + name + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static IntObjectLRUMap.MapEntry<CharSequence> cacheData(String name, int id2, int stripe) {
        IntSLRUCache<CharSequence> cache2;
        if (name == null) {
            FSRecords.handleError(new RuntimeException("VFS name enumerator corrupted"));
        }
        CharSequence rawName = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
        IntSLRUCache<CharSequence> intSLRUCache = cache2 = ourNameCache[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLRUMap.MapEntry<CharSequence> mapEntry = cache2.cacheEntry(id2, rawName);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        FileNameCache.$$$reportNull$$$0(2);
        return mapEntry;
    }

    private static int calcStripeIdFromNameId(int id2) {
        int h = id2;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CharSequence getVFileName(int nameId, @NotNull NameComputer computeName) throws IOException {
        IntSLRUCache<CharSequence> cache2;
        if (computeName == null) {
            FileNameCache.$$$reportNull$$$0(3);
        }
        assert (nameId > 0) : nameId;
        int l1 = nameId % 1024;
        IntObjectLRUMap.MapEntry<CharSequence> entry = ourArrayCache[l1];
        if (entry != null && entry.key == nameId) {
            CharSequence charSequence = (CharSequence)entry.value;
            if (charSequence == null) {
                FileNameCache.$$$reportNull$$$0(4);
            }
            return charSequence;
        }
        int stripe = FileNameCache.calcStripeIdFromNameId(nameId);
        IntSLRUCache<CharSequence> intSLRUCache = cache2 = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            entry = cache2.getCachedEntry(nameId);
        }
        if (entry == null) {
            entry = FileNameCache.cacheData(computeName.compute(nameId), nameId, stripe);
        }
        FileNameCache.ourArrayCache[l1] = entry;
        CharSequence charSequence = (CharSequence)entry.value;
        if (charSequence == null) {
            FileNameCache.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getVFileName(int nameId) {
        try {
            return FileNameCache.getVFileName(nameId, FSRecords::getNameByNameId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i2 = 0; i2 < ourNameCache.length; ++i2) {
            FileNameCache.ourNameCache[i2] = new IntSLRUCache(protectedSize, probationalSize);
        }
        FS_SEPARATORS = "/" + (Serializable)(File.separatorChar == '/' ? "" : Character.valueOf(File.separatorChar));
        ourArrayCache = new IntObjectLRUMap.MapEntry[1024];
        ourQueries = new AtomicInteger();
        ourMisses = new AtomicInteger();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FileNameCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FileNameCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "storeName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertShortFileName";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface NameComputer {
        public String compute(int var1) throws IOException;
    }
}

