/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.BitUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChildInfoImpl
extends FileAttributes
implements ChildInfo {
    public static final int UNKNOWN_ID_YET = -238;
    private final int id;
    private final int nameId;
    private final String symLinkTarget;
    private final ChildInfo @Nullable(value="null means children are unknown") [] children;

    public ChildInfoImpl(@NotNull String name, @Nullable FileAttributes attributes, ChildInfo @Nullable [] children2, @Nullable String symLinkTarget) {
        if (name == null) {
            ChildInfoImpl.$$$reportNull$$$0(0);
        }
        this(-238, FileNameCache.storeName(name), attributes, children2, symLinkTarget);
    }

    public ChildInfoImpl(int id2, int nameId, @Nullable FileAttributes attributes, ChildInfo @Nullable [] children2, @Nullable String symLinkTarget) {
        super(attributes == null ? UNKNOWN : attributes);
        this.nameId = nameId;
        this.id = id2;
        this.children = children2;
        this.symLinkTarget = symLinkTarget;
        if (id2 <= 0 && id2 != -238 || nameId <= 0 && nameId != -238) {
            throw new IllegalArgumentException("invalid arguments id: " + id2 + "; nameId: " + nameId);
        }
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public CharSequence getName() {
        CharSequence charSequence = FileNameCache.getVFileName(this.nameId);
        if (charSequence == null) {
            ChildInfoImpl.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getNameId() {
        return this.nameId;
    }

    public String getSymlinkTarget() {
        return this.symLinkTarget;
    }

    public ChildInfo @Nullable [] getChildren() {
        return this.children;
    }

    public FileAttributes getFileAttributes() {
        return this.flags == -1 ? null : this;
    }

    public @PersistentFS.Attributes int getFileAttributeFlags() {
        if (this.flags == -1) {
            return -1;
        }
        FileAttributes.Type type = this.getType();
        boolean isDirectory = type == FileAttributes.Type.DIRECTORY;
        boolean isWritable = !BitUtil.isSet((byte)this.flags, (byte)4);
        boolean isSymLink = BitUtil.isSet((byte)this.flags, (byte)1);
        boolean isSpecial = type == FileAttributes.Type.SPECIAL;
        boolean isHidden = BitUtil.isSet((byte)this.flags, (byte)2);
        FileAttributes.CaseSensitivity sensitivity = this.areChildrenCaseSensitive();
        boolean isCaseSensitive = sensitivity == FileAttributes.CaseSensitivity.SENSITIVE;
        return PersistentFSImpl.fileAttributesToFlags(isDirectory, isWritable, isSymLink, isSpecial, isHidden, sensitivity != FileAttributes.CaseSensitivity.UNKNOWN, isCaseSensitive);
    }

    @NonNls
    public String toString() {
        return (this.nameId > 0 ? this.getName() : "?") + "; nameId: " + this.nameId + "; id: " + this.id + " (" + (this.flags == -1 ? "unknown" : super.toString()) + ")" + (String)(this.children == null ? "" : "\n  " + StringUtil.join((Object[])this.children, info -> info.toString().replaceAll("\n", "\n  "), (String)"\n  "));
    }

    private ChildInfoImpl(int id2, int nameId, String symLinkTarget, ChildInfo @Nullable(value="null means children are unknown") [] children2, byte flags, long length, long lastModified) {
        super(flags, length, lastModified);
        this.id = id2;
        this.nameId = nameId;
        this.symLinkTarget = symLinkTarget;
        this.children = children2;
    }

    @NotNull
    public ChildInfo withChildren(ChildInfo @Nullable [] children2) {
        return new ChildInfoImpl(this.id, this.nameId, this.symLinkTarget, children2, this.flags, this.length, this.lastModified);
    }

    @NotNull
    public ChildInfo withNameId(int nameId) {
        return new ChildInfoImpl(this.id, nameId, this.symLinkTarget, this.children, this.flags, this.length, this.lastModified);
    }

    @NotNull
    public ChildInfo withId(int id2) {
        return new ChildInfoImpl(id2, this.nameId, this.symLinkTarget, this.children, this.flags, this.length, this.lastModified);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChildInfoImpl info = (ChildInfoImpl)((Object)o);
        return this.id == info.id && this.nameId == info.nameId && Objects.equals(this.symLinkTarget, info.symLinkTarget) && Arrays.equals(this.children, info.children);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.nameId, this.symLinkTarget, Arrays.hashCode(this.children));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/ChildInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/ChildInfoImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

