/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.local.SymbolicLinkRefresher;
import com.intellij.openapi.vfs.impl.local.WatchRootsManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.TestOnly;

public class LocalFileSystemImpl
extends LocalFileSystemBase
implements Disposable,
VirtualFilePointerCapableFileSystem {
    private static final int STATUS_UPDATE_PERIOD = 1000;
    private final ManagingFS myManagingFS;
    private final FileWatcher myWatcher;
    private final WatchRootsManager myWatchRootsManager;
    private final Runnable myAfterMarkDirtyCallback;
    private volatile boolean myDisposed;

    public LocalFileSystemImpl() {
        this(null);
    }

    public LocalFileSystemImpl(@Nullable Runnable afterMarkDirtyCallback) {
        this.myAfterMarkDirtyCallback = afterMarkDirtyCallback;
        this.myManagingFS = ManagingFS.getInstance();
        this.myWatcher = new FileWatcher(this.myManagingFS, () -> AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            if (!ApplicationManager.getApplication().isDisposed() && this.storeRefreshStatusToFiles() && this.myAfterMarkDirtyCallback != null) {
                this.myAfterMarkDirtyCallback.run();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS));
        this.myWatchRootsManager = new WatchRootsManager(this.myWatcher, this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
        new SymbolicLinkRefresher(this);
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = this.myWatcher;
        if (fileWatcher == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(0);
        }
        return fileWatcher;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myWatcher.dispose();
    }

    private boolean storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            this.markPathsDirty(dirtyPaths.dirtyPaths);
            this.markFlatDirsDirty(dirtyPaths.dirtyDirectories);
            this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
            return !dirtyPaths.dirtyPaths.isEmpty() || !dirtyPaths.dirtyDirectories.isEmpty() || !dirtyPaths.dirtyPathsRecursive.isEmpty();
        }
        return false;
    }

    private void markPathsDirty(@NotNull Iterable<String> dirtyPaths) {
        if (dirtyPaths == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(1);
        }
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file2 = this.findFileByPathIfCached(dirtyPath);
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markDirty();
        }
    }

    private void markFlatDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        if (dirtyPaths == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(2);
        }
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirty();
                for (VirtualFile child2 : ((NewVirtualFile)pair.first).getCachedChildren()) {
                    ((NewVirtualFile)child2).markDirty();
                }
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    private void markRecursiveDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        if (dirtyPaths == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(3);
        }
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirtyRecursively();
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    public void markSuspiciousFilesDirty(@NotNull List<? extends VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(4);
        }
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String string : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(string);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile virtualFile : files2) {
                if (virtualFile.getFileSystem() != this) continue;
                ((NewVirtualFile)virtualFile).markDirtyRecursively();
            }
        }
    }

    @NotNull
    public @NotNull Iterable<@NotNull VirtualFile> findCachedFilesForPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(5);
        }
        List list2 = ContainerUtil.mapNotNull(this.getAliasedPaths(path), this::findFileByPathIfCached);
        if (list2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private @NotNull List<@NotNull @SystemDependent String> getAliasedPaths(@NotNull String path) {
        if (path == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(7);
        }
        path = FileUtil.toSystemDependentName((String)path);
        ArrayList<@NotNull String> aliases = new ArrayList<String>(this.getFileWatcher().mapToAllSymlinks(path));
        assert (!aliases.contains(path));
        aliases.add(0, path);
        ArrayList<String> arrayList = aliases;
        if (arrayList == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequestsToRemove, @Nullable Collection<String> recursiveRootsToAdd, @Nullable Collection<String> flatRootsToAdd) {
        if (watchRequestsToRemove == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(9);
        }
        if (this.myDisposed) {
            Set<LocalFileSystem.WatchRequest> set2 = Collections.emptySet();
            if (set2 == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(10);
            }
            return set2;
        }
        List nonNullWatchRequestsToRemove = ContainerUtil.skipNulls(watchRequestsToRemove);
        LOG.assertTrue(nonNullWatchRequestsToRemove.size() == watchRequestsToRemove.size(), (Object)"watch requests collection should not contain `null` elements");
        Set<LocalFileSystem.WatchRequest> set3 = this.myWatchRootsManager.replaceWatchedRoots(nonNullWatchRequestsToRemove, (Collection)ObjectUtils.notNull(recursiveRootsToAdd, Collections.emptyList()), (Collection)ObjectUtils.notNull(flatRootsToAdd, Collections.emptyList()));
        if (set3 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(11);
        }
        return set3;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        Runnable heavyRefresh = () -> {
            for (VirtualFile root : this.myManagingFS.getRoots((NewVirtualFileSystem)this)) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
            this.refresh(asynchronous);
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    @ApiStatus.Internal
    public final void symlinkUpdated(int fileId, @Nullable VirtualFile parent, @NotNull CharSequence name, @NotNull String linkPath, @Nullable String linkTarget) {
        if (name == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(12);
        }
        if (linkPath == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(13);
        }
        if (linkTarget == null || !LocalFileSystemImpl.isRecursiveOrCircularSymlink(parent, name, linkTarget)) {
            this.myWatchRootsManager.updateSymlink(fileId, linkPath, linkTarget);
        }
    }

    @ApiStatus.Internal
    public final void symlinkRemoved(int fileId) {
        this.myWatchRootsManager.removeSymlink(fileId);
    }

    @NonNls
    public String toString() {
        return "LocalFileSystem";
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        super.cleanupForNextTest();
        this.myWatchRootsManager.clear();
    }

    private static boolean isRecursiveOrCircularSymlink(@Nullable VirtualFile parent, @NotNull CharSequence name, @NotNull String symlinkTarget) {
        if (name == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(14);
        }
        if (symlinkTarget == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(15);
        }
        if (LocalFileSystemImpl.startsWith(parent, name, symlinkTarget)) {
            return true;
        }
        if (!(parent instanceof VirtualFileSystemEntry)) {
            return false;
        }
        for (VirtualFileSystemEntry p = (VirtualFileSystemEntry)parent; p != null; p = p.getParent()) {
            String parentResolved;
            if (!p.thisOrParentHaveSymlink()) {
                return false;
            }
            if (!p.is(VFileProperty.SYMLINK) || !symlinkTarget.equals(parentResolved = p.getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(@Nullable VirtualFile parent, @NotNull CharSequence name, @NotNull String symlinkTarget) {
        if (name == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(16);
        }
        if (symlinkTarget == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(17);
        }
        if (parent != null) {
            String symlinkTargetParent = StringUtil.trimEnd((String)symlinkTarget, (String)("/" + name));
            return VfsUtilCore.isAncestorOrSelf((String)symlinkTargetParent, (VirtualFile)parent);
        }
        return FileUtil.PATH_CHAR_SEQUENCE_HASHING_STRATEGY.equals((Object)name, (Object)symlinkTarget);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequestsToRemove";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPath";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symlinkTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileWatcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedFilesForPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasedPaths";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "markPathsDirty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markFlatDirsDirty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markRecursiveDirsDirty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markSuspiciousFilesDirty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCachedFilesForPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAliasedPaths";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "symlinkUpdated";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveOrCircularSymlink";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

