/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.ResourceHandle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimedZipHandler
extends ZipHandlerBase {
    private static final Logger LOG = Logger.getInstance(TimedZipHandler.class);
    private static final boolean doTracing = LOG.isTraceEnabled();
    private static final AtomicLong ourOpenTime = new AtomicLong();
    private static final AtomicInteger ourOpenCount = new AtomicInteger();
    private static final AtomicInteger ourCloseCount = new AtomicInteger();
    private static final AtomicLong ourCloseTime = new AtomicLong();
    private static final Map<TimedZipHandler, ScheduledFuture<?>> ourOpenFileLimitGuard;
    private static final ScheduledExecutorService ourScheduledExecutorService;
    private final ZipResourceHandle myHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeOpenZipReferences() {
        Map<TimedZipHandler, ScheduledFuture<?>> map2 = ourOpenFileLimitGuard;
        synchronized (map2) {
            ourOpenFileLimitGuard.keySet().forEach(TimedZipHandler::dispose);
        }
    }

    public TimedZipHandler(@NotNull String path) {
        if (path == null) {
            TimedZipHandler.$$$reportNull$$$0(0);
        }
        super(path);
        this.myHandle = new ZipResourceHandle(((JarFileSystemImpl)JarFileSystem.getInstance()).isMakeCopyOfJar(this.getFile()) ? 2000L : 300000L);
    }

    public void dispose() {
        super.dispose();
        this.myHandle.invalidateZipReference();
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        this.myHandle.attach();
        ZipResourceHandle zipResourceHandle = this.myHandle;
        if (zipResourceHandle == null) {
            TimedZipHandler.$$$reportNull$$$0(1);
        }
        return zipResourceHandle;
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myHandle.getFileStamp();
    }

    static {
        int maxSize2 = 30;
        ourOpenFileLimitGuard = new LinkedHashMap<TimedZipHandler, ScheduledFuture<?>>(30, true){

            protected boolean removeEldestEntry(Map.Entry<TimedZipHandler, ScheduledFuture<?>> eldest, TimedZipHandler key, ScheduledFuture<?> value2) {
                if (this.size() > 30) {
                    key.myHandle.invalidateZipReference(value2);
                    return true;
                }
                return false;
            }
        };
        ourScheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Zip Handle Janitor", (int)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/TimedZipHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/TimedZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ZipResourceHandle
    extends ResourceHandle<ZipFile> {
        private final long myInvalidationTime;
        private ZipFile myFile;
        private long myFileStamp;
        private final ReentrantLock myLock = new ReentrantLock();
        private ScheduledFuture<?> myInvalidationRequest;

        private ZipResourceHandle(long invalidationTime) {
            this.myInvalidationTime = invalidationTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attach() throws IOException {
            Map<TimedZipHandler, ScheduledFuture<?>> map2 = ourOpenFileLimitGuard;
            synchronized (map2) {
                ourOpenFileLimitGuard.remove((Object)TimedZipHandler.this);
            }
            this.myLock.lock();
            try {
                ScheduledFuture<?> invalidationRequest = this.myInvalidationRequest;
                if (invalidationRequest != null) {
                    invalidationRequest.cancel(false);
                    this.myInvalidationRequest = null;
                }
                if (this.myFile == null) {
                    File fileToUse = TimedZipHandler.this.getFile();
                    if (doTracing) {
                        LOG.trace("Opening: " + fileToUse);
                    }
                    long t = doTracing ? System.nanoTime() : 0L;
                    this.myFileStamp = Files.getLastModifiedTime(fileToUse.toPath(), new LinkOption[0]).toMillis();
                    ZipFile file2 = new ZipFile(fileToUse);
                    if (doTracing) {
                        t = System.nanoTime() - t;
                        LOG.trace("Opened in " + TimeUnit.NANOSECONDS.toMillis(t) + "ms, times opened: " + ourOpenCount.incrementAndGet() + ", open time: " + TimeUnit.NANOSECONDS.toMillis(ourOpenTime.addAndGet(t)) + "ms, reference will be cached for " + this.myInvalidationTime + "ms");
                    }
                    this.myFile = file2;
                }
            }
            catch (Throwable e) {
                this.myLock.unlock();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() {
            ScheduledFuture<?> invalidationRequest;
            assert (this.myLock.isLocked());
            try {
                invalidationRequest = ourScheduledExecutorService.schedule(() -> this.invalidateZipReference(), this.myInvalidationTime, TimeUnit.MILLISECONDS);
                this.myInvalidationRequest = invalidationRequest;
            }
            finally {
                this.myLock.unlock();
            }
            Map<TimedZipHandler, ScheduledFuture<?>> map2 = ourOpenFileLimitGuard;
            synchronized (map2) {
                ourOpenFileLimitGuard.put(TimedZipHandler.this, invalidationRequest);
            }
        }

        @NotNull
        public final ZipFile get() {
            assert (this.myLock.isLocked());
            ZipFile zipFile = this.myFile;
            if (zipFile == null) {
                ZipResourceHandle.$$$reportNull$$$0(0);
            }
            return zipFile;
        }

        private void invalidateZipReference() {
            this.invalidateZipReference(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidateZipReference(@Nullable ScheduledFuture<?> expectedInvalidationRequest) {
            this.myLock.lock();
            try {
                if (this.myFile == null) {
                    return;
                }
                if (expectedInvalidationRequest != null) {
                    if (doTracing) {
                        LOG.trace("Invalidation cache size exceeded");
                    }
                    if (this.myInvalidationRequest != expectedInvalidationRequest) {
                        return;
                    }
                }
                this.myInvalidationRequest = null;
                long t = doTracing ? System.nanoTime() : 0L;
                try {
                    this.myFile.close();
                }
                catch (IOException ex) {
                    LOG.info((Throwable)ex);
                }
                if (doTracing) {
                    t = System.nanoTime() - t;
                    LOG.trace("Closed: " + TimedZipHandler.this.getFile() + " in " + TimeUnit.NANOSECONDS.toMillis(t) + "ms, times closed: " + ourCloseCount.incrementAndGet() + ", close time: " + TimeUnit.NANOSECONDS.toMillis(ourCloseTime.addAndGet(t)) + "ms");
                }
                this.myFile = null;
            }
            finally {
                this.myLock.unlock();
            }
        }

        private long getFileStamp() {
            assert (this.myLock.isLocked());
            return this.myFileStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/TimedZipHandler$ZipResourceHandle", "get"));
        }
    }
}

