/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = ConcurrentFactoryMap.createMap(key -> new CoreJarHandler(this, (String)key));

    @NotNull
    public String getProtocol() {
        return "jar";
    }

    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            CoreJarFileSystem.$$$reportNull$$$0(0);
        }
        Couple<String> pair = CoreJarFileSystem.splitPath(path);
        return this.myHandlers.get(pair.first).findFileByPath((String)pair.second);
    }

    @NotNull
    static Couple<String> splitPath(@NotNull String path) {
        int separator;
        if (path == null) {
            CoreJarFileSystem.$$$reportNull$$$0(1);
        }
        if ((separator = path.indexOf("!/")) < 0) {
            throw new IllegalArgumentException("Path in JarFileSystem must contain a separator: " + path);
        }
        String localPath = path.substring(0, separator);
        String pathInJar = path.substring(separator + 2);
        Couple couple = Couple.of((Object)localPath, (Object)pathInJar);
        if (couple == null) {
            CoreJarFileSystem.$$$reportNull$$$0(2);
        }
        return couple;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            CoreJarFileSystem.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(path);
    }

    public void clearHandlersCache() {
        this.myHandlers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

