/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFilePointerImpl
extends TraceableDisposable
implements VirtualFilePointer {
    private static final Logger LOG = Logger.getInstance(VirtualFilePointerImpl.class);
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    volatile FilePartNode myNode;
    private int useCount;
    boolean recursive;
    final VirtualFilePointerListener myListener;

    VirtualFilePointerImpl(@Nullable VirtualFilePointerListener listener2) {
        super(TRACE_CREATION);
        this.myListener = listener2;
    }

    @NotNull
    public String getFileName() {
        FilePartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return "";
        }
        Object result2 = node.myFileOrUrl;
        if (result2 instanceof VirtualFile) {
            String string = ((VirtualFile)result2).getName();
            if (string == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String url = (String)result2;
        int index2 = url.lastIndexOf(47);
        String string = index2 >= 0 ? url.substring(index2 + 1) : url;
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public VirtualFile getFile() {
        FilePartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return null;
        }
        return FilePartNode.myFile(node.myFileOrUrl);
    }

    @NotNull
    public String getUrl() {
        FilePartNode node = this.myNode;
        if (node == null) {
            return "";
        }
        String string = FilePartNode.myUrl(node.myFileOrUrl);
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = PathUtil.toPresentableUrl((String)this.getUrl());
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private FilePartNode checkDisposed(FilePartNode node) {
        if (node == null) {
            ProgressManager.checkCanceled();
            LOG.error("Already disposed: URL='" + this + "'");
        }
        return node;
    }

    public boolean isValid() {
        FilePartNode node = this.myNode;
        return node != null && FilePartNode.myFile(node.myFileOrUrl) != null;
    }

    @NonNls
    public String toString() {
        FilePartNode node = this.myNode;
        return node == null ? "(disposed)" : FilePartNode.myUrl(node.myFileOrUrl);
    }

    public void dispose() {
        boolean shouldKill;
        String url;
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        String string = url = TRACE_CREATION ? this.getUrl() : "?";
        if (pointerManager instanceof VirtualFilePointerManagerImpl) {
            shouldKill = ((VirtualFilePointerManagerImpl)pointerManager).decrementUsageCount(this);
        } else {
            boolean bl = shouldKill = this.incrementUsageCount(-1) == 0;
        }
        if (shouldKill) {
            this.kill("URL when die: " + url);
        }
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    boolean isRecursive() {
        return this.recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

