/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    @NotNull
    private final String myUrl;
    @Nullable
    private volatile VirtualFile myFile;
    private volatile boolean myRefreshed;

    public LightFilePointer(@NotNull String url) {
        if (url == null) {
            LightFilePointer.$$$reportNull$$$0(0);
        }
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightFilePointer.$$$reportNull$$$0(1);
        }
        this.myUrl = file2.getUrl();
        this.myFile = file2;
    }

    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            LightFilePointer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFileName() {
        VirtualFile file2 = this.myFile;
        if (file2 != null) {
            String string = file2.getName();
            if (string == null) {
                LightFilePointer.$$$reportNull$$$0(3);
            }
            return string;
        }
        int index2 = this.myUrl.lastIndexOf(47);
        String string = index2 >= 0 ? this.myUrl.substring(index2 + 1) : this.myUrl;
        if (string == null) {
            LightFilePointer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        VirtualFile file2 = this.getFile();
        if (file2 != null) {
            String string = file2.getPresentableUrl();
            if (string == null) {
                LightFilePointer.$$$reportNull$$$0(5);
            }
            return string;
        }
        return LightFilePointer.toPresentableUrl(this.myUrl);
    }

    @NotNull
    private static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            LightFilePointer.$$$reportNull$$$0(6);
        }
        String path = VirtualFileManager.extractPath((String)url);
        String protocol = VirtualFileManager.extractProtocol((String)url);
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
        String string = ((VirtualFileSystem)ObjectUtils.notNull((Object)fileSystem, (Object)StandardFileSystems.local())).extractPresentableUrl(path);
        if (string == null) {
            LightFilePointer.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        VirtualFile file2 = this.myFile;
        if (file2 != null && file2.isValid()) {
            return;
        }
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        VirtualFile virtualFile = vfManager.findFileByUrl(this.myUrl);
        if (virtualFile == null && !this.myRefreshed) {
            this.myRefreshed = true;
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread() || !application.isReadAccessAllowed()) {
                virtualFile = vfManager.refreshAndFindFileByUrl(this.myUrl);
            } else {
                application.executeOnPooledThread(() -> vfManager.refreshAndFindFileByUrl(this.myUrl));
            }
        }
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/LightFilePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/LightFilePointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

