/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.temp;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFileSystem
extends LocalFileSystemBase
implements VirtualFilePointerCapableFileSystem {
    private static final String TEMP_PROTOCOL = "temp";
    private final FSItem myRoot = new FSDir(null, "/");

    public static TempFileSystem getInstance() {
        return (TempFileSystem)VirtualFileManager.getInstance().getFileSystem(TEMP_PROTOCOL);
    }

    @Override
    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        if (normalizedPath == null) {
            TempFileSystem.$$$reportNull$$$0(0);
        }
        return "/";
    }

    @Override
    @Nullable
    public Path getNioPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    private FSItem convert(VirtualFile file2) {
        VirtualFile parentFile = file2.getParent();
        if (parentFile == null) {
            return this.myRoot;
        }
        FSItem parentItem = this.convert(parentFile);
        if (parentItem == null || !parentItem.isDirectory()) {
            return null;
        }
        return parentItem.findChild(file2.getName());
    }

    private FSDir convertDirectory(VirtualFile parent) {
        FSItem fsItem = this.convert(parent);
        if (fsItem == null) {
            FSRecords.invalidateCaches();
            throw new IllegalStateException("cannot find parent directory: " + parent.getPath());
        }
        assert (fsItem.isDirectory()) : "parent is not a directory: " + parent.getPath();
        return (FSDir)fsItem;
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        FSDir fsDir;
        FSItem existingDir;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            TempFileSystem.$$$reportNull$$$0(3);
        }
        if ((existingDir = (fsDir = this.convertDirectory(parent)).findChild(dir)) == null) {
            fsDir.addChild(new FSDir(fsDir, dir));
        } else if (!existingDir.isDirectory()) {
            throw new IOException("Directory already contains a file named " + dir);
        }
        return new FakeVirtualFile(parent, dir);
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(4);
        }
        if (name == null) {
            TempFileSystem.$$$reportNull$$$0(5);
        }
        FSDir fsDir = this.convertDirectory(parent);
        assert (fsDir.findChild(name) == null) : "File " + name + " already exists in " + parent.getPath();
        fsDir.addChild(new FSFile(fsDir, name));
        return new FakeVirtualFile(parent, name);
    }

    @Nullable
    public VirtualFile findModelChild(@NotNull VirtualFile parent, @NotNull String name) {
        FSItem child2;
        if (parent == null) {
            TempFileSystem.$$$reportNull$$$0(6);
        }
        if (name == null) {
            TempFileSystem.$$$reportNull$$$0(7);
        }
        return (child2 = this.convertDirectory(parent).findChild(name)) == null ? null : new FakeVirtualFile(parent, name);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(8);
        }
        if (newParent == null) {
            TempFileSystem.$$$reportNull$$$0(9);
        }
        if (copyName == null) {
            TempFileSystem.$$$reportNull$$$0(10);
        }
        VirtualFile virtualFile = VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file2, (VirtualFile)newParent, (String)copyName);
        if (virtualFile == null) {
            TempFileSystem.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) {
        FSItem fsItem;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(12);
        }
        if ((fsItem = this.convert(file2)) == null) {
            FSRecords.invalidateCaches();
            throw new IllegalStateException("failed to delete file " + file2.getPath());
        }
        fsItem.getParent().removeChild(fsItem);
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(13);
        }
        if (newParent == null) {
            TempFileSystem.$$$reportNull$$$0(14);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : "failed to move file " + file2.getPath();
        FSItem newParentItem = this.convert(newParent);
        assert (newParentItem != null && newParentItem.isDirectory()) : "failed to find move target " + file2.getPath();
        FSDir newDir = (FSDir)newParentItem;
        if (newDir.findChild(file2.getName()) != null) {
            throw new IOException("Directory already contains a file named " + file2.getName());
        }
        fsItem.getParent().removeChild(fsItem);
        newDir.addChild(fsItem);
        fsItem.myParent = newDir;
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(15);
        }
        if (newName2 == null) {
            TempFileSystem.$$$reportNull$$$0(16);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : file2;
        fsItem.setName(newName2);
    }

    @Override
    @NotNull
    public String getProtocol() {
        return TEMP_PROTOCOL;
    }

    @Override
    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            TempFileSystem.$$$reportNull$$$0(17);
        }
        return this.convert(fileOrDirectory) != null;
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(18);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : file2;
        String[] stringArray = fsItem.list();
        if (stringArray == null) {
            TempFileSystem.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(20);
        }
        String string = file2.getName();
        if (string == null) {
            TempFileSystem.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(22);
        }
        return this.convert(file2) instanceof FSDir;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(23);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : file2;
        return fsItem.myTimestamp;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(24);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : file2;
        fsItem.myTimestamp = timeStamp > 0L ? timeStamp : LocalTimeCounter.currentTime();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(25);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : file2;
        return fsItem.myWritable;
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(26);
        }
        FSItem fsItem = this.convert(file2);
        assert (fsItem != null) : file2;
        fsItem.myWritable = writableFlag;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        FSItem fsItem;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(27);
        }
        if ((fsItem = this.convert(file2)) == null) {
            throw new FileNotFoundException("Cannot find temp for " + file2.getPath());
        }
        assert (fsItem instanceof FSFile) : fsItem;
        if (((FSFile)fsItem).myContent == null) {
            TempFileSystem.$$$reportNull$$$0(28);
        }
        return ((FSFile)fsItem).myContent;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(29);
        }
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(file2));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, Object requestor, final long modStamp, long l) throws IOException {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(30);
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                FSItem fsItem = TempFileSystem.this.convert(file2);
                assert (fsItem instanceof FSFile) : fsItem;
                ((FSFile)fsItem).myContent = this.toByteArray();
                TempFileSystem.this.setTimeStamp(file2, modStamp);
            }
        };
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(31);
        }
        try {
            return this.contentsToByteArray(file2).length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FSItem item;
        if (file2 == null) {
            TempFileSystem.$$$reportNull$$$0(32);
        }
        if ((item = this.convert(file2)) == null) {
            return null;
        }
        long length = item instanceof FSFile ? (long)((FSFile)item).myContent.length : 0L;
        return new FileAttributes(item.isDirectory(), false, false, false, length, item.myTimestamp, item.myWritable, FileAttributes.CaseSensitivity.SENSITIVE);
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            TempFileSystem.$$$reportNull$$$0(33);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    protected String normalize(@NotNull String path) {
        if (path == null) {
            TempFileSystem.$$$reportNull$$$0(34);
        }
        String string = path;
        if (string == null) {
            TempFileSystem.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 28: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 28: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNioPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModelChild";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 28: 
            case 35: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 28: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FSFile
    extends FSItem {
        private byte[] myContent;

        FSFile(@NotNull FSDir parent, @NotNull String name) {
            if (parent == null) {
                FSFile.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FSFile.$$$reportNull$$$0(1);
            }
            super(parent, name);
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FSDir
    extends FSItem {
        private final Map<String, FSItem> myChildren;

        FSDir(@Nullable FSDir parent, @NotNull String name) {
            if (name == null) {
                FSDir.$$$reportNull$$$0(0);
            }
            super(parent, name);
            this.myChildren = new LinkedHashMap<String, FSItem>();
        }

        @Override
        @Nullable
        public FSItem findChild(@NotNull String name) {
            if (name == null) {
                FSDir.$$$reportNull$$$0(1);
            }
            return this.myChildren.get(name);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        void addChild(@NotNull FSItem item) {
            if (item == null) {
                FSDir.$$$reportNull$$$0(2);
            }
            this.myChildren.put(item.myName, item);
        }

        void removeChild(@NotNull FSItem fsItem) {
            if (fsItem == null) {
                FSDir.$$$reportNull$$$0(3);
            }
            if (fsItem.myName.equals("src") && this.getParent() == null) {
                throw new RuntimeException("removing src directory");
            }
            this.myChildren.remove(fsItem.myName);
        }

        @Override
        public String @NotNull [] list() {
            String[] stringArray = ArrayUtilRt.toStringArray(this.myChildren.keySet());
            if (stringArray == null) {
                FSDir.$$$reportNull$$$0(4);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fsItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSDir";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChild";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class FSItem {
        private FSDir myParent;
        private String myName;
        private long myTimestamp;
        private boolean myWritable;

        FSItem(@Nullable FSDir parent, @NotNull String name) {
            if (name == null) {
                FSItem.$$$reportNull$$$0(0);
            }
            this.myParent = parent;
            this.myName = name;
            this.myTimestamp = LocalTimeCounter.currentTime();
            this.myWritable = true;
        }

        public abstract boolean isDirectory();

        @Nullable
        public FSItem findChild(@NotNull String name) {
            if (name == null) {
                FSItem.$$$reportNull$$$0(1);
            }
            return null;
        }

        void setName(@NotNull String name) {
            if (name == null) {
                FSItem.$$$reportNull$$$0(2);
            }
            this.myParent.myChildren.remove(this.myName);
            this.myName = name;
            this.myParent.myChildren.put(name, this);
        }

        public FSDir getParent() {
            return this.myParent;
        }

        public String @NotNull [] list() {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                FSItem.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ex/temp/TempFileSystem$FSItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

