/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.BlocksRefresher;
import com.intellij.openapi.vcs.ex.BulkRangeChangeHandler;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangeChangeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0006\u0010\u0013\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0016\u001a\u00020\tH\u0002J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\u001cJ&\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J.\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u000eJ\u001c\u0010-\u001a\u00020\u00122\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010/\u001a\u00020\u000eR*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker;", "", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "originalChanges", "Lcom/intellij/diff/util/Range;", "(Ljava/util/List;Ljava/util/List;)V", "<set-?>", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "blocks", "getBlocks", "()Ljava/util/List;", "forceMergeNearbyBlocks", "", "isDirty", "()Z", "afterBulkRangeChange", "", "destroy", "onRangeShifted", "before", "after", "onRangesChanged", "partiallyApplyBlocks", "side", "Lcom/intellij/diff/util/Side;", "condition", "Lkotlin/Function1;", "rangeChanged", "startLine", "", "beforeLength", "afterLength", "rangesChanged", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "refreshDirty", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "fastRefresh", "setRanges", "ranges", "dirty", "intellij.platform.diff.impl"})
final class LineTracker {
    @NotNull
    private List<DocumentTracker.Block> blocks;
    private boolean isDirty;
    private boolean forceMergeNearbyBlocks;
    private final List<DocumentTracker.Handler> handlers;

    @NotNull
    public final List<DocumentTracker.Block> getBlocks() {
        return this.blocks;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRanges(@NotNull List<? extends Range> ranges, boolean dirty) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Iterable $this$map$iv = ranges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, dirty, false);
            collection.add(block);
        }
        List newBlocks = (List)destination$iv$iv;
        for (DocumentTracker.Block block : newBlocks) {
            this.onRangesChanged(CollectionsKt.emptyList(), block);
        }
        this.blocks = newBlocks;
        this.isDirty = dirty;
        this.forceMergeNearbyBlocks = false;
        this.afterBulkRangeChange(this.isDirty);
    }

    public final void destroy() {
        this.blocks = CollectionsKt.emptyList();
    }

    public final void refreshDirty(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean fastRefresh) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
        if (!this.isDirty) {
            return;
        }
        BlocksRefresher.Result result2 = new BlocksRefresher(this.handlers, text1, text2, lineOffsets1, lineOffsets2, this.forceMergeNearbyBlocks).refresh(this.blocks, fastRefresh);
        this.blocks = result2.getNewBlocks();
        this.isDirty = false;
        this.forceMergeNearbyBlocks = false;
        this.afterBulkRangeChange(this.isDirty);
    }

    /*
     * WARNING - void declaration
     */
    public final void rangeChanged(@NotNull Side side, int startLine, int beforeLength, int afterLength) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        RangeChangeHandler.Result data2 = new RangeChangeHandler().run(this.blocks, side, startLine, beforeLength, afterLength);
        this.onRangesChanged(data2.getAffectedBlocks(), data2.getNewAffectedBlock());
        int n = 0;
        int n2 = ((Collection)data2.getAfterBlocks()).size();
        while (n < n2) {
            void i2;
            this.onRangeShifted(data2.getAfterBlocks().get((int)i2), data2.getNewAfterBlocks().get((int)i2));
            ++i2;
        }
        this.blocks = data2.getNewBlocks();
        Collection collection = data2.getNewBlocks();
        n2 = 0;
        this.isDirty = !collection.isEmpty();
        this.afterBulkRangeChange(this.isDirty);
    }

    public final void rangesChanged(@NotNull Side side, @NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        List<DocumentTracker.Block> newBlocks = new BulkRangeChangeHandler(this.handlers, this.blocks, side).run(iterable);
        this.blocks = newBlocks;
        Collection collection = newBlocks;
        boolean bl = false;
        this.forceMergeNearbyBlocks = this.isDirty = !collection.isEmpty();
        this.afterBulkRangeChange(this.isDirty);
    }

    @NotNull
    public final List<DocumentTracker.Block> partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super DocumentTracker.Block, Boolean> condition) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        boolean bl = false;
        List newBlocks = new ArrayList();
        boolean bl2 = false;
        List appliedBlocks = new ArrayList();
        int shift = 0;
        for (DocumentTracker.Block block : this.blocks) {
            if (((Boolean)condition.invoke((Object)block)).booleanValue()) {
                appliedBlocks.add(block);
                shift += DocumentTrackerKt.access$getRangeDelta(block.getRange(), side);
                continue;
            }
            DocumentTracker.Block newBlock = DocumentTrackerKt.access$shift(block, side, shift);
            this.onRangeShifted(block, newBlock);
            newBlocks.add(newBlock);
        }
        this.blocks = newBlocks;
        this.afterBulkRangeChange(this.isDirty);
        return appliedBlocks;
    }

    private final void onRangesChanged(List<DocumentTracker.Block> before, DocumentTracker.Block after2) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangesChanged(before, after2);
        }
    }

    private final void onRangeShifted(DocumentTracker.Block before, DocumentTracker.Block after2) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangeShifted(before, after2);
        }
    }

    private final void afterBulkRangeChange(boolean isDirty) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.afterBulkRangeChange(isDirty);
        }
    }

    /*
     * WARNING - void declaration
     */
    public LineTracker(@NotNull List<? extends DocumentTracker.Handler> handlers, @NotNull List<? extends Range> originalChanges) {
        Collection<DocumentTracker.Block> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter(originalChanges, (String)"originalChanges");
        this.handlers = handlers;
        Iterable iterable = originalChanges;
        LineTracker lineTracker = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, false, false);
            collection.add(block);
        }
        collection = (List)destination$iv$iv;
        lineTracker.blocks = collection;
    }
}

