/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.BlocksRefresher;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u0000 ;2\u00020\u0001:\u0003;<=B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ6\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003H\u0002J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003H\u0002J \u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0002J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003H\u0002J?\u0010)\u001a\u00020&2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032'\u0010*\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0\u0003\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020&0+H\u0002J9\u0010/\u001a\u00020&2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032!\u00100\u001a\u001d\u0012\u0013\u0012\u001101\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020&0+H\u0002J\u001c\u00103\u001a\u0002042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u00105\u001a\u00020\fJ\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u00107\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\fH\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u00109\u001a\u0002012\u0006\u00105\u001a\u00020\fH\u0002J\u0018\u0010:\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0002R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006>"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher;", "", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "forceMergeNearbyBlocks", "", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/tools/util/text/LineOffsets;Z)V", "getForceMergeNearbyBlocks", "()Z", "getHandlers", "()Ljava/util/List;", "getLineOffsets1", "()Lcom/intellij/diff/tools/util/text/LineOffsets;", "getLineOffsets2", "getText1", "()Ljava/lang/CharSequence;", "getText2", "calcNonWhitespaceSize", "", "blocks", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "calcSize", "isWhitespaceLine", "text", "lineOffsets", "line", "isWhitespaceOnlySeparated", "block1", "block2", "mergeBlocks", "onRangeRefreshed", "", "before", "after", "processMergeableGroups", "processGroup", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "group", "processMergedBlocks", "processBlock", "Lcom/intellij/openapi/vcs/ex/BlocksRefresher$MergedBlock;", "merged", "refresh", "Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Result;", "fastRefresh", "refreshBlock", "block", "refreshMergedBlock", "mergedBlock", "shouldMergeBlocks", "Companion", "MergedBlock", "Result", "intellij.platform.diff.impl"})
final class BlocksRefresher {
    @NotNull
    private final List<DocumentTracker.Handler> handlers;
    @NotNull
    private final CharSequence text1;
    @NotNull
    private final CharSequence text2;
    @NotNull
    private final LineOffsets lineOffsets1;
    @NotNull
    private final LineOffsets lineOffsets2;
    private final boolean forceMergeNearbyBlocks;
    private static final int NEARBY_BLOCKS_LINES = 30;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Result refresh(@NotNull List<DocumentTracker.Block> blocks, boolean fastRefresh) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        ArrayList newBlocks = new ArrayList();
        this.processMergeableGroups(blocks, (Function1<? super List<DocumentTracker.Block>, Unit>)((Function1)new Function1<List<? extends DocumentTracker.Block>, Unit>(this, fastRefresh, newBlocks){
            final /* synthetic */ BlocksRefresher this$0;
            final /* synthetic */ boolean $fastRefresh;
            final /* synthetic */ ArrayList $newBlocks;

            public final void invoke(@NotNull List<DocumentTracker.Block> group2) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter(group2, (String)"group");
                    Iterable $this$any$iv = group2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                            boolean bl2 = false;
                            if (!it.isDirty$intellij_platform_diff_impl()) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    BlocksRefresher.access$processMergedBlocks(this.this$0, group2, (Function1)new Function1<MergedBlock, Unit>(this){
                        final /* synthetic */ refresh.1 this$0;

                        public final void invoke(@NotNull MergedBlock mergedBlock) {
                            Intrinsics.checkNotNullParameter((Object)mergedBlock, (String)"mergedBlock");
                            List freshBlocks = BlocksRefresher.access$refreshMergedBlock(this.this$0.this$0, mergedBlock, this.this$0.$fastRefresh);
                            BlocksRefresher.access$onRangeRefreshed(this.this$0.this$0, mergedBlock.getMerged(), freshBlocks);
                            this.this$0.$newBlocks.addAll(freshBlocks);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                } else {
                    this.$newBlocks.addAll((Collection)group2);
                }
            }
            {
                this.this$0 = blocksRefresher;
                this.$fastRefresh = bl;
                this.$newBlocks = arrayList;
                super(1);
            }
        }));
        return new Result(newBlocks);
    }

    private final void processMergeableGroups(List<DocumentTracker.Block> blocks, Function1<? super List<DocumentTracker.Block>, Unit> processGroup) {
        int i2;
        if (blocks.isEmpty()) {
            return;
        }
        int blockStart = 0;
        for (i2 = 0; i2 < blocks.size() - 1; ++i2) {
            if (this.shouldMergeBlocks(blocks.get(i2), blocks.get(i2 + 1))) continue;
            processGroup.invoke(blocks.subList(blockStart, i2 + 1));
            blockStart = i2 + 1;
        }
        processGroup.invoke(blocks.subList(blockStart, i2 + 1));
    }

    private final boolean shouldMergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        if (this.forceMergeNearbyBlocks && block2.getRange().start2 - block1.getRange().end2 < 30) {
            return true;
        }
        return this.isWhitespaceOnlySeparated(block1, block2);
    }

    private final boolean isWhitespaceOnlySeparated(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        TextRange textRange = DiffUtil.getLinesRange(this.lineOffsets1, block1.getRange().start1, block1.getRange().end1, false);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"DiffUtil.getLinesRange(l\u2026block1.range.end1, false)");
        TextRange range1 = textRange;
        TextRange textRange2 = DiffUtil.getLinesRange(this.lineOffsets1, block2.getRange().start1, block2.getRange().end1, false);
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"DiffUtil.getLinesRange(l\u2026block2.range.end1, false)");
        TextRange range2 = textRange2;
        int start2 = range1.getEndOffset();
        int end = range2.getStartOffset();
        return TrimUtil.trimStart(this.text1, start2, end) == end;
    }

    private final void processMergedBlocks(List<DocumentTracker.Block> group2, Function1<? super MergedBlock, Unit> processBlock) {
        boolean bl = !group2.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DocumentTracker.Block merged = null;
        bl3 = false;
        List original = new ArrayList();
        for (DocumentTracker.Block block : group2) {
            boolean bl5;
            if (merged == null) {
                merged = block;
                Collection collection = original;
                boolean bl6 = false;
                collection.add(block);
                continue;
            }
            DocumentTracker.Block newMerged = this.mergeBlocks(merged, block);
            if (newMerged != null) {
                merged = newMerged;
                Collection collection = original;
                bl5 = false;
                collection.add(block);
                continue;
            }
            processBlock.invoke((Object)new MergedBlock(merged, CollectionsKt.toList((Iterable)original)));
            original.clear();
            merged = block;
            Collection collection = original;
            bl5 = false;
            collection.add(merged);
        }
        DocumentTracker.Block block = merged;
        Intrinsics.checkNotNull((Object)block);
        processBlock.invoke((Object)new MergedBlock(block, CollectionsKt.toList((Iterable)original)));
    }

    private final DocumentTracker.Block mergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        boolean isDirty = block1.isDirty$intellij_platform_diff_impl() || block2.isDirty$intellij_platform_diff_impl();
        boolean isTooBig = block1.isTooBig$intellij_platform_diff_impl() || block2.isTooBig$intellij_platform_diff_impl();
        Range range2 = new Range(block1.getRange().start1, block2.getRange().end1, block1.getRange().start2, block2.getRange().end2);
        DocumentTracker.Block merged = new DocumentTracker.Block(range2, isDirty, isTooBig);
        for (DocumentTracker.Handler handler2 : this.handlers) {
            boolean success2 = handler2.mergeRanges(block1, block2, merged);
            if (success2) continue;
            return null;
        }
        return merged;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentTracker.Block> refreshMergedBlock(MergedBlock mergedBlock, boolean fastRefresh) {
        int newTotalSize;
        int newSize;
        void $this$flatMapTo$iv$iv;
        List<DocumentTracker.Block> freshBlocks = this.refreshBlock(mergedBlock.getMerged(), fastRefresh);
        if (mergedBlock.getOriginal().size() == 1) {
            return freshBlocks;
        }
        if (!this.forceMergeNearbyBlocks) {
            return freshBlocks;
        }
        Iterable $this$flatMap$iv = mergedBlock.getOriginal();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DocumentTracker.Block block = (DocumentTracker.Block)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = block.isDirty$intellij_platform_diff_impl() ? this.refreshBlock(block, fastRefresh) : CollectionsKt.listOf((Object)block);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List nonMergedFreshBlocks = (List)destination$iv$iv;
        int oldSize = this.calcNonWhitespaceSize(this.text1, this.text2, this.lineOffsets1, this.lineOffsets2, nonMergedFreshBlocks);
        if (oldSize < (newSize = this.calcNonWhitespaceSize(this.text1, this.text2, this.lineOffsets1, this.lineOffsets2, freshBlocks))) {
            return nonMergedFreshBlocks;
        }
        if (oldSize > newSize) {
            return freshBlocks;
        }
        int oldTotalSize = this.calcSize(nonMergedFreshBlocks);
        if (oldTotalSize <= (newTotalSize = this.calcSize(freshBlocks))) {
            return nonMergedFreshBlocks;
        }
        return freshBlocks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocumentTracker.Block> refreshBlock(DocumentTracker.Block block, boolean fastRefresh) {
        void $this$mapTo$iv$iv;
        if (block.getRange().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        FairDiffIterable iterable = null;
        boolean isTooBig = false;
        if (block.isTooBig$intellij_platform_diff_impl() && fastRefresh) {
            iterable = RangesBuilder.fastCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
            isTooBig = true;
        } else {
            FairDiffIterable realIterable = RangesBuilder.tryCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
            if (realIterable != null) {
                iterable = realIterable;
                isTooBig = false;
            } else {
                iterable = RangesBuilder.fastCompareLines(block.getRange(), this.text1, this.text2, this.lineOffsets1, this.lineOffsets2);
                isTooBig = true;
            }
        }
        Iterable<Range> iterable2 = iterable.iterateChanges();
        Intrinsics.checkNotNullExpressionValue(iterable2, (String)"iterable.iterateChanges()");
        Iterable<Range> $this$map$iv = iterable2;
        boolean $i$f$map = false;
        Iterable<Range> iterable3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            DocumentTracker.Block block2 = new DocumentTracker.Block(DocumentTrackerKt.access$shiftRange((Range)v1, block.getRange().start1, block.getRange().start2), false, isTooBig);
            collection.add(block2);
        }
        return (List)destination$iv$iv;
    }

    private final int calcSize(List<DocumentTracker.Block> blocks) {
        int result2 = 0;
        for (DocumentTracker.Block block : blocks) {
            result2 += block.getRange().end1 - block.getRange().start1;
            result2 += block.getRange().end2 - block.getRange().start2;
        }
        return result2;
    }

    private final int calcNonWhitespaceSize(CharSequence text1, CharSequence text2, LineOffsets lineOffsets1, LineOffsets lineOffsets2, List<DocumentTracker.Block> blocks) {
        int result2 = 0;
        for (DocumentTracker.Block block : blocks) {
            int line;
            int n = block.getRange().start1;
            int n2 = block.getRange().end1;
            while (n < n2) {
                if (!this.isWhitespaceLine(text1, lineOffsets1, line)) {
                    ++result2;
                }
                ++line;
            }
            n2 = block.getRange().end2;
            for (line = block.getRange().start2; line < n2; ++line) {
                if (this.isWhitespaceLine(text2, lineOffsets2, line)) continue;
                ++result2;
            }
        }
        return result2;
    }

    private final boolean isWhitespaceLine(CharSequence text2, LineOffsets lineOffsets, int line) {
        int end;
        int start2 = lineOffsets.getLineStart(line);
        return TrimUtil.trimStart(text2, start2, end = lineOffsets.getLineEnd(line)) == end;
    }

    private final void onRangeRefreshed(DocumentTracker.Block before, List<DocumentTracker.Block> after2) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangeRefreshed(before, after2);
        }
    }

    @NotNull
    public final List<DocumentTracker.Handler> getHandlers() {
        return this.handlers;
    }

    @NotNull
    public final CharSequence getText1() {
        return this.text1;
    }

    @NotNull
    public final CharSequence getText2() {
        return this.text2;
    }

    @NotNull
    public final LineOffsets getLineOffsets1() {
        return this.lineOffsets1;
    }

    @NotNull
    public final LineOffsets getLineOffsets2() {
        return this.lineOffsets2;
    }

    public final boolean getForceMergeNearbyBlocks() {
        return this.forceMergeNearbyBlocks;
    }

    public BlocksRefresher(@NotNull List<? extends DocumentTracker.Handler> handlers, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean forceMergeNearbyBlocks) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
        this.handlers = handlers;
        this.text1 = text1;
        this.text2 = text2;
        this.lineOffsets1 = lineOffsets1;
        this.lineOffsets2 = lineOffsets2;
        this.forceMergeNearbyBlocks = forceMergeNearbyBlocks;
    }

    public static final /* synthetic */ void access$processMergedBlocks(BlocksRefresher $this, List group2, Function1 processBlock) {
        $this.processMergedBlocks(group2, (Function1<? super MergedBlock, Unit>)processBlock);
    }

    public static final /* synthetic */ List access$refreshMergedBlock(BlocksRefresher $this, MergedBlock mergedBlock, boolean fastRefresh) {
        return $this.refreshMergedBlock(mergedBlock, fastRefresh);
    }

    public static final /* synthetic */ void access$onRangeRefreshed(BlocksRefresher $this, DocumentTracker.Block before, List after2) {
        $this.onRangeRefreshed(before, after2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Result;", "", "newBlocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "(Ljava/util/List;)V", "getNewBlocks", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class Result {
        @NotNull
        private final List<DocumentTracker.Block> newBlocks;

        @NotNull
        public final List<DocumentTracker.Block> getNewBlocks() {
            return this.newBlocks;
        }

        public Result(@NotNull List<DocumentTracker.Block> newBlocks) {
            Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
            this.newBlocks = newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component1() {
            return this.newBlocks;
        }

        @NotNull
        public final Result copy(@NotNull List<DocumentTracker.Block> newBlocks) {
            Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
            return new Result(newBlocks);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = result2.newBlocks;
            }
            return result2.copy(list2);
        }

        @NotNull
        public String toString() {
            return "Result(newBlocks=" + this.newBlocks + ")";
        }

        public int hashCode() {
            List<DocumentTracker.Block> list2 = this.newBlocks;
            return list2 != null ? ((Object)list2).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual(this.newBlocks, result2.newBlocks)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$MergedBlock;", "", "merged", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "original", "", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "getMerged", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getOriginal", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class MergedBlock {
        @NotNull
        private final DocumentTracker.Block merged;
        @NotNull
        private final List<DocumentTracker.Block> original;

        @NotNull
        public final DocumentTracker.Block getMerged() {
            return this.merged;
        }

        @NotNull
        public final List<DocumentTracker.Block> getOriginal() {
            return this.original;
        }

        public MergedBlock(@NotNull DocumentTracker.Block merged, @NotNull List<DocumentTracker.Block> original) {
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            Intrinsics.checkNotNullParameter(original, (String)"original");
            this.merged = merged;
            this.original = original;
        }

        @NotNull
        public final DocumentTracker.Block component1() {
            return this.merged;
        }

        @NotNull
        public final List<DocumentTracker.Block> component2() {
            return this.original;
        }

        @NotNull
        public final MergedBlock copy(@NotNull DocumentTracker.Block merged, @NotNull List<DocumentTracker.Block> original) {
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            Intrinsics.checkNotNullParameter(original, (String)"original");
            return new MergedBlock(merged, original);
        }

        public static /* synthetic */ MergedBlock copy$default(MergedBlock mergedBlock, DocumentTracker.Block block, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                block = mergedBlock.merged;
            }
            if ((n & 2) != 0) {
                list2 = mergedBlock.original;
            }
            return mergedBlock.copy(block, list2);
        }

        @NotNull
        public String toString() {
            return "MergedBlock(merged=" + this.merged + ", original=" + this.original + ")";
        }

        public int hashCode() {
            DocumentTracker.Block block = this.merged;
            List<DocumentTracker.Block> list2 = this.original;
            return (block != null ? block.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MergedBlock)) break block3;
                    MergedBlock mergedBlock = (MergedBlock)object;
                    if (!Intrinsics.areEqual((Object)this.merged, (Object)mergedBlock.merged) || !Intrinsics.areEqual(this.original, mergedBlock.original)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/ex/BlocksRefresher$Companion;", "", "()V", "NEARBY_BLOCKS_LINES", "", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

