/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.ExperimentalFeatureRegistryValueWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryUi
implements Disposable {
    private static final String RECENT_PROPERTIES_KEY = "RegistryRecentKeys";
    private final JBTable myTable;
    private final JTextArea myDescriptionLabel;
    private final JPanel myContent = new JPanel();
    private static final Icon RESTART_ICON = PlatformIcons.CHECK_ICON;
    private final RestoreDefaultsAction myRestoreDefaultsAction;
    private final MyTableModel myModel;
    private final Map<String, String> myModifiedValuesRequiringRestart = new HashMap<String, String>();
    private static final Map<Color, Icon> icons_cache = new HashMap<Color, Icon>();

    public RegistryUi() {
        this.myContent.setLayout(new BorderLayout(10, 4));
        this.myModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.setShowGrid(false);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setEnableAntialiasing(true);
        MyRenderer r = new MyRenderer();
        TableColumn c0 = this.myTable.getColumnModel().getColumn(0);
        c0.setCellRenderer(r);
        c0.setMaxWidth(RESTART_ICON.getIconWidth() + 12);
        c0.setMinWidth(RESTART_ICON.getIconWidth() + 12);
        c0.setHeaderValue(null);
        TableColumn c1 = this.myTable.getColumnModel().getColumn(1);
        c1.setCellRenderer(r);
        c1.setHeaderValue("Key");
        TableColumn c2 = this.myTable.getColumnModel().getColumn(2);
        c2.setCellRenderer(r);
        c2.setHeaderValue("Value");
        c2.setCellEditor(new MyEditor());
        this.myDescriptionLabel = new JTextArea(3, 50);
        this.myDescriptionLabel.setMargin((Insets)JBUI.insets((int)2));
        this.myDescriptionLabel.setWrapStyleWord(true);
        this.myDescriptionLabel.setLineWrap(true);
        this.myDescriptionLabel.setEditable(false);
        JScrollPane label2 = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionLabel);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)label2, "Center");
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)LangBundle.message((String)"label.export.plugin.description", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myContent.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable), "Center");
        this.myContent.add((Component)descriptionPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int viewRow = RegistryUi.this.myTable.getSelectedRow();
                if (viewRow != -1) {
                    int modelRow = RegistryUi.this.myTable.convertRowIndexToModel(viewRow);
                    RegistryValue value2 = RegistryUi.this.myModel.getRegistryValue(modelRow);
                    String description = value2.getDescription();
                    if (value2.isRestartRequired()) {
                        RegistryUi.this.myDescriptionLabel.setText(description + "\n" + IdeBundle.message((String)"registry.key.requires.ide.restart.note", (Object[])new Object[0]));
                    } else {
                        RegistryUi.this.myDescriptionLabel.setText(description);
                    }
                } else {
                    RegistryUi.this.myDescriptionLabel.setText(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/registry/RegistryUi$1", "valueChanged"));
            }
        });
        this.myRestoreDefaultsAction = new RestoreDefaultsAction();
        DefaultActionGroup tbGroup = new DefaultActionGroup();
        tbGroup.add((AnAction)new EditAction());
        tbGroup.add((AnAction)new RevertAction());
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("Registry", (ActionGroup)tbGroup, true);
        tb.setTargetComponent((JComponent)this.myTable);
        this.myContent.add((Component)tb.getComponent(), "North");
        final TableSpeedSearch search2 = new TableSpeedSearch((JTable)this.myTable);
        search2.setComparator(new SpeedSearchComparator(false));
        search2.setFilteringMode(true);
        this.myTable.setRowSorter(new TableRowSorter<TableModel>(this.myTable.getModel()));
        this.myTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                int modelRow;
                RegistryValue rv;
                int row;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getKeyCode() == 32 && (row = RegistryUi.this.myTable.getSelectedRow()) != -1 && (rv = RegistryUi.this.myModel.getRegistryValue(modelRow = RegistryUi.this.myTable.convertRowIndexToModel(row))).isBoolean()) {
                    RegistryUi.this.setValue(rv, !rv.asBoolean());
                    RegistryUi.keyChanged(rv.getKey());
                    for (int i2 : new int[]{0, 1, 2}) {
                        RegistryUi.this.myModel.fireTableCellUpdated(row, i2);
                    }
                    RegistryUi.this.invalidateActions();
                    if (search2.isPopupActive()) {
                        search2.hidePopup();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/registry/RegistryUi$2", "keyPressed"));
            }
        });
    }

    private void startEditingAtSelection() {
        this.myTable.editCellAt(this.myTable.getSelectedRow(), 2);
        if (this.myTable.isEditing()) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myTable.getEditorComponent(), true));
        }
    }

    private static List<String> getRecent() {
        String value2 = PropertiesComponent.getInstance().getValue(RECENT_PROPERTIES_KEY);
        return StringUtil.isEmpty((String)value2) ? new ArrayList(0) : StringUtil.split((String)value2, (String)"=");
    }

    private static void keyChanged(String key) {
        List<String> recent = RegistryUi.getRecent();
        recent.remove(key);
        recent.add(0, key);
        PropertiesComponent.getInstance().setValue(RECENT_PROPERTIES_KEY, StringUtil.join(recent, (String)"="), "");
    }

    public boolean show() {
        DialogWrapper dialog2 = new DialogWrapper(true){
            private AbstractAction myCloseAction;
            {
                this.setTitle(LangBundle.message((String)"dialog.title.registry", (Object[])new Object[0]));
                this.setModal(true);
                this.init();
                RegistryUi.this.invalidateActions();
            }

            @Nullable
            protected JComponent createNorthPanel() {
                if (ApplicationManager.getApplication().isInternal()) {
                    return null;
                }
                String warning = new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"b").addText(IdeBundle.message((String)"registry.change.warning", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}))).wrapWithHtmlBody().toString();
                JLabel warningLabel = new JLabel(warning);
                warningLabel.setIcon(UIUtil.getWarningIcon());
                warningLabel.setForeground((Color)JBColor.RED);
                return warningLabel;
            }

            protected JComponent createCenterPanel() {
                return RegistryUi.this.myContent;
            }

            protected void dispose() {
                super.dispose();
                Disposer.dispose((Disposable)RegistryUi.this);
            }

            protected String getDimensionServiceKey() {
                return "Registry";
            }

            public JComponent getPreferredFocusedComponent() {
                return RegistryUi.this.myTable;
            }

            protected Action @NotNull [] createActions() {
                Action[] actionArray = new Action[]{RegistryUi.this.myRestoreDefaultsAction, this.myCloseAction};
                if (actionArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionArray;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myCloseAction = new AbstractAction(IdeBundle.message((String)"registry.close.action.text", (Object[])new Object[0])){

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RegistryUi.this.processClose();
                        this.doOKAction();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/registry/RegistryUi$3$1", "actionPerformed"));
                    }
                };
                this.myCloseAction.putValue("DefaultAction", true);
            }

            public void doCancelAction() {
                TableCellEditor cellEditor = RegistryUi.this.myTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                RegistryUi.this.processClose();
                super.doCancelAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/RegistryUi$3", "createActions"));
            }
        };
        return dialog2.showAndGet();
    }

    private void processClose() {
        if (!this.myModifiedValuesRequiringRestart.isEmpty()) {
            RegistryBooleanOptionDescriptor.suggestRestart(this.myContent);
        }
    }

    private void setValue(@NotNull RegistryValue registryValue, boolean value2) {
        if (registryValue == null) {
            RegistryUi.$$$reportNull$$$0(0);
        }
        this.setValue(registryValue, Boolean.toString(value2));
    }

    private void setValue(@NotNull RegistryValue registryValue, @NotNull String value2) {
        boolean required;
        if (registryValue == null) {
            RegistryUi.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            RegistryUi.$$$reportNull$$$0(2);
        }
        if (required = registryValue.isRestartRequired()) {
            String key = registryValue.getKey();
            if (!this.myModifiedValuesRequiringRestart.containsKey(key)) {
                this.myModifiedValuesRequiringRestart.put(key, registryValue.asString());
            } else if (value2.equals(this.myModifiedValuesRequiringRestart.get(key))) {
                this.myModifiedValuesRequiringRestart.remove(key);
            }
        }
        registryValue.setValue(value2);
    }

    private void restoreDefaults() {
        String message2 = LangBundle.message((String)"dialog.message.are.you.sure.you.want.to.revert.registry.settings.to.default.values", (Object[])new Object[0]);
        int r = Messages.showYesNoDialog((Component)this.myContent, (String)message2, (String)LangBundle.message((String)"dialog.title.revert.to.defaults", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            Registry.getInstance().restoreDefaults();
            this.myModel.fireChanged();
            this.invalidateActions();
        }
    }

    private void invalidateActions() {
        this.myRestoreDefaultsAction.setEnabled(!Registry.getInstance().isInDefaultState());
    }

    public void dispose() {
    }

    private static String[] getOptions(@NotNull RegistryValue value2) {
        if (value2 == null) {
            RegistryUi.$$$reportNull$$$0(3);
        }
        String[] options2 = value2.getOptions();
        for (int i2 = 0; i2 < options2.length; ++i2) {
            options2[i2] = Strings.trimEnd((String)options2[i2], (String)"*");
        }
        return options2;
    }

    private static Icon createColoredIcon(Color color) {
        Icon icon2 = icons_cache.get(color);
        if (icon2 != null) {
            return icon2;
        }
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(16, 16, 3);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 16, 16);
        g.dispose();
        icon2 = new ImageIcon(image);
        icons_cache.put(color, icon2);
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/registry/RegistryUi";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RestoreDefaultsAction
    extends AbstractAction {
        RestoreDefaultsAction() {
            super(IdeBundle.message((String)"registry.restore.defaults.action.text", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                RestoreDefaultsAction.$$$reportNull$$$0(0);
            }
            RegistryUi.this.restoreDefaults();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/registry/RegistryUi$RestoreDefaultsAction", "actionPerformed"));
        }
    }

    private class MyEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JTextField myField = new JTextField();
        private final JCheckBox myCheckBox = new JCheckBox();
        private ComboBox<String> myComboBox;
        private RegistryValue myValue;

        private MyEditor() {
        }

        @Override
        @Nullable
        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            int modelRow = table.convertRowIndexToModel(row);
            this.myValue = ((MyTableModel)table.getModel()).getRegistryValue(modelRow);
            if (this.myValue.asColor(null) != null) {
                Color color = ColorChooser.chooseColor((Component)table, (String)IdeBundle.message((String)"dialog.title.choose.color", (Object[])new Object[0]), (Color)this.myValue.asColor(Color.WHITE));
                if (color != null) {
                    RegistryUi.this.setValue(this.myValue, color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                    RegistryUi.keyChanged(this.myValue.getKey());
                }
                return null;
            }
            if (this.myValue.isBoolean()) {
                this.myCheckBox.setSelected(this.myValue.asBoolean());
                this.myCheckBox.setBackground(table.getBackground());
                return this.myCheckBox;
            }
            if (this.myValue.isMultiValue()) {
                this.myComboBox = new ComboBox((Object[])RegistryUi.getOptions(this.myValue));
                this.myComboBox.setSelectedItem((Object)this.myValue.getSelectedOption());
                return this.myComboBox;
            }
            this.myField.setText(this.myValue.asString());
            this.myField.setBorder(null);
            this.myField.selectAll();
            return this.myField;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.myValue != null) {
                if (this.myValue.isBoolean()) {
                    RegistryUi.this.setValue(this.myValue, this.myCheckBox.isSelected());
                } else if (this.myValue.isMultiValue()) {
                    String selected2 = (String)this.myComboBox.getSelectedItem();
                    this.myValue.setSelectedOption(selected2);
                } else {
                    RegistryUi.this.setValue(this.myValue, this.myField.getText().trim());
                }
                RegistryUi.keyChanged(this.myValue.getKey());
            }
            RegistryUi.this.invalidateActions();
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final SimpleColoredComponent myComponent = new SimpleColoredComponent();

        private MyRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Color bg;
            if (table == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            int modelRow = table.convertRowIndexToModel(row);
            RegistryValue v = ((MyTableModel)table.getModel()).getRegistryValue(modelRow);
            Color color = bg = isSelected ? table.getSelectionBackground() : table.getBackground();
            if (v != null) {
                switch (column) {
                    case 0: {
                        this.myLabel.setText(null);
                        if (v.isRestartRequired()) {
                            this.myLabel.setIcon(RESTART_ICON);
                            this.myLabel.setToolTipText(IdeBundle.message((String)"registry.key.requires.ide.restart.note", (Object[])new Object[0]));
                        } else {
                            this.myLabel.setIcon(null);
                            this.myLabel.setToolTipText(null);
                        }
                        this.myLabel.setHorizontalAlignment(0);
                        break;
                    }
                    case 1: {
                        this.myComponent.clear();
                        this.myComponent.append(v.getKey(), MyRenderer.getAttributes(v, isSelected));
                        this.myComponent.setBackground(bg);
                        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this.myComponent, (boolean)true, (boolean)hasFocus);
                        SimpleColoredComponent simpleColoredComponent = this.myComponent;
                        if (simpleColoredComponent == null) {
                            MyRenderer.$$$reportNull$$$0(1);
                        }
                        return simpleColoredComponent;
                    }
                    case 2: {
                        if (v.asColor(null) != null) {
                            this.myLabel.setText(null);
                            this.myLabel.setToolTipText(v.asString());
                            this.myLabel.setIcon(RegistryUi.createColoredIcon(v.asColor(null)));
                            this.myLabel.setHorizontalAlignment(2);
                            break;
                        }
                        if (v.isBoolean()) {
                            JCheckBox box2 = new JCheckBox();
                            box2.setSelected(v.asBoolean());
                            box2.setBackground(bg);
                            JCheckBox jCheckBox = box2;
                            if (jCheckBox == null) {
                                MyRenderer.$$$reportNull$$$0(2);
                            }
                            return jCheckBox;
                        }
                        if (v.isMultiValue()) {
                            Object[] options2 = RegistryUi.getOptions(v);
                            ComboBox combo = new ComboBox(options2);
                            combo.setSelectedItem((Object)v.getSelectedOption());
                            ComboBox comboBox2 = combo;
                            if (comboBox2 == null) {
                                MyRenderer.$$$reportNull$$$0(3);
                            }
                            return comboBox2;
                        }
                        this.myComponent.clear();
                        this.myComponent.setBackground(bg);
                        this.myComponent.append(v.asString(), MyRenderer.getAttributes(v, isSelected));
                        if (v.isChangedFromDefault()) {
                            this.myComponent.append(" [" + Registry.getInstance().getBundleValue(v.getKey(), false) + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this.myComponent, (boolean)true, (boolean)hasFocus);
                        SimpleColoredComponent simpleColoredComponent = this.myComponent;
                        if (simpleColoredComponent == null) {
                            MyRenderer.$$$reportNull$$$0(4);
                        }
                        return simpleColoredComponent;
                    }
                }
                this.myLabel.setOpaque(true);
                this.myLabel.setBackground(bg);
            }
            JLabel jLabel = this.myLabel;
            if (jLabel == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            return jLabel;
        }

        @NotNull
        private static SimpleTextAttributes getAttributes(RegistryValue value2, boolean isSelected) {
            boolean changedFromDefault = value2.isChangedFromDefault();
            if (isSelected) {
                return new SimpleTextAttributes(changedFromDefault ? 1 : 0, UIUtil.getListSelectionForeground((boolean)true));
            }
            if (changedFromDefault) {
                return new SimpleTextAttributes(1, (Color)JBColor.blue);
            }
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyRenderer.$$$reportNull$$$0(6);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/registry/RegistryUi$MyRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/registry/RegistryUi$MyRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableCellRendererComponent";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyTableModel
    extends AbstractTableModel {
        private final List<RegistryValue> myAll = Registry.getAll();

        private MyTableModel() {
            this.myAll.addAll(ContainerUtil.map((Collection)Experiments.EP_NAME.getExtensionList(), ExperimentalFeatureRegistryValueWrapper::new));
            List<String> recent = RegistryUi.getRecent();
            this.myAll.sort((o1, o2) -> {
                boolean c2;
                String key1 = o1.getKey();
                boolean changed1 = o1.isChangedFromDefault();
                boolean changed2 = o2.isChangedFromDefault();
                if (changed1 && !changed2) {
                    return -1;
                }
                if (!changed1 && changed2) {
                    return 1;
                }
                String key2 = o2.getKey();
                int i1 = recent.indexOf(key1);
                int i2 = recent.indexOf(key2);
                boolean c1 = i1 != -1;
                boolean bl = c2 = i2 != -1;
                if (c1 && !c2) {
                    return -1;
                }
                if (!c1 && c2) {
                    return 1;
                }
                if (c1) {
                    return i1 - i2;
                }
                return key1.compareToIgnoreCase(key2);
            });
        }

        public void fireChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myAll.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RegistryValue value2 = this.getRegistryValue(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return value2.getKey();
                }
                case 2: {
                    return value2.asString();
                }
            }
            return value2;
        }

        private RegistryValue getRegistryValue(int rowIndex) {
            return this.myAll.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }

    private final class EditAction
    extends AnAction {
        private EditAction() {
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("EditSource"), (JComponent)RegistryUi.this.myTable, (Disposable)RegistryUi.this);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!RegistryUi.this.myTable.isEditing() && RegistryUi.this.myTable.getSelectedRow() >= 0);
            e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.RegistryUi.text.edit", (Object[])new Object[0]));
            e.getPresentation().setIcon(AllIcons.Actions.EditSource);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditAction.$$$reportNull$$$0(1);
            }
            RegistryUi.this.startEditingAtSelection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/util/registry/RegistryUi$EditAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RevertAction
    extends AnAction {
        private RevertAction() {
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("EditorDelete"), (JComponent)RegistryUi.this.myTable, (Disposable)RegistryUi.this);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RevertAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!RegistryUi.this.myTable.isEditing() && RegistryUi.this.myTable.getSelectedRow() >= 0);
            e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.RegistryUi.text", (Object[])new Object[0]));
            e.getPresentation().setIcon(AllIcons.General.Reset);
            if (e.getPresentation().isEnabled()) {
                RegistryValue rv = RegistryUi.this.myModel.getRegistryValue(RegistryUi.this.myTable.convertRowIndexToModel(RegistryUi.this.myTable.getSelectedRow()));
                e.getPresentation().setEnabled(rv.isChangedFromDefault());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RevertAction.$$$reportNull$$$0(1);
            }
            RegistryValue rv = RegistryUi.this.myModel.getRegistryValue(RegistryUi.this.myTable.convertRowIndexToModel(RegistryUi.this.myTable.getSelectedRow()));
            rv.resetToDefault();
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 0);
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 1);
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 2);
            RegistryUi.this.invalidateActions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/util/registry/RegistryUi$RevertAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

