/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryExtensionCollectorKt;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0017R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/util/registry/RegistryKeyBean;", "Lcom/intellij/openapi/extensions/PluginAware;", "()V", "defaultValue", "", "description", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "key", "restartRequired", "", "setPluginDescriptor", "", "pluginDescriptor", "Companion", "intellij.platform.ide.impl"})
public final class RegistryKeyBean
implements PluginAware {
    @Attribute(value="key")
    @RequiredElement
    @JvmField
    @NotNull
    public final String key;
    @Attribute(value="description")
    @RequiredElement
    @JvmField
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public final String description;
    @Attribute(value="defaultValue")
    @RequiredElement(allowEmpty=true)
    @JvmField
    @NotNull
    public final String defaultValue;
    @Attribute(value="restartRequired")
    @JvmField
    public final boolean restartRequired;
    @Transient
    private PluginDescriptor descriptor;
    private static final HashSet<String> pendingRemovalKeys;
    @NotNull
    public static final Companion Companion;

    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        this.descriptor = pluginDescriptor;
    }

    public RegistryKeyBean() {
        this.key = "";
        this.description = "";
        this.defaultValue = "";
    }

    static {
        Companion = new Companion(null);
        pendingRemovalKeys = new HashSet();
    }

    public static final /* synthetic */ HashSet access$getPendingRemovalKeys$cp() {
        return pendingRemovalKeys;
    }

    public static final /* synthetic */ void access$setDescriptor$p(RegistryKeyBean $this, PluginDescriptor pluginDescriptor) {
        $this.descriptor = pluginDescriptor;
    }

    @JvmStatic
    public static final void addKeysFromPlugins() {
        Companion.addKeysFromPlugins();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/util/registry/RegistryKeyBean$Companion;", "", "()V", "pendingRemovalKeys", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "addKeysFromPlugins", "", "createRegistryKeyDescriptor", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "extension", "Lcom/intellij/openapi/util/registry/RegistryKeyBean;", "intellij.platform.ide.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void addKeysFromPlugins() {
            void $this$mapTo$iv$iv;
            Iterable iterable = RegistryExtensionCollectorKt.access$getEP_NAME$p().getIterable();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"EP_NAME.iterable");
            Iterable $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RegistryKeyBean registryKeyBean = (RegistryKeyBean)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                RegistryKeyDescriptor registryKeyDescriptor = Companion.createRegistryKeyDescriptor((RegistryKeyBean)v1);
                collection.add(registryKeyDescriptor);
            }
            Registry.addKeys((List)((List)destination$iv$iv));
            RegistryExtensionCollectorKt.access$getEP_NAME$p().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RegistryKeyBean>(){

                public void extensionAdded(@NotNull RegistryKeyBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    Registry.addKeys((List)CollectionsKt.listOf((Object)com.intellij.openapi.util.registry.RegistryKeyBean$Companion.access$createRegistryKeyDescriptor(RegistryKeyBean.Companion, extension2)));
                }
            }, null);
            RegistryExtensionCollectorKt.access$getEP_NAME$p().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RegistryKeyBean>(){

                public void extensionRemoved(@NotNull RegistryKeyBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    RegistryKeyBean.access$getPendingRemovalKeys$cp().add(extension2.key);
                }
            }, null);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            application.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    for (String pendingRemovalKey : RegistryKeyBean.access$getPendingRemovalKeys$cp()) {
                        Registry.removeKey((String)pendingRemovalKey);
                    }
                    RegistryKeyBean.access$getPendingRemovalKeys$cp().clear();
                }
            });
        }

        private final RegistryKeyDescriptor createRegistryKeyDescriptor(RegistryKeyBean extension2) {
            PluginDescriptor pluginDescriptor = extension2.descriptor;
            String pluginId = pluginDescriptor != null && (pluginDescriptor = pluginDescriptor.getPluginId()) != null ? pluginDescriptor.getIdString() : null;
            CharSequence charSequence = extension2.description;
            Regex regex = RegistryExtensionCollectorKt.access$getCONSECUTIVE_SPACES_REGEX$p();
            String string = " ";
            boolean bl = false;
            return new RegistryKeyDescriptor(extension2.key, StringUtil.unescapeStringCharacters((String)regex.replace(charSequence, string)), extension2.defaultValue, extension2.restartRequired, pluginId);
        }

        private Companion() {
        }

        public static final /* synthetic */ RegistryKeyDescriptor access$createRegistryKeyDescriptor(Companion $this, RegistryKeyBean extension2) {
            return $this.createRegistryKeyDescriptor(extension2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

