/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

final class PluginsAdvertiserStartupActivity
implements StartupActivity.Background {
    private final AtomicBoolean listRefreshed = new AtomicBoolean();

    PluginsAdvertiserStartupActivity() {
    }

    public void runActivity(@NotNull Project project) {
        Application app;
        if (project == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() || app.isHeadlessEnvironment() || !UpdateSettings.getInstance().isPluginsCheckNeeded()) {
            return;
        }
        if (this.listRefreshed.compareAndSet(false, true)) {
            try {
                PluginsAdvertiser.ensureDeleted();
            }
            catch (IOException ignore) {
                this.listRefreshed.set(false);
            }
        }
        try {
            ((PluginAdvertiserService)app.getService(PluginAdvertiserService.class)).run(project);
        }
        catch (UnknownHostException e) {
            PluginsAdvertiser.LOG.warn("Host name could not be resolved: " + e.getMessage());
        }
        catch (Exception e) {
            PluginsAdvertiser.LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserStartupActivity", "runActivity"));
    }
}

