/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.ui.TableUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginsAdvertiserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiserDialog.class);
    @Nullable
    private final Project myProject;
    private final PluginDownloader[] myToInstallPlugins;
    private final List<? extends IdeaPluginDescriptor> myCustomPlugins;
    private final Set<PluginId> mySkippedPlugins = new HashSet<PluginId>();
    private final PluginManagerMain.PluginEnabler.HEADLESS pluginHelper = new PluginManagerMain.PluginEnabler.HEADLESS();
    @NotNull
    private Function<? super Boolean, Void> myFinishFunction;

    PluginsAdvertiserDialog(@Nullable Project project, PluginDownloader[] plugins2, List<? extends IdeaPluginDescriptor> customPlugins) {
        super(project);
        this.myProject = project;
        Arrays.sort(plugins2, (o1, o2) -> o1.getPluginName().compareToIgnoreCase(o2.getPluginName()));
        this.myToInstallPlugins = plugins2;
        this.myCustomPlugins = customPlugins;
        this.setTitle(IdeBundle.message((String)"dialog.title.choose.plugins.to.install.or.enable", (Object[])new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DetectedPluginsPanel foundPluginsPanel = new DetectedPluginsPanel(){

            @Override
            protected Set<PluginId> getSkippedPlugins() {
                return PluginsAdvertiserDialog.this.mySkippedPlugins;
            }
        };
        for (PluginDownloader uploadedPlugin : this.myToInstallPlugins) {
            foundPluginsPanel.add(uploadedPlugin);
        }
        TableUtil.ensureSelectionExists((JTable)foundPluginsPanel.getEntryTable());
        DetectedPluginsPanel detectedPluginsPanel = foundPluginsPanel;
        if (detectedPluginsPanel == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(0);
        }
        return detectedPluginsPanel;
    }

    protected void doOKAction() {
        if (this.doInstallPlugins()) {
            super.doOKAction();
        }
    }

    public void setFinishFunction(@NotNull Function<? super Boolean, Void> finishFunction) {
        if (finishFunction == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(1);
        }
        this.myFinishFunction = finishFunction;
    }

    public boolean doInstallPlugins() {
        HashSet<IdeaPluginDescriptor> pluginsToEnable = new HashSet<IdeaPluginDescriptor>();
        ArrayList<PluginNode> nodes = new ArrayList<PluginNode>();
        for (PluginDownloader downloader : this.myToInstallPlugins) {
            IdeaPluginDescriptor plugin2 = downloader.getDescriptor();
            if (this.mySkippedPlugins.contains(plugin2.getPluginId())) continue;
            pluginsToEnable.add(plugin2);
            if (!plugin2.isEnabled()) continue;
            nodes.add(PluginDownloader.createPluginNode(null, downloader));
        }
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(nodes)) {
            return false;
        }
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(this.pluginHelper, nodes);
        Runnable notifyRunnable = () -> {
            if (nodes.stream().anyMatch(o -> PluginManagerCore.getPlugin(o.getPluginId()) == null)) {
                PluginManagerMain.notifyPluginsUpdated(this.myProject);
            }
        };
        DisabledPluginsState.enablePlugins(pluginsToEnable, true);
        if (!nodes.isEmpty()) {
            try {
                PluginManagerMain.downloadPlugins(nodes, this.myCustomPlugins, true, notifyRunnable, (PluginManagerMain.PluginEnabler)this.pluginHelper, this.myFinishFunction);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else if (!pluginsToEnable.isEmpty()) {
            notifyRunnable.run();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFinishFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

