/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurableService;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginsAdvertiser {
    static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);
    private static final String CASHED_EXTENSIONS = "extensions.xml";
    public static final String IGNORE_ULTIMATE_EDITION = "ignoreUltimateEdition";
    @Deprecated
    public static final NotificationGroup NOTIFICATION_GROUP = PluginsAdvertiser.getNotificationGroup();
    public static final String FUS_GROUP_ID = "plugins.advertiser";
    private static SoftReference<KnownExtensions> ourKnownExtensions = new SoftReference(null);
    private static boolean extensionsHaveBeenUpdated = false;

    @NotNull
    public static List<Plugin> retrieve(@NotNull UnknownFeature unknownFeature) {
        if (unknownFeature == null) {
            PluginsAdvertiser.$$$reportNull$$$0(0);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("featureType", unknownFeature.getFeatureType());
        params.put("implementationName", unknownFeature.getImplementationName());
        params.put("build", MarketplaceRequests.getInstance().getBuildForPluginRepositoryRequests());
        List<FeatureImpl> features = MarketplaceRequests.getInstance().getFeatures(params);
        List list2 = ContainerUtil.map(features, feature -> new Plugin(feature.getPluginId() != null ? StringUtil.unquoteString((String)feature.getPluginId()) : null, feature.getPluginName() != null ? StringUtil.unquoteString((String)feature.getPluginName()) : null, feature.getBundled()));
        if (list2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Plugins Suggestion");
        if (notificationGroup == null) {
            PluginsAdvertiser.$$$reportNull$$$0(2);
        }
        return notificationGroup;
    }

    static void loadAllExtensions(Set<String> customPluginIds) throws IOException {
        Map<String, String> params = Collections.singletonMap("featureType", FileTypeFactory.FILE_TYPE_FACTORY_EP.getName());
        List<FeatureImpl> features = MarketplaceRequests.getInstance().getFeatures(params);
        Map<String, Set<Plugin>> setExtensions = features.stream().collect(Collectors.groupingBy(FeatureImpl::getImplementationName, Collectors.mapping(feature -> new Plugin(feature.getPluginId() != null ? StringUtil.unquoteString((String)feature.getPluginId()) : null, feature.getPluginName() != null ? StringUtil.unquoteString((String)feature.getPluginName()) : null, feature.getBundled(), customPluginIds.contains(feature.getPluginId())), Collectors.toSet())));
        PluginsAdvertiser.saveExtensions(setExtensions);
    }

    static void ensureDeleted() throws IOException {
        FileUtil.delete((Path)PluginsAdvertiser.getExtensionsFile());
    }

    @Nullable
    public static KnownExtensions loadExtensions() {
        if (!extensionsHaveBeenUpdated) {
            return null;
        }
        KnownExtensions knownExtensions = (KnownExtensions)ourKnownExtensions.get();
        if (knownExtensions != null) {
            return knownExtensions;
        }
        try {
            Path file2 = PluginsAdvertiser.getExtensionsFile();
            if (Files.isRegularFile(file2, new LinkOption[0])) {
                knownExtensions = (KnownExtensions)XmlSerializer.deserialize((Element)JDOMUtil.load((Path)file2), KnownExtensions.class);
                ourKnownExtensions = new SoftReference((Object)knownExtensions);
                return knownExtensions;
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @NotNull
    private static Path getExtensionsFile() {
        Path path = Path.of(PathManager.getPluginsPath(), CASHED_EXTENSIONS);
        if (path == null) {
            PluginsAdvertiser.$$$reportNull$$$0(3);
        }
        return path;
    }

    static void saveExtensions(Map<String, Set<Plugin>> extensions2) throws IOException {
        Path plugins2 = PluginsAdvertiser.getExtensionsFile();
        if (!Files.exists(plugins2, new LinkOption[0])) {
            FileUtil.ensureCanCreateFile((File)plugins2.toFile());
        }
        JDOMUtil.write((Element)XmlSerializer.serialize((Object)new KnownExtensions(extensions2)), (Path)plugins2);
        extensionsHaveBeenUpdated = true;
    }

    public static void openDownloadPage() {
        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl("https://www.jetbrains.com/idea/download/"));
    }

    static void enablePlugins(Project project, Collection<PluginId> disabledPlugins) {
        PluginManagerConfigurableService.getInstance().showPluginConfigurableAndEnable(project, disabledPlugins.toArray(PluginId.EMPTY_ARRAY));
    }

    @Nullable
    static List<String> hasBundledPluginToInstall(Collection<Plugin> plugins2) {
        if (PlatformUtils.isIdeaUltimate()) {
            return null;
        }
        ArrayList<String> bundled = new ArrayList<String>();
        for (Plugin plugin2 : plugins2) {
            if (!plugin2.myBundled || PluginManagerCore.getPlugin(PluginId.getId((String)plugin2.myPluginId)) != null) continue;
            bundled.add(plugin2.myPluginName != null ? plugin2.myPluginName : plugin2.myPluginId);
        }
        return bundled.isEmpty() ? null : bundled;
    }

    @Deprecated
    public static void installAndEnablePlugins(@NotNull Set<String> pluginIds2, @NotNull Runnable onSuccess2) {
        if (pluginIds2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(4);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(5);
        }
        PluginsAdvertiser.installAndEnable(new LinkedHashSet<PluginId>(ContainerUtil.map(pluginIds2, it -> PluginId.getId((String)it))), onSuccess2);
    }

    public static void installAndEnable(@NotNull Set<PluginId> pluginIds2, @NotNull Runnable onSuccess2) {
        if (pluginIds2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(6);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(7);
        }
        PluginsAdvertiser.installAndEnable(null, pluginIds2, true, onSuccess2);
    }

    public static void installAndEnable(@Nullable Project project, final @NotNull Set<PluginId> pluginIds2, final boolean showDialog, final @NotNull Runnable onSuccess2) {
        if (pluginIds2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(8);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(9);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true){
            private final Set<PluginDownloader> myPlugins;
            private List<IdeaPluginDescriptor> myRepositoryPlugins;
            private List<IdeaPluginDescriptor> myCustomPlugins;
            {
                super(arg0, arg1, arg2);
                this.myPlugins = new HashSet<PluginDownloader>();
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    @NotNull List ids = ContainerUtil.map((Collection)pluginIds2, id2 -> id2.getIdString());
                    List<PluginNode> marketplacePlugins2 = MarketplaceRequests.getInstance().loadLastCompatiblePluginDescriptors(ids);
                    this.myCustomPlugins = RepositoryHelper.loadPluginsFromCustomRepositories(indicator);
                    this.myRepositoryPlugins = UpdateChecker.mergePluginsFromRepositories(marketplacePlugins2, this.myCustomPlugins, true);
                    for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                        if (descriptor2.isEnabled() || !pluginIds2.contains(descriptor2.getPluginId()) || !PluginManagerCore.isCompatible(descriptor2)) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(descriptor2));
                    }
                    for (IdeaPluginDescriptor loadedPlugin : this.myRepositoryPlugins) {
                        if (!pluginIds2.contains(loadedPlugin.getPluginId())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                    }
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }

            public void onSuccess() {
                if (this.myRepositoryPlugins == null) {
                    return;
                }
                PluginsAdvertiserDialog advertiserDialog = new PluginsAdvertiserDialog(null, this.myPlugins.toArray(new PluginDownloader[0]), this.myCustomPlugins);
                advertiserDialog.setFinishFunction(result2 -> {
                    if (result2.booleanValue()) {
                        onSuccess2.run();
                    }
                    return null;
                });
                if (showDialog) {
                    advertiserDialog.showAndGet();
                } else {
                    advertiserDialog.doInstallPlugins();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$1", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownFeature";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieve";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installAndEnablePlugins";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installAndEnable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="plugin")
    public static final class Plugin
    implements Comparable<Plugin> {
        public String myPluginId;
        public String myPluginName;
        public boolean myBundled;
        public boolean myFromCustomRepository;

        public Plugin(String pluginId, String pluginName, boolean bundled) {
            this.myPluginId = pluginId;
            this.myBundled = bundled;
            this.myPluginName = pluginName;
        }

        public Plugin(String pluginId, String pluginName, boolean bundled, boolean isFromCustomRepository) {
            this.myPluginId = pluginId;
            this.myPluginName = pluginName;
            this.myBundled = bundled;
            this.myFromCustomRepository = isFromCustomRepository;
        }

        public Plugin() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugin plugin2 = (Plugin)o;
            if (this.myBundled != plugin2.myBundled) {
                return false;
            }
            if (!this.myPluginId.equals(plugin2.myPluginId)) {
                return false;
            }
            return this.myPluginName == null || this.myPluginName.equals(plugin2.myPluginName);
        }

        public int hashCode() {
            int result2 = this.myPluginId.hashCode();
            result2 = 31 * result2 + (this.myBundled ? 1 : 0);
            result2 = 31 * result2 + (this.myPluginName != null ? this.myPluginName.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(@NotNull Plugin other) {
            if (other == null) {
                Plugin.$$$reportNull$$$0(0);
            }
            if (this.myBundled && !other.myBundled) {
                return -1;
            }
            if (!this.myBundled && other.myBundled) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)this.myPluginId), (Comparable)((Object)other.myPluginId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$Plugin", "compareTo"));
        }
    }

    @Tag(value="plugins")
    public static final class PluginSet {
        public final Set<Plugin> myPlugins = new HashSet<Plugin>();

        public PluginSet() {
        }

        public PluginSet(Set<Plugin> plugins2) {
            this.myPlugins.addAll(plugins2);
        }
    }

    @Tag(value="exts")
    public static final class KnownExtensions {
        @OptionTag
        @XMap
        public final Map<String, PluginSet> myExtensions;

        public KnownExtensions() {
            this.myExtensions = new HashMap<String, PluginSet>();
        }

        public KnownExtensions(@NotNull Map<String, Set<Plugin>> extensions2) {
            if (extensions2 == null) {
                KnownExtensions.$$$reportNull$$$0(0);
            }
            this.myExtensions = new HashMap<String, PluginSet>();
            for (String ext : extensions2.keySet()) {
                this.myExtensions.put(ext, new PluginSet(extensions2.get(ext)));
            }
        }

        @Nullable
        public Set<Plugin> find(@NotNull String extension2) {
            PluginSet pluginSet;
            if (extension2 == null) {
                KnownExtensions.$$$reportNull$$$0(1);
            }
            return (pluginSet = this.myExtensions.get(extension2)) == null ? null : pluginSet.myPlugins;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$KnownExtensions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

