/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsData;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsState;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsStateService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\tH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\tR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsState;", "", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsStateService;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsStateService;)V", "enabledExtensionOrFileNames", "", "", "addEnabledExtensionOrFileNameAndInvalidateCache", "", "extensionOrFileName", "createUnknownExtensionFeature", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeature;", "getCachedData", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsData;", "ignoreExtensionOrFileNameAndInvalidateCache", "invalidateCacheDataForKey", "isIgnored", "", "requestData", "knownExtensions", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$KnownExtensions;", "requestExtensionData", "fileName", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "fullExtension", "updateCache", "Companion", "intellij.platform.ide.impl"})
public final class PluginAdvertiserExtensionsState {
    private final Set<String> enabledExtensionOrFileNames;
    private final Project project;
    private final PluginAdvertiserExtensionsStateService service;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void ignoreExtensionOrFileNameAndInvalidateCache(@NotNull String extensionOrFileName) {
        Intrinsics.checkNotNullParameter((Object)extensionOrFileName, (String)"extensionOrFileName");
        UnknownFeaturesCollector.getInstance(this.project).ignoreFeature(this.createUnknownExtensionFeature(extensionOrFileName));
        this.invalidateCacheDataForKey(extensionOrFileName);
    }

    public final void addEnabledExtensionOrFileNameAndInvalidateCache(@NotNull String extensionOrFileName) {
        Intrinsics.checkNotNullParameter((Object)extensionOrFileName, (String)"extensionOrFileName");
        this.enabledExtensionOrFileNames.add(extensionOrFileName);
        this.invalidateCacheDataForKey(extensionOrFileName);
    }

    private final PluginAdvertiserExtensionsData getCachedData(String extensionOrFileName) {
        Optional optional = (Optional)this.service.getCache$intellij_platform_ide_impl().getIfPresent((Object)extensionOrFileName);
        return optional != null ? (PluginAdvertiserExtensionsData)optional.orElse(null) : null;
    }

    public final boolean updateCache(@NotNull String extensionOrFileName) {
        Intrinsics.checkNotNullParameter((Object)extensionOrFileName, (String)"extensionOrFileName");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        LOG.assertTrue(!application.isReadAccessAllowed());
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        LOG.assertTrue(!application2.isDispatchThread());
        if (this.service.getCache$intellij_platform_ide_impl().getIfPresent((Object)extensionOrFileName) != null) {
            return false;
        }
        PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
        if (knownExtensions == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)knownExtensions, (String)"PluginsAdvertiser.loadExtensions() ?: return false");
        PluginsAdvertiser.KnownExtensions knownExtensions2 = knownExtensions;
        PluginAdvertiserExtensionsData newData = this.requestData(extensionOrFileName, knownExtensions2);
        this.service.getCache$intellij_platform_ide_impl().put((Object)extensionOrFileName, Optional.ofNullable(newData));
        return true;
    }

    private final void invalidateCacheDataForKey(String extensionOrFileName) {
        this.service.getCache$intellij_platform_ide_impl().invalidate((Object)extensionOrFileName);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PluginAdvertiserExtensionsData requestExtensionData(@NotNull String fileName, @NotNull FileType fileType, @Nullable String fullExtension) {
        block11: {
            Object object;
            block13: {
                block12: {
                    boolean alreadySupported;
                    Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                    Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
                    boolean bl = alreadySupported = !(fileType instanceof PlainTextLikeFileType);
                    if (fullExtension != null && this.isIgnored(fullExtension)) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "Extension '%s' is ignored in project '%s'";
                        Object[] objectArray = new Object[]{fullExtension, this.project.getName()};
                        boolean bl2 = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        LOG.debug(string2);
                        return null;
                    }
                    if (this.isIgnored(fileName)) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "File '%s' is ignored in project '%s'";
                        Object[] objectArray = new Object[]{fileName, this.project.getName()};
                        boolean bl3 = false;
                        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                        LOG.debug(string3);
                        return null;
                    }
                    if (fullExtension == null && fileType instanceof FakeFileType) {
                        return null;
                    }
                    PluginAdvertiserExtensionsData pluginAdvertiserExtensionsData = this.service.getLocalPlugin(fileName, fullExtension);
                    if (pluginAdvertiserExtensionsData != null) {
                        PluginAdvertiserExtensionsData pluginAdvertiserExtensionsData2 = pluginAdvertiserExtensionsData;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        PluginAdvertiserExtensionsData it = pluginAdvertiserExtensionsData2;
                        boolean bl6 = false;
                        return it;
                    }
                    PluginsAdvertiser.KnownExtensions knownExtensions = PluginsAdvertiser.loadExtensions();
                    if (knownExtensions == null) break block11;
                    if (alreadySupported) {
                        Object $i$f$map22;
                        Set<PluginsAdvertiser.Plugin> availablePlugins = knownExtensions.find(fileName);
                        if (availablePlugins != null) {
                            StringCompanionObject $this$mapTo$iv$iv;
                            Iterable $this$map$iv = availablePlugins;
                            boolean $i$f$map22 = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                PluginsAdvertiser.Plugin plugin2 = (PluginsAdvertiser.Plugin)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl7 = false;
                                String string = it.myPluginId;
                                collection.add(string);
                            }
                            Set plugins2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            $i$f$map22 = PluginManagerCore.getLoadedPlugins().iterator();
                            while ($i$f$map22.hasNext()) {
                                IdeaPluginDescriptor loadedPlugin;
                                IdeaPluginDescriptor ideaPluginDescriptor = loadedPlugin = (IdeaPluginDescriptor)$i$f$map22.next();
                                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"loadedPlugin");
                                if (!ideaPluginDescriptor.isEnabled()) continue;
                                PluginId pluginId = loadedPlugin.getPluginId();
                                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"loadedPlugin.pluginId");
                                if (!plugins2.contains(pluginId.getIdString())) continue;
                                $this$mapTo$iv$iv = StringCompanionObject.INSTANCE;
                                String string = "File '%s' (type: '%s') is already supported by fileName via '%s'(id: '%s') plugin";
                                Object[] objectArray = new Object[4];
                                objectArray[0] = fileName;
                                objectArray[1] = fileType;
                                objectArray[2] = loadedPlugin.getName();
                                PluginId pluginId2 = loadedPlugin.getPluginId();
                                Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"loadedPlugin.pluginId");
                                objectArray[3] = pluginId2.getIdString();
                                Object[] objectArray2 = objectArray;
                                boolean bl8 = false;
                                String string4 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                                LOG.debug(string4);
                                return null;
                            }
                        }
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "File '%s' (type: '%s') is already supported therefore looking only for plugins exactly matching fileName";
                        $i$f$map22 = new Object[]{fileName, fileType};
                        boolean $this$mapTo$iv$iv = false;
                        String string5 = String.format(string, Arrays.copyOf($i$f$map22, ((Object[])$i$f$map22).length));
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                        LOG.debug(string5);
                        return this.getCachedData(fileName);
                    }
                    object = fullExtension;
                    if (object == null) break block12;
                    String string = object;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    String it = string;
                    boolean bl11 = false;
                    object = this.getCachedData(it);
                    if (object != null) break block13;
                }
                object = this.getCachedData(fileName);
            }
            return object;
        }
        LOG.debug("No known extensions loaded");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final PluginAdvertiserExtensionsData requestData(String extensionOrFileName, PluginsAdvertiser.KnownExtensions knownExtensions) {
        IdeCompatibleUpdate it;
        Object object;
        Comparable<PluginsAdvertiser.Plugin> comparable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        HashSet allPlugins;
        Set<PluginsAdvertiser.Plugin> set2 = knownExtensions.find(extensionOrFileName);
        HashSet hashSet = allPlugins = set2 != null ? CollectionsKt.toHashSet((Iterable)set2) : null;
        if (allPlugins == null || allPlugins.isEmpty()) {
            LOG.debug("No features for extension " + extensionOrFileName);
            return null;
        }
        Iterable iterable = allPlugins;
        Object object2 = MarketplaceRequests.Companion.getInstance();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            comparable = (PluginsAdvertiser.Plugin)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = ((PluginsAdvertiser.Plugin)((Object)it)).myPluginId;
            object.add(string);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = ((MarketplaceRequests)object2).getLastCompatiblePluginUpdate((List<String>)object, null);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeCompatibleUpdate)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getPluginId();
            object2.add(object);
        }
        Set pluginIdsFromMarketplace = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        HashSet compatiblePlugins2 = SequencesKt.toHashSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allPlugins), (Function1)((Function1)new Function1<PluginsAdvertiser.Plugin, Boolean>(pluginIdsFromMarketplace){
            final /* synthetic */ Set $pluginIdsFromMarketplace;

            public final boolean invoke(PluginsAdvertiser.Plugin it) {
                return it.myFromCustomRepository || it.myBundled || this.$pluginIdsFromMarketplace.contains(it.myPluginId);
            }
            {
                this.$pluginIdsFromMarketplace = set2;
                super(1);
            }
        })));
        if (compatiblePlugins2.isEmpty()) {
            LOG.debug("No plugins for extension " + extensionOrFileName);
            return null;
        }
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object item$iv$iv;
            object2 = $this$debug$iv;
            boolean bl = false;
            item$iv$iv = compatiblePlugins2;
            comparable = new StringBuilder().append("Found following plugins for '").append(extensionOrFileName).append("': ");
            boolean $i$f$map2 = false;
            void var14_20 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                PluginsAdvertiser.Plugin plugin2 = (PluginsAdvertiser.Plugin)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = it2.myPluginId;
                collection.add(string);
            }
            collection = (List)destination$iv$iv2;
            object = ((StringBuilder)comparable).append(CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, (Function1)requestData.1.2.INSTANCE, (int)31, null)).toString();
            object2.debug((String)object, (Throwable)e$iv);
        }
        return new PluginAdvertiserExtensionsData(extensionOrFileName, compatiblePlugins2);
    }

    private final boolean isIgnored(String extensionOrFileName) {
        return this.enabledExtensionOrFileNames.contains(extensionOrFileName) || UnknownFeaturesCollector.getInstance(this.project).isIgnored(this.createUnknownExtensionFeature(extensionOrFileName));
    }

    private final UnknownFeature createUnknownExtensionFeature(String extensionOrFileName) {
        ExtensionPointName extensionPointName = FileTypeFactory.FILE_TYPE_FACTORY_EP;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"FileTypeFactory.FILE_TYPE_FACTORY_EP");
        return new UnknownFeature(extensionPointName.getName(), "File Type", extensionOrFileName, extensionOrFileName);
    }

    public PluginAdvertiserExtensionsState(@NotNull Project project, @NotNull PluginAdvertiserExtensionsStateService service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)service), (String)"service");
        this.project = project;
        this.service = service;
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
        this.enabledExtensionOrFileNames = set2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PluginsAdvertiser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final PluginAdvertiserExtensionsState getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsState;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PluginAdvertiserExtensionsState getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new PluginAdvertiserExtensionsState(project, PluginAdvertiserExtensionsStateService.Companion.getInstance());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

