/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdateStrategyKt;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001 B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy;", "", "currentBuild", "Lcom/intellij/openapi/util/BuildNumber;", "updates", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;)V", "product", "Lcom/intellij/openapi/updateSettings/impl/Product;", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/Product;Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;)V", "customization", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "kotlin.jvm.PlatformType", "checkForUpdates", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "compareBuilds", "", "n1", "n2", "isApplicable", "", "candidate", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "ignoredBuilds", "", "", "patches", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "newBuild", "from", "State", "intellij.platform.ide.impl"})
public final class UpdateStrategy {
    private final UpdateStrategyCustomization customization;
    private final BuildNumber currentBuild;
    private final Product product;
    private final UpdateSettings settings;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckForUpdateResult checkForUpdates() {
        void $this$sortedBy$iv;
        Pair result2;
        if (this.product == null || this.product.getChannels().isEmpty()) {
            return new CheckForUpdateResult(State.NOTHING_LOADED, null);
        }
        ChannelStatus channelStatus = this.settings.getSelectedChannelStatus();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)channelStatus), (String)"settings.selectedChannelStatus");
        ChannelStatus selectedChannel = channelStatus;
        List<String> list2 = this.settings.getIgnoredBuildNumbers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"settings.ignoredBuildNumbers");
        Set ignoredBuilds = CollectionsKt.toSet((Iterable)list2);
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.product.getChannels()), (Function1)((Function1)new Function1<UpdateChannel, Boolean>(selectedChannel){
            final /* synthetic */ ChannelStatus $selectedChannel;

            public final boolean invoke(@NotNull UpdateChannel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                return ch.getStatus().compareTo((Enum)this.$selectedChannel) >= 0;
            }
            {
                this.$selectedChannel = channelStatus;
                super(1);
            }
        }));
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Pair pair = result2 = (Pair)SequencesKt.maxWithOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                UpdateChannel ch = (UpdateChannel)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)ch.getStatus());
                ch = (UpdateChannel)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                ChannelStatus channelStatus = ch.getStatus();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)channelStatus)));
            }
        }), (Function1)checkForUpdates.result.3.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends BuildInfo, ? extends UpdateChannel>, Boolean>(this, ignoredBuilds){
            final /* synthetic */ UpdateStrategy this$0;
            final /* synthetic */ Set $ignoredBuilds;

            public final boolean invoke(@NotNull Pair<BuildInfo, UpdateChannel> p) {
                Intrinsics.checkNotNullParameter(p, (String)"p");
                return UpdateStrategy.access$isApplicable(this.this$0, (BuildInfo)p.getFirst(), this.$ignoredBuilds);
            }
            {
                this.this$0 = updateStrategy;
                this.$ignoredBuilds = set2;
                super(1);
            }
        })), (Comparator)new Comparator<Pair<? extends BuildInfo, ? extends UpdateChannel>>(this){
            final /* synthetic */ UpdateStrategy this$0;

            public final int compare(Pair<BuildInfo, UpdateChannel> p1, Pair<BuildInfo, UpdateChannel> p2) {
                return UpdateStrategy.access$compareBuilds(this.this$0, ((BuildInfo)p1.getFirst()).getNumber(), ((BuildInfo)p2.getFirst()).getNumber());
            }
            {
                this.this$0 = updateStrategy;
            }
        });
        BuildInfo newBuild = pair != null ? (BuildInfo)pair.getFirst() : null;
        Pair pair2 = result2;
        UpdateChannel updatedChannel = pair2 != null ? (UpdateChannel)pair2.getSecond() : null;
        UpdateChain patches2 = newBuild != null ? this.patches(newBuild, this.product, this.currentBuild) : null;
        return new CheckForUpdateResult(newBuild, updatedChannel, patches2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(BuildInfo candidate, Set<String> ignoredBuilds) {
        if (!this.customization.isNewerVersion(candidate.getNumber(), this.currentBuild)) return false;
        if (ignoredBuilds.contains(candidate.getNumber().asStringWithoutProductCode())) return false;
        BuildRange buildRange = candidate.getTarget();
        if (buildRange == null) return true;
        boolean bl = buildRange.inRange(this.currentBuild);
        if (!bl) return false;
        return true;
    }

    private final int compareBuilds(BuildNumber n1, BuildNumber n2) {
        int preferSameMajorVersion = Intrinsics.compare((int)(this.customization.haveSameMajorVersion(this.currentBuild, n1) ? 1 : 0), (int)(this.customization.haveSameMajorVersion(this.currentBuild, n2) ? 1 : 0));
        return preferSameMajorVersion != 0 ? preferSameMajorVersion : n1.compareTo(n2);
    }

    /*
     * WARNING - void declaration
     */
    private final UpdateChain patches(BuildInfo newBuild, Product product, BuildNumber from2) {
        Object v0;
        block8: {
            Iterable iterable = newBuild.getPatches();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                PatchInfo it = (PatchInfo)t;
                boolean bl3 = false;
                if (!(it.isAvailable() && it.getFromBuild().compareTo(from2) == 0)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        PatchInfo single = v0;
        if (single != null) {
            return new UpdateChain(CollectionsKt.listOf((Object[])new BuildNumber[]{from2, newBuild.getNumber()}), single.getSize());
        }
        MultiMap upgrades = new MultiMap();
        boolean bl = false;
        Map sizes = new LinkedHashMap();
        Iterable $this$forEach$iv = product.getChannels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UpdateChannel channel2 = (UpdateChannel)element$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = channel2.getBuilds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BuildInfo build2 = (BuildInfo)element$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)build2.getNumber().withoutProductCode(), (String)"build.number.withoutProductCode()");
                Iterable $this$forEach$iv3 = build2.getPatches();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Integer maxSize2;
                    BuildNumber fromBuild;
                    BuildNumber toBuild;
                    PatchInfo patch2 = (PatchInfo)element$iv3;
                    boolean bl6 = false;
                    if (!patch2.isAvailable()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)patch2.getFromBuild().withoutProductCode(), (String)"patch.fromBuild.withoutProductCode()");
                    upgrades.putValue((Object)toBuild, (Object)fromBuild);
                    if (patch2.getSize() == null || (maxSize2 = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)UpdateStrategyKt.access$getNUMBER$p(), (CharSequence)patch2.getSize(), (int)0, (int)2, null), (Function1)patches.1.1.1.maxSize.1.INSTANCE)))) == null) continue;
                    Map map2 = sizes;
                    Pair pair = TuplesKt.to((Object)TuplesKt.to((Object)fromBuild, (Object)toBuild), (Object)maxSize2);
                    boolean bl7 = false;
                    map2.put(pair.getFirst(), pair.getSecond());
                }
            }
        }
        InboundSemiGraph<BuildNumber> graph2 = new InboundSemiGraph<BuildNumber>(upgrades){
            final /* synthetic */ MultiMap $upgrades;

            @NotNull
            public Set<BuildNumber> getNodes() {
                Set set2 = this.$upgrades.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"upgrades.keySet()");
                Collection collection = this.$upgrades.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"upgrades.values()");
                return SetsKt.plus((Set)set2, (Iterable)collection);
            }

            @NotNull
            public Iterator<BuildNumber> getIn(@NotNull BuildNumber n) {
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                return this.$upgrades.get((Object)n).iterator();
            }
            {
                this.$upgrades = $captured_local_variable$0;
            }
        };
        List path = GraphAlgorithms.getInstance().findShortestPath((InboundSemiGraph)graph2, (Object)from2.withoutProductCode(), (Object)newBuild.getNumber().withoutProductCode());
        if (path == null || path.size() <= 2) {
            return null;
        }
        int total = 0;
        int element$iv = 1;
        int n = path.size();
        while (element$iv < n) {
            void i2;
            Integer size = (Integer)sizes.get(TuplesKt.to(path.get((int)(i2 - true)), path.get((int)i2)));
            if (size == null) {
                total = -1;
                break;
            }
            total += size.intValue();
            ++i2;
        }
        return new UpdateChain(path, total > 0 ? String.valueOf(total) : null);
    }

    public UpdateStrategy(@NotNull BuildNumber currentBuild, @Nullable Product product, @NotNull UpdateSettings settings) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.currentBuild = currentBuild;
        this.product = product;
        this.settings = settings;
        this.customization = UpdateStrategyCustomization.getInstance();
    }

    public UpdateStrategy(@NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updates2, @NotNull UpdateSettings settings) {
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkNotNullParameter((Object)updates2, (String)"updates");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String string = currentBuild.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBuild.productCode");
        this(currentBuild, updates2.get(string), settings);
    }

    public static final /* synthetic */ boolean access$isApplicable(UpdateStrategy $this, BuildInfo candidate, Set ignoredBuilds) {
        return $this.isApplicable(candidate, ignoredBuilds);
    }

    public static final /* synthetic */ int access$compareBuilds(UpdateStrategy $this, BuildNumber n1, BuildNumber n2) {
        return $this.compareBuilds(n1, n2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy$State;", "", "(Ljava/lang/String;I)V", "LOADED", "CONNECTION_ERROR", "NOTHING_LOADED", "intellij.platform.ide.impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State LOADED;
        public static final /* enum */ State CONNECTION_ERROR;
        public static final /* enum */ State NOTHING_LOADED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = LOADED = new State();
            stateArray[1] = CONNECTION_ERROR = new State();
            stateArray[2] = NOTHING_LOADED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

