/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceBrokenPlugin;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.ExternalUpdate;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateChecker$sam$i$java_lang_Runnable$0;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateRequestParameters;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0082\u0001\u0083\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u0001072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010=\u001a\u00020 H\u0002J@\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020'2\u0006\u00102\u001a\u0002032\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&2\b\u00106\u001a\u0004\u0018\u0001072\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J(\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020E2\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u0010\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020HH\u0007J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020EH\u0002J\u001e\u0010L\u001a\u00020\u00062\b\u0010:\u001a\u0004\u0018\u00010;2\n\b\u0002\u0010M\u001a\u0004\u0018\u000107H\u0007J\b\u0010N\u001a\u000201H\u0002J\u0016\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001050&H\u0002JF\u0010P\u001a\u0002012\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020 2\u0006\u0010T\u001a\u00020 2\u0006\u0010U\u001a\u00020 2\u0006\u0010D\u001a\u00020E2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010V\u001a\u0004\u0018\u00010WH\u0002J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020'0Y2\u0006\u0010Z\u001a\u00020\u0006H\u0002J\u001a\u0010[\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\\H\u0002JD\u0010]\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010A2\b\u0010M\u001a\u0004\u0018\u0001072\u0014\u0010^\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001050&2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&H\u0002J\b\u0010_\u001a\u00020\u000bH\u0007J\b\u0010`\u001a\u00020\u000bH\u0007J\u0010\u0010a\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010AH\u0007J\u001e\u0010b\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\f\u0012\n\u0018\u00010dj\u0004\u0018\u0001`e0cH\u0007J\n\u0010f\u001a\u0004\u0018\u00010gH\u0002J2\u0010h\u001a\b\u0012\u0004\u0012\u0002050Y2\f\u0010i\u001a\b\u0012\u0004\u0012\u0002050Y2\f\u0010j\u001a\b\u0012\u0004\u0012\u0002050Y2\u0006\u0010k\u001a\u00020 H\u0007J\b\u0010l\u001a\u000201H\u0007J\u001a\u0010m\u001a\u0002012\u0006\u0010T\u001a\u00020 2\b\b\u0001\u0010n\u001a\u00020\u0004H\u0002JZ\u0010o\u001a\u0002012\b\u0010Q\u001a\u0004\u0018\u00010R2\b\b\u0001\u0010p\u001a\u00020\u00042\b\b\u0001\u0010n\u001a\u00020\u00042\f\u0010q\u001a\b\u0012\u0004\u0012\u0002010r2\u0014\u0010s\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u000201\u0018\u00010t2\u0006\u0010u\u001a\u00020#2\u0006\u0010v\u001a\u00020\u0004H\u0002JJ\u0010w\u001a\u0002012\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010x\u001a\u00020J2\u0006\u0010Z\u001a\u00020\u00062\u000e\u0010y\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010A2\u0006\u0010S\u001a\u00020 2\u0006\u0010T\u001a\u00020 2\u0006\u0010U\u001a\u00020 H\u0002J,\u0010z\u001a\u0002012\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010{\u001a\u00020\u00042\b\u0010|\u001a\u0004\u0018\u00010\u00042\u0006\u0010}\u001a\u00020 H\u0007J\b\u0010~\u001a\u00020WH\u0007J\u001c\u0010~\u001a\u0002012\b\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010\u007f\u001a\u0004\u0018\u00010EH\u0007J\u0011\u0010\u0080\u0001\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007Jc\u0010\u0081\u0001\u001a\u0002012\u0014\u0010^\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001050&2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&2\b\u00106\u001a\u0004\u0018\u0001072\u0006\u00102\u001a\u0002032\b\u0010:\u001a\u0004\u0018\u00010;H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0014R\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006\u0084\u0001"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "DISABLED_UPDATE", "", "EMPTY_CHECK_UPDATE_RESULT", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$CheckPluginsUpdateResult;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "getNOTIFICATIONS$annotations", "PRODUCT_DATA_TTL_MS", "", "disabledToUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "getDisabledToUpdate$annotations", "getDisabledToUpdate", "()Ljava/util/Set;", "disabledToUpdatePlugins", "getDisabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "getExcludedFromUpdateCheckPlugins$annotations", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotifications", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "Lcom/intellij/notification/Notification;", "ourUpdatedPlugins", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "productDataCache", "Lcom/intellij/reference/SoftReference;", "Lcom/intellij/openapi/updateSettings/impl/Product;", "productDataLock", "Ljava/util/concurrent/locks/ReentrantLock;", "updateUrl", "getUpdateUrl", "()Ljava/lang/String;", "buildDownloaderAndPrepareToInstall", "", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "toUpdate", "toUpdateDisabled", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "host", "canEnableNotifications", "checkAndPrepareToInstall", "downloader", "checkExternalUpdates", "", "Lcom/intellij/openapi/updateSettings/impl/ExternalUpdate;", "manualCheck", "updateSettings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "checkPluginsUpdate", "newBuildNumber", "clearProductDataCache", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "showSettingsLink", "showDialog", "showEmptyNotification", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "getAllUpdatedPlugins", "", "checkPluginsUpdateResult", "getBrokenPlugins", "", "getIncompatiblePlugins", "updateable", "getNotificationGroup", "getNotificationGroupForUpdateResults", "getPluginUpdates", "getProductData", "Lcom/intellij/openapi/util/Pair;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadUpdatesData", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "mergePluginsFromRepositories", "marketplaceUpdates", "customPlugins", "addNotExist", "saveDisabledToUpdatePlugins", "showErrorMessage", "message", "showNotification", "title", "action", "Lkotlin/Function0;", "extraBuilder", "Lkotlin/Function1;", "notificationType", "notificationDisplayId", "showUpdateResult", "checkForUpdateResult", "externalUpdates", "testPlatformUpdate", "updateInfoText", "patchFilePath", "forceUpdate", "updateAndShowResult", "customSettings", "updateDescriptorsForInstalledPlugins", "validateCompatibleUpdatesForCurrentPlugins", "CheckPluginsUpdateResult", "NotificationUniqueType", "intellij.platform.ide.impl"})
public final class UpdateChecker {
    private static final Logger LOG;
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static final long PRODUCT_DATA_TTL_MS = 300000L;
    private static final ReentrantLock productDataLock;
    private static SoftReference<Product> productDataCache;
    private static Set<PluginId> ourDisabledToUpdatePlugins;
    private static final Map<PluginId, PluginDownloader> ourUpdatedPlugins;
    private static final MultiMap<NotificationUniqueType, Notification> ourShownNotifications;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static final CheckPluginsUpdateResult EMPTY_CHECK_UPDATE_RESULT;
    private static boolean ourHasFailedPlugins;
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    @NotNull
    public static final UpdateChecker INSTANCE;

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
            ApplicationInfoEx.UpdateUrls updateUrls = applicationInfoEx.getUpdateUrls();
            Intrinsics.checkNotNull((Object)updateUrls);
            Intrinsics.checkNotNullExpressionValue((Object)updateUrls, (String)"ApplicationInfoEx.getInstanceEx().updateUrls!!");
            String string2 = updateUrls.getCheckingUrl();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ApplicationInfoEx.getIns\u2026.updateUrls!!.checkingUrl");
        }
        return string;
    }

    public static /* synthetic */ void getExcludedFromUpdateCheckPlugins$annotations() {
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE and Plugin Updates");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"NotificationGroupManager\u2026\"IDE and Plugin Updates\")");
        return notificationGroup;
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup getNotificationGroupForUpdateResults() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Plugin Update Results");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"NotificationGroupManager\u2026(\"Plugin Update Results\")");
        return notificationGroup;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback2 = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback2){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)updateSettings, (String)"UpdateSettings.getInstance()");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, null, true, false, false, updateSettings, null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback2;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project, project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Project project = this.getProject();
                boolean bl = !this.$fromSettings;
                UpdateSettings updateSettings = this.$settings;
                Intrinsics.checkNotNullExpressionValue((Object)updateSettings, (String)"settings");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project, bl, this.$fromSettings, true, updateSettings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final Collection<PluginDownloader> getPluginUpdates() {
        return UpdateChecker.checkPluginsUpdate$default((ProgressIndicator)new EmptyProgressIndicator(), null, 2, null).getAvailableUpdates();
    }

    private final void doUpdateAndShowResult(Project project, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback2) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result2 = this.checkPlatformUpdate(updateSettings);
        if (result2.getState() == UpdateStrategy.State.CONNECTION_ERROR) {
            Exception e = result2.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            Object[] objectArray = new Object[1];
            Object object = e;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            objectArray[0] = object;
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
            this.showErrorMessage(showDialog, string);
            ActionCallback actionCallback = callback2;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        BuildInfo buildInfo = result2.getNewBuild();
        BuildNumber buildNumber = buildInfo != null ? buildInfo.getApiVersion() : null;
        CheckPluginsUpdateResult checkPluginsUpdateResult = null;
        Collection<ExternalUpdate> externalUpdates = null;
        try {
            checkPluginsUpdateResult = UpdateChecker.checkPluginsUpdate(indicator, buildNumber);
            externalUpdates = this.checkExternalUpdates(showDialog, updateSettings, indicator);
        }
        catch (IOException e) {
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"updat\u2026ction.failed\", e.message)");
            this.showErrorMessage(showDialog, string);
            ActionCallback actionCallback = callback2;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        UpdateSettings.getInstance().saveLastCheckedInfo();
        ApplicationManager.getApplication().invokeLater(new Runnable(project, result2, checkPluginsUpdateResult, externalUpdates, showSettingsLink, showDialog, showEmptyNotification, callback2){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ CheckPluginsUpdateResult $checkPluginsUpdateResult;
            final /* synthetic */ Collection $externalUpdates;
            final /* synthetic */ boolean $showSettingsLink;
            final /* synthetic */ boolean $showDialog;
            final /* synthetic */ boolean $showEmptyNotification;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                block0: {
                    UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$checkPluginsUpdateResult, this.$externalUpdates, this.$showSettingsLink, this.$showDialog, this.$showEmptyNotification);
                    ActionCallback actionCallback = this.$callback;
                    if (actionCallback == null) break block0;
                    actionCallback.setDone();
                }
            }
            {
                this.$project = project;
                this.$result = checkForUpdateResult;
                this.$checkPluginsUpdateResult = checkPluginsUpdateResult;
                this.$externalUpdates = collection;
                this.$showSettingsLink = bl;
                this.$showDialog = bl2;
                this.$showEmptyNotification = bl3;
                this.$callback = actionCallback;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        CheckForUpdateResult checkForUpdateResult;
        void product;
        Pair<Product, Exception> pair = UpdateChecker.getProductData();
        Product product2 = (Product)ExtensionsKt.component1(pair);
        Exception error = (Exception)ExtensionsKt.component2(pair);
        if (product != null && settings.isPlatformUpdateEnabled()) {
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            BuildNumber buildNumber = applicationInfo.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
            checkForUpdateResult = new UpdateStrategy(buildNumber, (Product)product, settings).checkForUpdates();
        } else if (error instanceof JDOMException) {
            LOG.info((Throwable)error);
            checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        } else if (error != null) {
            LOG.info((Throwable)error);
            checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, error);
        } else {
            checkForUpdateResult = new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        return checkForUpdateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Pair<Product, Exception> getProductData() {
        Lock lock2 = productDataLock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            Product product;
            Product product2;
            boolean bl3 = false;
            Product cached = (Product)SoftReference.dereference((Reference)((Reference)productDataCache));
            if (cached != null) {
                Pair pair = Pair.pair((Object)cached, null);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"pair(cached, null)");
                Pair pair2 = pair;
                return pair2;
            }
            UpdatesInfo updatesInfo = INSTANCE.loadUpdatesData();
            if (updatesInfo != null) {
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                BuildNumber buildNumber = applicationInfo.getBuild();
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
                String string = buildNumber.getProductCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().build.productCode");
                product2 = updatesInfo.get(string);
            } else {
                product2 = product = null;
            }
            if (product != null) {
                productDataCache = new SoftReference(product);
                Function0 function0 = (Function0)new Function0<Unit>(INSTANCE){

                    public final void invoke() {
                        UpdateChecker.access$clearProductDataCache((UpdateChecker)this.receiver);
                    }
                };
                AppExecutorUtil.getAppScheduledExecutorService().schedule(new UpdateChecker$sam$i$java_lang_Runnable$0(function0), 300000L, TimeUnit.MILLISECONDS);
            }
            Pair pair = Pair.pair(product, null);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"pair(product, null)");
            Pair pair3 = pair;
            return pair3;
        }
        finally {
            lock2.unlock();
        }
    }

    private final UpdatesInfo loadUpdatesData() throws IOException, JDOMException {
        Url url = Urls.newFromEncoded((String)this.getUpdateUrl());
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"file") ^ true) {
            Url url2 = UpdateRequestParameters.amendUpdateRequest(url);
            Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"UpdateRequestParameters.amendUpdateRequest(url)");
            url = url2;
        }
        LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{url});
        return (UpdatesInfo)HttpRequests.request((Url)url).connect((HttpRequests.RequestProcessor)loadUpdatesData.1.INSTANCE);
    }

    private final void clearProductDataCache() {
        if (productDataLock.tryLock(1L, TimeUnit.MILLISECONDS)) {
            productDataCache = null;
            productDataLock.unlock();
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CheckPluginsUpdateResult checkPluginsUpdate(@Nullable ProgressIndicator indicator, @Nullable BuildNumber newBuildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable;
        if (System.getProperty("idea.ignore.disabled.plugins") == null) {
            Map<PluginId, Set<String>> brokenPlugins;
            Map<PluginId, Set<String>> map2 = brokenPlugins = INSTANCE.getBrokenPlugins();
            boolean bl = false;
            if (!map2.isEmpty()) {
                PluginManagerCore.updateBrokenPlugins(brokenPlugins);
            }
        }
        if ((updateable = INSTANCE.collectUpdateablePlugins()).isEmpty()) {
            return EMPTY_CHECK_UPDATE_RESULT;
        }
        HashMap toUpdate = new HashMap();
        HashMap toUpdateDisabled = new HashMap();
        HashMap<PluginId, IdeaPluginDescriptor> latestCustomPluginsAsMap = new HashMap<PluginId, IdeaPluginDescriptor>();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> list2;
                if (host == null && appInfo.usesJetBrainsPluginRepository()) {
                    Map map3 = toUpdate;
                    Map map4 = toUpdateDisabled;
                    InstalledPluginsState installedPluginsState = state;
                    Intrinsics.checkNotNullExpressionValue((Object)installedPluginsState, (String)"state");
                    INSTANCE.validateCompatibleUpdatesForCurrentPlugins(updateable, map3, map4, newBuildNumber, installedPluginsState, indicator);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(RepositoryHelper.loadPlugins(host, newBuildNumber, indicator), (String)"RepositoryHelper.loadPlu\u2026ewBuildNumber, indicator)");
                Iterator<IdeaPluginDescriptor> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    IdeaPluginDescriptor storedDescriptor;
                    IdeaPluginDescriptor descriptor2;
                    IdeaPluginDescriptor ideaPluginDescriptor = descriptor2 = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"descriptor");
                    PluginId id2 = ideaPluginDescriptor.getPluginId();
                    if (updateable.remove(id2) != null) {
                        InstalledPluginsState installedPluginsState = state;
                        Intrinsics.checkNotNullExpressionValue((Object)installedPluginsState, (String)"state");
                        INSTANCE.buildDownloaderAndPrepareToInstall(installedPluginsState, descriptor2, newBuildNumber, toUpdate, toUpdateDisabled, indicator, host);
                    }
                    if ((storedDescriptor = (IdeaPluginDescriptor)latestCustomPluginsAsMap.get(id2)) != null && StringUtil.compareVersionNumbers((String)descriptor2.getVersion(), (String)storedDescriptor.getVersion()) <= 0) continue;
                    latestCustomPluginsAsMap.put(id2, descriptor2);
                }
            }
            catch (IOException e) {
                StringBuilder stringBuilder = new StringBuilder().append("failed to load plugin descriptions from ");
                String string = host;
                if (string == null) {
                    string = "default repository";
                }
                LOG.info(stringBuilder.append(string).append(": ").append(e.getMessage()).toString(), (Throwable)(LOG.isDebugEnabled() ? e : null));
            }
        }
        Collection<IdeaPluginDescriptor> incompatiblePlugins = INSTANCE.getIncompatiblePlugins(newBuildNumber, updateable, toUpdate);
        Collection<PluginDownloader> collection = toUpdate.isEmpty() ? null : toUpdate.values();
        Collection<PluginDownloader> collection2 = toUpdateDisabled.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"toUpdateDisabled.values");
        Collection collection3 = latestCustomPluginsAsMap.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"latestCustomPluginsAsMap.values");
        return new CheckPluginsUpdateResult(collection, collection2, collection3, incompatiblePlugins);
    }

    public static /* synthetic */ CheckPluginsUpdateResult checkPluginsUpdate$default(ProgressIndicator progressIndicator, BuildNumber buildNumber, int n, Object object) {
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return UpdateChecker.checkPluginsUpdate(progressIndicator, buildNumber);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CheckPluginsUpdateResult checkPluginsUpdate(@Nullable ProgressIndicator indicator) {
        return UpdateChecker.checkPluginsUpdate$default(indicator, null, 2, null);
    }

    private final Map<PluginId, Set<String>> getBrokenPlugins() {
        ApplicationInfo applicationInfo = ApplicationInfoImpl.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfoImpl.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfoImpl.getInstance().build");
        BuildNumber currentBuild = buildNumber;
        HashMap brokenPluginsMap = new HashMap();
        for (MarketplaceBrokenPlugin item : MarketplaceRequests.Companion.getInstance().getBrokenPlugins()) {
            try {
                String string = item.getOriginalUntil();
                if (string == null) continue;
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                if (string == null) continue;
                string2 = string;
                bl = false;
                boolean bl2 = false;
                String it22 = string2;
                boolean bl3 = false;
                Object object = it22;
                boolean bl4 = false;
                string = object.length() > 0 ? string2 : null;
                if (string == null) {
                    continue;
                }
                String parsedOriginalUntil = string;
                String string4 = item.getOriginalSince();
                if (string4 == null) continue;
                String string5 = string4;
                bl2 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string4 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                if (string4 == null) continue;
                string5 = string4;
                bl2 = false;
                boolean it22 = false;
                String it = string5;
                boolean bl5 = false;
                CharSequence charSequence = it;
                boolean bl6 = false;
                string4 = charSequence.length() > 0 ? string5 : null;
                if (string4 == null) {
                    continue;
                }
                String parsedOriginalSince = string4;
                BuildNumber buildNumber2 = BuildNumber.fromString((String)parsedOriginalUntil, (String)item.getId(), null);
                if (buildNumber2 == null) {
                    buildNumber2 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"BuildNumber.fromString(p\u2026id, null) ?: currentBuild");
                BuildNumber originalUntil = buildNumber2;
                BuildNumber buildNumber3 = BuildNumber.fromString((String)parsedOriginalSince, (String)item.getId(), null);
                if (buildNumber3 == null) {
                    buildNumber3 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber3, (String)"BuildNumber.fromString(p\u2026id, null) ?: currentBuild");
                BuildNumber originalSince = buildNumber3;
                BuildNumber buildNumber4 = BuildNumber.fromString((String)item.getUntil());
                if (buildNumber4 == null) {
                    buildNumber4 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber4, (String)"BuildNumber.fromString(item.until) ?: currentBuild");
                BuildNumber until = buildNumber4;
                BuildNumber buildNumber5 = BuildNumber.fromString((String)item.getSince());
                if (buildNumber5 == null) {
                    buildNumber5 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber5, (String)"BuildNumber.fromString(item.since) ?: currentBuild");
                BuildNumber since = buildNumber5;
                object = (Comparable)currentBuild;
                if (object.compareTo((Comparable)originalSince) < 0 || object.compareTo((Comparable)originalUntil) > 0 || (object = (Comparable)currentBuild).compareTo((Comparable)since) >= 0 && object.compareTo((Comparable)until) <= 0) continue;
                ((Set)brokenPluginsMap.computeIfAbsent(PluginId.getId((String)item.getId()), getBrokenPlugins.1.INSTANCE)).add(item.getVersion());
            }
            catch (Exception e) {
                LOG.error("cannot parse " + item, (Throwable)e);
            }
        }
        return brokenPluginsMap;
    }

    private final Collection<IdeaPluginDescriptor> getIncompatiblePlugins(BuildNumber newBuildNumber, Map<PluginId, IdeaPluginDescriptor> updateable, Map<PluginId, PluginDownloader> toUpdate) {
        if (newBuildNumber == null) {
            return null;
        }
        HashSet<IdeaPluginDescriptor> incompatiblePlugins = new HashSet<IdeaPluginDescriptor>();
        Map<PluginId, IdeaPluginDescriptor> map2 = updateable;
        boolean bl = false;
        Iterator<Map.Entry<PluginId, IdeaPluginDescriptor>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<PluginId, IdeaPluginDescriptor> entry;
            Map.Entry<PluginId, IdeaPluginDescriptor> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            IdeaPluginDescriptor installedPlugin = entry2.getValue();
            if (installedPlugin == null || !installedPlugin.isEnabled() || toUpdate.containsKey(installedPlugin.getPluginId()) || PluginManagerCore.isCompatible(installedPlugin, newBuildNumber) || installedPlugin.isBundled()) continue;
            incompatiblePlugins.add(installedPlugin);
        }
        return incompatiblePlugins;
    }

    @JvmStatic
    public static final void updateDescriptorsForInstalledPlugins(@NotNull InstalledPluginsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<PluginId, IdeaPluginDescriptor> updateable = INSTANCE.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return;
        }
        boolean bl = false;
        bl = false;
        INSTANCE.validateCompatibleUpdatesForCurrentPlugins(updateable, new LinkedHashMap(), new LinkedHashMap(), null, state, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateCompatibleUpdatesForCurrentPlugins(Map<PluginId, IdeaPluginDescriptor> updateable, Map<PluginId, PluginDownloader> toUpdate, Map<PluginId, PluginDownloader> toUpdateDisabled, BuildNumber buildNumber, InstalledPluginsState state, ProgressIndicator indicator) {
        Iterator $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        List<String> marketplacePluginIds = MarketplaceRequests.Companion.getInstance().getMarketplacePlugins(indicator);
        Object $this$map$iv = updateable;
        boolean $i$f$map = false;
        Map<PluginId, IdeaPluginDescriptor> map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Map.Entry entry = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = entry.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = ((PluginId)it2.getKey()).getIdString();
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        entry = $this$filterTo$iv$iv.iterator();
        while (entry.hasNext()) {
            Object element$iv$iv22 = entry.next();
            String it = (String)element$iv$iv22;
            boolean bl3 = false;
            if (!marketplacePluginIds.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        List idsToUpdate = (List)destination$iv$iv;
        List<IdeCompatibleUpdate> updates2 = MarketplaceRequests.Companion.getInstance().getLastCompatiblePluginUpdate(idsToUpdate, buildNumber);
        destination$iv$iv = updateable;
        $i$f$filterTo = false;
        $this$filterTo$iv$iv = destination$iv$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            IdeCompatibleUpdate lastUpdate;
            Object v0;
            void id2;
            Object object;
            IdeaPluginDescriptor descriptor2;
            block8: {
                entry = $i$f$filter = $this$filterTo$iv$iv.next();
                boolean element$iv$iv22 = false;
                destination$iv$iv = (PluginId)entry.getKey();
                entry = $i$f$filter;
                element$iv$iv22 = false;
                descriptor2 = (IdeaPluginDescriptor)entry.getValue();
                Iterable element$iv$iv22 = updates2;
                boolean it = false;
                object = element$iv$iv22;
                boolean it2 = false;
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Object t = iterator3.next();
                    IdeCompatibleUpdate it3 = (IdeCompatibleUpdate)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it3.getPluginId(), (Object)id2.getIdString())) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            if ((IdeCompatibleUpdate)v0 == null) {
                continue;
            }
            boolean isOutdated = descriptor2 == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(lastUpdate.getVersion(), descriptor2, buildNumber) > 0;
            if (!isOutdated) continue;
            try {
                MarketplaceRequests marketplaceRequests = MarketplaceRequests.Companion.getInstance();
                String string = id2.getIdString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.idString");
                object = marketplaceRequests.loadPluginDescriptor(string, lastUpdate, indicator);
            }
            catch (HttpRequests.HttpStatusException e) {
                if (e.getStatusCode() == 404) continue;
                throw (Throwable)e;
            }
            Object newDescriptor = object;
            this.buildDownloaderAndPrepareToInstall(state, (IdeaPluginDescriptor)newDescriptor, buildNumber, toUpdate, toUpdateDisabled, indicator, null);
        }
        Iterable $this$forEach$iv = toUpdate.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginId it = (PluginId)element$iv;
            boolean bl5 = false;
            updateable.remove(it);
        }
    }

    private final void buildDownloaderAndPrepareToInstall(InstalledPluginsState state, IdeaPluginDescriptor descriptor2, BuildNumber buildNumber, Map<PluginId, PluginDownloader> toUpdate, Map<PluginId, PluginDownloader> toUpdateDisabled, ProgressIndicator indicator, String host) {
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader(descriptor2, host, buildNumber);
        Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"PluginDownloader.createD\u2026iptor, host, buildNumber)");
        PluginDownloader downloader = pluginDownloader;
        state.onDescriptorDownload(descriptor2);
        UpdateChecker.checkAndPrepareToInstall(downloader, state, PluginManagerCore.isDisabled(downloader.getId()) ? toUpdateDisabled : toUpdate, buildNumber, indicator);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        String it;
        Iterator $this$filterTo$iv$iv;
        HashMap updateable = new HashMap();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray, (String)"PluginManagerCore.getPlugins()");
        IdeaPluginDescriptor[] $this$filter$iv = ideaPluginDescriptorArray;
        boolean $i$f$filter = false;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        void var7_15 = $this$filterTo$iv$iv;
        int n = ((void)var7_15).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it2 = element$iv$iv = var7_15[j];
            boolean bl = false;
            void v1 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!(!v1.isBundled() || it2.allowBundledUpdate())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateByTo$iv = (List)destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it3;
            IdeaPluginDescriptor $i$f$filterTo2 = (IdeaPluginDescriptor)element$iv;
            Map map2 = updateable;
            boolean bl = false;
            void v2 = it3;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            PluginId pluginId = v2.getPluginId();
            map2.put(pluginId, element$iv);
        }
        Path onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                List<String> list2 = Files.readAllLines(onceInstalled);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"Files.readAllLines(onceInstalled)");
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)collectUpdateablePlugins.3.INSTANCE), (Function1)((Function1)new Function1<PluginId, Boolean>(updateable){
                    final /* synthetic */ HashMap $updateable;

                    public final boolean invoke(@NotNull PluginId it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Map map2 = this.$updateable;
                        PluginId pluginId = it;
                        boolean bl = false;
                        Map map3 = map2;
                        boolean bl2 = false;
                        return !map3.containsKey(pluginId);
                    }
                    {
                        this.$updateable = hashMap;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (PluginId)element$iv;
                    boolean bl = false;
                    Map map3 = updateable;
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    map3.put(string, null);
                }
            }
            catch (IOException e) {
                LOG.error(((Object)onceInstalled).toString(), (Throwable)e);
            }
            onceInstalled.toFile().deleteOnExit();
        }
        Collection e = excludedFromUpdateCheckPlugins;
        boolean $i$f$forEach = false;
        if (!e.isEmpty()) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isInternal()) {
                Iterable $this$forEach$iv = excludedFromUpdateCheckPlugins;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PluginId excluded;
                    it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)PluginId.getId((String)it), (String)"PluginId.getId(it)");
                    IdeaPluginDescriptor plugin2 = (IdeaPluginDescriptor)updateable.get(excluded);
                    if (plugin2 == null || !plugin2.isBundled()) continue;
                    updateable.remove(excluded);
                }
            }
        }
        return updateable;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Collection<ExternalUpdate> checkExternalUpdates(boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)updateSettings, (String)"updateSettings");
        boolean bl = false;
        ArrayList result2 = new ArrayList();
        ExternalComponentManager externalComponentManager = ExternalComponentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)externalComponentManager, (String)"ExternalComponentManager.getInstance()");
        ExternalComponentManager manager2 = externalComponentManager;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.external.progress", (Object[])new Object[0]));
        }
        for (ExternalComponentSource source : ExternalComponentManager.getComponentSources()) {
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 != null) {
                progressIndicator2.checkCanceled();
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Collection<UpdatableExternalComponent> collection = source.getAvailableVersions(indicator, updateSettings);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"source.getAvailableVersi\u2026ndicator, updateSettings)");
                Iterable iterable = collection;
                boolean $i$f$filter = false;
                void var11_14 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UpdatableExternalComponent it = (UpdatableExternalComponent)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.isUpdateFor(manager2.findExistingComponentMatching(it, source))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List siteResult = (List)destination$iv$iv;
                iterable = siteResult;
                boolean bl3 = false;
                if (!(!iterable.isEmpty())) continue;
                iterable = result2;
                ExternalUpdate externalUpdate = new ExternalUpdate(siteResult, source);
                boolean bl4 = false;
                iterable.add(externalUpdate);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                Object[] objectArray = new Object[2];
                ExternalComponentSource externalComponentSource = source;
                Intrinsics.checkNotNullExpressionValue((Object)externalComponentSource, (String)"source");
                objectArray[0] = externalComponentSource.getName();
                String string = e.getMessage();
                if (string == null) {
                    string = "internal error";
                }
                objectArray[1] = string;
                String string2 = IdeBundle.message((String)"updates.external.error.message", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
                this.showErrorMessage(manualCheck, string2);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<IdeaPluginDescriptor> mergePluginsFromRepositories(@NotNull List<? extends IdeaPluginDescriptor> marketplaceUpdates, @NotNull List<? extends IdeaPluginDescriptor> customPlugins, boolean addNotExist) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(marketplaceUpdates, (String)"marketplaceUpdates");
        Intrinsics.checkNotNullParameter(customPlugins, (String)"customPlugins");
        Iterable iterable = marketplaceUpdates;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            PluginId pluginId = it.getPluginId();
            map2.put(pluginId, element$iv$iv);
        }
        Map compatiblePluginMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        for (IdeaPluginDescriptor ideaPluginDescriptor : customPlugins) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            IdeaPluginDescriptor plugin2 = (IdeaPluginDescriptor)compatiblePluginMap.get(pluginId);
            if (plugin2 == null) {
                if (!addNotExist) continue;
                compatiblePluginMap.put(pluginId, ideaPluginDescriptor);
                continue;
            }
            if (PluginDownloader.compareVersionsSkipBrokenAndIncompatible(ideaPluginDescriptor.getVersion(), plugin2) <= 0) continue;
            compatiblePluginMap.put(pluginId, ideaPluginDescriptor);
        }
        return CollectionsKt.toList((Iterable)compatiblePluginMap.values());
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(toUpdate, (String)"toUpdate");
        PluginDownloader downloader2 = downloader;
        PluginId pluginId = downloader2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"downloader.id");
        PluginId pluginId2 = pluginId;
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginId2);
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginVersion, installedPlugin, buildNumber) > 0) {
            IdeaPluginDescriptor descriptor2 = null;
            if (PluginManagerCore.isDisabled(pluginId2)) {
                descriptor2 = downloader2.getDescriptor();
            } else {
                PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId2);
                if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                    descriptor2 = downloader2.getDescriptor();
                    if (descriptor2 instanceof PluginNode && ((PluginNode)descriptor2).isIncomplete()) {
                        ProgressIndicator progressIndicator = indicator;
                        if (progressIndicator == null) {
                            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                        }
                        if (downloader2.prepareToInstall(progressIndicator)) {
                            descriptor2 = downloader2.getDescriptor();
                        }
                        ourUpdatedPlugins.put(pluginId2, downloader2);
                    }
                } else {
                    downloader2 = oldDownloader;
                    descriptor2 = oldDownloader.getDescriptor();
                }
            }
            if (PluginManagerCore.isCompatible(descriptor2, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor2.getPluginId())) {
                toUpdate.put(pluginId2, downloader2);
            }
        }
    }

    private final void showErrorMessage(boolean showDialog, @NlsContexts.DialogMessage String message2) {
        LOG.info(message2);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message2){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginDownloader> getAllUpdatedPlugins(CheckPluginsUpdateResult checkPluginsUpdateResult) {
        void $this$filterTo$iv$iv;
        ArrayList arrayList;
        Function1 notIgnored2 = getAllUpdatedPlugins.notIgnored.1.INSTANCE;
        Collection<PluginDownloader> collection = checkPluginsUpdateResult.getAvailableUpdates();
        if (collection != null) {
            void $this$filterTo$iv;
            Iterable iterable = collection;
            Collection destination$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                if (!((Boolean)notIgnored2.invoke(element$iv)).booleanValue()) continue;
                destination$iv.add(element$iv);
            }
            arrayList = (ArrayList)destination$iv;
        } else {
            arrayList = null;
        }
        ArrayList updatedPlugins = arrayList;
        Iterable $this$filter$iv = checkPluginsUpdateResult.getAvailableDisabledUpdates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)notIgnored2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List updatedDisabledPlugins = (List)destination$iv$iv;
        if (updatedPlugins == null) {
            return updatedDisabledPlugins;
        }
        updatedPlugins.addAll(updatedDisabledPlugins);
        return updatedPlugins;
    }

    /*
     * WARNING - void declaration
     */
    private final void showUpdateResult(Project project, CheckForUpdateResult checkForUpdateResult, CheckPluginsUpdateResult checkPluginsUpdateResult, Collection<? extends ExternalUpdate> externalUpdates, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification) {
        Object it;
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo newBuild = checkForUpdateResult.getNewBuild();
        List<PluginDownloader> updatedPlugins = this.getAllUpdatedPlugins(checkPluginsUpdateResult);
        if (updatedChannel != null && newBuild != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(project, updatedChannel, newBuild, checkForUpdateResult, showSettingsLink, updatedPlugins, checkPluginsUpdateResult){
                final /* synthetic */ Project $project;
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ BuildInfo $newBuild;
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ boolean $showSettingsLink;
                final /* synthetic */ List $updatedPlugins;
                final /* synthetic */ CheckPluginsUpdateResult $checkPluginsUpdateResult;

                public final void invoke() {
                    new UpdateInfoDialog(this.$project, this.$updatedChannel, this.$newBuild, this.$checkForUpdateResult.getPatches(), this.$showSettingsLink, this.$updatedPlugins, this.$checkPluginsUpdateResult.getIncompatiblePlugins()).show();
                }
                {
                    this.$project = project;
                    this.$updatedChannel = updateChannel;
                    this.$newBuild = buildInfo;
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$showSettingsLink = bl;
                    this.$updatedPlugins = list2;
                    this.$checkPluginsUpdateResult = checkPluginsUpdateResult;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLATFORM);
            if (collection != null) {
                Iterable iterable = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : iterable) {
                    Notification it2 = (Notification)element$iv;
                    boolean bl = false;
                    it2.expire();
                }
            }
            if (showDialog) {
                runnable2.invoke();
            } else {
                String string;
                SettingsEntryPointAction.newPlatformUpdate(checkForUpdateResult, updatedPlugins, checkPluginsUpdateResult.getIncompatiblePlugins());
                IdeUpdateUsageTriggerCollector.trigger("notification.shown");
                Object[] objectArray = new Object[2];
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                objectArray[0] = applicationNamesInfo.getFullProductName();
                objectArray[1] = newBuild.getVersion();
                String string2 = string = IdeBundle.message((String)"updates.new.build.notification.title", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"title");
                this.showNotification(project, string2, "", (Function0<Unit>)((Function0)new Function0<Unit>(runnable2){
                    final /* synthetic */ Function0 $runnable;

                    public final void invoke() {
                        IdeUpdateUsageTriggerCollector.trigger("notification.clicked");
                        this.$runnable.invoke();
                    }
                    {
                        this.$runnable = function0;
                        super(0);
                    }
                }), null, NotificationUniqueType.PLATFORM, "ide.update.available");
            }
            return;
        }
        boolean updateFound = false;
        Collection collection = updatedPlugins;
        boolean $i$f$forEach = false;
        if (!collection.isEmpty()) {
            updateFound = true;
            Collection collection2 = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
            if (collection2 != null) {
                Iterable iterable = collection2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : iterable) {
                    it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            Function0 function0 = (Function0)new Function0<Unit>(project, updatedPlugins, checkPluginsUpdateResult){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $updatedPlugins;
                final /* synthetic */ CheckPluginsUpdateResult $checkPluginsUpdateResult;

                public final void invoke() {
                    new PluginUpdateDialog(this.$project, this.$updatedPlugins, this.$checkPluginsUpdateResult.getCustomRepositoryPlugins()).show();
                }
                {
                    this.$project = project;
                    this.$updatedPlugins = list2;
                    this.$checkPluginsUpdateResult = checkPluginsUpdateResult;
                    super(0);
                }
            };
            if (showDialog || !this.canEnableNotifications()) {
                function0.invoke();
            } else {
                int n;
                int n2;
                void $this$count$iv;
                Iterable $i$f$forEach2 = updatedPlugins;
                int n3 = updatedPlugins.size();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        PluginDownloader downloader = (PluginDownloader)element$iv;
                        boolean bl = false;
                        if (!PluginManagerCore.isDisabled(downloader.getId())) continue;
                        int n4 = ++count$iv;
                        boolean bl2 = false;
                        if (n4 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = n = count$iv;
                }
                if (n3 != n) {
                    SettingsEntryPointAction.newPluginUpdates((Collection<PluginDownloader>)updatedPlugins, checkPluginsUpdateResult.getCustomRepositoryPlugins());
                    String names2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.names.1.INSTANCE, (int)31, null);
                    String title2 = updatedPlugins.size() == 1 ? IdeBundle.message((String)"updates.plugin.ready.short.title.available", (Object[])new Object[]{names2}) : IdeBundle.message((String)"updates.plugins.ready.short.title.available", (Object[])new Object[0]);
                    String message2 = updatedPlugins.size() == 1 ? "" : names2;
                    String string = title2;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"title");
                    this.showNotification(project, string, message2, (Function0<Unit>)function0, (Function1<? super Notification, Unit>)((Function1)new Function1<Notification, Unit>(updatedPlugins){
                        final /* synthetic */ List $updatedPlugins;

                        public final void invoke(@NotNull Notification notification) {
                            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                            E e = notification.getActions().get(0);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"notification.actions[0]");
                            Presentation presentation2 = ((AnAction)e).getTemplatePresentation();
                            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"notification.actions[0].templatePresentation");
                            presentation2.setText(IdeBundle.message((String)"plugin.settings.link.title", (Object[])new Object[0]));
                            String text2 = this.$updatedPlugins.size() == 1 ? IdeBundle.message((String)"plugins.configurable.update.button", (Object[])new Object[0]) : IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]);
                            notification.getActions().add(0, new NotificationAction(this, text2, text2){
                                final /* synthetic */ showUpdateResult.5 this$0;
                                final /* synthetic */ String $text;

                                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                                    notification.expire();
                                    PluginUpdateDialog.runUpdateAll(this.this$0.$updatedPlugins, (JComponent)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), null);
                                }
                                {
                                    this.this$0 = this$0;
                                    this.$text = $captured_local_variable$1;
                                    super($super_call_param$2);
                                }
                            });
                            notification.addAction((AnAction)new NotificationAction(this, IdeBundle.message((String)"updates.ignore.updates.link", (Object[])new Object[]{this.$updatedPlugins.size()})){
                                final /* synthetic */ showUpdateResult.5 this$0;

                                /*
                                 * WARNING - void declaration
                                 */
                                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                    void $this$mapTo$iv$iv;
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                                    notification.expire();
                                    Iterable $this$map$iv = this.this$0.$updatedPlugins;
                                    boolean $i$f$map = false;
                                    Iterable iterable = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void downloader;
                                        PluginDownloader pluginDownloader = (PluginDownloader)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean bl = false;
                                        IdeaPluginDescriptor ideaPluginDescriptor = downloader.getDescriptor();
                                        collection.add(ideaPluginDescriptor);
                                    }
                                    PluginUpdateDialog.ignorePlugins((List)destination$iv$iv);
                                }
                                {
                                    this.this$0 = this$0;
                                    super($super_call_param$1);
                                }
                            });
                        }
                        {
                            this.$updatedPlugins = list2;
                            super(1);
                        }
                    }), NotificationUniqueType.PLUGINS, "plugins.update.available");
                }
            }
        }
        if (externalUpdates != null && !externalUpdates.isEmpty()) {
            updateFound = true;
            Collection collection3 = ourShownNotifications.remove((Object)NotificationUniqueType.EXTERNAL);
            if (collection3 != null) {
                Iterable iterable = collection3;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : iterable) {
                    it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            for (ExternalUpdate externalUpdate : externalUpdates) {
                Function0 runnable4 = (Function0)new Function0<Unit>(externalUpdate){
                    final /* synthetic */ ExternalUpdate $update;

                    public final void invoke() {
                        this.$update.getSource().installUpdates(this.$update.getComponents());
                    }
                    {
                        this.$update = externalUpdate;
                        super(0);
                    }
                };
                if (showDialog) {
                    runnable4.invoke();
                    continue;
                }
                Object[] objectArray = new Object[1];
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                objectArray[0] = applicationNamesInfo.getFullProductName();
                String title3 = IdeBundle.message((String)"updates.plugins.ready.title.available", (Object[])objectArray);
                Collection<UpdatableExternalComponent> collection4 = externalUpdate.getComponents();
                Intrinsics.checkNotNullExpressionValue(collection4, (String)"update.components");
                String updates2 = CollectionsKt.joinToString$default((Iterable)collection4, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String message3 = IdeBundle.message((String)"updates.external.ready.message", (Object[])new Object[]{externalUpdate.getComponents().size(), updates2});
                String string = title3;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"title");
                String string3 = message3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message");
                this.showNotification(project, string, string3, (Function0<Unit>)runnable4, null, NotificationUniqueType.EXTERNAL, "external.components.available");
            }
        }
        if (!updateFound) {
            if (showDialog) {
                new NoUpdatesDialog(showSettingsLink).show();
            } else if (showEmptyNotification) {
                String string;
                Collection collection5 = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
                if (collection5 != null) {
                    Iterable iterable = collection5;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv : iterable) {
                        it = (Notification)element$iv;
                        boolean bl = false;
                        it.expire();
                    }
                }
                String string4 = string = IdeBundle.message((String)"updates.no.updates.notification", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"title");
                this.showNotification(project, string4, "", (Function0<Unit>)((Function0)showUpdateResult.8.INSTANCE), (Function1<? super Notification, Unit>)((Function1)showUpdateResult.9.INSTANCE), NotificationUniqueType.PLUGINS, "no.updates.available");
            }
        }
    }

    private final boolean canEnableNotifications() {
        return NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS && NotificationsConfigurationImpl.getSettings(UpdateChecker.getNotificationGroup().getDisplayId()).getDisplayType() != NotificationDisplayType.NONE;
    }

    private final void showNotification(Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message2, Function0<Unit> action2, Function1<? super Notification, Unit> extraBuilder, NotificationUniqueType notificationType, String notificationDisplayId) {
        String string;
        CharSequence charSequence = message2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            string = "";
        } else {
            String string2 = XmlStringUtil.wrapInHtml((CharSequence)message2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"XmlStringUtil.wrapInHtml(message)");
        }
        String content2 = string;
        NotificationType type = notificationType == NotificationUniqueType.PLATFORM ? NotificationType.IDE_UPDATE : NotificationType.INFORMATION;
        Notification notification = UpdateChecker.getNotificationGroup().createNotification(title, content2, type, null, notificationDisplayId);
        notification.setCollapseActionsDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.addAction((AnAction)new NotificationAction(action2, IdeBundle.message((String)"updates.notification.update.action", (Object[])new Object[0])){
            final /* synthetic */ Function0 $action;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification.expire();
                this.$action.invoke();
            }
            {
                this.$action = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
        Function1<? super Notification, Unit> function1 = extraBuilder;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)notification);
        }
        notification.whenExpired(new Runnable(notificationType, notification){
            final /* synthetic */ NotificationUniqueType $notificationType;
            final /* synthetic */ Notification $notification;

            public final void run() {
                UpdateChecker.access$getOurShownNotifications$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType), (Object)this.$notification);
            }
            {
                this.$notificationType = notificationUniqueType;
                this.$notification = notification;
            }
        });
        notification.notify(project);
        ourShownNotifications.putValue((Object)notificationType, (Object)notification);
    }

    @JvmStatic
    public static /* synthetic */ void getDisabledToUpdate$annotations() {
    }

    @NotNull
    public static final Set<PluginId> getDisabledToUpdate() {
        Set result2 = ourDisabledToUpdatePlugins;
        if (result2 == null) {
            block5: {
                result2 = new TreeSet();
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) {
                    try {
                        File file2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                        if (!file2.isFile()) break block5;
                        String string = FileUtil.loadFile((File)file2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.loadFile(file)");
                        CharSequence charSequence = string;
                        String string2 = "[\\s]";
                        int n = 0;
                        string2 = new Regex(string2);
                        n = 0;
                        boolean bl = false;
                        for (String line : string2.split(charSequence, n)) {
                            if (StringKt.nullize((String)line, (boolean)true) == null) continue;
                            boolean bl2 = false;
                            n = 0;
                            CharSequence it = charSequence;
                            boolean bl3 = false;
                            PluginId pluginId = PluginId.getId((String)it);
                            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(it)");
                            result2.add(pluginId);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            ourDisabledToUpdatePlugins = result2;
        }
        return result2;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        try {
            DisabledPluginsState.savePluginsList((Collection<PluginId>)UpdateChecker.getDisabledToUpdate(), Paths.get(PathManager.getConfigPath(), DISABLED_UPDATE));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        Application app;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!ourHasFailedPlugins && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            IdeaPluginDescriptor pluginDescriptor;
            UpdateSettings updateSettings = UpdateSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateSettings, (String)"UpdateSettings.getInstance()");
            if (updateSettings.isPluginsCheckNeeded() && (pluginDescriptor = PluginManagerCore.getPlugin(PluginUtil.getInstance().findPluginId(event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
                ourHasFailedPlugins = true;
                UpdateChecker.updateAndShowResult();
            }
        }
    }

    @ApiStatus.Internal
    public final void testPlatformUpdate(@Nullable Project project, @NotNull String updateInfoText, @Nullable String patchFilePath, boolean forceUpdate) {
        Intrinsics.checkNotNullParameter((Object)updateInfoText, (String)"updateInfoText");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal()) {
            throw (Throwable)new IllegalStateException();
        }
        UpdateChannel channel2 = null;
        BuildInfo newBuild = null;
        UpdateChain patches2 = null;
        if (forceUpdate) {
            UpdateChain updateChain;
            Element element2 = JDOMUtil.load((CharSequence)updateInfoText).getChild("product");
            if (element2 == null || (element2 = element2.getChild("channel")) == null) {
                throw (Throwable)new IllegalArgumentException("//channel missing");
            }
            Element node = element2;
            channel2 = new UpdateChannel(node);
            BuildInfo buildInfo = (BuildInfo)CollectionsKt.firstOrNull(channel2.getBuilds());
            if (buildInfo == null) {
                throw (Throwable)new IllegalArgumentException("//build missing");
            }
            newBuild = buildInfo;
            PatchInfo patchInfo = (PatchInfo)CollectionsKt.firstOrNull(newBuild.getPatches());
            if (patchInfo != null) {
                PatchInfo patchInfo2 = patchInfo;
                boolean bl = false;
                boolean bl2 = false;
                PatchInfo it = patchInfo2;
                boolean bl3 = false;
                updateChain = new UpdateChain(CollectionsKt.listOf((Object[])new BuildNumber[]{it.getFromBuild(), newBuild.getNumber()}), it.getSize());
            } else {
                updateChain = null;
            }
            patches2 = updateChain;
        } else {
            Element element3 = JDOMUtil.load((CharSequence)updateInfoText);
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"JDOMUtil.load(updateInfoText)");
            UpdatesInfo updateInfo = new UpdatesInfo(element3);
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            BuildNumber buildNumber = applicationInfo.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
            UpdateSettings updateSettings = UpdateSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)updateSettings, (String)"UpdateSettings.getInstance()");
            UpdateStrategy strategy = new UpdateStrategy(buildNumber, updateInfo, updateSettings);
            CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
            channel2 = checkForUpdateResult.getUpdatedChannel();
            newBuild = checkForUpdateResult.getNewBuild();
            patches2 = checkForUpdateResult.getPatches();
        }
        if (channel2 != null && newBuild != null) {
            File patchFile = patchFilePath != null ? new File(FileUtil.toSystemDependentName((String)patchFilePath)) : null;
            new UpdateInfoDialog(project, channel2, newBuild, patches2, patchFile).show();
        } else {
            new NoUpdatesDialog(true).show();
        }
    }

    @Deprecated(level=DeprecationLevel.ERROR, replaceWith=@ReplaceWith(imports={}, expression="getNotificationGroup()"), message="Use getNotificationGroup()")
    public static /* synthetic */ void getNOTIFICATIONS$annotations() {
    }

    @Deprecated(message="Use disabledToUpdate", replaceWith=@ReplaceWith(imports={}, expression="disabledToUpdate"))
    @JvmStatic
    public static /* synthetic */ void getDisabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use disabledToUpdate", replaceWith=@ReplaceWith(imports={}, expression="disabledToUpdate"))
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        void var1_1;
        void $this$mapTo$iv;
        Iterable iterable = UpdateChecker.getDisabledToUpdate();
        Collection destination$iv = new TreeSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PluginId pluginId = (PluginId)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String string = it.getIdString();
            collection.add(string);
        }
        return (Set)var1_1;
    }

    private UpdateChecker() {
    }

    static {
        UpdateChecker updateChecker;
        INSTANCE = updateChecker = new UpdateChecker();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UpdateChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        productDataLock = new ReentrantLock();
        ourUpdatedPlugins = new HashMap();
        ourShownNotifications = new MultiMap();
        $i$f$logger = false;
        excludedFromUpdateCheckPlugins = new HashSet();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        UpdateRequestParameters.addParameter("build", applicationInfo.getBuild().asString());
        UpdateRequestParameters.addParameter("uid", PermanentInstallationID.get());
        UpdateRequestParameters.addParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ExternalUpdateManager.ACTUAL != null) {
            String name = ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX ? "Toolbox" : ExternalUpdateManager.ACTUAL.toolName;
            UpdateRequestParameters.addParameter("manager", name);
        }
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        if (applicationInfoEx.isEAP()) {
            UpdateRequestParameters.addParameter("eap", "");
        }
        EMPTY_CHECK_UPDATE_RESULT = new CheckPluginsUpdateResult(null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null);
        NOTIFICATIONS = new NotificationGroup("IDE and Plugin Updates", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginManagerCore.CORE_ID);
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, Project project, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback2) {
        $this.doUpdateAndShowResult(project, showSettingsLink, showDialog, showEmptyNotification, updateSettings, indicator, callback2);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, Project project, CheckForUpdateResult checkForUpdateResult, CheckPluginsUpdateResult checkPluginsUpdateResult, Collection externalUpdates, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification) {
        $this.showUpdateResult(project, checkForUpdateResult, checkPluginsUpdateResult, externalUpdates, showSettingsLink, showDialog, showEmptyNotification);
    }

    public static final /* synthetic */ void access$clearProductDataCache(UpdateChecker $this) {
        $this.clearProductDataCache();
    }

    public static final /* synthetic */ MultiMap access$getOurShownNotifications$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotifications;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "", "(Ljava/lang/String;I)V", "PLATFORM", "PLUGINS", "EXTERNAL", "intellij.platform.ide.impl"})
    private static final class NotificationUniqueType
    extends Enum<NotificationUniqueType> {
        public static final /* enum */ NotificationUniqueType PLATFORM;
        public static final /* enum */ NotificationUniqueType PLUGINS;
        public static final /* enum */ NotificationUniqueType EXTERNAL;
        private static final /* synthetic */ NotificationUniqueType[] $VALUES;

        static {
            NotificationUniqueType[] notificationUniqueTypeArray = new NotificationUniqueType[3];
            NotificationUniqueType[] notificationUniqueTypeArray2 = notificationUniqueTypeArray;
            notificationUniqueTypeArray[0] = PLATFORM = new NotificationUniqueType();
            notificationUniqueTypeArray[1] = PLUGINS = new NotificationUniqueType();
            notificationUniqueTypeArray[2] = EXTERNAL = new NotificationUniqueType();
            $VALUES = notificationUniqueTypeArray;
        }

        public static NotificationUniqueType[] values() {
            return (NotificationUniqueType[])$VALUES.clone();
        }

        public static NotificationUniqueType valueOf(String string) {
            return Enum.valueOf(NotificationUniqueType.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003H\u00c6\u0003JM\u0010\u0013\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$CheckPluginsUpdateResult;", "", "availableUpdates", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "availableDisabledUpdates", "customRepositoryPlugins", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "incompatiblePlugins", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "getAvailableDisabledUpdates", "()Ljava/util/Collection;", "getAvailableUpdates", "getCustomRepositoryPlugins", "getIncompatiblePlugins", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class CheckPluginsUpdateResult {
        @Nullable
        private final Collection<PluginDownloader> availableUpdates;
        @NotNull
        private final Collection<PluginDownloader> availableDisabledUpdates;
        @NotNull
        private final Collection<IdeaPluginDescriptor> customRepositoryPlugins;
        @Nullable
        private final Collection<IdeaPluginDescriptor> incompatiblePlugins;

        @Nullable
        public final Collection<PluginDownloader> getAvailableUpdates() {
            return this.availableUpdates;
        }

        @NotNull
        public final Collection<PluginDownloader> getAvailableDisabledUpdates() {
            return this.availableDisabledUpdates;
        }

        @NotNull
        public final Collection<IdeaPluginDescriptor> getCustomRepositoryPlugins() {
            return this.customRepositoryPlugins;
        }

        @Nullable
        public final Collection<IdeaPluginDescriptor> getIncompatiblePlugins() {
            return this.incompatiblePlugins;
        }

        public CheckPluginsUpdateResult(@Nullable Collection<PluginDownloader> availableUpdates, @NotNull Collection<PluginDownloader> availableDisabledUpdates, @NotNull Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
            Intrinsics.checkNotNullParameter(availableDisabledUpdates, (String)"availableDisabledUpdates");
            Intrinsics.checkNotNullParameter(customRepositoryPlugins, (String)"customRepositoryPlugins");
            this.availableUpdates = availableUpdates;
            this.availableDisabledUpdates = availableDisabledUpdates;
            this.customRepositoryPlugins = customRepositoryPlugins;
            this.incompatiblePlugins = incompatiblePlugins;
        }

        @Nullable
        public final Collection<PluginDownloader> component1() {
            return this.availableUpdates;
        }

        @NotNull
        public final Collection<PluginDownloader> component2() {
            return this.availableDisabledUpdates;
        }

        @NotNull
        public final Collection<IdeaPluginDescriptor> component3() {
            return this.customRepositoryPlugins;
        }

        @Nullable
        public final Collection<IdeaPluginDescriptor> component4() {
            return this.incompatiblePlugins;
        }

        @NotNull
        public final CheckPluginsUpdateResult copy(@Nullable Collection<PluginDownloader> availableUpdates, @NotNull Collection<PluginDownloader> availableDisabledUpdates, @NotNull Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
            Intrinsics.checkNotNullParameter(availableDisabledUpdates, (String)"availableDisabledUpdates");
            Intrinsics.checkNotNullParameter(customRepositoryPlugins, (String)"customRepositoryPlugins");
            return new CheckPluginsUpdateResult(availableUpdates, availableDisabledUpdates, customRepositoryPlugins, incompatiblePlugins);
        }

        public static /* synthetic */ CheckPluginsUpdateResult copy$default(CheckPluginsUpdateResult checkPluginsUpdateResult, Collection collection, Collection collection2, Collection collection3, Collection collection4, int n, Object object) {
            if ((n & 1) != 0) {
                collection = checkPluginsUpdateResult.availableUpdates;
            }
            if ((n & 2) != 0) {
                collection2 = checkPluginsUpdateResult.availableDisabledUpdates;
            }
            if ((n & 4) != 0) {
                collection3 = checkPluginsUpdateResult.customRepositoryPlugins;
            }
            if ((n & 8) != 0) {
                collection4 = checkPluginsUpdateResult.incompatiblePlugins;
            }
            return checkPluginsUpdateResult.copy(collection, collection2, collection3, collection4);
        }

        @NotNull
        public String toString() {
            return "CheckPluginsUpdateResult(availableUpdates=" + this.availableUpdates + ", availableDisabledUpdates=" + this.availableDisabledUpdates + ", customRepositoryPlugins=" + this.customRepositoryPlugins + ", incompatiblePlugins=" + this.incompatiblePlugins + ")";
        }

        public int hashCode() {
            Collection<PluginDownloader> collection = this.availableUpdates;
            Collection<PluginDownloader> collection2 = this.availableDisabledUpdates;
            Collection<IdeaPluginDescriptor> collection3 = this.customRepositoryPlugins;
            Collection<IdeaPluginDescriptor> collection4 = this.incompatiblePlugins;
            return (((collection != null ? ((Object)collection).hashCode() : 0) * 31 + (collection2 != null ? ((Object)collection2).hashCode() : 0)) * 31 + (collection3 != null ? ((Object)collection3).hashCode() : 0)) * 31 + (collection4 != null ? ((Object)collection4).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CheckPluginsUpdateResult)) break block3;
                    CheckPluginsUpdateResult checkPluginsUpdateResult = (CheckPluginsUpdateResult)object;
                    if (!Intrinsics.areEqual(this.availableUpdates, checkPluginsUpdateResult.availableUpdates) || !Intrinsics.areEqual(this.availableDisabledUpdates, checkPluginsUpdateResult.availableDisabledUpdates) || !Intrinsics.areEqual(this.customRepositoryPlugins, checkPluginsUpdateResult.customRepositoryPlugins) || !Intrinsics.areEqual(this.incompatiblePlugins, checkPluginsUpdateResult.incompatiblePlugins)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

