/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginListLayout;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.PluginUpdateResult;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdateDialog
extends DialogWrapper {
    private final Collection<PluginDownloader> myDownloaders;
    private final boolean myPlatformUpdate;
    private final MyPluginModel myPluginModel;
    private final PluginsGroupComponent myPluginsPanel;
    private final PluginsGroup myGroup;
    private final PluginDetailsPageComponent myDetailsPage;
    private final JLabel myTotalLabel;
    private final ActionLink myIgnoreAction;
    @Nullable
    private Runnable myFinishCallback;
    private static Set<String> myIgnoredPluginsWithVersions;

    public PluginUpdateDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> updatedPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins) {
        if (updatedPlugins == null) {
            PluginUpdateDialog.$$$reportNull$$$0(0);
        }
        this(project, updatedPlugins, customRepositoryPlugins, false);
        this.setTitle(IdeBundle.message((String)"dialog.title.plugin.updates", (Object[])new Object[0]));
    }

    PluginUpdateDialog(@NotNull Collection<PluginDownloader> updatedPlugins) {
        if (updatedPlugins == null) {
            PluginUpdateDialog.$$$reportNull$$$0(1);
        }
        this(null, updatedPlugins, null, true);
        this.setTitle(IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
    }

    private PluginUpdateDialog(@Nullable Project project, Collection<PluginDownloader> updatedPlugins, final @Nullable Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins, boolean platformUpdate) {
        super(true);
        this.myGroup = new PluginsGroup("");
        this.myTotalLabel = new JLabel();
        this.myDownloaders = updatedPlugins;
        this.myPlatformUpdate = platformUpdate;
        this.myIgnoreAction = new ActionLink(IdeBundle.message((String)"updates.ignore.updates.button", (Object[])new Object[]{updatedPlugins.size()}), e -> {
            this.close(1);
            PluginUpdateDialog.ignorePlugins(ContainerUtil.map(this.myGroup.ui.plugins, component2 -> component2.getPluginDescriptor()));
        });
        this.myPluginModel = new MyPluginModel(project){

            @Override
            public void runRestartButton(@NotNull Component component2) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginUpdateDialog.this.doOKAction();
            }

            @Override
            @NotNull
            protected Collection<IdeaPluginDescriptor> getCustomRepoPlugins() {
                Collection<Object> collection = customRepositoryPlugins == null ? super.getCustomRepoPlugins() : Collections.unmodifiableCollection(customRepositoryPlugins);
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomRepoPlugins";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "runRestartButton";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myPluginModel.setTopController(Configurable.TopComponentController.EMPTY);
        this.myPluginModel.setPluginUpdatesService(new PluginUpdatesService(){

            @Override
            public void finishUpdate() {
            }
        });
        this.myDetailsPage = new PluginDetailsPageComponent(this.myPluginModel, (LinkListener<Object>)LinkListener.NULL, true);
        this.myDetailsPage.setOnlyUpdateMode();
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        this.myPluginsPanel = new PluginsGroupComponent((LayoutManager)((Object)new PluginListLayout()), eventHandler, (Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent>)((Function)descriptor2 -> this.createListComponent((IdeaPluginDescriptor)descriptor2)));
        PluginManagerConfigurable.registerCopyProvider(this.myPluginsPanel);
        this.myPluginsPanel.setSelectionListener(__ -> {
            List<ListPluginComponent> selection = this.myPluginsPanel.getSelection();
            int size = selection.size();
            this.myDetailsPage.showPlugin(size == 1 ? selection.get(0) : null, size > 1);
        });
        for (PluginDownloader plugin2 : updatedPlugins) {
            this.myGroup.descriptors.add(plugin2.getDescriptor());
        }
        this.myGroup.sortByName();
        this.myPluginsPanel.addGroup(this.myGroup);
        this.setOKButtonText(IdeBundle.message((String)"plugins.configurable.update.button", (Object[])new Object[0]));
        this.updateButtons();
        this.init();
        JRootPane rootPane = this.getPeer().getRootPane();
        if (rootPane != null) {
            rootPane.setPreferredSize((Dimension)new JBDimension(800, 600));
        }
    }

    private void updateButtons() {
        long total = 0L;
        int count = 0;
        for (ListPluginComponent plugin2 : this.myGroup.ui.plugins) {
            if (!plugin2.getChooseUpdateButton().isSelected()) continue;
            ++count;
            try {
                total += Long.parseLong(((PluginNode)plugin2.getPluginDescriptor()).getSize());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String text2 = null;
        if (total > 0L) {
            text2 = IdeBundle.message((String)"plugin.update.dialog.total.label", (Object[])new Object[]{StringUtilRt.formatFileSize((long)total).toUpperCase(Locale.ENGLISH)});
        }
        this.myTotalLabel.setText(text2);
        this.getOKAction().setEnabled(count > 0);
    }

    public void setFinishCallback(@NotNull Runnable finishCallback) {
        if (finishCallback == null) {
            PluginUpdateDialog.$$$reportNull$$$0(2);
        }
        this.myFinishCallback = finishCallback;
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.myPlatformUpdate) {
            return;
        }
        ArrayList<PluginDownloader> toDownloads = new ArrayList<PluginDownloader>();
        int index2 = 0;
        for (PluginDownloader downloader : this.myDownloaders) {
            ListPluginComponent component2;
            if (!(component2 = this.myGroup.ui.plugins.get(index2++)).getChooseUpdateButton().isSelected()) continue;
            toDownloads.add(downloader);
        }
        PluginUpdateDialog.runUpdateAll(toDownloads, this.getContentPanel(), this.myFinishCallback);
    }

    public static void runUpdateAll(final @NotNull Collection<PluginDownloader> toDownloads, final @Nullable JComponent ownerComponent, final @Nullable Runnable finishCallback) {
        if (toDownloads == null) {
            PluginUpdateDialog.$$$reportNull$$$0(3);
        }
        String message2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        new Task.Backgroundable(null, message2, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                List<PluginDownloader> downloaders;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(downloaders = UpdateInstaller.downloadPluginUpdates(toDownloads, indicator)).isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PluginUpdateResult result2 = UpdateInstaller.installDownloadedPluginUpdates(downloaders, ownerComponent, true);
                        if (result2.getPluginsInstalled().size() > 0) {
                            if (result2.getRestartRequired()) {
                                if (WelcomeFrame.getInstance() == null) {
                                    PluginManagerMain.notifyPluginsUpdated(null);
                                } else {
                                    PluginManagerConfigurable.shutdownOrRestartApp();
                                }
                            } else {
                                String message2 = PluginUpdateInfoDialog.notificationText(result2);
                                UpdateChecker.getNotificationGroup().createNotification(message2, NotificationType.INFORMATION).notify(this.myProject);
                            }
                        }
                    });
                }
            }

            public void onFinished() {
                if (finishCallback != null) {
                    finishCallback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$3", "run"));
            }
        }.queue();
    }

    public void doCancelAction() {
        this.close(1);
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        Wrapper panel2 = new Wrapper((JComponent)this.myIgnoreAction);
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return panel2;
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "plugin.update.dialog";
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            PluginUpdateDialog.$$$reportNull$$$0(4);
        }
        return dialogStyle;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog";
    }

    @NotNull
    private ListPluginComponent createListComponent(@NotNull IdeaPluginDescriptor updateDescriptor) {
        if (updateDescriptor == null) {
            PluginUpdateDialog.$$$reportNull$$$0(5);
        }
        ListPluginComponent component2 = new ListPluginComponent(this.myPluginModel, updateDescriptor, (LinkListener<Object>)LinkListener.NULL, true);
        component2.setOnlyUpdateMode();
        component2.getChooseUpdateButton().addActionListener(e -> this.updateButtons());
        ListPluginComponent listPluginComponent = component2;
        if (listPluginComponent == null) {
            PluginUpdateDialog.$$$reportNull$$$0(6);
        }
        return listPluginComponent;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.45f){

            protected Divider createDivider() {
                Divider divider = super.createDivider();
                divider.setBackground(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                return divider;
            }
        };
        this.myGroup.ui.panel.getParent().remove(this.myGroup.ui.panel);
        this.myGroup.ui.panel.setPreferredSize(new Dimension());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add(PluginManagerConfigurable.createScrollPane(this.myPluginsPanel, true));
        OpaquePanel titlePanel = new OpaquePanel((LayoutManager)new BorderLayout(), PluginManagerConfigurable.MAIN_BG_COLOR);
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)13, (int)12));
        leftPanel.add((Component)titlePanel, "South");
        this.myTotalLabel.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
        titlePanel.add((Component)this.myTotalLabel);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)this.myDetailsPage);
        return splitter;
    }

    @NotNull
    private static File getDisabledUpdateFile() {
        return new File(PathManager.getConfigPath(), "plugin_disabled_updates.txt");
    }

    @NotNull
    private static Set<String> getIgnoredPlugins() {
        if (myIgnoredPluginsWithVersions == null) {
            myIgnoredPluginsWithVersions = new HashSet<String>();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file2 = PluginUpdateDialog.getDisabledUpdateFile();
                    if (file2.isFile()) {
                        myIgnoredPluginsWithVersions.addAll(FileUtil.loadLines((File)file2));
                    }
                }
                catch (IOException e) {
                    Logger.getInstance(UpdateChecker.class).error((Throwable)e);
                }
            }
        }
        Set<String> set2 = myIgnoredPluginsWithVersions;
        if (set2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(7);
        }
        return set2;
    }

    static void ignorePlugins(@NotNull List<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(8);
        }
        Set<String> ignoredPlugins = PluginUpdateDialog.getIgnoredPlugins();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            ignoredPlugins.add(PluginUpdateDialog.getIdVersionValue(ideaPluginDescriptor));
        }
        try {
            File file2 = PluginUpdateDialog.getDisabledUpdateFile();
            FileUtil.writeToFile((File)file2, (String)StringUtil.join(ignoredPlugins, (String)LineSeparator.getSystemLineSeparator().getSeparatorString()));
        }
        catch (IOException e) {
            Logger.getInstance(UpdateChecker.class).error((Throwable)e);
        }
        SettingsEntryPointAction.removePluginsUpdate(descriptors2);
    }

    public static boolean isIgnored(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<String> plugins2;
        if (descriptor2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(9);
        }
        if ((plugins2 = PluginUpdateDialog.getIgnoredPlugins()).isEmpty()) {
            return false;
        }
        return plugins2.contains(PluginUpdateDialog.getIdVersionValue(descriptor2));
    }

    @NotNull
    private static String getIdVersionValue(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(10);
        }
        String string = descriptor2.getPluginId().getIdString() + "+" + descriptor2.getVersion();
        if (string == null) {
            PluginUpdateDialog.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDownloads";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createListComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredPlugins";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdVersionValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFinishCallback";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateAll";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createListComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ignorePlugins";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIdVersionValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

