/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.RelayUiToDelegateIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.roots.ui.configuration.SdkLookupContext;
import com.intellij.openapi.roots.ui.configuration.SdkLookupContextEx;
import com.intellij.openapi.roots.ui.configuration.SdkLookupContextEx$WhenMappings;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDownloadDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupImplKt;
import com.intellij.openapi.roots.ui.configuration.SdkLookupParameters;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0002\u001a\u00020\u0006J-\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\bH\u0002J-\u0010\u001a\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\bH\u0002J$\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\u001a\u0010(\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/SdkLookupContextEx;", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupContext;", "lookup", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupParameters;", "(Lcom/intellij/openapi/roots/ui/configuration/SdkLookupParameters;)V", "continueSdkLookupWithSuggestions", "", "rootProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doWaitSdkDownloadToComplete", "Lkotlin/Function0;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "executeFix", "indicator", "possibleFix", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkFixAction;", "resolveDownloadFix", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkDownloadableSdkFix;", "Lorg/jetbrains/annotations/Nullable;", "resolvers", "", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver$UnknownSdkLookup;", "unknownSdk", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdk;", "resolveLocalFix", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "runSdkResolutionUnderProgress", "action", "Lkotlin/Function1;", "testExistingSdk", "testLoadSdkAndWaitIfNeeded", "testSdkAndWaitForDownloadIfNeeded", "toHomePredicate", "Ljava/util/function/Predicate;", "", "sdkHomeFilter", "toVersionPredicate", "versionFilter", "trySdk", "intellij.platform.lang.impl"})
class SdkLookupContextEx
extends SdkLookupContext {
    public final void lookup() {
        Sdk namedSdk;
        Sdk sdk2;
        ProgressIndicator rootProgressIndicator = this.resolveProgressIndicator();
        SdkLookupContextEx sdkLookupContextEx = this;
        boolean bl = false;
        boolean bl2 = false;
        SdkLookupContextEx $this$run = sdkLookupContextEx;
        boolean bl3 = false;
        String string = $this$run.getSdkName();
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            boolean $i$f$runReadAction = false;
            sdk2 = (Sdk)ApplicationManager.getApplication().runReadAction(new Computable<T>($this$run){
                final /* synthetic */ SdkLookupContextEx $this_run$inlined;
                {
                    this.$this_run$inlined = sdkLookupContextEx;
                }

                public final T compute() {
                    boolean bl = false;
                    SdkType sdkType = this.$this_run$inlined.getSdkType();
                    return (T)(sdkType == null ? ProjectJdkTable.getInstance().findJdk(this.$this_run$inlined.getSdkName()) : ProjectJdkTable.getInstance().findJdk(this.$this_run$inlined.getSdkName(), this.$this_run$inlined.getSdkType().getName()));
                }
            });
        } else {
            sdk2 = namedSdk = null;
        }
        if ($this$run.trySdk(namedSdk, rootProgressIndicator)) {
            return;
        }
        for (Sdk sdk3 : SdkDownloadTracker.getInstance().findDownloadingSdks(this.getSdkName())) {
            if (!this.trySdk(sdk3, rootProgressIndicator)) continue;
            return;
        }
        for (Sdk sdk3 : this.getTestSdkSequence()) {
            if (!this.trySdk(sdk3, rootProgressIndicator)) continue;
            return;
        }
        this.continueSdkLookupWithSuggestions(rootProgressIndicator);
    }

    private final boolean trySdk(Sdk sdk2, ProgressIndicator rootProgressIndicator) {
        rootProgressIndicator.checkCanceled();
        if (sdk2 == null) {
            return false;
        }
        return this.testLoadSdkAndWaitIfNeeded(sdk2, rootProgressIndicator);
    }

    private final boolean testLoadSdkAndWaitIfNeeded(Sdk sdk2, ProgressIndicator rootProgressIndicator) {
        if (!this.checkSdkVersion(sdk2)) {
            return false;
        }
        if (this.testSdkAndWaitForDownloadIfNeeded(sdk2, rootProgressIndicator)) {
            return true;
        }
        return this.testExistingSdk(sdk2);
    }

    public final boolean testSdkAndWaitForDownloadIfNeeded(@NotNull Sdk sdk2, @NotNull ProgressIndicator rootProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)rootProgressIndicator, (String)"rootProgressIndicator");
        if (!SdkDownloadTracker.getInstance().isDownloading(sdk2)) {
            return false;
        }
        Function0 action2 = (Function0)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Function0<? extends Boolean>>(this, sdk2, rootProgressIndicator){
            final /* synthetic */ SdkLookupContextEx this$0;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ ProgressIndicator $rootProgressIndicator;

            @NotNull
            public final Function0<Boolean> invoke() {
                Function0<Boolean> function0;
                if (!SdkDownloadTracker.getInstance().isDownloading(this.$sdk)) {
                    return testSdkAndWaitForDownloadIfNeeded.action.1.INSTANCE;
                }
                this.this$0.onSdkNameResolved(this.$sdk);
                switch (SdkLookupContextEx$WhenMappings.$EnumSwitchMapping$0[((SdkLookupDownloadDecision)((Object)this.this$0.getOnDownloadingSdkDetected().invoke((Object)this.$sdk))).ordinal()]) {
                    case 1: {
                        function0 = this.this$0.doWaitSdkDownloadToComplete(this.$sdk, this.$rootProgressIndicator);
                        break;
                    }
                    case 2: {
                        function0 = testSdkAndWaitForDownloadIfNeeded.action.2.INSTANCE;
                        break;
                    }
                    case 3: {
                        function0 = (Function0)new Function0<Boolean>(this){
                            final /* synthetic */ testSdkAndWaitForDownloadIfNeeded.action.1 this$0;

                            public final boolean invoke() {
                                this.this$0.this$0.onSdkResolved(null);
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        };
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return function0;
            }
            {
                this.this$0 = sdkLookupContextEx;
                this.$sdk = sdk2;
                this.$rootProgressIndicator = progressIndicator;
                super(0);
            }
        }), (int)1, null);
        return (Boolean)action2.invoke();
    }

    @NotNull
    public Function0<Boolean> doWaitSdkDownloadToComplete(@NotNull Sdk sdk2, @NotNull ProgressIndicator rootProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)rootProgressIndicator, (String)"rootProgressIndicator");
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        Disposable disposable3 = disposable2;
        Consumer onDownloadCompleted2 = (Consumer)new Consumer<Boolean>(this, disposable3, sdk2){
            final /* synthetic */ SdkLookupContextEx this$0;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ Sdk $sdk;

            public final void consume(Boolean onSucceeded) {
                Sdk sdk2;
                Disposer.dispose((Disposable)this.$disposable);
                Boolean bl = onSucceeded;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"onSucceeded");
                if (bl.booleanValue() && this.this$0.checkSdkHomeAndVersion(this.$sdk)) {
                    sdk2 = this.$sdk;
                } else if (onSucceeded.booleanValue()) {
                    SdkLookupImplKt.access$getLOG$p().warn("Just downloaded SDK: " + this.$sdk + " has failed the checkSdkHomeAndVersion test");
                    sdk2 = null;
                } else {
                    sdk2 = null;
                }
                Sdk finalSdk = sdk2;
                this.this$0.onSdkResolved(finalSdk);
            }
            {
                this.this$0 = sdkLookupContextEx;
                this.$disposable = disposable2;
                this.$sdk = sdk2;
            }
        };
        boolean isDownloading = SdkDownloadTracker.getInstance().tryRegisterDownloadingListener(sdk2, disposable3, rootProgressIndicator, (Consumer<? super Boolean>)onDownloadCompleted2);
        if (!isDownloading) {
            Disposer.dispose((Disposable)disposable3);
            return doWaitSdkDownloadToComplete.1.INSTANCE;
        }
        return doWaitSdkDownloadToComplete.2.INSTANCE;
    }

    public final boolean testExistingSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (!this.checkSdkHomeAndVersion(sdk2)) {
            return false;
        }
        this.onSdkResolved(sdk2);
        return true;
    }

    private final void continueSdkLookupWithSuggestions(ProgressIndicator rootProgressIndicator) {
        if (this.getSdkType() == null) {
            this.onSdkResolved(null);
            return;
        }
        if ((SdkLookupDecision)((Object)this.getOnBeforeSdkSuggestionStarted().invoke()) == SdkLookupDecision.STOP) {
            this.onSdkResolved(null);
            return;
        }
        UnknownSdk unknownSdk2 = new UnknownSdk(this){
            @Nullable
            private final Predicate<String> versionPredicate;
            @Nullable
            private final Predicate<String> homePredicate;
            final /* synthetic */ SdkLookupContextEx this$0;

            @Nullable
            public final Predicate<String> getVersionPredicate() {
                return this.versionPredicate;
            }

            @Nullable
            public final Predicate<String> getHomePredicate() {
                return this.homePredicate;
            }

            @Nullable
            public String getSdkName() {
                return this.this$0.getSdkName();
            }

            @NotNull
            public SdkType getSdkType() {
                return this.this$0.getSdkType();
            }

            @Nullable
            public Predicate<String> getSdkVersionStringPredicate() {
                return this.versionPredicate;
            }

            @Nullable
            public Predicate<String> getSdkHomePredicate() {
                return this.homePredicate;
            }

            @NotNull
            public String toString() {
                Function1<String, Boolean> it;
                boolean bl;
                boolean bl2;
                Function1<String, Boolean> function1;
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl5 = false;
                boolean bl6 = false;
                StringBuilder $this$buildString = stringBuilder;
                boolean bl7 = false;
                $this$buildString.append("SdkLookup{" + this.getSdkType().getPresentableName());
                String string = this.getSdkName();
                if (string != null) {
                    function1 = string;
                    bl2 = false;
                    bl = false;
                    it = function1;
                    boolean bl8 = false;
                    $this$buildString.append(", name=" + (String)it);
                }
                Predicate<String> predicate2 = this.versionPredicate;
                if (predicate2 != null) {
                    function1 = predicate2;
                    bl2 = false;
                    bl = false;
                    it = function1;
                    boolean bl9 = false;
                    $this$buildString.append(", withVersionFilter");
                }
                Function1<String, Boolean> function12 = this.this$0.getSdkHomeFilter();
                if (function12 != null) {
                    function1 = function12;
                    bl2 = false;
                    bl = false;
                    it = function1;
                    boolean bl10 = false;
                    $this$buildString.append(", withSdkHomeFilter");
                }
                $this$buildString.append("}");
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                return string2;
            }
            {
                Predicate predicate2;
                Predicate predicate3;
                Predicate predicate4;
                Function1<String, Boolean> p1;
                continueSdkLookupWithSuggestions.unknownSdk.1 var8_7;
                boolean bl;
                boolean bl2;
                SdkLookupContextEx sdkLookupContextEx;
                Function1<String, Boolean> function1;
                this.this$0 = this$0;
                continueSdkLookupWithSuggestions.unknownSdk.1 v0 = this;
                Function1<String, Boolean> function12 = this$0.getVersionFilter();
                if (function12 != null) {
                    function1 = function12;
                    sdkLookupContextEx = this$0;
                    bl2 = false;
                    bl = false;
                    Function1<String, Boolean> function13 = function1;
                    var8_7 = v0;
                    boolean bl3 = false;
                    predicate4 = SdkLookupContextEx.access$toVersionPredicate(sdkLookupContextEx, (Function1)p1);
                    v0 = var8_7;
                    predicate3 = predicate4;
                } else {
                    predicate3 = null;
                }
                v0.versionPredicate = predicate3;
                continueSdkLookupWithSuggestions.unknownSdk.1 v3 = this;
                Function1<String, Boolean> function14 = this$0.getSdkHomeFilter();
                if (function14 != null) {
                    function1 = function14;
                    sdkLookupContextEx = this$0;
                    bl2 = false;
                    bl = false;
                    p1 = function1;
                    var8_7 = v3;
                    boolean bl4 = false;
                    predicate4 = SdkLookupContextEx.access$toHomePredicate(sdkLookupContextEx, p1);
                    v3 = var8_7;
                    predicate2 = predicate4;
                } else {
                    predicate2 = null;
                }
                v3.homePredicate = predicate2;
            }
        };
        this.runSdkResolutionUnderProgress(rootProgressIndicator, (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this, unknownSdk2){
            final /* synthetic */ SdkLookupContextEx this$0;
            final /* synthetic */ continueSdkLookupWithSuggestions.unknownSdk.1 $unknownSdk;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    void $this$mapNotNullTo$iv$iv;
                    ExtensionPointName<UnknownSdkResolver> extensionPointName = UnknownSdkResolver.EP_NAME;
                    Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"UnknownSdkResolver.EP_NAME");
                    Iterable iterable = extensionPointName.getIterable();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"UnknownSdkResolver.EP_NAME.iterable");
                    Iterable $this$mapNotNull$iv = iterable;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        UnknownSdkResolver.UnknownSdkLookup unknownSdkLookup;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        UnknownSdkResolver it = (UnknownSdkResolver)element$iv$iv;
                        boolean bl2 = false;
                        if (it.createResolver(this.this$0.getProject(), indicator) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        UnknownSdkResolver.UnknownSdkLookup it$iv$iv = unknownSdkLookup;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List resolvers = (List)destination$iv$iv;
                    indicator.checkCanceled();
                    UnknownSdkFixAction possibleFix2 = UnknownMissingSdk.createMissingFixAction(this.$unknownSdk, (Supplier<? extends UnknownSdkLocalSdkFix>)new Supplier<UnknownSdkLocalSdkFix>(this, resolvers, indicator){
                        final /* synthetic */ continueSdkLookupWithSuggestions.1 this$0;
                        final /* synthetic */ List $resolvers;
                        final /* synthetic */ ProgressIndicator $indicator;

                        @Nullable
                        public final UnknownSdkLocalSdkFix get() {
                            return SdkLookupContextEx.access$resolveLocalFix(this.this$0.this$0, this.$resolvers, this.this$0.$unknownSdk, this.$indicator);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$resolvers = list2;
                            this.$indicator = progressIndicator;
                        }
                    }, (Supplier<? extends UnknownSdkDownloadableSdkFix>)new Supplier<UnknownSdkDownloadableSdkFix>(this, resolvers, indicator){
                        final /* synthetic */ continueSdkLookupWithSuggestions.1 this$0;
                        final /* synthetic */ List $resolvers;
                        final /* synthetic */ ProgressIndicator $indicator;

                        @Nullable
                        public final UnknownSdkDownloadableSdkFix get() {
                            return SdkLookupContextEx.access$resolveDownloadFix(this.this$0.this$0, this.$resolvers, this.this$0.$unknownSdk, this.$indicator);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$resolvers = list2;
                            this.$indicator = progressIndicator;
                        }
                    });
                    if (possibleFix2 == null) {
                        this.this$0.onSdkResolved(null);
                        return;
                    }
                    Sdk sdkPrototype = possibleFix2.getRegisteredSdkPrototype();
                    if (sdkPrototype != null) {
                        boolean $i$f$runReadAction = false;
                        Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(){

                            public final T compute() {
                                boolean bl = false;
                                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                                Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
                                return (T)projectJdkTable.getAllJdks();
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { ProjectJ\u2026e.getInstance().allJdks }");
                        if (ArraysKt.contains((Object[])((Object[])object), (Object)sdkPrototype)) {
                            if (SdkLookupContextEx.access$testLoadSdkAndWaitIfNeeded(this.this$0, sdkPrototype, indicator)) {
                                return;
                            }
                            SdkLookupImplKt.access$getLOG$p().warn("The matched local SDK " + possibleFix2 + " does not pass our filters in " + this.this$0);
                            this.this$0.onSdkResolved(null);
                            return;
                        }
                    }
                    if ((SdkLookupDecision)((Object)this.this$0.getOnSdkFixResolved().invoke((Object)possibleFix2)) != SdkLookupDecision.CONTINUE) {
                        this.this$0.onSdkResolved(null);
                        return;
                    }
                    possibleFix2.addSuggestionListener(this.this$0.getFixListener(possibleFix2));
                    this.this$0.executeFix(indicator, possibleFix2);
                }
                catch (ProcessCanceledException e) {
                    this.this$0.onSdkResolved(null);
                    throw (Throwable)e;
                }
                catch (Throwable t) {
                    SdkLookupImplKt.access$getLOG$p().warn("Failed to resolve SDK for " + this.this$0 + ". " + t.getMessage(), t);
                    this.this$0.onSdkResolved(null);
                }
            }
            {
                this.this$0 = sdkLookupContextEx;
                this.$unknownSdk = var2_2;
                super(1);
            }
        }));
    }

    private final Predicate<String> toHomePredicate(Function1<? super String, Boolean> sdkHomeFilter) {
        return new Predicate<String>(sdkHomeFilter){
            final /* synthetic */ Function1 $sdkHomeFilter;

            public boolean test(@NotNull String t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return (Boolean)this.$sdkHomeFilter.invoke((Object)t);
            }

            @NotNull
            public String toString() {
                return this.$sdkHomeFilter.toString();
            }
            {
                this.$sdkHomeFilter = $captured_local_variable$0;
            }
        };
    }

    private final Predicate<String> toVersionPredicate(Function1<? super String, Boolean> versionFilter) {
        return new Predicate<String>(versionFilter){
            final /* synthetic */ Function1 $versionFilter;

            public boolean test(@NotNull String t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return (Boolean)this.$versionFilter.invoke((Object)t);
            }

            @NotNull
            public String toString() {
                return this.$versionFilter.toString();
            }
            {
                this.$versionFilter = $captured_local_variable$0;
            }
        };
    }

    public void executeFix(@NotNull ProgressIndicator indicator, @NotNull UnknownSdkFixAction possibleFix2) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)possibleFix2, (String)"possibleFix");
        possibleFix2.applySuggestionAsync(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UnknownSdkLocalSdkFix resolveLocalFix(List<? extends UnknownSdkResolver.UnknownSdkLookup> resolvers, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        UnknownSdkLocalSdkFix unknownSdkLocalSdkFix;
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
            unknownSdkLocalSdkFix = (UnknownSdkLocalSdkFix)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)resolvers), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, Unit>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator$inlined.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, UnknownSdkLocalSdkFix>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                @Nullable
                public final UnknownSdkLocalSdkFix invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.proposeLocalFix(this.$unknownSdk$inlined, this.$indicator$inlined);
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Boolean>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1<String, Boolean> function1 = this.this$0.getVersionFilter();
                    if (function1 == null) return true;
                    String string = it.getVersionString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.versionString");
                    if ((Boolean)function1.invoke((Object)string) == false) return false;
                    return true;
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Boolean>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1<String, Boolean> function1 = this.this$0.getSdkHomeFilter();
                    if (function1 == null) return true;
                    String string = it.getExistingSdkHome();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.existingSdkHome");
                    if ((Boolean)function1.invoke((Object)string) == false) return false;
                    return true;
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Unit>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator$inlined.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkLocalSdkFix, Boolean>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                public final boolean invoke(@NotNull UnknownSdkLocalSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (SdkLookupDecision)((Object)this.this$0.getOnLocalSdkSuggested().invoke((Object)it)) == SdkLookupDecision.CONTINUE;
                }
            })));
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        return unknownSdkLocalSdkFix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UnknownSdkDownloadableSdkFix resolveDownloadFix(List<? extends UnknownSdkResolver.UnknownSdkLookup> resolvers, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        UnknownSdkDownloadableSdkFix unknownSdkDownloadableSdkFix;
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
            unknownSdkDownloadableSdkFix = (UnknownSdkDownloadableSdkFix)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)resolvers), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, Unit>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator$inlined.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkResolver.UnknownSdkLookup, UnknownSdkDownloadableSdkFix>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                @Nullable
                public final UnknownSdkDownloadableSdkFix invoke(@NotNull UnknownSdkResolver.UnknownSdkLookup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.proposeDownload(this.$unknownSdk$inlined, this.$indicator$inlined);
                }
            })), (Function1)((Function1)new Function1<UnknownSdkDownloadableSdkFix, Boolean>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull UnknownSdkDownloadableSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Function1<String, Boolean> function1 = this.this$0.getVersionFilter();
                    if (function1 == null) return true;
                    String string = it.getVersionString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.versionString");
                    if ((Boolean)function1.invoke((Object)string) == false) return false;
                    return true;
                }
            })), (Function1)((Function1)new Function1<UnknownSdkDownloadableSdkFix, Unit>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                public final void invoke(@NotNull UnknownSdkDownloadableSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$indicator$inlined.checkCanceled();
                }
            })), (Function1)((Function1)new Function1<UnknownSdkDownloadableSdkFix, Boolean>(this, indicator, resolvers, unknownSdk2){
                final /* synthetic */ SdkLookupContextEx this$0;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ List $resolvers$inlined;
                final /* synthetic */ UnknownSdk $unknownSdk$inlined;
                {
                    this.this$0 = sdkLookupContextEx;
                    this.$indicator$inlined = progressIndicator;
                    this.$resolvers$inlined = list2;
                    this.$unknownSdk$inlined = unknownSdk2;
                    super(1);
                }

                public final boolean invoke(@NotNull UnknownSdkDownloadableSdkFix it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (SdkLookupDecision)((Object)this.this$0.getOnDownloadableSdkSuggested().invoke((Object)it)) == SdkLookupDecision.CONTINUE;
                }
            })));
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        return unknownSdkDownloadableSdkFix;
    }

    public void runSdkResolutionUnderProgress(@NotNull ProgressIndicator rootProgressIndicator, @NotNull Function1<? super ProgressIndicator, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)rootProgressIndicator, (String)"rootProgressIndicator");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Object object = this.getSdkType();
        if (object == null || (object = object.getPresentableName()) == null) {
            object = ProjectBundle.message((String)"sdk", (Object[])new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sdkType?.presentableName\u2026jectBundle.message(\"sdk\")");
        Object sdkTypeName = object;
        String string = this.getProgressMessageTitle();
        if (string == null) {
            String string2 = ProjectBundle.message((String)"sdk.lookup.resolving.sdk.progress", (Object[])new Object[]{sdkTypeName});
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProjectBundle.message(\"s\u2026k.progress\", sdkTypeName)");
        }
        String title = string;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, rootProgressIndicator, action2, title, this.getProject(), title, true, Task.Backgroundable.ALWAYS_BACKGROUND){
            final /* synthetic */ SdkLookupContextEx this$0;
            final /* synthetic */ ProgressIndicator $rootProgressIndicator;
            final /* synthetic */ Function1 $action;
            final /* synthetic */ String $title;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void parentProgress$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator progressIndicator = this.$rootProgressIndicator;
                Function1 action$iv = this.$action;
                boolean $i$f$runUnderNestedProgressAndRelayMessages = false;
                Function1 action$iv2 = (Function1)new Function1<ProgressIndicator, Unit>(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = function1;
                        super(1);
                    }

                    public final Unit invoke(@NotNull ProgressIndicator it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$action.invoke((Object)it);
                    }
                };
                if (parentProgress$iv instanceof AbstractProgressIndicatorExBase) {
                    AbstractProgressIndicatorExBase delegate$iv$iv = new RelayUiToDelegateIndicator(indicator);
                    boolean $i$f$runWithStateDelegate = false;
                    ((AbstractProgressIndicatorExBase)parentProgress$iv).addStateDelegate(delegate$iv$iv);
                    try {
                        Object object;
                        void cancelOf$iv$iv;
                        boolean bl = false;
                        ProgressIndicator progressIndicator2 = indicator;
                        void cancels$iv$iv = parentProgress$iv;
                        boolean $i$f$runUnderBoundCancellation = false;
                        Function0 action$iv$iv = (Function0)new Function0<Unit>(indicator, (ProgressIndicator)parentProgress$iv, action$iv2){
                            final /* synthetic */ ProgressIndicator $childProgress$inlined;
                            final /* synthetic */ ProgressIndicator $parentProgress$inlined;
                            final /* synthetic */ Function1 $action$inlined;
                            {
                                this.$childProgress$inlined = progressIndicator;
                                this.$parentProgress$inlined = progressIndicator2;
                                this.$action$inlined = function1;
                                super(0);
                            }

                            public final Unit invoke() {
                                boolean bl = false;
                                return this.$action$inlined.invoke((Object)this.$parentProgress$inlined);
                            }
                        };
                        if (!(cancelOf$iv$iv instanceof AbstractProgressIndicatorExBase)) {
                            object = action$iv$iv.invoke();
                        } else {
                            AbstractProgressIndicatorExBase relay$iv$iv = new AbstractProgressIndicatorExBase((ProgressIndicator)cancels$iv$iv){
                                final /* synthetic */ ProgressIndicator $cancels;
                                {
                                    this.$cancels = $captured_local_variable$0;
                                }

                                public void cancel() {
                                    super.cancel();
                                    this.$cancels.cancel();
                                }
                            };
                            boolean $i$f$runWithStateDelegate2 = false;
                            ((AbstractProgressIndicatorExBase)cancelOf$iv$iv).addStateDelegate(relay$iv$iv);
                            try {
                                Object object2 = action$iv$iv.invoke();
                                object = object2;
                            }
                            finally {
                                ((AbstractProgressIndicatorExBase)cancelOf$iv$iv).removeStateDelegate(relay$iv$iv);
                            }
                        }
                        Object object3 = object;
                    }
                    finally {
                        ((AbstractProgressIndicatorExBase)parentProgress$iv).removeStateDelegate(delegate$iv$iv);
                    }
                }
                if (indicator instanceof AbstractProgressIndicatorExBase) {
                    AbstractProgressIndicatorExBase delegate$iv$iv = new RelayUiToDelegateIndicator((ProgressIndicator)parentProgress$iv);
                    boolean $i$f$runWithStateDelegate = false;
                    ((AbstractProgressIndicatorExBase)indicator).addStateDelegate(delegate$iv$iv);
                    try {
                        Object object;
                        boolean bl = false;
                        void cancelOf$iv$iv = parentProgress$iv;
                        ProgressIndicator cancels$iv$iv = indicator;
                        boolean $i$f$runUnderBoundCancellation = false;
                        Function0 action$iv$iv = (Function0)new Function0<Unit>((ProgressIndicator)parentProgress$iv, indicator, action$iv2){
                            final /* synthetic */ ProgressIndicator $parentProgress$inlined;
                            final /* synthetic */ ProgressIndicator $childProgress$inlined;
                            final /* synthetic */ Function1 $action$inlined;
                            {
                                this.$parentProgress$inlined = progressIndicator;
                                this.$childProgress$inlined = progressIndicator2;
                                this.$action$inlined = function1;
                                super(0);
                            }

                            public final Unit invoke() {
                                boolean bl = false;
                                return this.$action$inlined.invoke((Object)this.$childProgress$inlined);
                            }
                        };
                        if (!(cancelOf$iv$iv instanceof AbstractProgressIndicatorExBase)) {
                            object = action$iv$iv.invoke();
                        } else {
                            AbstractProgressIndicatorExBase relay$iv$iv = new AbstractProgressIndicatorExBase(cancels$iv$iv){
                                final /* synthetic */ ProgressIndicator $cancels;
                                {
                                    this.$cancels = $captured_local_variable$0;
                                }

                                public void cancel() {
                                    super.cancel();
                                    this.$cancels.cancel();
                                }
                            };
                            boolean $i$f$runWithStateDelegate3 = false;
                            ((AbstractProgressIndicatorExBase)cancelOf$iv$iv).addStateDelegate(relay$iv$iv);
                            try {
                                Object object4 = action$iv$iv.invoke();
                                object = object4;
                            }
                            finally {
                                ((AbstractProgressIndicatorExBase)cancelOf$iv$iv).removeStateDelegate(relay$iv$iv);
                            }
                        }
                        Object object5 = object;
                    }
                    finally {
                        ((AbstractProgressIndicatorExBase)indicator).removeStateDelegate(delegate$iv$iv);
                    }
                }
                action$iv2.invoke((Object)indicator);
            }
            {
                this.this$0 = this$0;
                this.$rootProgressIndicator = $captured_local_variable$1;
                this.$action = $captured_local_variable$2;
                this.$title = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        });
    }

    public SdkLookupContextEx(@NotNull SdkLookupParameters lookup2) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        super(lookup2);
    }

    public static final /* synthetic */ Predicate access$toVersionPredicate(SdkLookupContextEx $this, Function1 versionFilter) {
        return $this.toVersionPredicate((Function1<? super String, Boolean>)versionFilter);
    }

    public static final /* synthetic */ Predicate access$toHomePredicate(SdkLookupContextEx $this, Function1 sdkHomeFilter) {
        return $this.toHomePredicate((Function1<? super String, Boolean>)sdkHomeFilter);
    }

    public static final /* synthetic */ UnknownSdkLocalSdkFix access$resolveLocalFix(SdkLookupContextEx $this, List resolvers, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        return $this.resolveLocalFix(resolvers, unknownSdk2, indicator);
    }

    public static final /* synthetic */ UnknownSdkDownloadableSdkFix access$resolveDownloadFix(SdkLookupContextEx $this, List resolvers, UnknownSdk unknownSdk2, ProgressIndicator indicator) {
        return $this.resolveDownloadFix(resolvers, unknownSdk2, indicator);
    }

    public static final /* synthetic */ boolean access$testLoadSdkAndWaitIfNeeded(SdkLookupContextEx $this, Sdk sdk2, ProgressIndicator rootProgressIndicator) {
        return $this.testLoadSdkAndWaitIfNeeded(sdk2, rootProgressIndicator);
    }
}

