/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ui.configuration.SdkDetector;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Producer;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkListModelBuilder {
    @Nullable
    private final Project myProject;
    @NotNull
    private final ProjectSdksModel mySdkModel;
    @NotNull
    private final Condition<? super Sdk> mySdkFilter;
    @NotNull
    private final Condition<? super SdkTypeId> mySdkTypeFilter;
    @NotNull
    private final Condition<? super SdkTypeId> mySdkTypeCreationFilter;
    @NotNull
    private final Condition<? super SdkListItem.SuggestedItem> mySuggestedItemsFilter;
    @NotNull
    private final Condition<? super SdkListItem.ActionRole> myActionRoleFilter;
    @NotNull
    private final EventDispatcher<ModelListener> myModelListener;
    private boolean mySuggestedItemsConnected;
    private boolean myIsSdkDetectorInProgress;
    private ImmutableList<SdkListItem.SdkItem> myHead;
    private ImmutableList<SdkListItem.ActionItem> myDownloadActions;
    private ImmutableList<SdkListItem.ActionItem> myAddActions;
    private ImmutableList<SdkListItem.SuggestedItem> mySuggestions;
    private SdkListItem.ProjectSdkItem myProjectSdkItem;
    private SdkListItem.NoneSdkItem myNoneSdkItem;
    private SdkListItem.InvalidSdkItem myInvalidItem;
    private ImmutableList<SdkListItem.SdkReferenceItem> myReferenceItems;

    public SdkListModelBuilder(@Nullable Project project, @NotNull ProjectSdksModel sdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter2, @Nullable Condition<? super SdkTypeId> sdkTypeCreationFilter2, @Nullable Condition<? super Sdk> sdkFilter) {
        if (sdkModel == null) {
            SdkListModelBuilder.$$$reportNull$$$0(0);
        }
        this(project, sdkModel, sdkTypeFilter2, sdkTypeCreationFilter2, sdkFilter, null, null);
    }

    public SdkListModelBuilder(@Nullable Project project, @NotNull ProjectSdksModel sdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter2, @Nullable Condition<? super SdkTypeId> sdkTypeCreationFilter2, @Nullable Condition<? super Sdk> sdkFilter, @Nullable Condition<? super SdkListItem.SuggestedItem> suggestedSdkFilter, @Nullable Condition<? super SdkListItem.ActionRole> actionRoleFilter) {
        if (sdkModel == null) {
            SdkListModelBuilder.$$$reportNull$$$0(1);
        }
        this.myModelListener = EventDispatcher.create(ModelListener.class);
        this.mySuggestedItemsConnected = false;
        this.myIsSdkDetectorInProgress = false;
        this.myHead = ImmutableList.of();
        this.myDownloadActions = ImmutableList.of();
        this.myAddActions = ImmutableList.of();
        this.mySuggestions = ImmutableList.of();
        this.myProjectSdkItem = null;
        this.myNoneSdkItem = null;
        this.myInvalidItem = null;
        this.myReferenceItems = ImmutableList.of();
        this.myProject = project;
        this.mySdkModel = sdkModel;
        this.mySdkTypeFilter = type -> type != null && (sdkTypeFilter2 == null || sdkTypeFilter2.value(type));
        Condition simpleJavaTypeFix = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists();
        this.mySdkTypeCreationFilter = type -> !(type == null || type instanceof SdkType && !((SdkType)type).allowCreationByUser() || !this.mySdkTypeFilter.value(type) || sdkTypeCreationFilter2 != null && !sdkTypeCreationFilter2.value(type) || !simpleJavaTypeFix.value(type));
        this.mySdkFilter = sdk2 -> sdk2 != null && this.mySdkTypeFilter.value((Object)sdk2.getSdkType()) && (sdkFilter == null || sdkFilter.value(sdk2));
        this.mySuggestedItemsFilter = item -> item != null && this.mySdkTypeCreationFilter.value((Object)item.sdkType) && (suggestedSdkFilter == null || suggestedSdkFilter.value(item));
        this.myActionRoleFilter = role -> actionRoleFilter == null || actionRoleFilter.value((Object)role);
    }

    public void addModelListener(@NotNull ModelListener listener2) {
        if (listener2 == null) {
            SdkListModelBuilder.$$$reportNull$$$0(2);
        }
        this.myModelListener.addListener((EventListener)listener2);
    }

    public void removeListener(@NotNull ModelListener listener2) {
        if (listener2 == null) {
            SdkListModelBuilder.$$$reportNull$$$0(3);
        }
        this.myModelListener.removeListener((EventListener)listener2);
    }

    @NotNull
    public SdkListItem.SdkReferenceItem addSdkReferenceItem(@NotNull SdkType type, @NotNull String name, @Nullable String versionString, boolean isValid) {
        if (type == null) {
            SdkListModelBuilder.$$$reportNull$$$0(4);
        }
        if (name == null) {
            SdkListModelBuilder.$$$reportNull$$$0(5);
        }
        SdkListItem.SdkReferenceItem element2 = new SdkListItem.SdkReferenceItem(type, name, versionString, isValid);
        this.removeSdkReferenceItem(element2);
        ImmutableList.Builder builder2 = ImmutableList.builder();
        builder2.addAll(this.myReferenceItems);
        builder2.add((Object)element2);
        this.myReferenceItems = builder2.build();
        this.syncModel();
        SdkListItem.SdkReferenceItem sdkReferenceItem = element2;
        if (sdkReferenceItem == null) {
            SdkListModelBuilder.$$$reportNull$$$0(6);
        }
        return sdkReferenceItem;
    }

    public void removeSdkReferenceItem(@NotNull SdkListItem.SdkReferenceItem item) {
        if (item == null) {
            SdkListModelBuilder.$$$reportNull$$$0(7);
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (SdkListItem.SdkReferenceItem element2 : this.myReferenceItems) {
            if (Objects.equals(element2, item)) continue;
            builder2.add((Object)element2);
        }
        this.myReferenceItems = builder2.build();
        this.syncModel();
    }

    @NotNull
    private SdkListModel syncModel() {
        SdkListModel model2 = this.buildModel();
        ((ModelListener)this.myModelListener.getMulticaster()).syncModel(model2);
        SdkListModel sdkListModel = model2;
        if (sdkListModel == null) {
            SdkListModelBuilder.$$$reportNull$$$0(8);
        }
        return sdkListModel;
    }

    @NotNull
    public SdkListModel buildModel() {
        Sdk projectSdk;
        ImmutableList.Builder newModel = ImmutableList.builder();
        if (this.myNoneSdkItem != null) {
            newModel.add((Object)this.myNoneSdkItem);
        }
        if (this.myProjectSdkItem != null && ((projectSdk = this.mySdkModel.getProjectSdk()) == null || this.mySdkFilter.value((Object)projectSdk))) {
            newModel.add((Object)this.myProjectSdkItem);
        }
        if (this.myInvalidItem != null) {
            newModel.add((Object)this.myInvalidItem);
        }
        newModel.addAll(this.myReferenceItems);
        newModel.addAll(this.myHead);
        ImmutableList subItems = ImmutableList.builder().addAll(this.myDownloadActions).addAll(this.myAddActions).build();
        if (subItems.size() > 3 && !newModel.build().isEmpty()) {
            newModel.add((Object)new SdkListItem.GroupItem(AllIcons.General.Add, ProjectBundle.message((String)"combobox.item.add.sdk", (Object[])new Object[0]), (List<SdkListItem.ActionItem>)subItems));
        } else {
            newModel.addAll((Iterable)subItems);
        }
        for (SdkListItem.SuggestedItem item : this.mySuggestions) {
            if (!this.isApplicableSuggestedItem(item)) continue;
            newModel.add((Object)item);
        }
        return new SdkListModel(this.myIsSdkDetectorInProgress, (List<? extends SdkListItem>)newModel.build(), (Producer<? extends Sdk>)((Producer)() -> this.mySdkModel.getProjectSdk()));
    }

    private boolean isApplicableSuggestedItem(@NotNull SdkListItem.SuggestedItem item) {
        if (item == null) {
            SdkListModelBuilder.$$$reportNull$$$0(9);
        }
        if (!this.mySdkTypeFilter.value((Object)item.sdkType)) {
            return false;
        }
        for (Sdk sdk2 : this.mySdkModel.getSdks()) {
            if (!FileUtil.pathsEqual((String)sdk2.getHomePath(), (String)item.homePath)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public SdkListItem showProjectSdkItem() {
        SdkListItem.ProjectSdkItem projectSdkItem = new SdkListItem.ProjectSdkItem();
        if (Objects.equals(this.myProjectSdkItem, projectSdkItem)) {
            SdkListItem.ProjectSdkItem projectSdkItem2 = this.myProjectSdkItem;
            if (projectSdkItem2 == null) {
                SdkListModelBuilder.$$$reportNull$$$0(10);
            }
            return projectSdkItem2;
        }
        this.myProjectSdkItem = projectSdkItem;
        this.syncModel();
        SdkListItem.ProjectSdkItem projectSdkItem3 = this.myProjectSdkItem;
        if (projectSdkItem3 == null) {
            SdkListModelBuilder.$$$reportNull$$$0(11);
        }
        return projectSdkItem3;
    }

    @NotNull
    public SdkListItem showNoneSdkItem() {
        SdkListItem.NoneSdkItem noneSdkItem = new SdkListItem.NoneSdkItem();
        if (Objects.equals(this.myNoneSdkItem, noneSdkItem)) {
            SdkListItem.NoneSdkItem noneSdkItem2 = this.myNoneSdkItem;
            if (noneSdkItem2 == null) {
                SdkListModelBuilder.$$$reportNull$$$0(12);
            }
            return noneSdkItem2;
        }
        this.myNoneSdkItem = noneSdkItem;
        this.syncModel();
        SdkListItem.NoneSdkItem noneSdkItem3 = this.myNoneSdkItem;
        if (noneSdkItem3 == null) {
            SdkListModelBuilder.$$$reportNull$$$0(13);
        }
        return noneSdkItem3;
    }

    @NotNull
    public SdkListItem showInvalidSdkItem(@NotNull String name) {
        SdkListItem.InvalidSdkItem invalidItem;
        if (name == null) {
            SdkListModelBuilder.$$$reportNull$$$0(14);
        }
        if (Objects.equals(this.myInvalidItem, invalidItem = new SdkListItem.InvalidSdkItem(name))) {
            SdkListItem.InvalidSdkItem invalidSdkItem = this.myInvalidItem;
            if (invalidSdkItem == null) {
                SdkListModelBuilder.$$$reportNull$$$0(15);
            }
            return invalidSdkItem;
        }
        this.myInvalidItem = invalidItem;
        this.syncModel();
        SdkListItem.InvalidSdkItem invalidSdkItem = this.myInvalidItem;
        if (invalidSdkItem == null) {
            SdkListModelBuilder.$$$reportNull$$$0(16);
        }
        return invalidSdkItem;
    }

    public void reloadSdks() {
        ImmutableList.Builder newHead = new ImmutableList.Builder();
        for (Sdk sdk2 : SdkListModelBuilder.sortSdks(this.mySdkModel.getSdks())) {
            if (!this.mySdkFilter.value((Object)sdk2)) continue;
            newHead.add((Object)this.newSdkItem(sdk2));
        }
        this.myHead = newHead.build();
        this.syncModel();
    }

    @NotNull
    private SdkListItem.SdkItem newSdkItem(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SdkListModelBuilder.$$$reportNull$$$0(17);
        }
        return new SdkListItem.SdkItem(sdk2){

            @Override
            boolean hasSameSdk(@NotNull Sdk value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Objects.equals(this.sdk, value2) || Objects.equals(SdkListModelBuilder.this.mySdkModel.findSdk(this.sdk), value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/roots/ui/configuration/SdkListModelBuilder$1", "hasSameSdk"));
            }
        };
    }

    public boolean executeAction(@NotNull JComponent parent, @NotNull SdkListItem item, @NotNull Consumer<? super SdkListItem> afterExecution) {
        if (parent == null) {
            SdkListModelBuilder.$$$reportNull$$$0(18);
        }
        if (item == null) {
            SdkListModelBuilder.$$$reportNull$$$0(19);
        }
        if (afterExecution == null) {
            SdkListModelBuilder.$$$reportNull$$$0(20);
        }
        Consumer onNewSdkAdded = sdk2 -> {
            this.reloadSdks();
            SdkListItem.SdkItem sdkItem = this.newSdkItem((Sdk)sdk2);
            afterExecution.consume((Object)sdkItem);
        };
        if (item instanceof SdkListItem.ActionItem) {
            ProjectSdksModel.NewSdkAction action2 = ((SdkListItem.ActionItem)item).action;
            action2.actionPerformed(null, parent, (Consumer<? super Sdk>)onNewSdkAdded);
            return true;
        }
        if (item instanceof SdkListItem.SuggestedItem) {
            SdkListItem.SuggestedItem suggestedItem = (SdkListItem.SuggestedItem)item;
            final String homePath = suggestedItem.homePath;
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, ProjectBundle.message((String)"progress.title.jdk.combo.box.resolving.jdk.home", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setText(ProjectBundle.message((String)"progress.text.jdk.combo.box.resolving.jdk.home", (Object[])new Object[]{StringUtil.trimMiddle((String)homePath, (int)50)}));
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (File[])new File[]{new File(homePath)});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/SdkListModelBuilder$2", "run"));
                }
            });
            this.mySdkModel.addSdk(suggestedItem.sdkType, homePath, (Consumer<? super Sdk>)onNewSdkAdded);
            return true;
        }
        return false;
    }

    public void processSelectedElement(@NotNull JComponent parent, @NotNull SdkListItem item, @NotNull Consumer<? super SdkListItem> afterNewItemAdded, @NotNull Consumer<? super SdkListItem> onSelectableItem) {
        if (parent == null) {
            SdkListModelBuilder.$$$reportNull$$$0(21);
        }
        if (item == null) {
            SdkListModelBuilder.$$$reportNull$$$0(22);
        }
        if (afterNewItemAdded == null) {
            SdkListModelBuilder.$$$reportNull$$$0(23);
        }
        if (onSelectableItem == null) {
            SdkListModelBuilder.$$$reportNull$$$0(24);
        }
        if (!this.executeAction(parent, item, afterNewItemAdded)) {
            onSelectableItem.consume((Object)item);
        }
    }

    public void reloadActions() {
        Map<SdkType, ProjectSdksModel.NewSdkAction> downloadActions = this.mySdkModel.createDownloadActions(this.mySdkTypeCreationFilter);
        Map<SdkType, ProjectSdksModel.NewSdkAction> addActions = this.mySdkModel.createAddActions(this.mySdkTypeCreationFilter);
        this.myDownloadActions = this.createActions(SdkListItem.ActionRole.DOWNLOAD, downloadActions);
        this.myAddActions = this.createActions(SdkListItem.ActionRole.ADD, addActions);
        this.syncModel();
    }

    public void detectItems(@NotNull JComponent parent, @NotNull Disposable lifetime) {
        if (parent == null) {
            SdkListModelBuilder.$$$reportNull$$$0(25);
        }
        if (lifetime == null) {
            SdkListModelBuilder.$$$reportNull$$$0(26);
        }
        if (this.mySuggestedItemsConnected) {
            return;
        }
        this.mySuggestedItemsConnected = true;
        SdkDetector.getInstance().getDetectedSdksWithUpdate(this.myProject, lifetime, ModalityState.stateForComponent((Component)parent), new SdkDetector.DetectedSdkListener(){

            @Override
            public void onSearchStarted() {
                SdkListModelBuilder.this.mySuggestions = ImmutableList.of();
                SdkListModelBuilder.this.myIsSdkDetectorInProgress = true;
                SdkListModelBuilder.this.syncModel();
            }

            @Override
            public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home2) {
                SdkListItem.SuggestedItem item;
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (version2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (home2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!SdkListModelBuilder.this.mySuggestedItemsFilter.value((Object)(item = new SdkListItem.SuggestedItem(type, version2, home2)))) {
                    return;
                }
                SdkListModelBuilder.this.mySuggestions = ImmutableList.builder().addAll(SdkListModelBuilder.this.mySuggestions).add((Object)item).build();
                SdkListModelBuilder.this.syncModel();
            }

            @Override
            public void onSearchCompleted() {
                SdkListModelBuilder.this.myIsSdkDetectorInProgress = false;
                SdkListModelBuilder.this.syncModel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "version";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "home";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/SdkListModelBuilder$3";
                objectArray[2] = "onSdkDetected";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private ImmutableList<SdkListItem.ActionItem> createActions(@NotNull SdkListItem.ActionRole role, @NotNull Map<SdkType, ProjectSdksModel.NewSdkAction> actions) {
        if (role == null) {
            SdkListModelBuilder.$$$reportNull$$$0(27);
        }
        if (actions == null) {
            SdkListModelBuilder.$$$reportNull$$$0(28);
        }
        if (!this.myActionRoleFilter.value((Object)role)) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                SdkListModelBuilder.$$$reportNull$$$0(29);
            }
            return immutableList;
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (ProjectSdksModel.NewSdkAction action2 : actions.values()) {
            builder2.add((Object)new SdkListItem.ActionItem(role, action2, null));
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            SdkListModelBuilder.$$$reportNull$$$0(30);
        }
        return immutableList;
    }

    private static Sdk @NotNull [] sortSdks(Sdk @NotNull [] sdks) {
        if (sdks == null) {
            SdkListModelBuilder.$$$reportNull$$$0(31);
        }
        Sdk[] clone = (Sdk[])sdks.clone();
        Arrays.sort(clone, (sdk1, sdk2) -> {
            SdkType sdkType2;
            SdkType sdkType1 = (SdkType)sdk1.getSdkType();
            return !sdkType1.equals((Object)(sdkType2 = (SdkType)sdk2.getSdkType())) ? StringUtil.compare((String)sdkType1.getPresentableName(), (String)sdkType2.getPresentableName(), (boolean)true) : sdkType1.getComparator().compare(sdk1, sdk2);
        });
        if (clone == null) {
            SdkListModelBuilder.$$$reportNull$$$0(32);
        }
        return clone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListModelBuilder";
                break;
            }
            case 7: 
            case 9: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterExecution";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterNewItemAdded";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelectableItem";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lifetime";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListModelBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addSdkReferenceItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "syncModel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "showProjectSdkItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "showNoneSdkItem";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "showInvalidSdkItem";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sortSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSdkReferenceItem";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSdkReferenceItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableSuggestedItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showInvalidSdkItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newSdkItem";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "detectItems";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sortSdks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 29: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ModelListener
    extends EventListener {
        default public void syncModel(@NotNull SdkListModel model2) {
            if (model2 == null) {
                ModelListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/ui/configuration/SdkListModelBuilder$ModelListener", "syncModel"));
        }
    }
}

