/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkDetector {
    private static final Logger LOG = Logger.getInstance(SdkDetector.class);
    private final AtomicBoolean myIsRunning = new AtomicBoolean(false);
    private final Object myPublicationLock = new Object();
    private final Set<DetectedSdkListener> myListeners = new HashSet<DetectedSdkListener>();
    private final List<Consumer<? super DetectedSdkListener>> myDetectedResults = new ArrayList<Consumer<? super DetectedSdkListener>>();
    private final DetectedSdkListener myMulticaster = new DetectedSdkListener(){

        void logEvent(@NotNull Consumer<? super DetectedSdkListener> e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            SdkDetector.this.myDetectedResults.add(e);
            for (DetectedSdkListener listener2 : SdkDetector.this.myListeners) {
                e.accept(listener2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSearchStarted() {
            Object object = SdkDetector.this.myPublicationLock;
            synchronized (object) {
                SdkDetector.this.myDetectedResults.clear();
                this.logEvent(listener2 -> listener2.onSearchStarted());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home2) {
            if (type == null) {
                1.$$$reportNull$$$0(1);
            }
            if (version2 == null) {
                1.$$$reportNull$$$0(2);
            }
            if (home2 == null) {
                1.$$$reportNull$$$0(3);
            }
            Object object = SdkDetector.this.myPublicationLock;
            synchronized (object) {
                this.logEvent(listener2 -> listener2.onSdkDetected(type, version2, home2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSearchCompleted() {
            Object object = SdkDetector.this.myPublicationLock;
            synchronized (object) {
                SdkDetector.this.myIsRunning.set(false);
                this.logEvent(e -> e.onSearchCompleted());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "home";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkDetector$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logEvent";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSdkDetected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public static SdkDetector getInstance() {
        SdkDetector sdkDetector = (SdkDetector)ApplicationManager.getApplication().getService(SdkDetector.class);
        if (sdkDetector == null) {
            SdkDetector.$$$reportNull$$$0(0);
        }
        return sdkDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDetectedSdksWithUpdate(@Nullable Project project, @NotNull Disposable lifetime, @NotNull ModalityState callbackModality, @NotNull DetectedSdkListener listener2) {
        if (lifetime == null) {
            SdkDetector.$$$reportNull$$$0(1);
        }
        if (callbackModality == null) {
            SdkDetector.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            SdkDetector.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        if (!SdkDetector.isDetectorEnabled()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            LOG.warn("Sdks detection is skipped, because deadlock is coming for synchronous detection");
            return;
        }
        EdtDetectedSdkListener actualListener = new EdtDetectedSdkListener(callbackModality, listener2);
        Object object = this.myPublicationLock;
        synchronized (object) {
            if (!this.myListeners.add(actualListener)) {
                return;
            }
            if (this.myListeners.size() <= 1 && this.myIsRunning.compareAndSet(false, true)) {
                this.myDetectedResults.clear();
                SdkDetector.startSdkDetection(project, this.myMulticaster);
            }
            this.myDetectedResults.forEach(result2 -> result2.accept(listener2));
        }
        Disposer.register((Disposable)lifetime, () -> this.myListeners.remove(actualListener));
    }

    private static boolean isDetectorEnabled() {
        return Registry.is((String)"sdk.detector.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectSdks(@NotNull SdkType type, @NotNull ProgressIndicator indicator, @NotNull DetectedSdkListener callback2) {
        if (type == null) {
            SdkDetector.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            SdkDetector.$$$reportNull$$$0(5);
        }
        if (callback2 == null) {
            SdkDetector.$$$reportNull$$$0(6);
        }
        callback2.onSearchStarted();
        try {
            if (SdkDetector.isDetectorEnabled()) {
                SdkDetector.detect(type, indicator, callback2);
            }
        }
        finally {
            callback2.onSearchCompleted();
        }
    }

    private static void detect(@NotNull SdkType type, @NotNull ProgressIndicator indicator, @NotNull DetectedSdkListener callback2) {
        if (type == null) {
            SdkDetector.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            SdkDetector.$$$reportNull$$$0(8);
        }
        if (callback2 == null) {
            SdkDetector.$$$reportNull$$$0(9);
        }
        try {
            Collection suggestedPaths = type.suggestHomePaths();
            for (String path : suggestedPaths) {
                String version2;
                block13: {
                    indicator.checkCanceled();
                    if (path == null) continue;
                    try {
                        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) continue;
                        if (!type.isValidSdkHome(path)) {
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to process detected SDK for " + type + " at " + path + ". " + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                try {
                    version2 = type.getVersionString(path);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get the detected SDK version for " + type + " at " + path + ". " + e.getMessage(), (Throwable)e);
                    continue;
                }
                if (version2 == null) {
                    LOG.warn("No version is returned for detected SDK " + type + " at " + path);
                    continue;
                }
                callback2.onSdkDetected(type, version2, path);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to detect SDK: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void startSdkDetection(@Nullable Project project, final @NotNull DetectedSdkListener callback2) {
        if (callback2 == null) {
            SdkDetector.$$$reportNull$$$0(10);
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project, ProjectBundle.message((String)"progress.title.detecting.sdks", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    SdkType[] types;
                    callback2.onSearchStarted();
                    indicator.setIndeterminate(false);
                    int item = 0;
                    for (SdkType type : types = SdkType.getAllTypes()) {
                        indicator.setFraction((double)((float)item++ / (float)types.length));
                        indicator.checkCanceled();
                        SdkDetector.detect(type, indicator, callback2);
                    }
                }
                finally {
                    callback2.onSearchCompleted();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/SdkDetector$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkDetector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lifetime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackModality";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDetectedSdksWithUpdate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "detectSdks";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startSdkDetection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EdtDetectedSdkListener
    implements DetectedSdkListener {
        private final ModalityState myState;
        private final DetectedSdkListener myTarget;

        EdtDetectedSdkListener(@NotNull ModalityState state, @NotNull DetectedSdkListener target2) {
            if (state == null) {
                EdtDetectedSdkListener.$$$reportNull$$$0(0);
            }
            if (target2 == null) {
                EdtDetectedSdkListener.$$$reportNull$$$0(1);
            }
            this.myState = state;
            this.myTarget = target2;
        }

        void dispatch(@NotNull Runnable r) {
            if (r == null) {
                EdtDetectedSdkListener.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().invokeLater(r, this.myState);
        }

        @Override
        public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home2) {
            if (type == null) {
                EdtDetectedSdkListener.$$$reportNull$$$0(3);
            }
            if (version2 == null) {
                EdtDetectedSdkListener.$$$reportNull$$$0(4);
            }
            if (home2 == null) {
                EdtDetectedSdkListener.$$$reportNull$$$0(5);
            }
            this.dispatch(() -> this.myTarget.onSdkDetected(type, version2, home2));
        }

        @Override
        public void onSearchStarted() {
            this.dispatch(() -> this.myTarget.onSearchStarted());
        }

        @Override
        public void onSearchCompleted() {
            this.dispatch(() -> this.myTarget.onSearchCompleted());
        }

        public int hashCode() {
            return this.myTarget.hashCode();
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof EdtDetectedSdkListener && Objects.equals(((EdtDetectedSdkListener)obj2).myTarget, this.myTarget);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "home";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkDetector$EdtDetectedSdkListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatch";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSdkDetected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DetectedSdkListener {
        public void onSdkDetected(@NotNull SdkType var1, @NotNull String var2, @NotNull String var3);

        default public void onSearchStarted() {
        }

        default public void onSearchCompleted() {
        }
    }
}

