/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.SdkAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkAppearanceServiceImpl
extends SdkAppearanceService {
    @NotNull
    public CellAppearanceEx forNullSdk(boolean selected2) {
        CellAppearanceEx cellAppearanceEx = FileAppearanceService.getInstance().forInvalidUrl(ProjectBundle.message((String)"sdk.missing.item", (Object[])new Object[0]));
        if (cellAppearanceEx == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(0);
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forSdk(@Nullable Sdk sdk2, boolean isInComboBox, boolean selected2, boolean showVersion) {
        if (sdk2 == null) {
            CellAppearanceEx cellAppearanceEx = this.forNullSdk(selected2);
            if (cellAppearanceEx == null) {
                SdkAppearanceServiceImpl.$$$reportNull$$$0(1);
            }
            return cellAppearanceEx;
        }
        String name = sdk2.getName();
        SdkType sdkType = (SdkType)sdk2.getSdkType();
        boolean hasValidPath = sdkType.sdkHasValidPath(sdk2);
        String versionString = showVersion ? sdk2.getVersionString() : null;
        CellAppearanceEx cellAppearanceEx = this.forSdk((SdkTypeId)sdkType, name, versionString, hasValidPath, isInComboBox, selected2);
        if (cellAppearanceEx == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(2);
        }
        return cellAppearanceEx;
    }

    @NotNull
    public CellAppearanceEx forSdk(@NotNull SdkTypeId sdkType, @NotNull String name, @Nullable String versionString, boolean hasValidPath, boolean isInComboBox, boolean selected2) {
        if (sdkType == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(3);
        }
        if (name == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(4);
        }
        CompositeAppearance appearance = new CompositeAppearance();
        if (sdkType instanceof SdkType) {
            appearance.setIcon(((SdkType)sdkType).getIcon());
        }
        SimpleTextAttributes attributes = SdkAppearanceServiceImpl.getTextAttributes(hasValidPath, selected2);
        CompositeAppearance.DequeEnd ending = appearance.getEnding();
        ending.addText(StringUtil.shortenTextWithEllipsis((String)name, (int)50, (int)0), attributes);
        if (versionString != null && !versionString.equals(name) && !StringUtil.isEmptyOrSpaces((String)versionString)) {
            SimpleTextAttributes textAttributes = isInComboBox && !selected2 ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected2 ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            @NlsSafe String shortVersion = StringUtil.shortenTextWithEllipsis((String)versionString, (int)30, (int)0);
            ending.addComment(shortVersion, textAttributes);
        }
        CompositeAppearance compositeAppearance = ending.getAppearance();
        if (compositeAppearance == null) {
            SdkAppearanceServiceImpl.$$$reportNull$$$0(5);
        }
        return compositeAppearance;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected2) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected2 || SystemInfoRt.isWindows && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/SdkAppearanceServiceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forNullSdk";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/SdkAppearanceServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

