/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LibraryImpl
extends TraceableDisposable
implements LibraryEx.ModifiableModelEx,
LibraryEx,
RootProvider {
    private static final Logger LOG = Logger.getInstance(LibraryImpl.class);
    private static final String EXCLUDED_ROOTS_TAG = "excluded";
    @NlsSafe
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    @Nullable
    private VirtualFilePointerContainer myExcludedRoots;
    private final LibraryImpl mySource;
    private PersistentLibraryKind<?> myKind;
    private LibraryProperties myProperties;
    @Nullable
    private final ModifiableRootModel myRootModel;
    private boolean myDisposed;
    private final Disposable myPointersDisposable;
    private final ProjectModelExternalSource myExternalSource;
    private final EventDispatcher<RootProvider.RootSetChangedListener> myDispatcher;
    @NonNls
    public static final String ROOT_TYPE_ATTR = "type";
    private static final OrderRootType DEFAULT_JAR_DIRECTORY_TYPE = OrderRootType.CLASSES;

    LibraryImpl(LibraryTable table, @NotNull Element element2, ModifiableRootModel rootModel) throws InvalidDataException {
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(0);
        }
        this(table, rootModel, null, null, LibraryImpl.findPersistentLibraryKind(element2), LibraryImpl.findExternalSource(element2));
        this.readExternal(element2);
    }

    LibraryImpl(String name, @Nullable PersistentLibraryKind<?> kind, LibraryTable table, ModifiableRootModel rootModel, ProjectModelExternalSource externalSource) {
        this(table, rootModel, null, name, kind, externalSource);
        if (kind != null) {
            this.myProperties = kind.createDefaultProperties();
        }
    }

    private LibraryImpl(@NotNull LibraryImpl from2, LibraryImpl newSource, ModifiableRootModel rootModel) {
        if (from2 == null) {
            LibraryImpl.$$$reportNull$$$0(1);
        }
        this(from2.myLibraryTable, rootModel, newSource, from2.myName, from2.myKind, from2.myExternalSource);
        from2.checkDisposed();
        if (from2.myKind != null && from2.myProperties != null) {
            this.myProperties = this.myKind.createDefaultProperties();
            Object state = from2.myProperties.getState();
            if (state != null) {
                this.myProperties.loadState(state);
            }
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer thatContainer = from2.myRoots.get(rootType);
            if (thatContainer == null || thatContainer.isEmpty()) continue;
            this.getOrCreateContainer(rootType).addAll(thatContainer);
        }
        if (from2.myExcludedRoots != null) {
            this.myExcludedRoots = from2.myExcludedRoots.clone(this.myPointersDisposable);
        }
    }

    private LibraryImpl(LibraryTable table, @Nullable ModifiableRootModel rootModel, LibraryImpl newSource, String name, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
        super(true);
        this.myRoots = new HashMap<OrderRootType, VirtualFilePointerContainer>(3);
        this.myPointersDisposable = Disposer.newDisposable();
        this.myDispatcher = EventDispatcher.create(RootProvider.RootSetChangedListener.class);
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = newSource;
        this.myKind = kind;
        this.myName = name;
        this.myExternalSource = externalSource;
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    @Nullable
    private static ProjectModelExternalSource findExternalSource(@NotNull Element element2) {
        String externalSourceId;
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(2);
        }
        return (externalSourceId = element2.getAttributeValue("__external-system-id")) != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(externalSourceId) : null;
    }

    @Nullable
    private static PersistentLibraryKind<?> findPersistentLibraryKind(@NotNull Element element2) {
        String typeString;
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(3);
        }
        if ((typeString = element2.getAttributeValue(ROOT_TYPE_ATTR)) == null) {
            return null;
        }
        LibraryKind kind = LibraryKind.findById((String)typeString);
        if (kind == null) {
            return UnknownLibraryKind.getOrCreate(typeString);
        }
        if (!(kind instanceof PersistentLibraryKind)) {
            LOG.error("Cannot load non-persistable library kind: " + typeString);
            return null;
        }
        return (PersistentLibraryKind)kind;
    }

    @NotNull
    private Set<OrderRootType> getAllRootTypes() {
        Set rootTypes = ContainerUtil.set((Object[])OrderRootType.getAllTypes());
        if (this.myKind != null) {
            rootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        Set set2 = rootTypes;
        if (set2 == null) {
            LibraryImpl.$$$reportNull$$$0(4);
        }
        return set2;
    }

    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            this.throwDisposalError("'" + this.myName + "' already disposed: " + this.getStackTrace());
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getPresentableName() {
        return LibraryImpl.getPresentableName(this);
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(5);
        }
        this.checkDisposed();
        VirtualFilePointerContainer result2 = this.myRoots.get(rootType);
        String[] stringArray = result2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result2.getUrls();
        if (stringArray == null) {
            LibraryImpl.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(7);
        }
        this.checkDisposed();
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFile[] virtualFileArray = container == null ? VirtualFile.EMPTY_ARRAY : container.getFiles();
        if (virtualFileArray == null) {
            LibraryImpl.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        this.checkDisposed();
        return new LibraryImpl(this, this, this.myRootModel);
    }

    @NotNull
    public Library cloneLibrary(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            LibraryImpl.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(this.myLibraryTable == null);
        return new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
    }

    @NotNull
    public List<String> getInvalidRootUrls(@NotNull OrderRootType type) {
        if (type == null) {
            LibraryImpl.$$$reportNull$$$0(10);
        }
        if (this.myDisposed) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LibraryImpl.$$$reportNull$$$0(11);
            }
            return list2;
        }
        VirtualFilePointerContainer container = this.myRoots.get(type);
        List pointers2 = container == null ? Collections.emptyList() : container.getList();
        SmartList invalidPaths = null;
        for (VirtualFilePointer pointer : pointers2) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList();
            }
            invalidPaths.add(pointer.getUrl());
        }
        List list3 = ContainerUtil.notNullize(invalidPaths);
        if (list3 == null) {
            LibraryImpl.$$$reportNull$$$0(12);
        }
        return list3;
    }

    public void setProperties(LibraryProperties properties) {
        LOG.assertTrue(this.isWritable());
        if (this.myKind == null) {
            if (properties != null && !(properties instanceof DummyLibraryProperties)) {
                LOG.error("Cannot set properties for library with default type");
            }
            return;
        }
        this.myProperties = properties;
    }

    @NotNull
    public RootProvider getRootProvider() {
        LibraryImpl libraryImpl = this;
        if (libraryImpl == null) {
            LibraryImpl.$$$reportNull$$$0(13);
        }
        return libraryImpl;
    }

    @NotNull
    private VirtualFilePointerListener getListener() {
        Project project;
        Project project2 = project = this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null;
        VirtualFilePointerListener virtualFilePointerListener = this.myRootModel != null ? ((RootModelImpl)this.myRootModel).getRootsChangedListener() : (project != null ? ProjectRootManagerImpl.getInstanceImpl(project).getRootsValidityChangedListener() : ProjectJdkImpl.getGlobalVirtualFilePointerListener());
        if (virtualFilePointerListener == null) {
            LibraryImpl.$$$reportNull$$$0(14);
        }
        return virtualFilePointerListener;
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myExternalSource;
    }

    public void readExternal(Element element2) throws InvalidDataException {
        this.readName(element2);
        this.readProperties(element2);
        this.readRoots(element2);
        this.readJarDirectories(element2);
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateContainer(@NotNull OrderRootType rootType) {
        VirtualFilePointerContainer roots;
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(15);
        }
        if ((roots = this.myRoots.get(rootType)) == null) {
            roots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable, this.getListener());
            this.myRoots.put(rootType, roots);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = roots;
        if (virtualFilePointerContainer == null) {
            LibraryImpl.$$$reportNull$$$0(16);
        }
        return virtualFilePointerContainer;
    }

    @Deprecated
    private void readJarDirectories(@NotNull Element element2) {
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(17);
        }
        List jarDirs = element2.getChildren("jarDirectory");
        for (Element jarDir : jarDirs) {
            String url = jarDir.getAttributeValue("url");
            if (url == null) continue;
            String recursive = jarDir.getAttributeValue("recursive");
            OrderRootType rootType = LibraryImpl.getJarDirectoryRootType(jarDir.getAttributeValue(ROOT_TYPE_ATTR));
            VirtualFilePointerContainer roots = this.getOrCreateContainer(rootType);
            boolean recursively = Boolean.parseBoolean(recursive);
            roots.addJarDirectory(url, recursively);
        }
    }

    @NotNull
    private static OrderRootType getJarDirectoryRootType(@Nullable String type) {
        for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
            if (!rootType.name().equals(type)) continue;
            PersistentOrderRootType persistentOrderRootType = rootType;
            if (persistentOrderRootType == null) {
                LibraryImpl.$$$reportNull$$$0(18);
            }
            return persistentOrderRootType;
        }
        OrderRootType orderRootType = DEFAULT_JAR_DIRECTORY_TYPE;
        if (orderRootType == null) {
            LibraryImpl.$$$reportNull$$$0(19);
        }
        return orderRootType;
    }

    private void readProperties(@NotNull Element element2) {
        String typeId;
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(20);
        }
        if ((typeId = element2.getAttributeValue(ROOT_TYPE_ATTR)) == null) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById((String)typeId);
        Element propertiesElement = element2.getChild("properties");
        if (this.myKind == null) {
            this.myKind = UnknownLibraryKind.getOrCreate(typeId);
            UnknownLibraryKind.UnknownLibraryProperties properties = new UnknownLibraryKind.UnknownLibraryProperties();
            properties.setConfiguration(propertiesElement);
            this.myProperties = properties;
            return;
        }
        this.myProperties = this.myKind.createDefaultProperties();
        if (propertiesElement != null) {
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)this.myProperties, (Element)propertiesElement);
        }
    }

    private void readName(@NotNull Element element2) {
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(21);
        }
        this.myName = element2.getAttributeValue("name");
    }

    private void readRoots(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(22);
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            Element rootChild = element2.getChild(rootType.name());
            if (rootChild == null || rootChild.getChildren("root").isEmpty()) continue;
            VirtualFilePointerContainer roots = this.getOrCreateContainer(rootType);
            roots.readExternal(rootChild, "root", true);
        }
        Element excludedRoot = element2.getChild(EXCLUDED_ROOTS_TAG);
        if (excludedRoot != null && !excludedRoot.getChildren("root").isEmpty()) {
            this.getOrCreateExcludedRoots().readExternal(excludedRoot, "root", false);
        }
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateExcludedRoots() {
        VirtualFilePointerContainer excludedRoots = this.myExcludedRoots;
        if (excludedRoots == null) {
            this.myExcludedRoots = excludedRoots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = excludedRoots;
        if (virtualFilePointerContainer == null) {
            LibraryImpl.$$$reportNull$$$0(23);
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    private static List<OrderRootType> sortRootTypes(@NotNull Collection<? extends OrderRootType> rootTypes) {
        if (rootTypes == null) {
            LibraryImpl.$$$reportNull$$$0(24);
        }
        ArrayList<OrderRootType> allTypes = new ArrayList<OrderRootType>(rootTypes);
        allTypes.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        ArrayList<OrderRootType> arrayList = allTypes;
        if (arrayList == null) {
            LibraryImpl.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public void writeExternal(Element rootElement) {
        Module module;
        Object project;
        this.checkDisposed();
        Element element2 = new Element("library");
        if (this.myName != null) {
            element2.setAttribute("name", this.myName);
        }
        if (this.myKind != null) {
            element2.setAttribute(ROOT_TYPE_ATTR, this.myKind.getKindId());
            LOG.assertTrue(this.myProperties != null, (Object)("Properties is 'null' in library with kind " + this.myKind));
            Object state = this.myProperties.getState();
            if (state != null) {
                Element propertiesElement;
                Element element3 = propertiesElement = state instanceof Element ? ((Element)state).clone() : XmlSerializer.serialize((Object)state);
                if (propertiesElement != null) {
                    element2.addContent(propertiesElement.setName("properties"));
                }
            }
        }
        if (this.myExternalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)(project = (module = this.getModule()) == null ? (this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null) : module.getProject()))) {
            element2.setAttribute("__external-system-id", this.myExternalSource.getId());
        }
        ArrayList<OrderRootType> storableRootTypes = new ArrayList<OrderRootType>(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            storableRootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        for (OrderRootType rootType : LibraryImpl.sortRootTypes(storableRootTypes)) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if ((roots == null || roots.isEmpty()) && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            if (roots != null) {
                roots.writeExternal(rootTypeElement, "root", false);
            }
            element2.addContent(rootTypeElement);
        }
        if (this.myExcludedRoots != null && !this.myExcludedRoots.isEmpty()) {
            Element excluded = new Element(EXCLUDED_ROOTS_TAG);
            this.myExcludedRoots.writeExternal(excluded, "root", false);
            element2.addContent(excluded);
        }
        this.writeJarDirectories(element2);
        rootElement.addContent(element2);
    }

    @Deprecated
    private void writeJarDirectories(@NotNull Element element2) {
        if (element2 == null) {
            LibraryImpl.$$$reportNull$$$0(26);
        }
        List<OrderRootType> rootTypes = LibraryImpl.sortRootTypes(this.myRoots.keySet());
        for (OrderRootType rootType : rootTypes) {
            VirtualFilePointerContainer container = this.myRoots.get(rootType);
            ArrayList<Pair> jarDirectories = new ArrayList<Pair>(container.getJarDirectories());
            jarDirectories.sort(Comparator.comparing(p -> (String)p.getFirst(), String.CASE_INSENSITIVE_ORDER));
            for (Pair pair : jarDirectories) {
                String url = (String)pair.getFirst();
                boolean isRecursive = (Boolean)pair.getSecond();
                Element jarDirElement = new Element("jarDirectory");
                jarDirElement.setAttribute("url", url);
                jarDirElement.setAttribute("recursive", Boolean.toString(isRecursive));
                if (!rootType.equals((Object)DEFAULT_JAR_DIRECTORY_TYPE)) {
                    jarDirElement.setAttribute(ROOT_TYPE_ATTR, rootType.name());
                }
                element2.addContent(jarDirElement);
            }
        }
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.myKind;
    }

    public void forgetKind() {
        if (this.myKind == null) {
            return;
        }
        this.myKind = UnknownLibraryKind.getOrCreate(this.myKind.getKindId());
        Object propertiesState = this.myProperties.getState();
        if (propertiesState != null) {
            UnknownLibraryKind.UnknownLibraryProperties properties = new UnknownLibraryKind.UnknownLibraryProperties();
            properties.setConfiguration(XmlSerializer.serialize((Object)propertiesState));
            this.myProperties = properties;
        } else {
            this.myProperties = null;
        }
    }

    public void restoreKind() {
        if (this.myKind == null || !(this.myKind instanceof UnknownLibraryKind)) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById((String)this.myKind.getKindId());
        Element configuration2 = ((UnknownLibraryKind.UnknownLibraryProperties)this.myProperties).getConfiguration();
        this.myProperties = this.myKind.createDefaultProperties();
        if (configuration2 != null) {
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)this.myProperties, (Element)configuration2);
        }
    }

    public void addExcludedRoot(@NotNull String url) {
        VirtualFilePointerContainer roots;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(27);
        }
        if ((roots = this.getOrCreateExcludedRoots()).findByUrl(url) == null) {
            roots.add(url);
        }
    }

    public boolean removeExcludedRoot(@NotNull String url) {
        VirtualFilePointer pointer;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(28);
        }
        if (this.myExcludedRoots != null && (pointer = this.myExcludedRoots.findByUrl(url)) != null) {
            this.myExcludedRoots.remove(pointer);
            return true;
        }
        return false;
    }

    public String @NotNull [] getExcludedRootUrls() {
        String[] stringArray = this.myExcludedRoots != null ? this.myExcludedRoots.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            LibraryImpl.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    public VirtualFile @NotNull [] getExcludedRoots() {
        VirtualFile[] virtualFileArray = this.myExcludedRoots != null ? this.myExcludedRoots.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            LibraryImpl.$$$reportNull$$$0(30);
        }
        return virtualFileArray;
    }

    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    public void setKind(@NotNull PersistentLibraryKind<?> kind) {
        if (kind == null) {
            LibraryImpl.$$$reportNull$$$0(31);
        }
        LOG.assertTrue(this.isWritable());
        LOG.assertTrue(this.myKind == null || this.myKind == kind, (Object)("Library kind cannot be changed from " + this.myKind + " to " + kind));
        this.myKind = kind;
        this.myProperties = kind.createDefaultProperties();
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(32);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(33);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.add(url);
    }

    public void addRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            LibraryImpl.$$$reportNull$$$0(34);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(35);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.add(file2);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(36);
        }
        this.addJarDirectory(url, recursive, OrderRootType.CLASSES);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive) {
        if (file2 == null) {
            LibraryImpl.$$$reportNull$$$0(37);
        }
        this.addJarDirectory(file2, recursive, OrderRootType.CLASSES);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(38);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(39);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.addJarDirectory(url, recursive);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            LibraryImpl.$$$reportNull$$$0(40);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(41);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.addJarDirectory(file2.getUrl(), recursive);
    }

    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(42);
        }
        return this.isJarDirectory(url, OrderRootType.CLASSES);
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(43);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(44);
        }
        if ((container = this.myRoots.get(rootType)) == null) {
            return false;
        }
        List jarDirectories = container.getJarDirectories();
        return jarDirectories.contains(Pair.create((Object)url, (Object)false)) || jarDirectories.contains(Pair.create((Object)url, (Object)true));
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(45);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(46);
        }
        VirtualFilePointer fp = (container = this.myRoots.get(rootType)) == null ? null : container.findByUrl(url);
        return fp != null && fp.isValid();
    }

    public boolean hasSameContent(@NotNull Library library2) {
        if (library2 == null) {
            LibraryImpl.$$$reportNull$$$0(47);
        }
        return this.equals(library2);
    }

    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointer byUrl;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(48);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(49);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer virtualFilePointer = byUrl = container == null ? null : container.findByUrl(url);
        if (byUrl != null) {
            container.remove(byUrl);
            if (this.myExcludedRoots != null) {
                for (String excludedRoot : this.myExcludedRoots.getUrls()) {
                    VirtualFilePointer pointer;
                    if (this.isUnderRoots(excludedRoot) || (pointer = this.myExcludedRoots.findByUrl(excludedRoot)) == null) continue;
                    this.myExcludedRoots.remove(pointer);
                }
            }
            container.removeJarDirectory(url);
            return true;
        }
        return false;
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(50);
        }
        for (VirtualFilePointerContainer container : this.myRoots.values()) {
            if (!VfsUtilCore.isUnder((String)url, Arrays.asList(container.getUrls()))) continue;
            return true;
        }
        return false;
    }

    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(51);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(52);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container != null) {
            container.moveUp(url);
        }
    }

    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(53);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(54);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container != null) {
            container.moveDown(url);
        }
    }

    public boolean isChanged() {
        return !this.mySource.equals((Object)this);
    }

    private boolean areRootsChanged(@NotNull LibraryImpl that) {
        if (that == null) {
            LibraryImpl.$$$reportNull$$$0(55);
        }
        return !that.equals((Object)this);
    }

    public Library getSource() {
        return this.mySource;
    }

    public void commit() {
        this.checkDisposed();
        if (this.isChanged()) {
            this.mySource.commit(this);
        }
        Disposer.dispose((Disposable)this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            LibraryImpl.$$$reportNull$$$0(56);
        }
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Objects.equals(fromModel.myName, this.myName)) {
            String oldName = this.myName;
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this, oldName);
            }
        }
        this.myKind = fromModel.getKind();
        this.myProperties = fromModel.myProperties;
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            LibraryImpl.$$$reportNull$$$0(57);
        }
        HashMap<OrderRootType, VirtualFilePointerContainer> clonedRoots = new HashMap<OrderRootType, VirtualFilePointerContainer>();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container = entry.getValue();
            VirtualFilePointerContainer clone = container.clone(this.myPointersDisposable, this.getListener());
            clonedRoots.put(rootType, clone);
        }
        this.myRoots.clear();
        this.myRoots.putAll(clonedRoots);
        VirtualFilePointerContainer excludedRoots = fromModel.myExcludedRoots;
        this.myExcludedRoots = excludedRoots != null ? excludedRoots.clone(this.myPointersDisposable) : null;
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container : new HashSet<VirtualFilePointerContainer>(this.myRoots.values())) {
            container.killAll();
        }
        if (this.myExcludedRoots != null) {
            this.myExcludedRoots.killAll();
        }
        Disposer.dispose((Disposable)this.myPointersDisposable);
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library2 = (LibraryImpl)((Object)o);
        if (!Objects.equals(this.myName, library2.myName)) {
            return false;
        }
        if (!this.myRoots.equals(library2.myRoots)) {
            return false;
        }
        if (!Objects.equals(this.myKind, library2.myKind)) {
            return false;
        }
        if (!Objects.equals(this.myProperties, library2.myProperties)) {
            return false;
        }
        return Comparing.equal((Object)this.myExcludedRoots, (Object)library2.myExcludedRoots);
    }

    public int hashCode() {
        int result2 = this.myName != null ? this.myName.hashCode() : 0;
        result2 = 31 * result2 + this.myRoots.hashCode();
        return result2;
    }

    @NonNls
    public String toString() {
        return "Library: name:" + this.myName + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public @Nullable(value="will return non-null value only for module level libraries") Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            LibraryImpl.$$$reportNull$$$0(58);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            LibraryImpl.$$$reportNull$$$0(59);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LibraryImpl.$$$reportNull$$$0(60);
        }
        if (parentDisposable == null) {
            LibraryImpl.$$$reportNull$$$0(61);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireRootSetChanged() {
        ((RootProvider.RootSetChangedListener)this.myDispatcher.getMulticaster()).rootSetChanged((RootProvider)this);
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public static String getPresentableName(@NotNull LibraryEx library2) {
        String name;
        if (library2 == null) {
            LibraryImpl.$$$reportNull$$$0(62);
        }
        if ((name = library2.getName()) != null) {
            String string = name;
            if (string == null) {
                LibraryImpl.$$$reportNull$$$0(63);
            }
            return string;
        }
        if (library2.isDisposed()) {
            String string = ProjectModelBundle.message((String)"disposed.library.title", (Object[])new Object[0]);
            if (string == null) {
                LibraryImpl.$$$reportNull$$$0(64);
            }
            return string;
        }
        String[] urls = library2.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            String string = PathUtil.getFileName((String)PathUtil.toPresentableUrl((String)urls[0]));
            if (string == null) {
                LibraryImpl.$$$reportNull$$$0(65);
            }
            return string;
        }
        String string = ProjectModelBundle.message((String)"empty.library.title", (Object[])new Object[0]);
        if (string == null) {
            LibraryImpl.$$$reportNull$$$0(66);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 33: 
            case 35: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = ROOT_TYPE_ATTR;
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 27: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModel";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRootUrls";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContainer";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarDirectoryRootType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExcludedRoots";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sortRootTypes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExternalSource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPersistentLibraryKind";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cloneLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRootUrls";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readJarDirectories";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readProperties";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readRoots";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sortRootTypes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeJarDirectories";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setKind";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasSameContent";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "moveRootUp";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "moveRootDown";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "areRootsChanged";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addRootSetChangedListener";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeRootSetChangedListener";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

