/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidatorCallback;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserMessages;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserPaths;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserPathsKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J&\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\nJ\u0006\u0010\f\u001a\u00020\u0006JG\u0010\r\u001a\u00020\u00062=\u0010\u000e\u001a9\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00140\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserPaths;", "", "()V", "computeJdkFilePath", "Ljava/nio/file/Path;", "installCustomJdk", "", "jdkName", "", "resolveSuggestedHome", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resetCustomJdk", "runWithProgress", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "indicator", "jdkFile", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.lang.impl"})
public final class RuntimeChooserPaths {
    private final Path computeJdkFilePath() {
        String string = PathManager.getCustomOptionsDirectory();
        if (string == null) {
            throw (Throwable)new IllegalStateException("Runtime selection not supported");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathManager.getCustomOpt\u2026selection not supported\")");
        String directory = string;
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String scriptName = applicationNamesInfo.getScriptName();
        String configName = scriptName + (!SystemInfo.isWindows ? "" : (CpuArch.isIntel64() ? "64.exe" : ".exe")) + ".jdk";
        Path path = Path.of(directory, configName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Path.of(directory, configName)");
        return path;
    }

    public final void installCustomJdk(@NlsSafe @NotNull String jdkName, @NotNull Function1<? super ProgressIndicator, ? extends Path> resolveSuggestedHome) {
        Intrinsics.checkNotNullParameter((Object)jdkName, (String)"jdkName");
        Intrinsics.checkNotNullParameter(resolveSuggestedHome, (String)"resolveSuggestedHome");
        this.runWithProgress((Function2<? super ProgressIndicator, ? super Path, String>)((Function2)new Function2<ProgressIndicator, Path, String>(resolveSuggestedHome, jdkName){
            final /* synthetic */ Function1 $resolveSuggestedHome;
            final /* synthetic */ String $jdkName;

            @Nullable
            public final String invoke(@NotNull ProgressIndicator indicator, @NotNull Path jdkFile) {
                Path path;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Intrinsics.checkNotNullParameter((Object)jdkFile, (String)"jdkFile");
                try {
                    path = (Path)this.$resolveSuggestedHome.invoke((Object)indicator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    RuntimeChooserPathsKt.access$getLOG$p().warn("resolve failed. " + t.getMessage(), t);
                    return null;
                }
                Path sdkHome = path;
                Path path2 = (Path)RuntimeChooserJreValidator.INSTANCE.testNewJdkUnderProgress(true, (Function0<String>)((Function0)new Function0<String>(sdkHome){
                    final /* synthetic */ Path $sdkHome;

                    @Nullable
                    public final String invoke() {
                        Path path = this.$sdkHome;
                        return path != null && (path = path.toAbsolutePath()) != null ? ((Object)path).toString() : null;
                    }
                    {
                        this.$sdkHome = path;
                        super(0);
                    }
                }), new RuntimeChooserJreValidatorCallback<Path>(){

                    @NotNull
                    public Path onSdkResolved(@Nullable String displayName, @NotNull String versionString, @NotNull Path sdkHome) {
                        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
                        return sdkHome;
                    }

                    @Nullable
                    public Path onError(@NotNull String message2) {
                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                        RuntimeChooserMessages.showErrorMessage$default(RuntimeChooserMessages.INSTANCE, message2, null, 2, null);
                        return null;
                    }
                });
                if (path2 == null) {
                    return null;
                }
                Path home2 = path2;
                Path path3 = jdkFile.getParent();
                if (path3 != null) {
                    PathKt.createDirectories((Path)path3);
                }
                PathKt.write$default((Path)jdkFile, (CharSequence)((Object)home2.toAbsolutePath()).toString(), null, (boolean)false, (int)6, null);
                RuntimeChooserPathsKt.access$getLOG$p().warn("Set custom boot runtime to: " + home2 + " in the " + jdkFile + ". On errors, please remove the .jdk file");
                return this.$jdkName;
            }
            {
                this.$resolveSuggestedHome = function1;
                this.$jdkName = string;
                super(2);
            }
        }));
    }

    public final void resetCustomJdk() {
        this.runWithProgress((Function2<? super ProgressIndicator, ? super Path, String>)((Function2)resetCustomJdk.1.INSTANCE));
    }

    private final void runWithProgress(Function2<? super ProgressIndicator, ? super Path, String> action2) {
        String string = LangBundle.message((String)"progress.title.choose.ide.runtime.set.jdk", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"prog\u2026ose.ide.runtime.set.jdk\")");
        String title = string;
        new Task.Backgroundable(this, action2, title, null, title, true, Task.Backgroundable.DEAF){
            final /* synthetic */ RuntimeChooserPaths this$0;
            final /* synthetic */ Function2 $action;
            final /* synthetic */ String $title;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Path jdkFileShadow = null;
                try {
                    Path jdkFile;
                    jdkFileShadow = jdkFile = RuntimeChooserPaths.access$computeJdkFilePath(this.this$0);
                    String runtimeName = (String)this.$action.invoke((Object)indicator, (Object)jdkFile);
                    if (runtimeName != null) {
                        RuntimeChooserMessages.INSTANCE.showRestartMessage(runtimeName);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    RuntimeChooserPathsKt.access$getLOG$p().warn("Failed to change boot runtime in " + jdkFileShadow + ". " + t.getMessage(), t);
                    String string = LangBundle.message((String)"dialog.message.choose.ide.runtime.unknown.error", (Object[])new Object[]{t.getLocalizedMessage()});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"dial\u2026ror\", t.localizedMessage)");
                    RuntimeChooserMessages.showErrorMessage$default(RuntimeChooserMessages.INSTANCE, string, null, 2, null);
                }
            }
            {
                this.this$0 = this$0;
                this.$action = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }.queue();
    }

    public static final /* synthetic */ Path access$computeJdkFilePath(RuntimeChooserPaths $this) {
        return $this.computeJdkFilePath();
    }
}

