/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.RelayUiToDelegateIndicator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J \u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020#H\u0016J\u001e\u0010$\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bJ\u0012\u0010%\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010&\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/PendingJdkRequest;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "item", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "installDir", "Ljava/nio/file/Path;", "javaHome", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "getInstallDir", "()Ljava/nio/file/Path;", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getItem", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "getJavaHome", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "component1", "component2", "component3", "copy", "doRealDownload", "indicator", "installAction", "Lkotlin/Function0;", "equals", "", "other", "", "hashCode", "", "toString", "", "tryStartInstallOrWait", "waitForDownload", "wrapProgressIfNeeded", "action", "intellij.platform.lang.impl"})
final class PendingJdkRequest
implements JdkInstallRequest {
    private final AtomicBoolean isRunning;
    private final CompletableFuture<Unit> future;
    private volatile ProgressIndicator progressIndicator;
    @NotNull
    private final JdkItem item;
    @NotNull
    private final Path installDir;
    @NotNull
    private final Path javaHome;

    public final void tryStartInstallOrWait(@Nullable ProgressIndicator indicator, @NotNull Function0<Unit> installAction2) {
        Intrinsics.checkNotNullParameter(installAction2, (String)"installAction");
        if (this.isRunning.compareAndSet(false, true)) {
            this.doRealDownload(indicator, installAction2);
        } else {
            this.waitForDownload(indicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRealDownload(ProgressIndicator indicator, Function0<Unit> installAction2) {
        this.progressIndicator = indicator;
        try {
            installAction2.invoke();
            this.future.complete(Unit.INSTANCE);
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
            throw t;
        }
        finally {
            this.progressIndicator = null;
        }
    }

    private final void waitForDownload(ProgressIndicator indicator) {
        this.wrapProgressIfNeeded(indicator, (Function0<Unit>)((Function0)new Function0<Unit>(this, indicator){
            final /* synthetic */ PendingJdkRequest this$0;
            final /* synthetic */ ProgressIndicator $indicator;

            public final void invoke() {
                while (true) {
                    ProgressIndicator progressIndicator = this.$indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    try {
                        PendingJdkRequest.access$getFuture$p(this.this$0).get(100L, TimeUnit.MILLISECONDS);
                        return;
                    }
                    catch (TimeoutException t) {
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw (Throwable)new ProcessCanceledException();
                    }
                    catch (CancellationException e) {
                        throw (Throwable)new ProcessCanceledException();
                    }
                    catch (ExecutionException e) {
                        Throwable throwable = e.getCause();
                        if (throwable == null) {
                            throwable = e;
                        }
                        throw throwable;
                    }
                    break;
                }
            }
            {
                this.this$0 = pendingJdkRequest;
                this.$indicator = progressIndicator;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wrapProgressIfNeeded(ProgressIndicator indicator, Function0<Unit> action2) {
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (!(progressIndicator instanceof ProgressIndicatorBase)) {
            progressIndicator = null;
        }
        ProgressIndicatorBase parentProgress = (ProgressIndicatorBase)progressIndicator;
        if (indicator == null || parentProgress == null) {
            action2.invoke();
            return;
        }
        RelayUiToDelegateIndicator delegate2 = new RelayUiToDelegateIndicator(indicator);
        parentProgress.addStateDelegate(delegate2);
        try {
            action2.invoke();
            return;
        }
        finally {
            parentProgress.removeStateDelegate(delegate2);
        }
    }

    @NotNull
    public String toString() {
        return "PendingJdkRequest(item=" + this.getItem() + ", installDir=" + this.getInstallDir() + ')';
    }

    @Override
    @NotNull
    public JdkItem getItem() {
        return this.item;
    }

    @Override
    @NotNull
    public Path getInstallDir() {
        return this.installDir;
    }

    @Override
    @NotNull
    public Path getJavaHome() {
        return this.javaHome;
    }

    public PendingJdkRequest(@NotNull JdkItem item, @NotNull Path installDir, @NotNull Path javaHome) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        this.item = item;
        this.installDir = installDir;
        this.javaHome = javaHome;
        this.isRunning = new AtomicBoolean(false);
        this.future = new CompletableFuture();
    }

    public static final /* synthetic */ CompletableFuture access$getFuture$p(PendingJdkRequest $this) {
        return $this.future;
    }

    @NotNull
    public final JdkItem component1() {
        return this.getItem();
    }

    @NotNull
    public final Path component2() {
        return this.getInstallDir();
    }

    @NotNull
    public final Path component3() {
        return this.getJavaHome();
    }

    @NotNull
    public final PendingJdkRequest copy(@NotNull JdkItem item, @NotNull Path installDir, @NotNull Path javaHome) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        return new PendingJdkRequest(item, installDir, javaHome);
    }

    public static /* synthetic */ PendingJdkRequest copy$default(PendingJdkRequest pendingJdkRequest, JdkItem jdkItem, Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            jdkItem = pendingJdkRequest.getItem();
        }
        if ((n & 2) != 0) {
            path = pendingJdkRequest.getInstallDir();
        }
        if ((n & 4) != 0) {
            path2 = pendingJdkRequest.getJavaHome();
        }
        return pendingJdkRequest.copy(jdkItem, path, path2);
    }

    public int hashCode() {
        JdkItem jdkItem = this.getItem();
        Path path = this.getInstallDir();
        Path path2 = this.getJavaHome();
        return ((jdkItem != null ? ((Object)jdkItem).hashCode() : 0) * 31 + (path != null ? ((Object)path).hashCode() : 0)) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PendingJdkRequest)) break block3;
                PendingJdkRequest pendingJdkRequest = (PendingJdkRequest)object;
                if (!Intrinsics.areEqual((Object)this.getItem(), (Object)pendingJdkRequest.getItem()) || !Intrinsics.areEqual((Object)this.getInstallDir(), (Object)pendingJdkRequest.getInstallDir()) || !Intrinsics.areEqual((Object)this.getJavaHome(), (Object)pendingJdkRequest.getJavaHome())) break block3;
            }
            return true;
        }
        return false;
    }
}

