/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerStore;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.WSLDistributionForJdkInstaller;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\bH\u0014J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u0004H\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase;", "()V", "defaultInstallDir", "Ljava/nio/file/Path;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "newVersion", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "findHistoryRoots", "", "feedItem", "installJdkImpl", "", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "wrap", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$WSLDistributionForJdkInstallerImpl;", "d", "wslDistributionFromPath", "targetDir", "Companion", "WSLDistributionForJdkInstallerImpl", "intellij.platform.lang.impl"})
public final class JdkInstaller
extends JdkInstallerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected List<Path> findHistoryRoots(@NotNull JdkItem feedItem) {
        Intrinsics.checkNotNullParameter((Object)feedItem, (String)"feedItem");
        boolean $i$f$service = false;
        Class<JdkInstallerStore> serviceClass$iv = JdkInstallerStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return ((JdkInstallerStore)((Object)object)).findInstallations(feedItem);
    }

    @Override
    @Nullable
    protected WSLDistributionForJdkInstaller wslDistributionFromPath(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(((Object)targetDir).toString());
        if (wSLDistribution == null) {
            return null;
        }
        WSLDistribution d = wSLDistribution;
        return this.wrap(d);
    }

    private final WSLDistributionForJdkInstallerImpl wrap(WSLDistribution d) {
        return new WSLDistributionForJdkInstallerImpl(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installJdkImpl(@NotNull JdkInstallRequest request, @Nullable ProgressIndicator indicator, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((Consumer)new Consumer<JdkInstallerListener>(request, project){
            final /* synthetic */ JdkInstallRequest $request;
            final /* synthetic */ Project $project;

            public final void accept(JdkInstallerListener it) {
                it.onJdkDownloadStarted(this.$request, this.$project);
            }
            {
                this.$request = jdkInstallRequest;
                this.$project = project;
            }
        });
        try {
            super.installJdkImpl(request, indicator, project);
            JdkInstaller jdkInstaller = this;
            boolean bl = false;
            try {
                Object object = Result.Companion;
                JdkInstaller $this$runCatching = jdkInstaller;
                boolean bl2 = false;
                boolean $i$f$service = false;
                Class<JdkInstallerStore> serviceClass$iv = JdkInstallerStore.class;
                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object2 == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                ((JdkInstallerStore)((Object)object2)).registerInstall(request.getItem(), request.getInstallDir());
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        catch (Throwable throwable) {
            JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((Consumer)new Consumer<JdkInstallerListener>(request, project){
                final /* synthetic */ JdkInstallRequest $request;
                final /* synthetic */ Project $project;

                public final void accept(JdkInstallerListener it) {
                    it.onJdkDownloadFinished(this.$request, this.$project);
                }
                {
                    this.$request = jdkInstallRequest;
                    this.$project = project;
                }
            });
            throw throwable;
        }
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((Consumer)new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    @NotNull
    public Path defaultInstallDir(@Nullable WSLDistributionForJdkInstaller wslDistribution) {
        if (wslDistribution instanceof WSLDistributionForJdkInstallerImpl) {
            return this.defaultInstallDir(((WSLDistributionForJdkInstallerImpl)wslDistribution).getD());
        }
        return this.defaultInstallDir();
    }

    @NotNull
    public final Path defaultInstallDir(@Nullable WSLDistribution wslDistribution) {
        block2: {
            WSLDistribution wSLDistribution = wslDistribution;
            if (wSLDistribution == null) break block2;
            WSLDistribution wSLDistribution2 = wSLDistribution;
            boolean bl = false;
            boolean bl2 = false;
            WSLDistribution dist = wSLDistribution2;
            boolean bl3 = false;
            String string = dist.getUserHome();
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String home2 = string2;
                boolean bl6 = false;
                String string3 = dist.getWindowsPath(home2 + "/.jdks");
                if (string3 != null) {
                    String string4 = string3;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    String it = string4;
                    boolean bl9 = false;
                    Path path = Paths.get(it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(it)");
                    return path;
                }
            }
        }
        return this.defaultInstallDir();
    }

    @Override
    @NotNull
    public Path defaultInstallDir() {
        Path path;
        String explicitHome = System.getProperty("jdk.downloader.home");
        if (explicitHome != null) {
            Path path2 = Paths.get(explicitHome, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(explicitHome)");
            return path2;
        }
        String string = System.getProperty("user.home");
        if (string == null) {
            string = ".";
        }
        Path home2 = Paths.get(FileUtil.toCanonicalPath((String)string), new String[0]);
        if (SystemInfo.isLinux) {
            Path path3 = home2.resolve(".jdks");
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"home.resolve(\".jdks\")");
        } else if (SystemInfo.isMac) {
            Path path4 = home2.resolve("Library/Java/JavaVirtualMachines");
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"home.resolve(\"Library/Java/JavaVirtualMachines\")");
        } else if (SystemInfo.isWindows) {
            Path path5 = home2.resolve(".jdks");
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"home.resolve(\".jdks\")");
        } else {
            String string2 = "Unsupported OS: " + SystemInfo.getOsNameAndVersion();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return path;
    }

    @NotNull
    public final Path defaultInstallDir(@NotNull JdkItem newVersion, @Nullable WSLDistribution wslDistribution) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return this.defaultInstallDir(this.defaultInstallDir(wslDistribution), newVersion);
    }

    public static /* synthetic */ Path defaultInstallDir$default(JdkInstaller jdkInstaller, JdkItem jdkItem, WSLDistribution wSLDistribution, int n, Object object) {
        if ((n & 2) != 0) {
            wSLDistribution = null;
        }
        return jdkInstaller.defaultInstallDir(jdkItem, wSLDistribution);
    }

    @JvmStatic
    @NotNull
    public static final JdkInstaller getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$WSLDistributionForJdkInstallerImpl;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "d", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "getD", "()Lcom/intellij/execution/wsl/WSLDistribution;", "executeOnWsl", "Lcom/intellij/execution/process/ProcessOutput;", "command", "", "", "dir", "timeout", "", "getWslPath", "path", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
    private static final class WSLDistributionForJdkInstallerImpl
    implements WSLDistributionForJdkInstaller {
        @NotNull
        private final WSLDistribution d;

        @Override
        @NotNull
        public String getWslPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = this.d.getWslPath(((Object)path).toString());
            if (string == null) {
                String string2 = "Failed to map " + path + " to WSL";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return string;
        }

        @Override
        @NotNull
        public ProcessOutput executeOnWsl(@NotNull List<String> command, @NotNull String dir, int timeout) {
            Intrinsics.checkNotNullParameter(command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            ProcessOutput processOutput = this.d.executeOnWsl(command, new WSLCommandLineOptions().setRemoteWorkingDirectory(dir), timeout, null);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"d.executeOnWsl(command, \u2026tory(dir), timeout, null)");
            return processOutput;
        }

        @NotNull
        public final WSLDistribution getD() {
            return this.d;
        }

        public WSLDistributionForJdkInstallerImpl(@NotNull WSLDistribution d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            this.d = d;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JdkInstaller getInstance() {
            boolean $i$f$service = false;
            Class<JdkInstaller> serviceClass$iv = JdkInstaller.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (JdkInstaller)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

