/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoKt;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkFixConfigurator;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JarSdkConfigurator;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkFixConfigurator;", "extraJars", "", "", "(Ljava/util/List;)V", "getExtraJars", "()Ljava/util/List;", "configureSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "resolveExtraJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "intellij.platform.lang.impl"})
final class JarSdkConfigurator
implements UnknownSdkFixConfigurator {
    @NotNull
    private final List<String> extraJars;

    @Override
    public void configureSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        SdkModificator sdkModificator = sdk2.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"sdk.sdkModificator");
        SdkModificator sdkModificator2 = sdkModificator;
        for (String path : this.extraJars) {
            VirtualFile extraJar = this.resolveExtraJar(sdk2, path);
            if (extraJar != null) {
                sdkModificator2.addRoot(extraJar, OrderRootType.CLASSES);
                JdkAutoKt.access$getLOG$p().info("Jar '" + path + "' has been added to sdk '" + sdk2.getName() + '\'');
                continue;
            }
            JdkAutoKt.access$getLOG$p().warn("Cant resolve path '" + path + "' for jdk home '" + sdk2.getHomeDirectory() + '\'');
        }
        sdkModificator2.commitChanges();
    }

    private final VirtualFile resolveExtraJar(Sdk sdk2, String path) {
        VirtualFile virtualFile = sdk2.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"sdk.homeDirectory ?: return null");
        VirtualFile homeDirectory = virtualFile;
        VirtualFile virtualFile2 = homeDirectory.findFileByRelativePath(path);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"homeDirectory.findFileBy\u2026Path(path) ?: return null");
        VirtualFile file2 = virtualFile2;
        return JarFileSystem.getInstance().getJarRootForLocalFile(file2);
    }

    @NotNull
    public final List<String> getExtraJars() {
        return this.extraJars;
    }

    public JarSdkConfigurator(@NotNull List<String> extraJars) {
        Intrinsics.checkNotNullParameter(extraJars, (String)"extraJars");
        this.extraJars = extraJars;
    }
}

